/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLInheritanceRelation
extends AbstractWXMLDesignObject {
    InheritanceRelation relation = null;

    public WXMLInheritanceRelation(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result;
        boolean bl = result = object.getClass() == InheritanceRelation.class;
        if (result) {
            this.relation = (InheritanceRelation)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.relation != null) {
            String designName = this.relation.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("logical").append('/');
        }
        buffer.append(this.getConfiguration().get("inheritancePath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element parentNode, DesignObject object) {
        if (object instanceof InheritanceRelation) {
            InheritanceRelation rel = (InheritanceRelation)object;
            this.appendConnectionInfo(parentNode, StringUtilities.encodeAttributeValue(rel.getSourceEntity().getObjectID()), "source");
            this.appendConnectionInfo(parentNode, StringUtilities.encodeAttributeValue(rel.getTargetEntity().getObjectID()), "target");
        }
    }

    private void appendConnectionInfo(Element parentNode, String objectID, String label) {
        Element connectionNode = parentNode.getOwnerDocument().createElement("inheritance");
        parentNode.appendChild(connectionNode);
        connectionNode.setAttribute("endpoint", label);
        connectionNode.setAttribute("entity", StringUtilities.encodeAttributeValue(objectID));
    }
}

