/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLDesign
extends AbstractXMLWriter {
    public WXMLDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof Design;
    }

    @Override
    public String getRelativePath() {
        return "";
    }

    @Override
    public Document writeDocument(Object object) {
        Design design = (Design)object;
        Document doc = this.createDocument("model");
        Element designElm = doc.getDocumentElement();
        this.appendVersion(doc, designElm, design);
        this.appendDesignProperties(doc, designElm, design);
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            this.appendChangeRequestsInfo(doc, designElm, design);
        }
        this.appendDesignInfo(doc, designElm, design.getDataTypesDesign());
        this.appendDesignInfo(doc, designElm, design.getLogicalDesign());
        this.appendRelationalDesignsInfo(doc, designElm, design);
        this.appendMultidimensionalDesignsInfo(doc, designElm, design);
        this.appendProcessModelInfo(doc, designElm, design.getProcessModel());
        this.appendDesignInfo(doc, designElm, design.getBusinessInfoDesign());
        Element domNode = doc.createElement("domains");
        designElm.appendChild(domNode);
        Collection all = design.getStorableDesignObjects();
        HashMap domainFileNames = new HashMap();
        if (design.isSaveDefaultDomains()) {
            domainFileNames.put("defaultdomains", new ArrayList());
        }
        HashSet importedFiles = new HashSet();
        Iterator it = all.iterator();
        DesignObject designObject = null;
        while (it.hasNext()) {
            designObject = (DesignObject)it.next();
            this.handleDesignObject(domNode, designObject, domainFileNames, importedFiles);
        }
        this.handleDomainFiles(domainFileNames);
        importedFiles.clear();
        domainFileNames.clear();
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            this.getPersistenceManager().write(design.getRDBMSSiteSet());
        }
        design.setDirty(false);
        return doc;
    }

    private void appendDesignProperties(Document doc, Element designElm, Design design) {
        String notes;
        Text content;
        Element child;
        Element objInfo = doc.createElement("object");
        String comment = design.getComment();
        if (comment != null) {
            child = doc.createElement("comment");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(comment));
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        if ((notes = design.getNotes()) != null) {
            child = doc.createElement("notes");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(notes));
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        this.appendChange(objInfo, design.getCreation(), "created");
        this.appendChange(objInfo, design.getChange(), "changed");
        designElm.appendChild(objInfo);
    }

    private void appendVersion(Document doc, Element designElm, Design design) {
        Element versionElem = doc.createElement("version");
        versionElem.setAttribute("version", String.valueOf(design.getVersion()));
        versionElem.setAttribute("design_id", design.getDesignID());
        designElm.appendChild(versionElem);
    }

    private void appendChangeRequestsInfo(Document doc, Element designElm, Design design) {
        Element child = doc.createElement("changerequests");
        Iterator it = design.getChangeRequestSet().iterator();
        StringBuffer ids = new StringBuffer();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                ids.append(", ");
            } else {
                first = false;
            }
            ids.append(StringUtilities.encodeAttributeValue(((DesignObject)it.next()).getObjectID()));
        }
        child.setAttribute("id", ids.toString());
        designElm.appendChild(child);
    }

    private void appendDesignInfo(Document doc, Element designElm, DesignPart designPart) {
        if (!designPart.isNewModel() || designPart.getAppView().isSelectedForSave(designPart)) {
            Element child = doc.createElement("design");
            child.setAttribute("type", StringUtilities.encodeAttributeValue(designPart.getObjectTypeName()));
            child.setAttribute("id", StringUtilities.encodeAttributeValue(designPart.getObjectID()));
            child.setAttribute("path_id", StringUtilities.encodeAttributeValue(designPart.getPathIDString()));
            if (designPart.getMainView() != null) {
                child.setAttribute("main_view_id", designPart.getMainView().getDPVId());
            } else {
                child.setAttribute("main_view_id", "null");
            }
            child.setAttribute("should_be_open", StringUtilities.encodeAttributeValue(String.valueOf(designPart.isLoaded())));
            if (designPart instanceof LogicalDesign) {
                if (((LogicalDesign)designPart).isSubviewToNewDesign()) {
                    child.setAttribute("is_visible", String.valueOf(true));
                } else {
                    child.setAttribute("is_visible", String.valueOf(designPart.isMainViewVisible()));
                }
            } else if (designPart instanceof RelationalDesign) {
                if (((RelationalDesign)designPart).isSubviewToNewDesign()) {
                    child.setAttribute("is_visible", String.valueOf(true));
                } else {
                    child.setAttribute("is_visible", String.valueOf(designPart.isMainViewVisible()));
                }
            } else {
                child.setAttribute("is_visible", String.valueOf(designPart.isMainViewVisible()));
            }
            if (designPart instanceof DataFlowDesign) {
                child.setAttribute("top_level_dfd_design", String.valueOf(((DataFlowDesign)designPart).isTopLevel()));
            }
            Element name = doc.createElement("name");
            name.appendChild(doc.createTextNode(StringUtilities.encodeAttributeValue(designPart.getName())));
            child.appendChild(name);
            Element comment = doc.createElement("comment");
            comment.appendChild(doc.createTextNode(StringUtilities.encodeAttributeValue(designPart.getComment())));
            child.appendChild(comment);
            designElm.appendChild(child);
            Element notes = doc.createElement("notes");
            notes.appendChild(doc.createTextNode(StringUtilities.encodeAttributeValue(designPart.getNotes())));
            child.appendChild(notes);
            designElm.appendChild(child);
        }
    }

    private void appendRelationalDesignsInfo(Document doc, Element designNode, Design design) {
        for (RelationalDesign relDesign : design.getRelationalDesigns()) {
            if (!design.shouldExportFull(relDesign) && !design.shouldExportPartial(relDesign)) continue;
            this.appendDesignInfo(doc, designNode, relDesign);
        }
    }

    private void appendMultidimensionalDesignsInfo(Document doc, Element designNode, Design design) {
        for (MultidimensionalDesign mdDesign : design.getMultidimensionalDesigns()) {
            if (!design.shouldExportFull(mdDesign) && !design.shouldExportPartial(mdDesign)) continue;
            this.appendDesignInfo(doc, designNode, mdDesign);
        }
    }

    private void appendProcessModelInfo(Document doc, Element designElm, ProcessModel processModel) {
        Element child = doc.createElement("design");
        child.setAttribute("type", StringUtilities.encodeAttributeValue(processModel.getObjectTypeName()));
        child.setAttribute("id", StringUtilities.encodeAttributeValue(processModel.getObjectID()));
        Element name = doc.createElement("name");
        name.appendChild(doc.createTextNode(StringUtilities.encodeAttributeValue(processModel.getName())));
        child.appendChild(name);
        Element comment = doc.createElement("comment");
        comment.appendChild(doc.createTextNode(StringUtilities.encodeAttributeValue(processModel.getComment())));
        child.appendChild(comment);
        designElm.appendChild(child);
        Element notes = doc.createElement("notes");
        notes.appendChild(doc.createTextNode(StringUtilities.encodeAttributeValue(processModel.getNotes())));
        child.appendChild(notes);
        designElm.appendChild(child);
        this.appendDataFlowDesignsInfo(doc, designElm, processModel);
    }

    private void appendDataFlowDesignsInfo(Document doc, Element designNode, ProcessModel processModel) {
        for (DataFlowDesign dfDesign : processModel.getDataFlowDesigns()) {
            this.appendDesignInfo(doc, designNode, dfDesign);
        }
    }

    private void handleDesignObject(Element domNode, DesignObject designObject, Map domainFileNames, Set importedFiles) {
        if (designObject instanceof Domain) {
            String fileName = ((Domain)designObject).getFileName();
            ArrayList<DesignObject> domains = null;
            if (domainFileNames.containsKey(fileName)) {
                domains = (ArrayList<DesignObject>)domainFileNames.get(fileName);
                domains.add(designObject);
            } else if (!importedFiles.contains(fileName)) {
                if (designObject.belongsToDesign()) {
                    domains = new ArrayList<DesignObject>();
                    domains.add(designObject);
                    domainFileNames.put(fileName, domains);
                    this.appendDomainFileNameNode(domNode, fileName, true);
                } else {
                    importedFiles.add(fileName);
                    this.appendDomainFileNameNode(domNode, fileName, false);
                }
            }
        }
    }

    private void handleDomainFiles(Map domainMap) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            for (String fileName : domainMap.keySet()) {
                List domainList = (List)domainMap.get(fileName);
                this.getPersistenceManager().write(domainList);
            }
        }
    }

    private void appendDomainFileNameNode(Element parentNode, String fileName, boolean contains) {
        Element domainFileElm = parentNode.getOwnerDocument().createElement("domain");
        domainFileElm.setAttribute("name", StringUtilities.encodeAttributeValue(fileName));
        domainFileElm.setAttribute("role", contains ? OBJECT_CONTAINS : OBJECT_USES);
        parentNode.appendChild(domainFileElm);
    }

    @Override
    public String getFilenameFor(Object object) {
        Design design = (Design)object;
        return new StringBuffer(design.getFileName()).append(".dmd").toString();
    }

    protected void appendImportedDesigns(Element parent, Design design) {
        String[] names = design.getImportedDesignNames();
        for (int i = 0; i < names.length; ++i) {
            Element importsElm = this.createElement(parent, "imports");
            importsElm.setAttribute("design", StringUtilities.encodeAttributeValue(names[i]));
        }
    }

    private void createProperty(Document doc, Element e, EngPropertyHolder h) {
        Element propElem = doc.createElement("property");
        propElem.setAttribute("name", StringUtilities.encodeAttributeValue(h.getName()));
        propElem.setAttribute("selected", String.valueOf(h.isSelected()));
        e.appendChild(propElem);
    }
}

