/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLFKArc
extends AbstractRXMLDesignObject {
    public RXMLFKArc(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getRelationalDesign().getArcSet().createArc(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        String mandatory;
        Table table;
        FKArc arc = (FKArc)super.recreateObject(objInfo, design, tryReadWriteLocking);
        String tableID = objInfo.getAttribute("table");
        if (tableID != null && !"".equalsIgnoreCase(tableID) && (table = (Table)design.getDesignObject(tableID)) != null) {
            table.addArc(arc);
            Map map = this.getProperties(objInfo, "fkeys");
            Object[] keys = map.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                String fkeyID = (String)map.get(key);
                if (fkeyID == null) continue;
                arc.addFKid(fkeyID);
            }
        }
        if ((mandatory = objInfo.getAttribute("mandatory")) != null && "true".equalsIgnoreCase(mandatory)) {
            arc.setMandatory(true);
        } else {
            arc.setMandatory(false);
        }
        return arc;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/');
            if (this.isOldDesign()) {
                String relDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getObjectID();
                buffer.append("relational").append('/').append(StringUtilities.decodeAttributeValue(relDesName)).append('/');
            } else {
                String relDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getPathIDString();
                buffer.append("rel").append('/').append(relDesName).append('/');
            }
        }
        buffer.append(this.getConfiguration().get("arcPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == FKArc.class;
    }
}

