/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.geom.Point2D;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.ObjectChange;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DLDomains;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.RLDomains;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLHandler;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractXMLWriter
extends AbstractXMLHandler {
    private AbstractXMLWriter successor;
    private static final Logger LOGGER = new Logger(AbstractXMLWriter.class);

    public AbstractXMLWriter(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public abstract boolean canWrite(Object var1);

    @Override
    public final boolean canRead(String objectID) {
        return false;
    }

    public boolean write(Object object) {
        try {
            Document doc = this.writeDocument(object);
            if (doc != null) {
                this.getPersistenceManager().storeDocument(doc, this.getRelativePath(object), this.getFilenameFor(object), this);
                if (this.getPersistenceManager().getAppView().getCurrentOperation() != 5) {
                    ModelIDObject mo;
                    if (object instanceof ModelIDObject && (mo = (ModelIDObject)object).getFilePath() == null) {
                        String fpath = this.getPersistenceManager().getDesignLocation() + File.separatorChar + this.getRelativePath(object) + File.separatorChar + this.getFilenameFor(object) + ".xml";
                        mo.setFilePath(fpath);
                    }
                    if (object instanceof ModelIDObject) {
                        ((ModelIDObject)object).setDirty(false);
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            this.getPersistenceManager().setSaveFailed(true);
            e.printStackTrace();
            LOGGER.error("Unable to save object: " + object, e);
            return false;
        }
    }

    public String getDocumentAsString(Object object) {
        Document doc = this.writeDocument(object);
        StringBuffer buffer = new StringBuffer();
        String data = this.prettyPrint(doc, buffer);
        return data;
    }

    public Document getDocument(Object object) {
        Document doc = this.writeDocument(object);
        return doc;
    }

    public final boolean handleWrite(Object object) {
        AbstractXMLWriter writer = this.getWriterFor(object);
        if (writer != null) {
            return writer.write(object);
        }
        return false;
    }

    public AbstractXMLWriter getWriterFor(Object object) {
        if (object instanceof RLDomains || object instanceof DLDomains) {
            return null;
        }
        if (this.canWrite(object)) {
            return this;
        }
        AbstractXMLWriter writer = this.getSuccessor();
        if (writer != null) {
            return writer.getWriterFor(object);
        }
        LOGGER.error("No writer for: " + object.getClass());
        return null;
    }

    public abstract Document writeDocument(Object var1);

    public abstract String getFilenameFor(Object var1);

    public void setSuccessor(AbstractXMLWriter writer) {
        this.successor = writer;
    }

    public AbstractXMLWriter getSuccessor() {
        return this.successor;
    }

    public AbstractXMLWriter getLast() {
        if (this.getSuccessor() == null) {
            return this;
        }
        return this.getSuccessor().getLast();
    }

    protected Element createElement(Element parent, String tagName) {
        Element element = parent.getOwnerDocument().createElement(tagName);
        parent.appendChild(element);
        return element;
    }

    protected Element createParameterElement(Element parent, String key, String value) {
        Element paramElm = this.createElement(parent, "parameter");
        paramElm.setAttribute("name", key);
        paramElm.setAttribute("value", value);
        return paramElm;
    }

    protected void appendTextNode(Element parent, String text) {
        Text node = parent.getOwnerDocument().createTextNode(text);
        parent.appendChild(node);
    }

    protected void appendMainDisplay(Element parentNode, DesignPartView dpv) {
        if (dpv.isMasterDPV()) {
            this.appendDisplay(parentNode, dpv);
        }
    }

    protected void appendSubordinateDisplays(Element parentNode, DesignPartView dpv) {
        if (dpv.isMasterDPV()) {
            Document doc = parentNode.getOwnerDocument();
            Element displays = doc.createElement("subordinate_displays");
            for (DesignPartView sdpv : dpv.getSubordinateViews()) {
                this.appendDisplay(displays, sdpv);
            }
            parentNode.appendChild(displays);
        }
    }

    protected void appendDisplay(Element parentNode, DesignPartView dpv) {
        TopView tv;
        int j;
        Document doc = parentNode.getOwnerDocument();
        Element display = dpv.isMasterDPV() ? doc.createElement("main_display") : doc.createElement("subordinate_display");
        display.setAttribute("name", StringUtilities.encodeAttributeValue(dpv.getName()));
        display.setAttribute("objectid", dpv.getDPVId());
        this.appendDisplayProperties(display, dpv);
        Object[] cellViews = dpv.getTopviewsList().toArray();
        for (j = 0; j < cellViews.length; ++j) {
            tv = (TopView)cellViews[j];
            if (tv.isConnection() || !(tv instanceof ContainerView)) continue;
            this.appendObjectReprElement(display, tv);
        }
        for (j = 0; j < cellViews.length; ++j) {
            tv = (TopView)cellViews[j];
            if (!tv.isConnection() || !tv.isConnection() || !(tv.getModel() instanceof ConnectionInterface) || !(tv instanceof TVConnector)) continue;
            this.appendConnectorInfo(display, (TVConnector)tv);
        }
        this.addDiagramViewsInDPV(dpv.getDesignPart(), display, dpv);
        ModelIDObject modelIDObject = dpv.isMasterDPV() ? dpv.getDesignPart() : dpv.getPlaceHolder();
        if (modelIDObject != null) {
            display.setAttribute("comment", StringUtilities.encodeAttributeValue(modelIDObject.getComment()));
            display.setAttribute("notes", StringUtilities.encodeAttributeValue(modelIDObject.getNotes()));
            this.appendChange(display, modelIDObject.getCreation(), "created");
            this.appendChange(display, modelIDObject.getChange(), "changed");
        }
        parentNode.appendChild(display);
    }

    private void appendObjectReprElement(Element parentNode, TopView tv) {
        Document doc = parentNode.getOwnerDocument();
        DesignObject designObject = tv.getModel();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        objInfo.setAttribute("viewid", StringUtilities.encodeAttributeValue(tv.getViewID()));
        objInfo.setAttribute("tv_generator_id", StringUtilities.encodeAttributeValue(tv.getGeneratorID()));
        objInfo.setAttribute("viewnumber", String.valueOf(tv.getViewNumber()));
        this.appendGraphInfo(objInfo, tv);
        parentNode.appendChild(objInfo);
    }

    private void appendGraphInfo(Element objInfo, TopView tv) {
        ApplicationView view = tv.getApplicationView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(tv);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    private void appendConnectorInfo(Element parentNode, TVConnector tv) {
        block15: {
            try {
                Point2D p;
                Object obj;
                int i;
                List edgePoints;
                TypeElement te;
                Document doc = parentNode.getOwnerDocument();
                ConnectionInterface connector = (ConnectionInterface)((Object)tv.getModel());
                DesignPartView dpv = tv.getDesignPartView();
                if (tv == null || connector.getSourceTopView(dpv) == null || connector.getTargetTopView(dpv) == null) break block15;
                Element objInfo = doc.createElement("objectid");
                objInfo.setAttribute("role", "represents");
                objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(((DesignObject)((Object)connector)).getObjectTypeName()));
                objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(((DesignObject)((Object)connector)).getObjectID()));
                DesignObject source = connector.getSourceObject();
                DesignObject target = connector.getTargetObject();
                if (source != null) {
                    objInfo.setAttribute("source", StringUtilities.encodeAttributeValue(source.getObjectID()));
                }
                if (target != null) {
                    objInfo.setAttribute("target", StringUtilities.encodeAttributeValue(target.getObjectID()));
                }
                if (connector instanceof DTReference && (te = ((DTReference)connector).getTypeElement()) != null) {
                    objInfo.setAttribute("stelement", StringUtilities.encodeAttributeValue(te.getObjectID()));
                }
                objInfo.setAttribute("viewid_source", connector.getSourceTopView(dpv) != null ? connector.getSourceTopView(dpv).getViewID() : NULL_STR);
                objInfo.setAttribute("viewid_target", connector.getTargetTopView(dpv) != null ? connector.getTargetTopView(dpv).getViewID() : NULL_STR);
                Element points = doc.createElement("points");
                if (tv != null && tv.getEdge() != null && tv.getEdge().getCellView() != null) {
                    edgePoints = ((EdgeView)tv.getEdge().getCellView()).getPoints();
                    for (i = 0; i < edgePoints.size(); ++i) {
                        obj = edgePoints.get(i);
                        p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                        if (p == null) continue;
                        Element point = doc.createElement("point");
                        point.setAttribute("x_coordinate", Double.toString(p.getX()));
                        point.setAttribute("y_coordinate", Double.toString(p.getY()));
                        points.appendChild(point);
                    }
                } else if (tv != null) {
                    edgePoints = tv.getEdgePoints();
                    for (i = 0; i < edgePoints.size(); ++i) {
                        obj = edgePoints.get(i);
                        p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                        if (p == null) continue;
                        Element point = doc.createElement("point");
                        point.setAttribute("x_coordinate", Double.toString(p.getX()));
                        point.setAttribute("y_coordinate", Double.toString(p.getY()));
                        points.appendChild(point);
                    }
                }
                objInfo.appendChild(points);
                EdgeView edgeView = tv.getEdgeView();
                if (edgeView != null) {
                    Element labels = doc.createElement("labels");
                    Element lbl = doc.createElement("source");
                    lbl.setAttribute("x_coordinate", Double.toString(tv.getSourceLabelBounds().getX()));
                    lbl.setAttribute("y_coordinate", Double.toString(tv.getSourceLabelBounds().getY()));
                    lbl.setAttribute("width", Double.toString(tv.getSourceLabelBounds().getWidth()));
                    lbl.setAttribute("height", Double.toString(tv.getSourceLabelBounds().getHeight()));
                    labels.appendChild(lbl);
                    Label label = tv.getLabel(0);
                    if (label != null) {
                        this.appendDesignObjectColor(lbl, label);
                        this.appendDesignObjectFonts(lbl, label);
                    }
                    lbl = doc.createElement("target");
                    lbl.setAttribute("x_coordinate", Double.toString(tv.getTargetLabelBounds().getX()));
                    lbl.setAttribute("y_coordinate", Double.toString(tv.getTargetLabelBounds().getY()));
                    lbl.setAttribute("width", Double.toString(tv.getTargetLabelBounds().getWidth()));
                    lbl.setAttribute("height", Double.toString(tv.getTargetLabelBounds().getHeight()));
                    labels.appendChild(lbl);
                    label = tv.getLabel(2);
                    if (label != null) {
                        this.appendDesignObjectColor(lbl, label);
                        this.appendDesignObjectFonts(lbl, label);
                    }
                    lbl = doc.createElement("main_label");
                    lbl.setAttribute("x_coordinate", Double.toString(tv.getLabelBounds().getX()));
                    lbl.setAttribute("y_coordinate", Double.toString(tv.getLabelBounds().getY()));
                    lbl.setAttribute("width", Double.toString(tv.getLabelBounds().getWidth()));
                    lbl.setAttribute("height", Double.toString(tv.getLabelBounds().getHeight()));
                    labels.appendChild(lbl);
                    label = tv.getLabel(1);
                    if (label != null) {
                        this.appendDesignObjectColor(lbl, label);
                        this.appendDesignObjectFonts(lbl, label);
                    }
                    objInfo.appendChild(labels);
                    Element graphycal = doc.createElement("graphical");
                    Element param = objInfo.getOwnerDocument().createElement("parameter");
                    graphycal.appendChild(param);
                    param.setAttribute("name", "use_default_color");
                    param.setAttribute("value", Boolean.toString(tv.useDefaultColor()));
                    if (!tv.useDefaultColor()) {
                        param = objInfo.getOwnerDocument().createElement("parameter");
                        graphycal.appendChild(param);
                        param.setAttribute("name", "color");
                        param.setAttribute("value", tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : NULL_STR);
                        param = objInfo.getOwnerDocument().createElement("parameter");
                        graphycal.appendChild(param);
                        param.setAttribute("name", "width");
                        param.setAttribute("value", Integer.toString(tv.getLineWidth()));
                    }
                    objInfo.appendChild(graphycal);
                }
                parentNode.appendChild(objInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void appendDisplayProperties(Element objInfo, DesignPartView dpv) {
        objInfo.setAttribute("notation", Integer.toString(dpv.getNotation()));
        objInfo.setAttribute("show_all_details", Boolean.toString(dpv.showAllDetails()));
        objInfo.setAttribute("show_names_only", Boolean.toString(dpv.isShowNamesOnly()));
        objInfo.setAttribute("show_elements", Boolean.toString(dpv.showElements()));
        objInfo.setAttribute("show_datatype", Boolean.toString(dpv.showDatatype()));
        objInfo.setAttribute("show_keys", Boolean.toString(dpv.showKeys()));
        objInfo.setAttribute("auto_route", Boolean.toString(dpv.isAutoRoute()));
        objInfo.setAttribute("box_in_box", Boolean.toString(dpv.isBoxInBox()));
    }

    protected void appendSubViews(Element parentNode, DesignPart designPart) {
        Document doc = parentNode.getOwnerDocument();
        Element subviews = doc.createElement("sub_views_collection");
        Iterator it = designPart.getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvPH = (DesignPartViewPlaceHolder)it.next();
            this.appendSubView(subviews, dpvPH, dpvPH.getDesignPartView());
        }
        parentNode.appendChild(subviews);
    }

    protected void appendSubView(Element parentNode, DesignPartViewPlaceHolder dpvPH, DesignPartView dpv) {
        Document doc = parentNode.getOwnerDocument();
        Element subView = doc.createElement("sub_view");
        subView.setAttribute("subview_name", StringUtilities.encodeAttributeValue(dpv.getName()));
        subView.setAttribute("id", dpv.getDPVId());
        subView.setAttribute("generator", dpv.getGeneratorId());
        if (dpvPH != null) {
            subView.setAttribute("visible", dpvPH.getVisible() ? "true" : "false");
            subView.setAttribute("comment", StringUtilities.encodeAttributeValue(dpvPH.getComment()));
            subView.setAttribute("notes", StringUtilities.encodeAttributeValue(dpvPH.getNotes()));
        }
        String sv_type = "sub_view";
        if (dpv == dpv.getDesignPart().getMainView()) {
            sv_type = "main_view";
        }
        subView.setAttribute("sv_type", sv_type);
        subView.setAttribute("generator", dpv.getGeneratorId());
        subView.setAttribute("rep_oid", dpv.getRepositoryOID());
        subView.setAttribute("rep_ovid", dpv.getRepositoryOVID());
        subView.setAttribute("is_checkedout", String.valueOf(dpv.isCheckedOut()));
        subView.setAttribute("checkedout_by", dpv.getCheckedOutBy());
        if (dpvPH != null) {
            this.appendChange(subView, dpvPH.getCreation(), "created");
            this.appendChange(subView, dpvPH.getChange(), "changed");
        }
        this.appendMainDisplay(subView, dpv);
        this.appendSubordinateDisplays(subView, dpv);
        parentNode.appendChild(subView);
    }

    protected void appendDiagramViews(Document doc, Element objInfo, DesignPart designPart) {
        Element elm = doc.createElement("diagram_views");
        Design design = designPart.getDesign();
        Iterator it = designPart.getDiagramViewSet().iterator();
        while (it.hasNext()) {
            DesignPartView dpv;
            DiagramView dv = (DiagramView)it.next();
            TopView tv = dv.getFirstViewForDPV(designPart.getMainView());
            if (tv == null || (dpv = dv.getDesignPartView()) == null) continue;
            DesignPart dp = dpv.getDesignPart();
            if (design.shouldExportFull(dp)) {
                this.appendDiagramViewInfo(doc, elm, dv);
                continue;
            }
            if (dpv == dp.getMainView()) {
                if (!design.shouldExportPartial(dp)) continue;
                this.appendDiagramViewInfo(doc, elm, dv);
                continue;
            }
            if (!design.shouldExportDPV(dpv)) continue;
            this.appendDiagramViewInfo(doc, elm, dv);
        }
        objInfo.appendChild(elm);
    }

    private void addDiagramViewsInDPV(DesignPart dp, Element svElement, DesignPartView dpv) {
        Iterator it = dp.getDiagramViewSet().iterator();
        while (it.hasNext()) {
            DiagramView dv = (DiagramView)it.next();
            TopView tv = dv.getFirstViewForDPV(dpv);
            if (tv == null || tv.getCellView() == null) continue;
            this.appendDiagramViewInfo(svElement.getOwnerDocument(), svElement, dv, tv);
        }
    }

    protected void appendDiagramViewInfo(Document doc, Element elm, DiagramView dv) {
        this.appendDiagramViewInfo(doc, elm, dv, null);
    }

    protected void appendDiagramViewInfo(Document doc, Element elm, DiagramView dv, TopView topView) {
        Element dvElm = doc.createElement("diagram_view");
        dvElm.setAttribute("objectid", dv.getObjectID());
        dvElm.setAttribute("dpv_id", dv.getDpvID());
        dvElm.setAttribute("dpv_name", dv.getDpvName());
        dvElm.setAttribute("composite", String.valueOf(dv.isCompositeView()));
        if (topView != null) {
            this.appendGraphInfo(dvElm, topView);
        } else {
            TopView tv = dv.getTopView();
            if (tv != null) {
                this.appendGraphInfo(dvElm, tv);
            }
        }
        elm.appendChild(dvElm);
    }

    protected void appendNamingOptions(Document doc, Element objInfo, DesignPart designPart) {
        Element elm = doc.createElement("naming_options");
        for (NamingOptionsHolder noHolder : designPart.getNamingOptionsHolderList()) {
            this.appendNamingOptionsInfo(doc, elm, noHolder);
        }
        objInfo.appendChild(elm);
    }

    protected void appendNamingOptionsInfo(Document doc, Element elm, NamingOptionsHolder nh) {
        Element noElem = doc.createElement("naming_option");
        noElem.setAttribute("class_name", nh.getClassName().getName());
        noElem.setAttribute("max_name_length", String.valueOf(nh.getMaxNameLength()));
        noElem.setAttribute("case_type", StringUtilities.encodeAttributeValue(String.valueOf(nh.getCaseType())));
        noElem.setAttribute("valid_characters", nh.getValidChars());
        noElem.setAttribute("all_valid", Boolean.toString(nh.getIsValid()));
        elm.appendChild(noElem);
    }

    protected void appendDesignObjectColor(Element objectInfoNode, DesignObject object) {
        objectInfoNode.setAttribute("use_default_color", StringUtilities.encodeAttributeValue(String.valueOf(object.useDefaultColor())));
        objectInfoNode.setAttribute("background_color", object.getBackgroundColor() != null ? Integer.toString(object.getBackgroundColor().getRGB()) : NULL_STR);
        objectInfoNode.setAttribute("foreground_color", object.getForegroundColor() != null ? Integer.toString(object.getForegroundColor().getRGB()) : NULL_STR);
    }

    protected void appendDesignObjectFonts(Element objectInfo, DesignObject designObject) {
        if (designObject instanceof EditableFonts) {
            TopView ef = designObject.getTopView();
            Element fontsElm = this.createElement(objectInfo, "fonts");
            for (FontObject fo : ef.getEditableFonts()) {
                this.appendFontObjectInfo(fontsElm, fo);
            }
        }
    }

    private void appendFontObjectInfo(Element fontsElm, FontObject fo) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("fo_type", fo.getType());
        map.put("font_name", fo.getFont().getName());
        map.put("font_style", String.valueOf(fo.getFont().getStyle()));
        map.put("font_size", String.valueOf(fo.getFont().getSize()));
        map.put("font_color", String.valueOf(fo.getColor().getRGB()));
        this.appendProperties(fontsElm, "font_object", map);
    }

    protected void appendChange(Element parentNode, ObjectChange change, String label) {
        Document doc = parentNode.getOwnerDocument();
        Element child = doc.createElement("alter");
        child.setAttribute("type", StringUtilities.encodeAttributeValue(label));
        Element grandchild = doc.createElement("user");
        Text content = doc.createTextNode(change.getUser().getName());
        grandchild.appendChild(content);
        child.appendChild(grandchild);
        grandchild = doc.createElement("timestamp");
        content = doc.createTextNode(change.getTimeString("UTC"));
        grandchild.appendChild(content);
        child.appendChild(grandchild);
        parentNode.appendChild(child);
    }
}

