/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.FKAttributeManager;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.XMLFromMapToSteramTransformer;
import oracle.dbtools.crest.model.metadata.XMLFromMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLFromObjTransformer;
import oracle.dbtools.crest.model.metadata.XMLMapToObjTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToStreamTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToStringBuilderTransformer;
import oracle.dbtools.crest.model.metadata.XMLToMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLToObjectSAXTransformer;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.RMDeletedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.DDLSelectionPersistence;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.io.FolderFilesListing;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.net.InflaterInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLTransformationManager
implements MDXMLConstants {
    public static final String EXTENSION_LOCAL_FILES = ".local";
    public static final String COMPRESSED_FILE_SUFIX = "z";
    public static final String EXTENSION_LOCAL_FILES_COMPRESSED = ".localz";
    public static final String EXTENSION_XML_FILES = ".xml";
    public static final String EXTENSION_DESIGN_FILE = ".dmd";
    public static final String EXTENSION_DESIGN_FILE_COMPRESSED = ".dmdz";
    public static final String EXTENSION_XML_FILES_COMPRESSED = ".xmlz";
    public static boolean JDOM_PARSING = false;
    public static final String OBJECT_LIST = "Objects.local";
    public static final String CHANGE_REQUEST_LIST = "ChangeRequests.local";
    public static final String SENSITIVE_TYPES_LIST = "SensitiveTypes.local";
    public static final String DIAGRAM_LIST = "Diagrams.local";
    public static final String SITE_TYPE = "siteType";
    public static final String SITE_ID = "siteID";
    public static final String SITE_NAME = "siteName";
    public static final String MARKED_GENERATE = "markedGenerate";
    public static boolean lazy_loading = false;
    private MDTransformationManager mdtManager = null;
    private boolean checkDirty = true;
    private static boolean saveFailed = false;
    private MDTransformationManager xmlMapManager = null;
    private MDTransformationManager objectMapTransManager = null;
    private MetaDataManager metaDataManager = new MetaDataManager();
    private XMLToObjectSAXTransformer xMLToObjectSAXTransformer;
    private static final Logger LOGGER = new Logger(XMLTransformationManager.class);
    FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.endsWith(XMLTransformationManager.EXTENSION_XML_FILES) || name.endsWith(XMLTransformationManager.EXTENSION_XML_FILES_COMPRESSED) || file.isDirectory();
        }
    };

    public boolean isCheckDirty() {
        return this.checkDirty;
    }

    public void setCheckDirty(boolean checkDirty) {
        this.checkDirty = checkDirty;
    }

    public String fixFilePath(String path) {
        int pos = path.indexOf(92);
        if (pos == -1) {
            return path;
        }
        return path.replaceAll("[\\\\]", "/");
    }

    public boolean designExists(String location, String fileNameNoExt) {
        for (int i = 0; i < XMLConstants.DESIGN_EXTENSIONS.length; ++i) {
            String ext = XMLConstants.DESIGN_EXTENSIONS[i];
            File file = new File(location, fileNameNoExt + ext);
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public boolean deleteDesign(String location, String fileNameNoExt) {
        File file = null;
        boolean result = true;
        if (fileNameNoExt != null) {
            for (int i = 0; i < XMLConstants.DESIGN_EXTENSIONS.length; ++i) {
                String ext = XMLConstants.DESIGN_EXTENSIONS[i];
                file = new File(location, fileNameNoExt + ext);
                if (!file.exists()) continue;
                result = file.delete();
            }
            file = new File(location, fileNameNoExt);
            if (file.exists() && file.isDirectory()) {
                result = this.deleteDirectory(file);
            }
        }
        return result;
    }

    public boolean deleteFiles(List files) {
        boolean result = false;
        System.gc();
        for (int i = 0; i < files.size(); ++i) {
            File file;
            String filePath = (String)files.get(i);
            if (filePath == null || !(file = new File(this.fixFilePath(filePath))).exists()) continue;
            if (file.isDirectory()) {
                result = this.deleteDirectory(file);
                continue;
            }
            result = file.delete();
            if (result) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            result = file.delete();
        }
        return result;
    }

    public boolean deleteDirectory(File dir) {
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
            return dir.delete();
        }
        return false;
    }

    private void addObjectsToLists(DesignPart dp, List<StorableObject> list, Map pdMap, boolean multi, boolean single) {
        boolean partial = dp.getDesign().shouldExportPartial(dp);
        if (pdMap != null) {
            Boolean shouldSave = this.shouldSave(dp);
            pdMap.put(dp, shouldSave);
        }
        for (ModelIDObject obj : dp.getStorableDesignObjects()) {
            if (!multi && !obj.isUsedAsRemoteObject() || (dp instanceof LogicalDesign || dp instanceof RelationalDesign) && partial && !dp.getDesign().shouldExport((DesignObject)obj)) continue;
            list.add(obj);
        }
    }

    public boolean saveDesignFile(Design design) {
        return XMLTransformationManager.saveContentOfObject(design.getStorageName(), design, design.isCompressedDesign(), this.getMDTransformationManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveDesign(Design design) {
        try {
            TransformationPackage tp;
            Iterator tpit;
            ProcessModel processModel;
            DataTypesDesign dataTypesDesign;
            saveFailed = false;
            int oper = design.getCurrentOperation();
            if (oper == 4 || oper == 5) {
                this.checkDirty = false;
            }
            int pers = design.getModelPersistence();
            boolean multi = design.isVersioned() || pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_MANY_FILES;
            boolean single = !design.isVersioned() && (pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE);
            HashMap<StorageDesign, Boolean> dpMap = new HashMap<StorageDesign, Boolean>();
            this.saveRDBMSSites(design);
            this.saveDomains(design);
            this.saveChangeRequestList(design);
            if (oper == 4) {
                this.saveAdditionalFiles(design);
            }
            ArrayList<StorableObject> list = new ArrayList<StorableObject>();
            list.add(design);
            if (this.isCheckDirty()) {
                if (design.getExtendedMap().isDirty()) {
                    list.add(design.getExtendedMap());
                }
            } else {
                list.add(design.getExtendedMap());
            }
            boolean processSVNadd = this.scanForNewModelsInOldDesign(design, single);
            Iterator requests = design.getChangeRequestSet().iterator();
            while (requests.hasNext()) {
                ChangeRequest req = (ChangeRequest)requests.next();
                list.add(req);
            }
            if (this.isCheckDirty()) {
                if (design.getBusinessInfoDesign().isLoaded() && (design.getBusinessInfoDesign().isDirty() || design.getBusinessInfoDesign().hasDirtyStorableObjects())) {
                    list.add(design.getBusinessInfoDesign());
                    this.addObjectsToLists(design.getBusinessInfoDesign(), list, dpMap, multi, single);
                    this.saveObjectList(design.getBusinessInfoDesign());
                }
            } else if (design.getBusinessInfoDesign().isLoaded() && design.shouldExportFull(design.getBusinessInfoDesign())) {
                list.add(design.getBusinessInfoDesign());
                this.addObjectsToLists(design.getBusinessInfoDesign(), list, dpMap, multi, single);
                this.saveObjectList(design.getBusinessInfoDesign());
            }
            if ((dataTypesDesign = design.getDataTypesDesign()).isLoaded() && (design.shouldExportFull(dataTypesDesign) || design.shouldExportPartial(dataTypesDesign))) {
                list.add(dataTypesDesign);
                this.addObjectsToLists(dataTypesDesign, list, dpMap, multi, single);
                this.saveObjectList(dataTypesDesign);
                if (multi) {
                    this.saveDiagrams(dataTypesDesign);
                } else {
                    this.saveDiagramsList(dataTypesDesign);
                }
                DDLSelectionPersistence.saveDDLSelection(dataTypesDesign, dataTypesDesign.getNotMarkedGenerateObjects());
            }
            if (design.getLogicalDesign().isLoaded() && (design.shouldExportFull(design.getLogicalDesign()) || design.shouldExportPartial(design.getLogicalDesign()))) {
                list.add(design.getLogicalDesign());
                this.addObjectsToLists(design.getLogicalDesign(), list, dpMap, multi, single);
                this.saveObjectList(design.getLogicalDesign());
                if (multi) {
                    this.saveDiagrams(design.getLogicalDesign());
                } else {
                    this.saveDiagramsList(design.getLogicalDesign());
                }
            }
            for (DesignPart model : design.getRelationalDesigns()) {
                if (!model.isLoaded() || !design.shouldExportFull(model) && !design.shouldExportPartial(model)) continue;
                RelationalDesign relationalDesign = (RelationalDesign)model;
                list.add(model);
                if (this.isCheckDirty()) {
                    if (relationalDesign.getRMExtendedMap().isDirty()) {
                        list.add(relationalDesign.getRMExtendedMap());
                    }
                    if (relationalDesign.getRMDeletedMap().isDirty()) {
                        list.add(relationalDesign.getRMDeletedMap());
                    }
                } else {
                    list.add(relationalDesign.getRMExtendedMap());
                    list.add(relationalDesign.getRMDeletedMap());
                }
                this.addObjectsToLists(model, list, dpMap, multi, single);
                this.saveObjectList(model);
                if (multi) {
                    this.saveDiagrams(model);
                } else {
                    this.saveDiagramsList(model);
                }
                DDLSelectionPersistence.saveDDLSelection(relationalDesign, relationalDesign.getNotMarkedGenerateObjects());
                StorageDesign[] storageDesigns = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
                for (int i = 0; i < storageDesigns.length; ++i) {
                    List sol;
                    StorageDesign stDes = storageDesigns[i];
                    if (!stDes.isOpen()) continue;
                    DataModelerAddin.saveAllEditors(stDes);
                    Boolean shouldSave = stDes.isOpen() && (stDes.isDirty() || stDes.hasDirtyStorableObjects() || relationalDesign.hasDirtyStorableObjects());
                    dpMap.put(stDes, shouldSave);
                    list.add(stDes);
                    DDLSelectionPersistence.saveDDLSelection(stDes, false);
                    if (this.isCheckDirty()) {
                        if (stDes.isDirty() || stDes.hasDirtyStorableObjects() || shouldSave.booleanValue()) {
                            if (design.isOldRepositoryType()) {
                                this.clearPropertyMap(stDes.getStorableObjects());
                            }
                            if (multi) {
                                if (design.shouldExportPartial(model)) {
                                    sol = stDes.getStorableObjects();
                                    for (Object obj : sol) {
                                        if (!(obj instanceof RelationalObjectProxy) || !design.shouldExport((RelationalObjectProxy)obj)) continue;
                                        list.add((StorableObject)obj);
                                    }
                                } else {
                                    List stObjects = stDes.getStorableObjects();
                                    block12: for (StorableObject so : stObjects) {
                                        String soID = null;
                                        ModelIDObject mo = null;
                                        if (!(so instanceof ModelIDObject) || so.isDirty() || !relationalDesign.hasDirtyStorableObjects()) continue;
                                        mo = (ModelIDObject)so;
                                        soID = mo.getObjectID();
                                        if (relationalDesign.getStorableDesignObjects() == null) continue;
                                        Collection sdoCollection = relationalDesign.getStorableDesignObjects();
                                        for (Object sdo : sdoCollection) {
                                            ModelIDObject rmo;
                                            if (!(sdo instanceof ModelIDObject) || !soID.equalsIgnoreCase((rmo = (ModelIDObject)sdo).getObjectID())) continue;
                                            if (mo == null || !rmo.isDirty()) continue block12;
                                            so.setDirty(true);
                                            continue block12;
                                        }
                                    }
                                    list.addAll(stDes.getStorableObjects());
                                }
                            }
                        }
                    } else {
                        if (design.isOldRepositoryType()) {
                            this.clearPropertyMap(stDes.getStorableObjects());
                        }
                        if (multi) {
                            if (design.shouldExportPartial(model)) {
                                sol = stDes.getStorableObjects();
                                for (Object obj : sol) {
                                    if (!(obj instanceof RelationalObjectProxy) || !design.shouldExport((RelationalObjectProxy)obj)) continue;
                                    list.add((StorableObject)obj);
                                }
                            } else {
                                list.addAll(stDes.getStorableObjects());
                            }
                        }
                    }
                    this.saveObjectList(stDes);
                }
            }
            for (MultidimensionalDesign mdDesign : design.getMultidimensionalDesigns()) {
                this.saveObjectList(mdDesign);
                this.saveDiagrams(mdDesign);
                if (!multi) {
                    this.saveDiagramsList(mdDesign);
                }
                if (this.isCheckDirty()) {
                    if (!mdDesign.isLoaded() || !mdDesign.isDirty() && !mdDesign.hasDirtyStorableObjects()) continue;
                    list.add(mdDesign);
                    this.addObjectsToLists(mdDesign, list, dpMap, multi, single);
                    continue;
                }
                if (!mdDesign.isLoaded() || !design.shouldExportFull(mdDesign) && !design.shouldExportPartial(mdDesign)) continue;
                list.add(mdDesign);
                this.addObjectsToLists(mdDesign, list, dpMap, multi, single);
            }
            if (this.isCheckDirty()) {
                if (design.getProcessModel().isLoaded()) {
                    processModel = design.getProcessModel();
                    this.saveObjectList(processModel);
                    list.add(processModel);
                    this.addObjectsToLists(processModel, list, dpMap, multi, single);
                    for (DataFlowDesign dfDesign : processModel.getDataFlowDesigns()) {
                        this.saveObjectList(dfDesign);
                        if (multi) {
                            this.saveDiagrams(dfDesign);
                        } else {
                            this.saveDiagramsList(dfDesign);
                        }
                        if (!dfDesign.isLoaded() || !dfDesign.isDirty() && !dfDesign.hasDirtyStorableObjects()) continue;
                        list.add(dfDesign);
                        this.addObjectsToLists(dfDesign, list, dpMap, multi, single);
                    }
                    tpit = design.getProcessModel().getTransformationPackageSet().iterator();
                    while (tpit.hasNext()) {
                        tp = (TransformationPackage)tpit.next();
                        for (TransformationTask tt : tp.getTransformationTaskSet()) {
                            this.saveObjectList(tt);
                            if (multi) {
                                this.saveDiagrams(tt);
                            } else {
                                this.saveDiagramsList(tt);
                            }
                            if (!tt.isLoaded() || !tt.isDirty() && !tt.hasDirtyStorableObjects()) continue;
                            list.add(tt);
                            this.addObjectsToLists(tt, list, dpMap, multi, single);
                        }
                    }
                }
            } else if (design.getProcessModel().isLoaded() && design.shouldExportFull(design.getProcessModel())) {
                processModel = design.getProcessModel();
                this.saveObjectList(processModel);
                list.add(processModel);
                this.addObjectsToLists(processModel, list, dpMap, multi, single);
                for (DataFlowDesign dfDesign : processModel.getDataFlowDesigns()) {
                    this.saveObjectList(dfDesign);
                    if (multi) {
                        this.saveDiagrams(dfDesign);
                    } else {
                        this.saveDiagramsList(dfDesign);
                    }
                    if (!dfDesign.isLoaded()) continue;
                    list.add(dfDesign);
                    this.addObjectsToLists(dfDesign, list, dpMap, multi, single);
                }
                tpit = design.getProcessModel().getTransformationPackageSet().iterator();
                while (tpit.hasNext()) {
                    tp = (TransformationPackage)tpit.next();
                    for (TransformationTask tt : tp.getTransformationTaskSet()) {
                        this.saveObjectList(tt);
                        if (multi) {
                            this.saveDiagrams(tt);
                        } else {
                            this.saveDiagramsList(tt);
                        }
                        if (!tt.isLoaded()) continue;
                        list.add(tt);
                        this.addObjectsToLists(tt, list, dpMap, multi, single);
                    }
                }
            }
            ArrayList<StorableObject> dpList = new ArrayList<StorableObject>();
            for (StorableObject obj : list) {
                if (obj instanceof DesignPart || obj instanceof StorageDesign) {
                    dpList.add(obj);
                    continue;
                }
                this.saveObject(obj);
            }
            for (ModelIDObject modelIDObject : dpList) {
                this.saveObject(modelIDObject);
                if (modelIDObject instanceof DesignPart) {
                    DesignPart dp = (DesignPart)modelIDObject;
                    try {
                        if (single) {
                            this.saveDesignPartSingleFile(dp);
                        }
                        if (design.getCurrentOperation() == 5) continue;
                        dp.doAfterSave();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in cleaning files in model: " + dp.getName(), e);
                    }
                    continue;
                }
                if (!(modelIDObject instanceof StorageDesign)) continue;
                StorageDesign sd = (StorageDesign)modelIDObject;
                try {
                    if (single) {
                        this.savePhysicalModelSingleFile(sd);
                    }
                    if (design.getCurrentOperation() == 5) continue;
                    sd.doAfterSave();
                }
                catch (Exception e) {
                    LOGGER.error("Error in cleaning files in physical model: " + sd.getName(), e);
                }
            }
            if (processSVNadd) {
                this.addNewModelsToSVN(design, dpList);
            }
            design.setLoadedModelPersistence(design.getModelPersistence());
            design.setStorableObjectStatuses(null);
            if (saveFailed) {
                MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectly"), true);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Unable to save the design: " + design.getName(), ex);
            MessageDialogs.showErrorMessage("Unable to save the design: " + design.getName());
            return false;
        }
    }

    private boolean scanForNewModelsInOldDesign(Design design, boolean single) {
        boolean processSVNadd = false;
        if (Extension.isSVNExtensionLoaded() && !design.isNewDesign() && design.isVersioned()) {
            ArrayList<ModelIDObject> dpList = new ArrayList<ModelIDObject>();
            for (DesignPart designPart : design.getRelationalDesigns()) {
                dpList.add(designPart);
                for (StorageDesign stoDesign : designPart.getStorageDesignFactory().getSorageDesigns()) {
                    dpList.add(stoDesign);
                }
            }
            for (DesignPart designPart : design.getMultidimensionalDesigns()) {
                dpList.add(designPart);
            }
            for (DesignPart designPart : design.getProcessModel().getDataFlowDesigns()) {
                dpList.add(designPart);
            }
            for (DesignPart designPart : design.getProcessModel().getAllTransformationTasks()) {
                dpList.add(designPart);
            }
            for (ModelIDObject object : dpList) {
                if (object instanceof DesignPart) {
                    DesignPart dp = (DesignPart)object;
                    if (single || design.getCurrentOperation() == 5 || !dp.isNewModel()) continue;
                    dp.setAddObjectsToSVNatModelLevel(true);
                    processSVNadd = true;
                    continue;
                }
                if (!(object instanceof StorageDesign)) continue;
                StorageDesign sd = (StorageDesign)object;
                if (single || design.getCurrentOperation() == 5 || !sd.isNewModel()) continue;
                sd.setAddObjectsToSVNatModelLevel(true);
                processSVNadd = true;
            }
        }
        return processSVNadd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewModelsToSVN(Design design, List models) {
        if (Extension.isSVNExtensionLoaded()) {
            SVNClientHelper svnClientHelper = SVNClientHelper.getInstance();
            if (!design.isNewDesign() && design.isVersioned()) {
                DesignPart dp;
                StorageDesign sd;
                ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
                for (ModelIDObject object : models) {
                    if (!(object instanceof StorageDesign) || !(sd = (StorageDesign)object).getPhysicalDesign().isAddObjectsToSVNatModelLevel()) continue;
                    sd.setAddObjectsToSVNatModelLevel(false);
                }
                TimeLog.log("start  adding to SVN - for new models");
                for (ModelIDObject object : models) {
                    if (object instanceof StorageDesign) {
                        sd = (StorageDesign)object;
                        if (!sd.isAddObjectsToSVNatModelLevel()) continue;
                        try {
                            list.add(sd);
                            svnClientHelper.doAdd(new File(sd.getStoragePath()), true);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        finally {
                            sd.setAddObjectsToSVNatModelLevel(false);
                            continue;
                        }
                    }
                    if (!(object instanceof DesignPart) || !(dp = (DesignPart)object).isAddObjectsToSVNatModelLevel()) continue;
                    try {
                        list.add(dp);
                        boolean upperFileAdded = false;
                        File fileToAdd = new File(dp.getStoragePath());
                        if (!svnClientHelper.isVersioned(fileToAdd)) {
                            if (svnClientHelper.isVersioned(fileToAdd.getParentFile())) {
                                svnClientHelper.doAdd(fileToAdd, true);
                            } else {
                                File upperFileToAdd = fileToAdd = fileToAdd.getParentFile();
                                while (!svnClientHelper.isVersioned(fileToAdd)) {
                                    upperFileToAdd = fileToAdd;
                                    fileToAdd = fileToAdd.getParentFile();
                                }
                                svnClientHelper.doAdd(upperFileToAdd, true);
                                upperFileAdded = true;
                            }
                        }
                        if (dp instanceof TransformationTask && XMLTransformationManager.isFileAndDirModel(dp.getClass())) {
                            File modelFile = new File(dp.getStoragePath()).getParentFile().getParentFile();
                            svnClientHelper.doAdd(new File(modelFile.getAbsolutePath() + EXTENSION_XML_FILES), true);
                            continue;
                        }
                        if (upperFileAdded || !XMLTransformationManager.isFileAndDirModel(dp.getClass())) continue;
                        svnClientHelper.doAdd(new File(dp.getStorageName()), true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        dp.setAddObjectsToSVNatModelLevel(false);
                    }
                }
                TimeLog.log("start  set properties for new models");
                for (ModelIDObject object : list) {
                    if (object instanceof StorageDesign) {
                        sd = (StorageDesign)object;
                        svnClientHelper.saveProperties((StorableObject)sd);
                        Iterator storableObjects = sd.getStorableObjects().iterator();
                        while (storableObjects.hasNext()) {
                            svnClientHelper.saveProperties((StorableObject)((ModelIDObject)storableObjects.next()));
                        }
                        continue;
                    }
                    if (!(object instanceof DesignPart)) continue;
                    dp = (DesignPart)object;
                    svnClientHelper.saveDesignPartProperties(dp, true);
                    if (!(dp instanceof BusinessInfoDesign)) {
                        svnClientHelper.saveDPVs(dp, true, true);
                    }
                    if (!(dp instanceof RelationalDesign)) continue;
                    RelationalDesign rd = (RelationalDesign)dp;
                    for (StorageDesign stoDesign : rd.getStorageDesignFactory().getSorageDesigns()) {
                        svnClientHelper.saveProperties((ModelIDObject)stoDesign, true);
                        Iterator storableObjects = stoDesign.getStorableObjects().iterator();
                        while (storableObjects.hasNext()) {
                            svnClientHelper.saveProperties((ModelIDObject)storableObjects.next(), true);
                        }
                    }
                }
                TimeLog.log("end  set properties for new models");
            }
        }
    }

    public static boolean isFileAndDirModel(Class aClass) {
        return aClass != null && (RelationalDesign.class.isAssignableFrom(aClass) || MultidimensionalDesign.class.isAssignableFrom(aClass) || DataFlowDesign.class.isAssignableFrom(aClass) || TransformationTask.class.isAssignableFrom(aClass) || Design.class.isAssignableFrom(aClass) || TransformationPackage.class.isAssignableFrom(aClass));
    }

    /*
     * WARNING - void declaration
     */
    public boolean saveDesignOld(Design design) {
        try {
            Iterator tpit;
            ProcessModel processModel;
            DataTypesDesign dataTypesDesign;
            saveFailed = false;
            int oper = design.getCurrentOperation();
            if (oper == 4 || oper == 5) {
                this.checkDirty = false;
            }
            int pers = design.getModelPersistence();
            boolean multi = design.isVersioned() || pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_MANY_FILES;
            boolean single = !design.isVersioned() && (pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE);
            this.saveRDBMSSites(design);
            this.saveDomains(design);
            this.saveChangeRequestList(design);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(design);
            if (this.isCheckDirty()) {
                if (design.getExtendedMap().isDirty()) {
                    list.add(design.getExtendedMap());
                }
            } else {
                list.add(design.getExtendedMap());
            }
            Iterator requests = design.getChangeRequestSet().iterator();
            while (requests.hasNext()) {
                ChangeRequest req = (ChangeRequest)requests.next();
                list.add(req);
            }
            if (this.isCheckDirty()) {
                if (design.getBusinessInfoDesign().isLoaded() && (design.getBusinessInfoDesign().isDirty() || design.getBusinessInfoDesign().hasDirtyStorableObjects())) {
                    list.add(design.getBusinessInfoDesign());
                    list.addAll(design.getBusinessInfoDesign().getStorableDesignObjects());
                    this.saveObjectList(design.getBusinessInfoDesign());
                }
            } else if (design.getBusinessInfoDesign().isLoaded() && design.shouldExportFull(design.getBusinessInfoDesign())) {
                list.add(design.getBusinessInfoDesign());
                list.addAll(design.getBusinessInfoDesign().getStorableDesignObjects());
                this.saveObjectList(design.getBusinessInfoDesign());
            }
            if ((dataTypesDesign = design.getDataTypesDesign()).isLoaded() && (design.shouldExportFull(dataTypesDesign) || design.shouldExportPartial(dataTypesDesign))) {
                list.add(dataTypesDesign);
                list.addAll(dataTypesDesign.getStorableDesignObjects());
                this.saveObjectList(dataTypesDesign);
                this.saveDiagrams(dataTypesDesign);
                DDLSelectionPersistence.saveDDLSelection(dataTypesDesign, dataTypesDesign.getNotMarkedGenerateObjects());
            }
            if (design.getLogicalDesign().isLoaded() && (design.shouldExportFull(design.getLogicalDesign()) || design.shouldExportPartial(design.getLogicalDesign()))) {
                list.add(design.getLogicalDesign());
                if (design.shouldExportPartial(design.getLogicalDesign())) {
                    Collection pc = design.getLogicalDesign().getStorableDesignObjects();
                    for (DesignObject designObject : pc) {
                        if (!design.shouldExport(designObject)) continue;
                        list.add(designObject);
                    }
                } else {
                    list.addAll(design.getLogicalDesign().getStorableDesignObjects());
                }
                this.saveObjectList(design.getLogicalDesign());
                this.saveDiagrams(design.getLogicalDesign());
            }
            for (DesignPart model : design.getRelationalDesigns()) {
                void var13_24;
                if (!model.isLoaded() || !design.shouldExportFull(model) && !design.shouldExportPartial(model)) continue;
                RelationalDesign relationalDesign = (RelationalDesign)model;
                list.add(model);
                if (this.isCheckDirty()) {
                    if (relationalDesign.getRMExtendedMap().isDirty()) {
                        list.add(relationalDesign.getRMExtendedMap());
                    }
                    if (relationalDesign.getRMDeletedMap().isDirty()) {
                        list.add(relationalDesign.getRMDeletedMap());
                    }
                } else {
                    list.add(relationalDesign.getRMExtendedMap());
                    list.add(relationalDesign.getRMDeletedMap());
                }
                if (design.shouldExportPartial(model)) {
                    Collection collection = model.getStorableDesignObjects();
                    for (DesignObject designObject : collection) {
                        if (!design.shouldExport(designObject)) continue;
                        list.add(designObject);
                    }
                } else {
                    list.addAll(model.getStorableDesignObjects());
                }
                this.saveObjectList(model);
                this.saveDiagrams(model);
                DDLSelectionPersistence.saveDDLSelection(relationalDesign, relationalDesign.getNotMarkedGenerateObjects());
                StorageDesign[] storageDesignArray = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
                boolean bl = false;
                while (var13_24 < storageDesignArray.length) {
                    StorageDesign stDes = storageDesignArray[var13_24];
                    if (stDes.isOpen()) {
                        List sol;
                        DataModelerAddin.saveAllEditors(stDes);
                        list.add(stDes);
                        DDLSelectionPersistence.saveDDLSelection(stDes, false);
                        if (this.isCheckDirty()) {
                            if (stDes.isDirty() || stDes.hasDirtyStorableObjects()) {
                                if (design.isOldRepositoryType()) {
                                    this.clearPropertyMap(stDes.getStorableObjects());
                                }
                                if (design.shouldExportPartial(model)) {
                                    sol = stDes.getStorableObjects();
                                    for (Object obj : sol) {
                                        if (!(obj instanceof RelationalObjectProxy) || !design.shouldExport((RelationalObjectProxy)obj)) continue;
                                        list.add((StorableObject)obj);
                                    }
                                } else {
                                    list.addAll(stDes.getStorableObjects());
                                }
                            }
                        } else {
                            if (design.isOldRepositoryType()) {
                                this.clearPropertyMap(stDes.getStorableObjects());
                            }
                            if (design.shouldExportPartial(model)) {
                                sol = stDes.getStorableObjects();
                                for (Object obj : sol) {
                                    if (!(obj instanceof RelationalObjectProxy) || !design.shouldExport((RelationalObjectProxy)obj)) continue;
                                    list.add((StorableObject)obj);
                                }
                            } else {
                                list.addAll(stDes.getStorableObjects());
                            }
                        }
                        this.saveObjectList(stDes);
                    }
                    ++var13_24;
                }
            }
            for (MultidimensionalDesign mdDesign : design.getMultidimensionalDesigns()) {
                this.saveObjectList(mdDesign);
                this.saveDiagrams(mdDesign);
                if (this.isCheckDirty()) {
                    if (!mdDesign.isLoaded() || !mdDesign.isDirty() && !mdDesign.hasDirtyStorableObjects()) continue;
                    list.add(mdDesign);
                    list.addAll(mdDesign.getStorableDesignObjects());
                    continue;
                }
                if (!mdDesign.isLoaded() || !design.shouldExportFull(mdDesign) && !design.shouldExportPartial(mdDesign)) continue;
                list.add(mdDesign);
                list.addAll(mdDesign.getStorableDesignObjects());
            }
            if (this.isCheckDirty()) {
                if (design.getProcessModel().isLoaded()) {
                    processModel = design.getProcessModel();
                    this.saveObjectList(processModel);
                    list.add(processModel);
                    list.addAll(processModel.getStorableDesignObjects());
                    for (DataFlowDesign dfDesign : processModel.getDataFlowDesigns()) {
                        this.saveObjectList(dfDesign);
                        this.saveDiagrams(dfDesign);
                        if (!dfDesign.isLoaded() || !dfDesign.isDirty() && !dfDesign.hasDirtyStorableObjects()) continue;
                        list.add(dfDesign);
                        list.addAll(dfDesign.getStorableDesignObjects());
                    }
                    tpit = design.getProcessModel().getTransformationPackageSet().iterator();
                    while (tpit.hasNext()) {
                        TransformationPackage transformationPackage = (TransformationPackage)tpit.next();
                        for (TransformationTask tt : transformationPackage.getTransformationTaskSet()) {
                            this.saveObjectList(tt);
                            this.saveDiagrams(tt);
                            if (!tt.isLoaded() || !tt.isDirty() && !tt.hasDirtyStorableObjects()) continue;
                            list.add(tt);
                            list.addAll(tt.getStorableDesignObjects());
                        }
                    }
                }
            } else if (design.getProcessModel().isLoaded() && design.shouldExportFull(design.getProcessModel())) {
                processModel = design.getProcessModel();
                this.saveObjectList(processModel);
                list.add(processModel);
                list.addAll(processModel.getStorableDesignObjects());
                for (DataFlowDesign dfDesign : processModel.getDataFlowDesigns()) {
                    this.saveObjectList(dfDesign);
                    this.saveDiagrams(dfDesign);
                    if (!dfDesign.isLoaded()) continue;
                    list.add(dfDesign);
                    list.addAll(dfDesign.getStorableDesignObjects());
                }
                tpit = design.getProcessModel().getTransformationPackageSet().iterator();
                while (tpit.hasNext()) {
                    TransformationPackage transformationPackage = (TransformationPackage)tpit.next();
                    for (TransformationTask tt : transformationPackage.getTransformationTaskSet()) {
                        this.saveObjectList(tt);
                        this.saveDiagrams(tt);
                        if (!tt.isLoaded()) continue;
                        list.add(tt);
                        list.addAll(tt.getStorableDesignObjects());
                    }
                }
            }
            ArrayList<StorableObject> dpList = new ArrayList<StorableObject>();
            for (StorableObject storableObject : list) {
                if (storableObject instanceof DesignPart || storableObject instanceof StorageDesign) {
                    dpList.add(storableObject);
                    continue;
                }
                this.saveObject(storableObject);
            }
            for (ModelIDObject modelIDObject : dpList) {
                this.saveObject(modelIDObject);
                if (modelIDObject instanceof DesignPart) {
                    DesignPart dp = (DesignPart)modelIDObject;
                    try {
                        if (design.getCurrentOperation() == 5 || pers == Design.PERS_MODEL_IN_ONE_FILE) continue;
                        dp.synchronizeFilesMap(true);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in cleaning files in model: " + dp.getName(), e);
                    }
                    continue;
                }
                if (!(modelIDObject instanceof StorageDesign)) continue;
                StorageDesign sd = (StorageDesign)modelIDObject;
                try {
                    sd.doAfterSave();
                }
                catch (Exception e) {
                    LOGGER.error("Error in cleaning files in physical model: " + sd.getName(), e);
                }
            }
            if (saveFailed) {
                MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectly"), true);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Unable to save the design: " + design.getName(), ex);
            MessageDialogs.showErrorMessage("Unable to save the design: " + design.getName());
            return false;
        }
    }

    private boolean shouldSave(DesignPart designPart) {
        boolean shouldSave = designPart.isLoaded() && (!this.isCheckDirty() || this.isCheckDirty() && (designPart.isDirty() || designPart.hasDirtyStorableObjects()));
        return shouldSave;
    }

    public boolean saveDesignPart(DesignPart designPart) {
        boolean shouldSave;
        boolean result = false;
        Design des = designPart.getDesign();
        int pers = des.getModelPersistence();
        boolean bl = shouldSave = designPart.isLoaded() && (!this.isCheckDirty() || this.isCheckDirty() && (designPart.isDirty() || designPart.hasDirtyStorableObjects()));
        if (des.isVersioned() || pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_MANY_FILES) {
            result = this.saveDesignPartMultiFiles(designPart);
            if (result && shouldSave && (pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE)) {
                result = this.saveDesignPartSingleFile(designPart);
            }
        } else if (pers == Design.PERS_MODEL_IN_ONE_FILE) {
            result = this.saveDesignPartSingleFile(designPart);
            this.saveDesignPartSFAdditionalObjects(designPart);
        }
        return result;
    }

    private void addSFAdditionalObjectsToLists(DesignPart dp, List<StorableObject> list, boolean multi, boolean single) {
        boolean partial = dp.getDesign().shouldExportPartial(dp);
        for (ModelIDObject obj : dp.getStorableDesignObjects()) {
            if (multi || !single || !obj.isUsedAsRemoteObject() || (dp instanceof LogicalDesign || dp instanceof RelationalDesign) && partial && !dp.getDesign().shouldExport((DesignObject)obj)) continue;
            list.add(obj);
        }
    }

    public boolean saveDesignPartSFAdditionalObjects(DesignPart designPart) {
        if (designPart.isLoaded()) {
            try {
                Design des = designPart.getDesign();
                int pers = des.getModelPersistence();
                boolean multi = des.isVersioned() || pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_MANY_FILES;
                boolean single = !des.isVersioned() && (pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE);
                ArrayList<StorableObject> list = new ArrayList<StorableObject>();
                this.addSFAdditionalObjectsToLists(designPart, list, multi, single);
                if (this.isCheckDirty()) {
                    if (designPart instanceof RelationalDesign) {
                        RelationalDesign relationalDesign = (RelationalDesign)designPart;
                        if (relationalDesign.getRMExtendedMap().isDirty()) {
                            list.add(relationalDesign.getRMExtendedMap());
                        }
                        if (relationalDesign.getRMDeletedMap().isDirty()) {
                            list.add(relationalDesign.getRMDeletedMap());
                        }
                    }
                } else if (designPart instanceof RelationalDesign) {
                    list.add(((RelationalDesign)designPart).getRMExtendedMap());
                    list.add(((RelationalDesign)designPart).getRMDeletedMap());
                }
                for (StorableObject obj : list) {
                    this.saveObject(obj);
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveDesignPartSingleFile(DesignPart designPart) {
        if (designPart.isLoaded()) {
            String storageName = designPart.getStoragePath() + File.separatorChar + designPart.getShortObjectID() + ".model.local";
            TimeLog.log("start save operation");
            try {
                MDTransformationManager trMan = this.getMDTransformationManager();
                File fPath = new File(storageName).getParentFile();
                if (!fPath.exists()) {
                    fPath.mkdirs();
                }
                saveFailed = false;
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    FileOutputStream fs = new FileOutputStream(new File(storageName));
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                    BufferedWriter bs = new BufferedWriter(osw, 8192);
                    if (designPart instanceof RelationalDesign) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add("rmExtendedMap");
                        list.add("StorageDesigns");
                        XMLTransformationManager.writeContentAsStream(designPart, bs, trMan, true, list);
                    } else {
                        XMLTransformationManager.writeContentAsStream(designPart, bs, trMan, true, null);
                    }
                    bs.flush();
                    bs.close();
                    if (designPart.isDirty()) {
                        this.saveObject(designPart);
                    }
                    if (!(designPart instanceof BusinessInfoDesign) && !(designPart instanceof ProcessModel)) {
                        this.saveDiagramsList(designPart);
                    }
                    try {
                        int pers = designPart.getDesign().getModelPersistence();
                        if (pers != Design.PERS_MODEL_IN_ONE_FILE) {
                            designPart.synchronizeFilesMap(true);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in cleaning files in model: " + designPart.getName(), e);
                    }
                    TimeLog.log("end save operation");
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                if (saveFailed) {
                    MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectly"), true);
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
                MessageDialogs.showErrorMessage(message, true);
            }
        }
        return false;
    }

    public boolean saveDesignPartMultiFiles(DesignPart designPart) {
        try {
            saveFailed = false;
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(designPart);
            if (this.isCheckDirty()) {
                if (designPart.isLoaded() && (designPart.isDirty() || designPart.hasDirtyStorableObjects())) {
                    list.addAll(designPart.getStorableDesignObjects());
                    if (!(designPart instanceof BusinessInfoDesign) && !(designPart instanceof ProcessModel)) {
                        this.saveDiagrams(designPart);
                    }
                }
                if (designPart instanceof RelationalDesign) {
                    RelationalDesign relationalDesign = (RelationalDesign)designPart;
                    if (relationalDesign.getRMExtendedMap().isDirty()) {
                        list.add(relationalDesign.getRMExtendedMap());
                    }
                    if (relationalDesign.getRMDeletedMap().isDirty()) {
                        list.add(relationalDesign.getRMDeletedMap());
                    }
                }
            } else if (designPart.isLoaded()) {
                list.addAll(designPart.getStorableDesignObjects());
                if (designPart instanceof RelationalDesign) {
                    list.add(((RelationalDesign)designPart).getRMExtendedMap());
                    list.add(((RelationalDesign)designPart).getRMDeletedMap());
                }
                if (!(designPart instanceof BusinessInfoDesign) && !(designPart instanceof ProcessModel)) {
                    this.saveDiagrams(designPart);
                }
            }
            ArrayList<StorableObject> dpList = new ArrayList<StorableObject>();
            for (StorableObject storableObject : list) {
                if (storableObject instanceof DesignPart) {
                    dpList.add(storableObject);
                    continue;
                }
                this.saveObject(storableObject);
            }
            if (this.isCheckDirty()) {
                if (designPart.isLoaded() && (designPart.isDirty() || designPart.hasDirtyStorableObjects())) {
                    this.saveObjectList(designPart);
                }
            } else if (designPart.isLoaded()) {
                this.saveObjectList(designPart);
            }
            for (DesignPart designPart2 : dpList) {
                try {
                    this.saveObject(designPart2);
                    designPart2.synchronizeFilesMap(true);
                }
                catch (Exception e) {
                    LOGGER.error("Error in cleaning files in model: " + designPart2.getName(), e);
                }
            }
            if (saveFailed) {
                MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectly"), true);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Unable to save the Design Part: " + designPart.getName(), ex);
            MessageDialogs.showErrorMessage("Unable to save the Design Part: " + designPart.getName(), true);
            return false;
        }
    }

    public MDTransformationManager getMDTransformationManager() {
        if (this.mdtManager == null) {
            this.mdtManager = new MDTransformationManager(this.metaDataManager);
            this.mdtManager.registerTransformer(ModelIDObject.class, XMLFromObjTransformer.class, XMLToObjectTransformer.class, XMLObjToStreamTransformer.class);
            this.mdtManager.registerTransformer(Object.class, XMLFromObjTransformer.class, XMLToObjectTransformer.class, XMLObjToStreamTransformer.class);
            MDTransformer.SKP_DEFAULTS = true;
        }
        return this.mdtManager;
    }

    public Document getXMLContent(Object object) {
        MDTransformationManager.TrObjects trs = this.getMDTransformationManager().getTransformersFor(object.getClass());
        if (trs != null && trs.getFromObjectTransformer() != null) {
            return ((XMLFromObjTransformer)trs.getFromObjectTransformer()).transformFromObject(object);
        }
        return null;
    }

    public String getContentAsString(Object object) {
        MDTransformationManager.TrObjects trs = this.getMDTransformationManager().getTransformersFor(object.getClass());
        if (trs != null && trs.getFromObjectTransformer() != null) {
            return ((XMLObjToStringBuilderTransformer)trs.getFromObjectTransformer()).transformFromObjectToString(object, null);
        }
        return null;
    }

    private boolean saveObject(StorableObject object) {
        if (object instanceof StorageObject && ((StorageObject)object).isNullInstance() && !((StorageObject)object).isStorableNullInstance()) {
            return false;
        }
        Design design = object.getDesign();
        int oper = design.getCurrentOperation();
        if (!this.isCheckDirty() || this.isCheckDirty() && this.hasDirtyStatus(object)) {
            String storageName = object.getStorageName();
            if (object instanceof ModelIDObject) {
                if (!this.isCheckDirty()) {
                    ((ModelIDObject)object).setSegmentedStorageName(null);
                }
                storageName = ((ModelIDObject)object).getSegmentedStorageName();
                if (Extension.isSVNExtensionLoaded() && design.isVersioned() && ((ModelIDObject)object).isRestoredFromSavedDelete()) {
                    File[] files = new File[]{new File(storageName)};
                    SVNClientHelper.getInstance().doRevert(files, false);
                    ((ModelIDObject)object).setRestoredFromSavedDelete(false);
                }
            }
            if (storageName != null) {
                try {
                    XMLTransformationManager.saveContentOfObject(storageName, object, design.isCompressedDesign(), this.getMDTransformationManager());
                    if (oper != 5) {
                        this.clearDirtyStatus(object);
                    }
                    if (Extension.isSVNExtensionLoaded() && design.isVersioned()) {
                        Map<String, String> svnDMPropertiesCache;
                        ModelIDObject mo;
                        SVNClientHelper SVN_Client_Helper = SVNClientHelper.getInstance();
                        if (this.shouldAddToSVN(object)) {
                            SVN_Client_Helper.saveProperties(object);
                        }
                        if (object instanceof ModelIDObject && (mo = (ModelIDObject)object).getDesign().isSingleObjectRefresh() && (mo instanceof ModelObject || mo instanceof StorageObject)) {
                            mo.updateSVNStorableObjectStatus();
                        }
                        if ((svnDMPropertiesCache = design.getSVNDMPropertiesCache()) != null && object instanceof ModelIDObject) {
                            String objID = ((ModelIDObject)object).getObjectID();
                            String parentID = "";
                            String shortParentID = "";
                            Object parent = ((ModelIDObject)object).getParent();
                            if (parent != null && parent instanceof ModelIDObject) {
                                parentID = ((ModelIDObject)parent).getObjectID();
                                int firstHiphenIndex = parentID.indexOf("-");
                                int lastHiphenIndex = parentID.lastIndexOf("-");
                                if (firstHiphenIndex > 0 && lastHiphenIndex > 0 && firstHiphenIndex != lastHiphenIndex) {
                                    shortParentID = parentID.substring(0, firstHiphenIndex) + parentID.substring(lastHiphenIndex);
                                }
                            }
                            if (svnDMPropertiesCache.get(objID + shortParentID) != null) {
                                svnDMPropertiesCache.remove(objID + shortParentID);
                            }
                        }
                    }
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("Can not write data! Location: " + object.getStorageName() + " - Name: " + object.getName(), e);
                    saveFailed = true;
                }
            }
        }
        return false;
    }

    private boolean shouldAddToSVN(StorableObject object) {
        DesignPart so;
        DesignObject dobj;
        return !(object instanceof DesignObject ? (dobj = (DesignObject)object).getDesignPart().isAddObjectsToSVNatModelLevel() : (object instanceof DesignPart ? (so = (DesignPart)object).isAddObjectsToSVNatModelLevel() : (object instanceof StorageDesign ? (so = (StorageDesign)object).isAddObjectsToSVNatModelLevel() : (object instanceof DesignPartView ? (dobj = (DesignPartView)object).getDesignPart().isAddObjectsToSVNatModelLevel() : (object instanceof StorageObject ? (so = (StorageObject)object).getStorageDesign().isAddObjectsToSVNatModelLevel() : (object instanceof RMExtendedMap ? (so = (RMExtendedMap)object).getRelationalModel().isAddObjectsToSVNatModelLevel() : object instanceof RMDeletedMap && (so = (RMDeletedMap)object).getRelationalModel().isAddObjectsToSVNatModelLevel()))))));
    }

    public boolean transformFromXMLToObject(Object object, String fileName) {
        return this.transformFromXMLToObject(object, new File(fileName), false);
    }

    public boolean transformFromXMLToObject(Object object, File file, boolean useCompressedFiles) {
        return this.transformFromXMLToObject(object, file, useCompressedFiles, true, null);
    }

    public boolean transformFromXMLToObjectSAX(Object object, File file, List excludeProps) {
        XMLToObjectSAXTransformer tr = this.getXMLToObjectSAXTransformer();
        try {
            tr.transformToObject(object, file, false, excludeProps);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean transformFromXMLToObject(Object object, File file, boolean useCompressedFiles, boolean clearDirtyFlag, List excludeProps) {
        MDTransformationManager.TrObjects trs = this.getMDTransformationManager().getTransformersFor(object.getClass());
        if (trs == null) return false;
        if (trs.getToObjectTransformer() == null) return false;
        try {
            String fileName = file.getAbsolutePath();
            if (useCompressedFiles) {
                Document doc;
                if (!fileName.endsWith(COMPRESSED_FILE_SUFIX)) {
                    fileName = fileName + COMPRESSED_FILE_SUFIX;
                    File zFile = new File(fileName);
                    doc = XMLTransformationManager.getDocument(zFile);
                } else {
                    doc = XMLTransformationManager.getDocument(file);
                }
                if (doc == null) return false;
                ((XMLToObjectTransformer)trs.getToObjectTransformer()).transformToObject(object, doc, excludeProps);
            } else {
                MDTransformer tr = trs.getToObjectTransformer();
                if (tr instanceof XMLToObjectTransformer) {
                    ((XMLToObjectTransformer)trs.getToObjectTransformer()).transformToObject(object, file, excludeProps);
                }
            }
            if (!clearDirtyFlag) return true;
            this.clearDirtyStatus(object);
            return true;
        }
        catch (Exception e) {
            boolean log = true;
            if (e instanceof FileNotFoundException && object instanceof ModelIDObject) {
                ModelIDObject mobj = (ModelIDObject)object;
                String id = mobj.getObjectID();
                if ("47E390DE-0671-C4B1-8428-0F45CBEE18F8".equals(id)) return false;
                if ("F72C39E0-D1CA-8821-2AD7-A1E95A37D3D1".equals(id)) {
                    return false;
                }
            }
            if (!log) return false;
            String fname = file.getName();
            if (fname.startsWith("ExtendedMap_RM")) return false;
            if (fname.startsWith("DeletedMap_RM")) return false;
            LOGGER.error("Unable to load object from XML: " + file.getAbsolutePath(), e);
        }
        return false;
    }

    public void transformFromXMLToObject(Object object, Document doc) {
        XMLToObjectTransformer tr = (XMLToObjectTransformer)this.getMDTransformationManager().getToObjectTransformerFor(object.getClass());
        if (tr != null && doc != null) {
            tr.transformToObject(object, doc, null);
        }
    }

    public Map transformFromObjectToMap(Object object) {
        return this.transformFromObjectToMap(object, null, null);
    }

    public Map transformFromObjectToMap(Object object, List inludeProps, List includeCollections) {
        return this.transformFromObjectToMap(object, inludeProps, includeCollections, null);
    }

    public Map transformFromObjectToMap(Object object, List inludeProps, List includeCollections, List excludeProperties) {
        XMLObjToMapTransformer tr = (XMLObjToMapTransformer)this.getObjectMapTransformationManager().getFromObjectTransformerFor(object.getClass());
        if (tr != null) {
            return tr.transformFromObject(object, null, null, false, false, inludeProps, includeCollections, excludeProperties);
        }
        return null;
    }

    public void transformFromMapToObject(Object object, Map map) {
        this.transformFromMapToObject(object, map, null, null);
    }

    public void transformFromMapToObject(Object object, Map map, List inludeProps, List includeCollections) {
        XMLMapToObjTransformer tr = (XMLMapToObjTransformer)this.getObjectMapTransformationManager().getToObjectTransformerFor(object.getClass());
        if (tr != null) {
            tr.transformFromMap(object, map, false, inludeProps, includeCollections);
        }
    }

    public void openChangeRequestList(Design design) {
        List<ObjectHelper> objects0 = XMLTransformationManager.getObjects(design.getStoragePath(), CHANGE_REQUEST_LIST, design.isCompressedDesign());
        List objects = this.recreateObjectList(objects0, design.getClass().getName(), design.getFolderToTypeMap(), design.getStoragePath(), CHANGE_REQUEST_LIST, design.isCompressedDesign(), design.isVersioned());
        for (ObjectHelper oh : objects) {
            ChangeRequest request = design.getChangeRequestSet().createChangeRequest(oh.id);
            if (oh.name != null && oh.name.length() > 0) {
                request.setName(oh.name);
            }
            this.transformFromXMLToObject(request, new File(request.getStorageName()), design.isCompressedDesign());
        }
    }

    protected void saveChangeRequestList(Design design) {
        if ((!this.isCheckDirty() || this.isCheckDirty() && design.isChangeRequestListChanged()) && this.saveObjectList(design.getClass().getName(), design.getStoragePath(), design.getChangeRequestSet().iterator(), CHANGE_REQUEST_LIST, design.isCompressedDesign(), new String[0])) {
            design.setChangeRequestListChanged(false);
        }
    }

    protected void saveObjectList(DesignPart designPart) {
        if (this.saveObjectList(designPart.getClass().getName(), designPart.getStoragePath(), designPart.getStorableDesignObjects().iterator(), OBJECT_LIST, designPart.getDesign().isCompressedDesign(), new String[0])) {
            designPart.setObjectListChanged(false);
        }
    }

    protected void saveDiagrams(DesignPart designPart) {
        ArrayList<DesignPartView> list = new ArrayList<DesignPartView>();
        DesignPartViewPlaceHolder dph = designPart.getMainDPVPlaceHolder();
        list.add(dph.getDesignPartView());
        Iterator it = designPart.getDesignSubviews().iterator();
        while (it.hasNext()) {
            dph = (DesignPartViewPlaceHolder)it.next();
            if (designPart.getDesign().shouldExportPartial(designPart)) {
                if (!designPart.getDesign().shouldExportDPV(dph.getDesignPartView()) || dph.getDesignPartView() instanceof DPVCompactMultidimentional) continue;
                list.add(dph.getDesignPartView());
                continue;
            }
            if (dph.getDesignPartView() instanceof DPVCompactMultidimentional) continue;
            list.add(dph.getDesignPartView());
        }
        this.saveObjectList(designPart.getClass().getName(), designPart.getStoragePath(), list.iterator(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign(), new String[0]);
        for (DesignPartView dpv : list) {
            if (this.isCheckDirty() && (!this.isCheckDirty() || !dpv.isDirty())) continue;
            this.saveObject(dpv);
        }
    }

    public void saveObjectsAndDiagramsList(DesignPart designPart) {
        this.saveObjectList(designPart);
        this.saveDiagramsList(designPart);
    }

    public void saveDiagramsList(DesignPart designPart) {
        ArrayList<DesignPartView> list = new ArrayList<DesignPartView>();
        DesignPartViewPlaceHolder dph = designPart.getMainDPVPlaceHolder();
        list.add(dph.getDesignPartView());
        Iterator it = designPart.getDesignSubviews().iterator();
        while (it.hasNext()) {
            dph = (DesignPartViewPlaceHolder)it.next();
            list.add(dph.getDesignPartView());
        }
        this.saveObjectList(designPart.getClass().getName(), designPart.getStoragePath(), list.iterator(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign(), new String[0]);
    }

    protected void saveObjectList(StorageDesign storageDesign) {
        if ((!this.isCheckDirty() || this.isCheckDirty() && storageDesign.isObjectListChanged()) && this.saveObjectList(storageDesign.getClass().getName(), storageDesign.getStoragePath(), storageDesign.getStorableObjects().iterator(), OBJECT_LIST, storageDesign.getDesign().isCompressedDesign(), new String[0])) {
            storageDesign.setObjectListChanged(false);
        }
    }

    protected boolean saveObjectList(String className, String storagePath, Iterator objects, String fileName, boolean useCompressedFiles, String ... additionalAttributes) {
        try {
            Design design = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element rootElement = doc.createElement(className);
            doc.appendChild(rootElement);
            while (objects.hasNext()) {
                String parentID;
                DesignObject desObj;
                DesignPart dp;
                RelationalObjectProxy proxy;
                Object obj = objects.next();
                if (obj instanceof ModelIDObject) {
                    design = ((ModelIDObject)obj).getDesign();
                } else if (obj instanceof DesignPartView) {
                    design = ((DesignPartView)obj).getDesign();
                }
                if (!(obj instanceof DesignObject) ? obj instanceof RelationalObjectProxy && !(proxy = (RelationalObjectProxy)obj).getDesign().shouldExport(proxy) : ((dp = (desObj = (DesignObject)obj).getDesignPart()) instanceof LogicalDesign || dp instanceof RelationalDesign) && dp.getDesign().shouldExportPartial(dp) && !dp.getDesign().shouldExport(desObj)) continue;
                if (obj instanceof StorageObject && ((StorageObject)obj).isNullInstance() && !((StorageObject)obj).isStorableNullInstance()) continue;
                Element child = doc.createElement("object");
                rootElement.appendChild(child);
                if (obj instanceof DesignObject) {
                    DesignObject desObj2 = (DesignObject)obj;
                    child.setAttribute("objectType", desObj2.getObjectTypeName());
                    child.setAttribute("objectID", desObj2.getObjectID());
                    child.setAttribute("name", StringUtilities.encodeAttributeValue(desObj2.getName()));
                    child.setAttribute("seqName", desObj2.getDirectorySegmentName());
                    if (obj instanceof FKIndexAssociation) {
                        String refCID;
                        FKIndexAssociation fk = (FKIndexAssociation)obj;
                        String cid = fk.getContainerID();
                        if (cid != null) {
                            child.setAttribute("containerID", cid);
                        }
                        if ((refCID = fk.getReferredTableID()) != null) {
                            child.setAttribute("refContainerID", refCID);
                        }
                    }
                    parentID = desObj2.getDesignPartId();
                    String sourceObjectID = null;
                    String targetObjectID = null;
                    if (obj instanceof ConnectionInterface) {
                        ConnectionInterface connection = (ConnectionInterface)obj;
                        DesignObject sourceObject = connection.getSourceObject();
                        DesignObject targetObject = connection.getTargetObject();
                        if (sourceObject != null) {
                            sourceObjectID = sourceObject.getObjectID();
                        }
                        if (targetObject != null) {
                            targetObjectID = targetObject.getObjectID();
                        }
                    }
                    child.setAttribute("propertyClassName", desObj2.getClass().getName());
                    child.setAttribute("propertyParentId", parentID);
                    child.setAttribute("propertySourceId", sourceObjectID);
                    child.setAttribute("propertyTargetId", targetObjectID);
                } else if (obj instanceof StorageObject) {
                    StorageObject storObj = (StorageObject)obj;
                    child.setAttribute("objectType", storObj.getObjectTypeName());
                    child.setAttribute("objectID", storObj.getObjectID());
                    child.setAttribute("name", storObj.getName());
                    child.setAttribute("seqName", storObj.getDirectorySegmentName());
                    parentID = storObj.getStorageDesign().getRDBMSSite().getShortObjectID();
                    child.setAttribute("propertyClassName", storObj.getClass().getName());
                    child.setAttribute("propertyParentId", parentID);
                } else if (obj instanceof DesignPartView) {
                    DesignPartView dpv = (DesignPartView)obj;
                    String sv_type = "sub_view";
                    if (dpv == dpv.getDesignPart().getMainView()) {
                        sv_type = "main_view";
                    }
                    child.setAttribute("objectType", sv_type);
                    child.setAttribute("objectID", dpv.getDPVId());
                    String dname = dpv.getName();
                    if (dname == null || dname.isEmpty()) {
                        dname = dpv.getDesignPart().getName();
                    }
                    child.setAttribute("name", StringUtilities.encodeAttributeValue(dname));
                    child.setAttribute("visible", dpv.isEditorVisible() ? TRUE : FALSE);
                }
                if (additionalAttributes == null) continue;
                for (int i = 0; i < additionalAttributes.length; i += 2) {
                    child.setAttribute(additionalAttributes[i], additionalAttributes[i + 1]);
                }
            }
            String fpath = new File(storagePath, fileName).getCanonicalPath();
            XMLTransformationManager.saveDocument(fpath, doc, useCompressedFiles);
            if (design != null) {
                design.getLocalObjectFilesMap().remove(fpath);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Can not save Object List for: " + className, e);
            return false;
        }
    }

    private List<DesignPartHelper> getModels(Design design) {
        SVNClientHelper svnch = null;
        if (Extension.isSVNExtensionLoaded()) {
            svnch = SVNClientHelper.getInstance();
        }
        ArrayList<DesignPartHelper> list = new ArrayList<DesignPartHelper>();
        try {
            DesignPartHelper dph;
            File file;
            int i;
            File[] files;
            DesignPartHelper dph2;
            File md = new File(design.getStoragePath(), "businessinfo");
            String modelFileName = design.getBusinessInfoDesign().getName() + EXTENSION_XML_FILES;
            if (design.isCompressedDesign()) {
                modelFileName = modelFileName + COMPRESSED_FILE_SUFIX;
            }
            File mf = new File(md, modelFileName);
            if (!(svnch != null && svnch.isDeleted(mf) || (dph2 = XMLTransformationManager.getDesignPartHelperFor(mf, design.isCompressedDesign(), "Business Information")) == null)) {
                list.add(dph2);
            }
            md = new File(design.getStoragePath(), "datatypes");
            modelFileName = design.getDataTypesDesign().getName() + EXTENSION_XML_FILES;
            if (design.isCompressedDesign()) {
                modelFileName = modelFileName + COMPRESSED_FILE_SUFIX;
            }
            mf = new File(md, modelFileName);
            if (!(svnch != null && svnch.isDeleted(mf) || (dph2 = XMLTransformationManager.getDesignPartHelperFor(mf, design.isCompressedDesign(), "Data Types")) == null)) {
                list.add(dph2);
            }
            md = new File(design.getStoragePath(), "logical");
            modelFileName = design.getLogicalDesign().getName() + EXTENSION_XML_FILES;
            if (design.isCompressedDesign()) {
                modelFileName = modelFileName + COMPRESSED_FILE_SUFIX;
            }
            mf = new File(md, modelFileName);
            if (!(svnch != null && svnch.isDeleted(mf) || (dph2 = XMLTransformationManager.getDesignPartHelperFor(mf, design.isCompressedDesign(), "LogicalDesign")) == null)) {
                list.add(dph2);
            }
            if ((md = new File(design.getStoragePath(), "rel")).exists()) {
                files = md.listFiles(this.filter);
                for (i = 0; i < files.length; ++i) {
                    file = files[i];
                    if (svnch != null && svnch.isDeleted(file) || (dph = XMLTransformationManager.getDesignPartHelperFor(file, design.isCompressedDesign(), "RelationalModel")) == null) continue;
                    list.add(dph);
                }
            }
            if ((md = new File(design.getStoragePath(), "multidimensional")).exists()) {
                files = md.listFiles(this.filter);
                for (i = 0; i < files.length; ++i) {
                    file = files[i];
                    if (svnch != null && svnch.isDeleted(file) || (dph = XMLTransformationManager.getDesignPartHelperFor(file, design.isCompressedDesign(), "Dimensional Model")) == null) continue;
                    list.add(dph);
                }
            }
            md = new File(design.getStoragePath(), "pm");
            modelFileName = design.getProcessModel().getName() + EXTENSION_XML_FILES;
            if (design.isCompressedDesign()) {
                modelFileName = modelFileName + COMPRESSED_FILE_SUFIX;
            }
            mf = new File(md, modelFileName);
            if (!(svnch != null && svnch.isDeleted(mf) || (dph2 = XMLTransformationManager.getDesignPartHelperFor(mf, design.isCompressedDesign(), "Process Model")) == null)) {
                list.add(dph2);
            }
            if ((md = new File(design.getStoragePath(), XMLConstants.DATAFLOW_PATH)).exists()) {
                ArrayList<DesignPartHelper> dfd = new ArrayList<DesignPartHelper>();
                ArrayList<DesignPartHelper> sorted = new ArrayList<DesignPartHelper>();
                File[] files2 = md.listFiles(this.filter);
                for (int i2 = 0; i2 < files2.length; ++i2) {
                    DesignPartHelper dph3;
                    File file2 = files2[i2];
                    if (svnch != null && svnch.isDeleted(file2) || (dph3 = XMLTransformationManager.getDesignPartHelperFor(file2, design.isCompressedDesign(), "Data Flow Diagram")) == null) continue;
                    if (dph3.top_level_dfd_design) {
                        sorted.add(0, dph3);
                        continue;
                    }
                    dfd.add(dph3);
                }
                this.orderDFDs_byParent(dfd, sorted);
                list.addAll(sorted);
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not load Models from Design: " + design.getStoragePath(), e);
        }
        return list;
    }

    private void orderDFDs_byParent(List source, List sorted) {
        for (DesignPartHelper dph : source) {
            if (sorted.contains(dph)) continue;
            this.addParent(dph, source, sorted);
            sorted.add(dph);
        }
    }

    private void addParent(DesignPartHelper dph, List source, List sorted) {
        if (dph.parent_id != null) {
            for (int i = 0; i < source.size(); ++i) {
                DesignPartHelper temp = (DesignPartHelper)source.get(i);
                if (!temp.id.equals(dph.parent_id)) continue;
                this.addParent(temp, source, sorted);
                if (sorted.contains(temp)) continue;
                sorted.add(temp);
            }
        }
    }

    private List<DesignPartHelper> getTransformationTasks(TransformationPackage tp) {
        SVNClientHelper svnch = null;
        if (Extension.isSVNExtensionLoaded()) {
            svnch = SVNClientHelper.getInstance();
        }
        ArrayList<DesignPartHelper> list = new ArrayList<DesignPartHelper>();
        try {
            File md = new File(tp.getStoragePath(), "tt");
            if (md.exists()) {
                File[] files = md.listFiles(this.filter);
                for (int i = 0; i < files.length; ++i) {
                    DesignPartHelper dph;
                    File file = files[i];
                    if (svnch != null && svnch.isDeleted(file) || (dph = XMLTransformationManager.getDesignPartHelperFor(file, tp.getDesign().isCompressedDesign(), "TransformationTask")) == null) continue;
                    list.add(dph);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not load Transformation Tasks: " + tp.getStoragePath(), e);
        }
        return list;
    }

    public static DesignPartHelper getDesignPartHelperFor(File file, boolean useCompressedFiles, String type) {
        if (file.exists() && file.isFile()) {
            try {
                Document doc = null;
                if (useCompressedFiles) {
                    doc = XMLTransformationManager.getDocument(file);
                } else {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                }
                if (doc != null) {
                    DesignPartHelper dph = new DesignPartHelper();
                    Element elm = doc.getDocumentElement();
                    dph.type = type;
                    dph.name = elm.getAttribute("name");
                    dph.id = elm.getAttribute("id");
                    String parent_id = elm.getAttribute("parentDFD_ID");
                    if (parent_id != null && !"".equals(parent_id)) {
                        dph.parent_id = parent_id;
                    }
                    dph.main_view_id = elm.getAttribute("mainViewID");
                    String topLevel = elm.getAttribute("topLevel");
                    dph.top_level_dfd_design = "true".equalsIgnoreCase(topLevel);
                    return dph;
                }
            }
            catch (Exception e) {
                LOGGER.error("Can not parse file: " + file.getAbsolutePath(), e);
            }
        }
        return null;
    }

    private static DesignPartHelper getDesignPartInfo(File file, boolean useCompressedFiles) {
        if (file.exists()) {
            try {
                Document doc = null;
                if (useCompressedFiles) {
                    doc = XMLTransformationManager.getDocument(file);
                } else {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                }
                if (doc != null) {
                    DesignPartHelper dph = new DesignPartHelper();
                    Element elm = doc.getDocumentElement();
                    String className = elm.getAttribute("class");
                    if (className.endsWith("SubView")) {
                        dph.type = "sub_view";
                        dph.visible = false;
                    } else {
                        dph.type = "main_view";
                        dph.visible = className.equalsIgnoreCase(DPVLogical.class.getName()) || className.equalsIgnoreCase(DPVRelational.class.getName());
                    }
                    dph.name = elm.getAttribute("name");
                    dph.id = elm.getAttribute("id");
                    return dph;
                }
            }
            catch (Exception e) {
                LOGGER.error("Can not parse file: " + file.getAbsolutePath(), e);
            }
        }
        return null;
    }

    public void createObjectList(String className, Map f2tMap, String storagePath, String fileName, boolean useCompressedFiles) {
        File objList = useCompressedFiles ? new File(storagePath, fileName + COMPRESSED_FILE_SUFIX) : new File(storagePath, fileName);
        if (!objList.exists() || ApplicationView.REBUILD_OBJECT_LIST) {
            try {
                if (objList.exists()) {
                    objList.delete();
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.newDocument();
                Element rootElement = doc.createElement(className);
                doc.appendChild(rootElement);
                for (String key : f2tMap.keySet()) {
                    String value = (String)f2tMap.get(key);
                    File dir = new File(storagePath, key);
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    File[] files = dir.listFiles(this.filter);
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isDirectory()) {
                            File[] subFiles = file.listFiles(this.filter);
                            for (int j = 0; j < subFiles.length; ++j) {
                                File subFile = subFiles[j];
                                if (subFile.isDirectory()) continue;
                                Element child = doc.createElement("object");
                                rootElement.appendChild(child);
                                child.setAttribute("objectType", value);
                                child.setAttribute("objectID", FileUtils.removeExt(subFile.getName()));
                                child.setAttribute("name", "");
                                child.setAttribute("seqName", file.getName());
                            }
                            continue;
                        }
                        Element child = doc.createElement("object");
                        rootElement.appendChild(child);
                        if (DIAGRAM_LIST.equalsIgnoreCase(fileName)) {
                            DesignPartHelper dph = XMLTransformationManager.getDesignPartInfo(file, useCompressedFiles);
                            child.setAttribute("objectType", dph.type);
                            child.setAttribute("objectID", dph.id);
                            child.setAttribute("name", dph.name);
                            child.setAttribute("visible", dph.visible ? TRUE : FALSE);
                            continue;
                        }
                        child.setAttribute("objectType", value);
                        child.setAttribute("objectID", FileUtils.removeExt(file.getName()));
                        child.setAttribute("name", "");
                        child.setAttribute("seqName", "");
                    }
                }
                XMLTransformationManager.saveDocument(new File(storagePath, fileName).getCanonicalPath(), doc, useCompressedFiles);
            }
            catch (Exception e) {
                LOGGER.error("Can not create ObjectList: " + storagePath + File.separatorChar + fileName, e);
                e.printStackTrace();
            }
        }
    }

    public List recreateObjectList(List<ObjectHelper> objects, String className, Map f2tMap, String storagePath, String fileName, boolean useCompressedFiles, boolean isDesignVersioned) {
        ArrayList<ObjectHelper> newList = new ArrayList<ObjectHelper>();
        File objList = useCompressedFiles ? new File(storagePath, fileName + COMPRESSED_FILE_SUFIX) : new File(storagePath, fileName);
        if (!objList.exists() || ApplicationView.REBUILD_OBJECT_LIST) {
            try {
                HashMap<String, ObjectHelper> map = new HashMap<String, ObjectHelper>();
                HashMap<String, ObjectHelper> processed = new HashMap<String, ObjectHelper>();
                if (objList.exists()) {
                    objList.delete();
                }
                for (ObjectHelper oh : objects) {
                    map.put(oh.id, oh);
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.newDocument();
                Element rootElement = doc.createElement(className);
                doc.appendChild(rootElement);
                for (String key : f2tMap.keySet()) {
                    String value = (String)f2tMap.get(key);
                    File dir = new File(storagePath, key);
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    File[] files = dir.listFiles(this.filter);
                    for (int i = 0; i < files.length; ++i) {
                        int ind;
                        ObjectHelper oht;
                        String path;
                        String name;
                        String text;
                        ObjectHelper temp;
                        ObjectHelper oh;
                        File file = files[i];
                        if (file.isDirectory()) {
                            File[] subFiles = file.listFiles(this.filter);
                            for (int j = 0; j < subFiles.length; ++j) {
                                int ind2;
                                File subFile = subFiles[j];
                                if (subFile.isDirectory()) continue;
                                Element child = doc.createElement("object");
                                rootElement.appendChild(child);
                                String id = FileUtils.removeExt(subFile.getName());
                                ObjectHelper temp2 = (ObjectHelper)processed.get(id);
                                ObjectHelper oh2 = (ObjectHelper)map.get(id);
                                if (temp2 == null) {
                                    child.setAttribute("objectType", value);
                                    child.setAttribute("objectID", id);
                                    if (oh2 != null) {
                                        child.setAttribute("name", oh2.name);
                                        if (oh2.contID != null) {
                                            child.setAttribute("containerID", oh2.contID);
                                        }
                                        if (oh2.refContID != null) {
                                            child.setAttribute("refContainerID", oh2.refContID);
                                        }
                                    } else {
                                        child.setAttribute("name", "");
                                    }
                                    child.setAttribute("seqName", file.getName());
                                    if (oh2 != null) {
                                        if (oh2.propertyClassname != null) {
                                            child.setAttribute("propertyClassName", oh2.propertyClassname);
                                        }
                                        if (oh2.propertyParentid != null) {
                                            child.setAttribute("propertyParentId", oh2.propertyParentid);
                                        }
                                        if (oh2.propertySourceid != null) {
                                            child.setAttribute("propertySourceId", oh2.propertySourceid);
                                        }
                                        if (oh2.propertyTargetid != null) {
                                            child.setAttribute("propertyTargetId", oh2.propertyTargetid);
                                        }
                                    }
                                    if (oh2 == null) {
                                        oh2 = new ObjectHelper();
                                        oh2.type = value;
                                        oh2.id = id;
                                    }
                                    oh2.seq_name = file.getName();
                                    oh2.file = subFile;
                                    newList.add(oh2);
                                    processed.put(id, oh2);
                                    continue;
                                }
                                Design.openFailed();
                                String text2 = "Duplicated file for ";
                                String name2 = "";
                                if (oh2 != null) {
                                    name2 = oh2 != null ? oh2.name : "";
                                } else {
                                    oh2 = new ObjectHelper();
                                }
                                oh2.file = subFile;
                                oh2.seq_name = file.getName();
                                String path2 = " ID - " + id + " \npath - " + subFile.getCanonicalPath();
                                LOGGER.error(text2 + name2 + path2);
                                ObjectHelper oht2 = this.getHelperWithBiggerFile(temp2, oh2);
                                if (oht2 == temp2 || (ind2 = newList.indexOf(temp2)) <= -1) continue;
                                newList.set(ind2, oht2);
                                processed.put(id, oht2);
                            }
                            continue;
                        }
                        Element child = doc.createElement("object");
                        rootElement.appendChild(child);
                        if (DIAGRAM_LIST.equalsIgnoreCase(fileName)) {
                            DesignPartHelper dph = XMLTransformationManager.getDesignPartInfo(file, useCompressedFiles);
                            if (dph == null) {
                                Design.openFailed();
                                continue;
                            }
                            oh = (ObjectHelper)map.get(dph.id);
                            child.setAttribute("objectType", dph.type);
                            child.setAttribute("objectID", dph.id);
                            child.setAttribute("name", dph.name);
                            if (oh != null) {
                                child.setAttribute("visible", oh.visible ? TRUE : FALSE);
                            } else {
                                child.setAttribute("visible", dph.visible ? TRUE : FALSE);
                                oh = new ObjectHelper();
                                oh.type = dph.type;
                                oh.id = dph.id;
                                oh.name = dph.name;
                                oh.file = file;
                                oh.visible = dph.visible;
                            }
                            temp = (ObjectHelper)processed.get(dph.id);
                            if (temp == null) {
                                newList.add(oh);
                                processed.put(dph.id, oh);
                                continue;
                            }
                            Design.openFailed();
                            text = "Duplicated file for ";
                            name = oh != null ? oh.name : "";
                            path = " ID - " + dph.id + " \npath - " + file.getCanonicalPath();
                            LOGGER.error(text + name + path);
                            oht = this.getHelperWithBiggerFile(temp, oh);
                            processed.put(dph.id, oht);
                            if (oht == temp || (ind = newList.indexOf(temp)) <= -1) continue;
                            newList.set(ind, oht);
                            processed.put(dph.id, oht);
                            continue;
                        }
                        String id = FileUtils.removeExt(file.getName());
                        oh = (ObjectHelper)map.get(id);
                        child.setAttribute("objectType", value);
                        child.setAttribute("objectID", id);
                        if (oh != null) {
                            child.setAttribute("name", oh.name);
                        } else {
                            child.setAttribute("name", "");
                            oh = new ObjectHelper();
                            oh.type = value;
                            oh.id = id;
                        }
                        child.setAttribute("seqName", "");
                        if (oh != null) {
                            if (oh.propertyClassname != null) {
                                child.setAttribute("propertyClassName", oh.propertyClassname);
                            }
                            if (oh.propertyParentid != null) {
                                child.setAttribute("propertyParentId", oh.propertyParentid);
                            }
                            if (oh.propertySourceid != null) {
                                child.setAttribute("propertySourceId", oh.propertySourceid);
                            }
                            if (oh.propertyTargetid != null) {
                                child.setAttribute("propertyTargetId", oh.propertyTargetid);
                            }
                        }
                        if ((temp = (ObjectHelper)processed.get(id)) == null) {
                            newList.add(oh);
                            processed.put(id, oh);
                            continue;
                        }
                        Design.openFailed();
                        text = "Duplicated file for ";
                        name = oh != null ? oh.name : "";
                        path = " ID - " + id + " \npath - " + file.getCanonicalPath();
                        LOGGER.error(text + name + path);
                        oht = this.getHelperWithBiggerFile(temp, oh);
                        processed.put(id, oht);
                        if (oht == temp || (ind = newList.indexOf(temp)) <= -1) continue;
                        newList.set(ind, oht);
                        processed.put(id, oht);
                    }
                }
                XMLTransformationManager.saveDocument(new File(storagePath, fileName).getCanonicalPath(), doc, useCompressedFiles);
            }
            catch (Exception e) {
                LOGGER.error("Can not create ObjectList: " + storagePath + File.separatorChar + fileName, e);
                e.printStackTrace();
            }
        } else {
            return objects;
        }
        return newList;
    }

    private ObjectHelper getHelperWithBiggerFile(ObjectHelper oh1, ObjectHelper oh2) {
        if (oh1.file != null && oh2.file != null) {
            if (oh1.file.length() > oh2.file.length()) {
                return oh1;
            }
            return oh2;
        }
        if (oh1.file != null) {
            return oh1;
        }
        if (oh2.file != null) {
            return oh2;
        }
        return oh1;
    }

    public static List<ObjectHelper> getObjects(String storagePath, String fileName, boolean useCompressedFiles) {
        ArrayList<ObjectHelper> list = new ArrayList<ObjectHelper>();
        try {
            Document doc = null;
            if (useCompressedFiles) {
                doc = XMLTransformationManager.getDocument(new File(storagePath, fileName + COMPRESSED_FILE_SUFIX));
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                File file = new File(storagePath, fileName);
                if (file.exists()) {
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                }
            }
            if (doc != null) {
                NodeList nodeList = doc.getElementsByTagName("object");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element node = (Element)nodeList.item(i);
                    ObjectHelper helper = new ObjectHelper();
                    helper.type = node.getAttribute("objectType");
                    helper.id = node.getAttribute("objectID");
                    helper.markedGenerate = new Boolean(node.getAttribute(MARKED_GENERATE));
                    helper.name = StringUtilities.decodeAttributeValue(node.getAttribute("name"));
                    helper.seq_name = node.getAttribute("seqName");
                    helper.propertyClassname = node.getAttribute("propertyClassName");
                    helper.propertyParentid = node.getAttribute("propertyParentId");
                    helper.propertySourceid = node.getAttribute("propertySourceId");
                    helper.propertyTargetid = node.getAttribute("propertyTargetId");
                    if ("FKIndexAssociation".equals(helper.type)) {
                        helper.contID = node.getAttribute("containerID");
                        helper.refContID = node.getAttribute("refContainerID");
                    }
                    if (DIAGRAM_LIST.equalsIgnoreCase(fileName)) {
                        String visible = node.getAttribute("visible");
                        helper.visible = "true".equalsIgnoreCase(visible);
                    }
                    list.add(helper);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not parse Object List: " + storagePath + File.separatorChar + fileName, e);
        }
        return list;
    }

    public boolean openDesign(Design design, File file) {
        if (file.exists() && this.transformFromXMLToObject(design, file, design.isCompressedDesign())) {
            design.setLoadedModelPersistence(design.getModelPersistence());
            this.loadRDBMSSites(design);
            this.openChangeRequestList(design);
            List<DesignPartHelper> list = this.getModels(design);
            design.getRelationalDesigns().removeAll();
            for (DesignPartHelper helper : list) {
                String mainViewId = helper.main_view_id;
                if (helper.type.equalsIgnoreCase("Business Information")) {
                    BusinessInfoDesign biDesign = design.getBusinessInfoDesign();
                    biDesign.setName(helper.name);
                    biDesign.setObjectID(helper.id);
                    this.transformFromXMLToObject(biDesign, new File(biDesign.getStorageName()), design.isCompressedDesign());
                    biDesign.setLoaded(false);
                    continue;
                }
                if (helper.type.equalsIgnoreCase("Data Types")) {
                    DataTypesDesign dtDesign = design.getDataTypesDesign();
                    dtDesign.setNewModel(false);
                    dtDesign.setName(helper.name);
                    dtDesign.setObjectID(helper.id);
                    if (mainViewId != null && !"".equalsIgnoreCase(mainViewId) && !"null".equalsIgnoreCase(mainViewId)) {
                        dtDesign.getMainView().setDPVId(mainViewId);
                    }
                    this.transformFromXMLToObject(dtDesign, new File(dtDesign.getStorageName()), design.isCompressedDesign());
                    dtDesign.setLoaded(false);
                    continue;
                }
                if (helper.type.equalsIgnoreCase("LogicalDesign")) {
                    LogicalDesign logical = design.getLogicalDesign();
                    logical.setNewModel(false);
                    logical.setName(helper.name);
                    logical.setObjectID(helper.id);
                    if (mainViewId != null && !"".equalsIgnoreCase(mainViewId) && !"null".equalsIgnoreCase(mainViewId)) {
                        logical.getMainView().setDPVId(mainViewId);
                    }
                    this.transformFromXMLToObject(logical, new File(logical.getStorageName()), design.isCompressedDesign());
                    logical.setLoaded(false);
                    continue;
                }
                if (helper.type.equalsIgnoreCase("RelationalModel")) {
                    RelationalDesign relModel = design.addRelationalDesign(helper.name);
                    relModel.setObjectID(helper.id);
                    relModel.setNewModel(false);
                    if (mainViewId != null && !"".equalsIgnoreCase(mainViewId) && !"null".equalsIgnoreCase(mainViewId)) {
                        relModel.getMainView().setDPVId(mainViewId);
                    }
                    this.transformFromXMLToObject(relModel, new File(relModel.getStorageName()), design.isCompressedDesign());
                    relModel.setShouldBeOpen(true);
                    relModel.setLoaded(false);
                    relModel.setMainViewVisible(false);
                    continue;
                }
                if (helper.type.equalsIgnoreCase("Dimensional Model")) {
                    MultidimensionalDesign mdDesign = design.addMultidimensionalDesign(helper.name);
                    design.setMultidimensionalDesign(mdDesign);
                    mdDesign.setNewModel(false);
                    mdDesign.setObjectID(helper.id);
                    if (mainViewId != null && !"".equalsIgnoreCase(mainViewId) && !"null".equalsIgnoreCase(mainViewId)) {
                        mdDesign.getMainView().setDPVId(mainViewId);
                    }
                    this.transformFromXMLToObject(mdDesign, new File(mdDesign.getStorageName()), design.isCompressedDesign());
                    mdDesign.setLoaded(false);
                    mdDesign.setShouldBeOpen(true);
                    continue;
                }
                if (helper.type.equalsIgnoreCase("Process Model")) {
                    ProcessModel processModel = design.getProcessModel();
                    processModel.setObjectID(helper.id);
                    this.transformFromXMLToObject(processModel, new File(processModel.getStorageName()), design.isCompressedDesign());
                    processModel.setLoaded(false);
                    continue;
                }
                if (!helper.type.equalsIgnoreCase("Data Flow Diagram")) continue;
                DataFlowDesign dfDesign = helper.top_level_dfd_design ? design.getProcessModel().addDataFlowDesign(helper.name) : design.getProcessModel().addDataFlowDesign(helper.name, false);
                dfDesign.setNewModel(false);
                design.getProcessModel().setDataFlowDesign(dfDesign);
                dfDesign.setObjectID(helper.id);
                design.getProcessModel().setHasOpenedDFDesigns(true);
                if (mainViewId != null && !"".equalsIgnoreCase(mainViewId) && !"null".equalsIgnoreCase(mainViewId)) {
                    dfDesign.getMainView().setDPVId(mainViewId);
                }
                this.transformFromXMLToObject(dfDesign, new File(dfDesign.getStorageName()), design.isCompressedDesign());
                dfDesign.setLoaded(false);
                dfDesign.setShouldBeOpen(true);
            }
            return true;
        }
        return false;
    }

    public void openDesignPart(DesignPart designPart) {
        Design des = designPart.getDesign();
        designPart.getErrorDescriptionList().clear();
        int pers = des.getLoadedModelPersistence();
        if ((pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE) && this.modelFileExists(designPart)) {
            this.openDesignPartSingleFile(designPart);
            return;
        }
        this.openDesignPartManyFiles(designPart);
    }

    private boolean modelFileExists(ModelIDObject dp) {
        String storageName = dp.getStoragePath() + File.separatorChar + dp.getShortObjectID() + ".model.local";
        File file = new File(storageName);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDesignPartSingleFile(DesignPart designPart) {
        block25: {
            if (!designPart.isLoaded()) {
                String storageName = designPart.getStoragePath() + File.separatorChar + designPart.getShortObjectID() + ".model.local";
                TimeLog.log("start open model operation");
                boolean ftemp = FKAttributeManager.CAN_SYNCHRONIZE;
                if (designPart instanceof LogicalDesign) {
                    FKAttributeManager.CAN_SYNCHRONIZE = false;
                }
                try {
                    File file = new File(storageName);
                    if (!file.exists()) {
                        return;
                    }
                    if (storageName == null) break block25;
                    boolean pkchanges = designPart.getDesign().isPropagatePKChahges();
                    try {
                        designPart.getDesign().setPropagatePKChahges(false);
                        ApplicationView.canLogging = false;
                        ApplicationView.loading = true;
                        this.transformFromXMLToObjectSAX(designPart, file, null);
                        designPart.executeTasks();
                        if (designPart instanceof RelationalDesign) {
                            DDLSelectionPersistence.restoreDDLSelection(designPart);
                            this.loadExistingPhysicalModels((RelationalDesign)designPart);
                        } else if (designPart instanceof DataTypesDesign) {
                            DDLSelectionPersistence.restoreDDLSelection(designPart);
                        }
                        if (designPart instanceof LogicalDesign) {
                            FKAttributeManager.CAN_SYNCHRONIZE = true;
                        }
                        if (!(designPart instanceof BusinessInfoDesign) && !(designPart instanceof ProcessModel)) {
                            List<ObjectHelper> objects = XMLTransformationManager.getObjects(designPart.getStoragePath(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign());
                            for (ObjectHelper oh : objects) {
                                DesignPartView dpv = null;
                                if (!oh.visible || (dpv = "main_view".equalsIgnoreCase(oh.type) || designPart.getMainView().getDPVId().equalsIgnoreCase(oh.id) ? designPart.getMainView() : designPart.getSubViewByID(oh.id)) == null) continue;
                                boolean locked = dpv.getUndoManager().isLocked();
                                try {
                                    dpv.getUndoManager().setLocked(true);
                                    dpv.setDPVId(oh.id);
                                    dpv.setName(oh.name);
                                    if (dpv.isMainDiagram()) {
                                        designPart.setVisible(oh.visible);
                                    } else {
                                        dpv.setMustBeVisible(oh.visible);
                                    }
                                    dpv.setDirty(false);
                                }
                                finally {
                                    dpv.getUndoManager().setLocked(locked);
                                }
                            }
                        }
                        designPart.doAfterLoad();
                        DesignPartView dpv = designPart.getMainView();
                        if (dpv != null) {
                            boolean locked = dpv.getUndoManager().isLocked();
                            try {
                                dpv.getUndoManager().setLocked(true);
                                designPart.getMainView().getWorkSpace().updateSettings();
                                dpv.setDirty(false);
                            }
                            finally {
                                dpv.getUndoManager().setLocked(locked);
                            }
                        }
                        this.clearDirtyStatusForObjectsIn(designPart);
                    }
                    catch (Exception e) {
                        String message = "Error in open model " + designPart.getName() + "\n file " + storageName;
                        LOGGER.error(message, e);
                        MessageDialogs.showErrorMessage(message);
                    }
                    finally {
                        designPart.getDesign().setPropagatePKChahges(pkchanges);
                        FKAttributeManager.CAN_SYNCHRONIZE = ftemp;
                        ApplicationView.canLogging = true;
                        ApplicationView.loading = false;
                        TimeLog.log("end load operation");
                    }
                }
                catch (Exception e) {
                    String message = "Error in open model " + designPart.getName() + "\n file " + storageName;
                    LOGGER.error(message, e);
                    MessageDialogs.showErrorMessage(message, true);
                }
            }
        }
    }

    private void clearDirtyStatusForObjectsIn(DesignPart dp) {
        for (Object object : dp.getStorableDesignObjects()) {
            this.clearDirtyStatus(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openDesignPartManyFiles(DesignPart designPart) {
        boolean temp = ApplicationView.canLogging;
        ApplicationView.canLogging = false;
        designPart.getDesign().setPropagatePKChahges(false);
        boolean ftemp = FKAttributeManager.CAN_SYNCHRONIZE;
        if (designPart instanceof LogicalDesign) {
            FKAttributeManager.CAN_SYNCHRONIZE = false;
        }
        try {
            StorableObject stObject;
            ObjectHelper oh2;
            designPart.doBeforeLoad();
            List<ObjectHelper> objects0 = XMLTransformationManager.getObjects(designPart.getStoragePath(), OBJECT_LIST, designPart.getDesign().isCompressedDesign());
            List objects = this.recreateObjectList(objects0, designPart.getClass().getName(), designPart.getFolderToTypeMap(), designPart.getStoragePath(), OBJECT_LIST, designPart.getDesign().isCompressedDesign(), designPart.getDesign().isVersioned());
            Iterator oit = objects.iterator();
            if (designPart instanceof MultidimensionalDesign) {
                while (oit.hasNext()) {
                    oh2 = (ObjectHelper)oit.next();
                    stObject = designPart.getDesign().getDesignObject(oh2.id);
                    if (stObject != null) continue;
                    stObject = designPart.createObject(oh2.type, oh2.id, oh2.name);
                }
                oit = objects.iterator();
            }
            try {
                while (oit.hasNext()) {
                    FKIndexAssociation fk;
                    oh2 = (ObjectHelper)oit.next();
                    stObject = designPart.getDesign().getDesignObject(oh2.id);
                    if (stObject == null) {
                        stObject = designPart.createObject(oh2.type, oh2.id, oh2.name);
                    }
                    boolean fk_need_load = false;
                    if ("FKIndexAssociation".equals(oh2.type) && stObject instanceof FKIndexAssociation) {
                        if (oh2.contID != null && !"".equals(oh2.contID) && oh2.refContID != null && !"".equals(oh2.refContID)) {
                            fk = (FKIndexAssociation)stObject;
                            fk.setContainerID(oh2.contID);
                            fk.setReferredTableID(oh2.refContID);
                        } else {
                            fk_need_load = true;
                        }
                    }
                    if (stObject != null) {
                        if (!lazy_loading || fk_need_load) {
                            Relation relation;
                            String storageName = stObject.getStorageName();
                            if (stObject instanceof ModelIDObject) {
                                ((ModelIDObject)stObject).setDirectorySegmentName(oh2.seq_name, true);
                                storageName = ((ModelIDObject)stObject).getSegmentedStorageName();
                            }
                            try {
                                this.transformFromXMLToObject(stObject, new File(storageName), designPart.getDesign().isCompressedDesign());
                                stObject.setLoadedCompletely(true);
                            }
                            catch (Exception ex) {
                                Design.openFailed();
                                LOGGER.error("Error in loading of " + storageName, ex);
                            }
                            if (stObject instanceof FKIndexAssociation) {
                                FKIndexAssociation fk2 = (FKIndexAssociation)stObject;
                                try {
                                    fk2.setDirectorySegmentName(oh2.seq_name, true);
                                }
                                catch (Exception ex) {
                                    System.out.println("fk - " + fk2.getName() + "   - table " + fk2.getTable().getName());
                                    Design.openFailed();
                                    LOGGER.error("Error in adding foreign key " + fk2.getName() + "  for table " + fk2.getTable().getName(), ex);
                                }
                            } else if (stObject instanceof TransformationPackage) {
                                TransformationPackage tp = (TransformationPackage)stObject;
                                this.loadTransformationPackage(tp);
                            } else if (stObject instanceof Relation && ((relation = (Relation)stObject).getSourceEntity() == null || relation.getTargetEntity() == null)) {
                                relation.remove();
                            }
                            this.clearDirtyStatus(stObject);
                            continue;
                        }
                        if (stObject instanceof FKIndexAssociation) {
                            fk = (FKIndexAssociation)stObject;
                            try {
                                fk.setDirectorySegmentName(oh2.seq_name, true);
                                designPart.getDesign().addDesignObject(fk);
                                if (designPart instanceof RelationalDesign) {
                                    ((RelationalDesign)designPart).getFKIndexAssociationSet().add(fk);
                                }
                                fk.setDirectorySegmentName(oh2.seq_name, true);
                                continue;
                            }
                            catch (Exception ex) {
                                System.out.println("fk - " + fk.getName() + "   - table " + fk.getTable().getName());
                                Design.openFailed();
                                LOGGER.error("Error in adding foreign key " + fk.getName() + "  for table " + fk.getTable().getName(), ex);
                                continue;
                            }
                        }
                        if (!(stObject instanceof ModelIDObject)) continue;
                        ((ModelIDObject)stObject).setDirectorySegmentName(oh2.seq_name, true);
                        continue;
                    }
                    LOGGER.error("Can not create Object : " + oh2.type + " - " + oh2.id);
                }
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
            designPart.executeTasks();
            if (designPart instanceof RelationalDesign) {
                DDLSelectionPersistence.restoreDDLSelection(designPart);
                this.loadExistingPhysicalModels((RelationalDesign)designPart);
            } else if (designPart instanceof DataTypesDesign) {
                DDLSelectionPersistence.restoreDDLSelection(designPart);
            }
            if (!(designPart instanceof BusinessInfoDesign) && !(designPart instanceof ProcessModel)) {
                objects0 = XMLTransformationManager.getObjects(designPart.getStoragePath(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign());
                objects = this.recreateObjectList(objects0, designPart.getClass().getName(), designPart.getDiagramFolderMap(), designPart.getStoragePath(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign(), designPart.getDesign().isVersioned());
                for (ObjectHelper oh2 : objects) {
                    DesignPartView dpv = "main_view".equalsIgnoreCase(oh2.type) || designPart.getMainView().getDPVId().equalsIgnoreCase(oh2.id) ? designPart.getMainView() : designPart.createDesignPartSubView();
                    if (dpv == null) continue;
                    boolean locked = dpv.getUndoManager().isLocked();
                    try {
                        dpv.getUndoManager().setLocked(true);
                        dpv.setDPVId(oh2.id);
                        dpv.setName(oh2.name);
                        this.transformFromXMLToObject(dpv, new File(dpv.getStorageName()), designPart.getDesign().isCompressedDesign());
                        if (dpv.isMainDiagram()) {
                            designPart.setVisible(oh2.visible);
                        } else {
                            dpv.setMustBeVisible(oh2.visible);
                        }
                        dpv.setDirty(false);
                    }
                    finally {
                        dpv.getUndoManager().setLocked(locked);
                    }
                }
            }
            if (designPart instanceof LogicalDesign) {
                FKAttributeManager.CAN_SYNCHRONIZE = true;
            }
            designPart.doAfterLoad();
            DesignPartView dpv = designPart.getMainView();
            if (dpv == null) return;
            boolean locked = dpv.getUndoManager().isLocked();
            try {
                dpv.getUndoManager().setLocked(true);
                designPart.getMainView().getWorkSpace().updateSettings();
                return;
            }
            finally {
                dpv.getUndoManager().setLocked(locked);
            }
        }
        finally {
            if (designPart instanceof LogicalDesign) {
                FKAttributeManager.CAN_SYNCHRONIZE = ftemp;
            }
            designPart.getDesign().setPropagatePKChahges(true);
            ApplicationView.canLogging = temp;
        }
    }

    public void loadTransformationPackage(TransformationPackage tp) {
        tp.getDesign().getProcessModel().setTransformationPackage(tp);
        List<DesignPartHelper> ttList = this.getTransformationTasks(tp);
        for (DesignPartHelper helper : ttList) {
            String mainViewId = helper.main_view_id;
            TransformationTask tt = tp.createTransformationTask(helper.id);
            tt.setName(helper.name);
            if (mainViewId != null && !"".equalsIgnoreCase(mainViewId) && !"null".equalsIgnoreCase(mainViewId)) {
                tt.getMainView().setDPVId(mainViewId);
            }
            this.transformFromXMLToObject(tt, new File(tt.getStorageName()), tp.getDesign().isCompressedDesign());
            this.loadTransformationTask(tt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTransformationTask(TransformationTask tt) {
        tt.setLoaded(false);
        tt.doBeforeLoad();
        List<ObjectHelper> ttObjects0 = XMLTransformationManager.getObjects(tt.getStoragePath(), OBJECT_LIST, tt.getDesign().isCompressedDesign());
        List ttObjects = this.recreateObjectList(ttObjects0, tt.getClass().getName(), tt.getFolderToTypeMap(), tt.getStoragePath(), OBJECT_LIST, tt.getDesign().isCompressedDesign(), tt.getDesign().isVersioned());
        for (ObjectHelper toh : ttObjects) {
            StorableObject sto = tt.createObject(toh.type, toh.id, toh.name);
            if (sto == null) continue;
            String storName = sto.getStorageName();
            if (sto instanceof ModelIDObject) {
                ((ModelIDObject)sto).setDirectorySegmentName(toh.seq_name, true);
                storName = ((ModelIDObject)sto).getSegmentedStorageName();
            }
            this.transformFromXMLToObject(sto, new File(storName), tt.getDesign().isCompressedDesign());
            this.clearDirtyStatus(sto);
        }
        List<ObjectHelper> trobjects0 = XMLTransformationManager.getObjects(tt.getStoragePath(), DIAGRAM_LIST, tt.getDesign().isCompressedDesign());
        List trobjects = this.recreateObjectList(trobjects0, tt.getClass().getName(), tt.getDiagramFolderMap(), tt.getStoragePath(), DIAGRAM_LIST, tt.getDesign().isCompressedDesign(), tt.getDesign().isVersioned());
        for (ObjectHelper oh2 : trobjects) {
            DesignPartView dpv = "main_view".equalsIgnoreCase(oh2.type) || tt.getMainView().getDPVId().equalsIgnoreCase(oh2.id) ? tt.getMainView() : tt.createDesignPartSubView();
            if (dpv == null) continue;
            boolean locked = dpv.getUndoManager().isLocked();
            try {
                dpv.getUndoManager().setLocked(true);
                dpv.setDPVId(oh2.id);
                dpv.setName(oh2.name);
                this.transformFromXMLToObject(dpv, new File(dpv.getStorageName()), tt.getDesign().isCompressedDesign());
                dpv.setMustBeVisible(oh2.visible);
                dpv.setDirty(false);
            }
            finally {
                dpv.getUndoManager().setLocked(locked);
            }
        }
        tt.doAfterLoad();
        DesignPartView dpv = tt.getMainView();
        if (dpv != null) {
            boolean locked = dpv.getUndoManager().isLocked();
            try {
                dpv.getUndoManager().setLocked(true);
                tt.getMainView().getWorkSpace().updateSettings();
            }
            finally {
                dpv.getUndoManager().setLocked(locked);
            }
        }
    }

    private Element getFirstElementByTagName(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            Element elem = (Element)nodes.item(0);
            return elem;
        }
        return null;
    }

    public void loadExistingPhysicalModels(RelationalDesign relModel) {
        String storagePath = relModel.getDesign().getLoadedVersion() < 3.2f ? "storage" : "phys";
        File rmDir = new File(relModel.getStoragePath(), storagePath);
        if (rmDir.exists()) {
            File[] rdbmsTypes = rmDir.listFiles();
            for (int i = 0; i < rdbmsTypes.length; ++i) {
                StorageDesign stoDes;
                SVNClientHelper svnClientHelper;
                File file = rdbmsTypes[i];
                if (!file.isDirectory() || Extension.isSVNExtensionLoaded() && (svnClientHelper = SVNClientHelper.getInstance()).isDeleted(file)) continue;
                String siteID = file.getName();
                RDBMSSite site = relModel.getDesign().getLoadedVersion() < 3.2f ? relModel.getDesign().getRDBMSSiteSet().getByObjectID(siteID) : relModel.getDesign().getRDBMSSiteSet().getByShortObjectIDString(siteID);
                if (site == null && relModel.getDesign().getLoadedVersion() >= 3.2f) {
                    File sdFile;
                    String sdFileName = file.getName() + EXTENSION_XML_FILES;
                    if (relModel.getDesign().isCompressedDesign()) {
                        sdFileName = sdFileName + COMPRESSED_FILE_SUFIX;
                    }
                    if ((sdFile = new File(file, sdFileName)).exists()) {
                        Element siteTypeElm;
                        Document doc = null;
                        if (relModel.getDesign().isCompressedDesign()) {
                            doc = XMLTransformationManager.getDocument(sdFile);
                        } else {
                            try {
                                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                                DocumentBuilder db = dbf.newDocumentBuilder();
                                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(sdFile), "UTF-8");
                                doc = db.parse(new InputSource(reader));
                                reader.close();
                            }
                            catch (Exception e) {
                                LOGGER.warn(e.getMessage(), e);
                            }
                        }
                        if (doc != null && (siteTypeElm = this.getFirstElementByTagName(SITE_TYPE, doc.getDocumentElement())) != null) {
                            String siteType = siteTypeElm.getTextContent();
                            Element siteTypeID = this.getFirstElementByTagName(SITE_ID, doc.getDocumentElement());
                            String siteOID = siteTypeID.getTextContent();
                            Element siteTypeName = this.getFirstElementByTagName(SITE_NAME, doc.getDocumentElement());
                            String siteName = siteTypeName.getTextContent();
                            site = relModel.getDesign().getRDBMSSiteSet().createSite(siteName, relModel.getDesign());
                            int type = 9;
                            try {
                                type = Integer.parseInt(siteType);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            RDBMSType rdbmsType = Design.getDefaultRDBMSTypeSet().get(type);
                            site.setType(rdbmsType);
                            site.setObjectID(siteOID);
                            site.setPathID(relModel.getDesign().getRDBMSSiteSet().nextIndex());
                        }
                    }
                }
                if (site == null || (stoDes = relModel.getStorageDesign(site)) == null) continue;
                stoDes.setOpen(false);
                stoDes.setTempModel(false);
                this.clearDirtyStatus(stoDes);
                stoDes.setAllStorableObjectsDirty(false);
            }
        }
    }

    private boolean supportStorageDesignInSingleFile(StorageDesign sd) {
        return sd instanceof StorageDesignOracle || sd instanceof AbstractStorageDesignDB2 || sd instanceof StorageDesignUDB || sd instanceof StorageDesignSqlServer;
    }

    public void openPhysicalModel(StorageDesign physicalModel) {
        this.openPhysicalModel(physicalModel, true);
    }

    public void openPhysicalModel(StorageDesign physicalModel, boolean clearDirtyFlag) {
        boolean temp = Design.OPEN_FAILED;
        Design.OPEN_FAILED = false;
        Design des = physicalModel.getDesign();
        int pers = des.getLoadedModelPersistence();
        if ((pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE) && this.supportStorageDesignInSingleFile(physicalModel) && this.modelFileExists(physicalModel)) {
            this.openPhysicalModelSingleFile(physicalModel, clearDirtyFlag);
            return;
        }
        this.openPhysicalModelManyFiles(physicalModel, clearDirtyFlag);
        if (Design.OPEN_FAILED) {
            MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), Messages.getString("Design.SomeObjectsNotLoadedCorrectly"), true);
        }
        Design.OPEN_FAILED = temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPhysicalModelSingleFile(StorageDesign physicalModel, boolean clearDirtyFlag) {
        if (physicalModel.getStorageName() != null) {
            try {
                ArrayList<ModelIDObject> withWrongSegment = new ArrayList<ModelIDObject>();
                physicalModel.setLoading(true);
                String mstorageName = physicalModel.getStoragePath() + File.separatorChar + physicalModel.getShortObjectID() + ".model.local";
                File file = new File(mstorageName);
                if (file.exists()) {
                    List<ObjectHelper> objects = XMLTransformationManager.getObjects(physicalModel.getStoragePath(), OBJECT_LIST, physicalModel.getDesign().isCompressedDesign());
                    for (ObjectHelper oh : objects) {
                        StorageObjectSet set = physicalModel.getStorageObjectSetForType(oh.type);
                        if (set != null) {
                            StorageObject stObject = physicalModel.getStorageObject(oh.id);
                            if (stObject == null) {
                                oh.object = set.createElement(oh.id);
                                continue;
                            }
                            oh.object = stObject;
                            continue;
                        }
                        oh.object = physicalModel.getStorageObject(oh.id);
                        if (oh.object != null) continue;
                        physicalModel.getNotLoadedObjectHelpersMap().put(oh.id, oh);
                    }
                    this.transformFromXMLToObjectSAX(physicalModel, file, null);
                    for (ObjectHelper oh : objects) {
                        ModelIDObject stObject = (ModelIDObject)oh.object;
                        if (stObject == null) continue;
                        String oldSegmentName = stObject.getDirectorySegmentName();
                        if (physicalModel.isCloneOperation()) {
                            stObject.setSegmentedStorageName(null);
                        }
                        stObject.setDirectorySegmentName(oh.seq_name, true);
                        boolean loaded = stObject.isLoadedCompletely();
                        boolean keepDirty = false;
                        if (physicalModel.isCloneOperation()) {
                            stObject.setDirectorySegmentName(oldSegmentName, true);
                            stObject.setSegmentedStorageName(null);
                        } else {
                            String seg = stObject.getDirectorySegmentName();
                            if (!seg.equals(oh.seq_name) && loaded) {
                                keepDirty = true;
                                stObject.setDirectorySegmentName(oh.seq_name, true);
                                withWrongSegment.add(stObject);
                            }
                        }
                        if (clearDirtyFlag && !keepDirty) {
                            this.clearDirtyStatus(stObject);
                            continue;
                        }
                        stObject.setDirty(true);
                    }
                    ArrayList<ModelIDObject> dirtyObjects = null;
                    if (!clearDirtyFlag) {
                        dirtyObjects = physicalModel.getDirtyObjects();
                    } else {
                        physicalModel.doAfterLoad();
                    }
                    if (dirtyObjects == null) {
                        dirtyObjects = withWrongSegment;
                    }
                    if (dirtyObjects != null) {
                        for (ModelIDObject obj : dirtyObjects) {
                            obj.setDirty(true);
                        }
                    }
                }
                if (!clearDirtyFlag) {
                    physicalModel.setDirty(true);
                }
            }
            finally {
                physicalModel.setLoading(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPhysicalModelManyFiles(StorageDesign physicalModel, boolean clearDirtyFlag) {
        if (physicalModel.getStorageName() != null) {
            try {
                ArrayList<ModelIDObject> withWrongSegment = new ArrayList<ModelIDObject>();
                physicalModel.setLoading(true);
                physicalModel.getNotLoadedObjectHelpersMap().clear();
                File file = physicalModel.getDesign().isCompressedDesign() ? new File(physicalModel.getStorageName() + COMPRESSED_FILE_SUFIX) : new File(physicalModel.getStorageName());
                if (file.exists()) {
                    this.transformFromXMLToObject(physicalModel, file, physicalModel.getDesign().isCompressedDesign(), clearDirtyFlag, null);
                    List<ObjectHelper> objects0 = XMLTransformationManager.getObjects(physicalModel.getStoragePath(), OBJECT_LIST, physicalModel.getDesign().isCompressedDesign());
                    List objects = this.recreateObjectList(objects0, physicalModel.getClass().getName(), physicalModel.getFolderToTypeMap(), physicalModel.getStoragePath(), OBJECT_LIST, physicalModel.getDesign().isCompressedDesign(), physicalModel.getDesign().isVersioned());
                    for (ObjectHelper oh : objects) {
                        StorageObjectSet set = physicalModel.getStorageObjectSetForType(oh.type);
                        if (set != null) {
                            StorageObject stObject = physicalModel.getStorageObject(oh.id);
                            if (stObject == null) {
                                oh.object = set.createElement(oh.id);
                                continue;
                            }
                            oh.object = stObject;
                            continue;
                        }
                        oh.object = physicalModel.getStorageObject(oh.id);
                        if (oh.object != null) continue;
                        physicalModel.getNotLoadedObjectHelpersMap().put(oh.id, oh);
                    }
                    for (ObjectHelper oh : objects) {
                        ModelIDObject stObject = (ModelIDObject)oh.object;
                        if (stObject == null) continue;
                        String storageName = stObject.getStorageName();
                        String oldSegmentName = stObject.getDirectorySegmentName();
                        if (physicalModel.isCloneOperation()) {
                            stObject.setSegmentedStorageName(null);
                        }
                        stObject.setDirectorySegmentName(oh.seq_name, true);
                        storageName = stObject.getSegmentedStorageName();
                        boolean loaded = this.transformFromXMLToObject(stObject, new File(storageName), physicalModel.getDesign().isCompressedDesign(), clearDirtyFlag, null);
                        boolean keepDirty = false;
                        if (physicalModel.isCloneOperation()) {
                            stObject.setDirectorySegmentName(oldSegmentName, true);
                            stObject.setSegmentedStorageName(null);
                        } else {
                            String seg = stObject.getDirectorySegmentName();
                            if (!seg.equals(oh.seq_name) && loaded) {
                                keepDirty = true;
                                stObject.setDirectorySegmentName(oh.seq_name, true);
                                withWrongSegment.add(stObject);
                            }
                            stObject.setLoadedCompletely(loaded);
                        }
                        if (clearDirtyFlag && !keepDirty) {
                            this.clearDirtyStatus(stObject);
                            continue;
                        }
                        stObject.setDirty(true);
                    }
                    ArrayList<ModelIDObject> dirtyObjects = null;
                    if (!clearDirtyFlag) {
                        dirtyObjects = physicalModel.getDirtyObjects();
                    } else {
                        physicalModel.doAfterLoad();
                    }
                    if (dirtyObjects == null) {
                        dirtyObjects = withWrongSegment;
                    }
                    if (dirtyObjects != null) {
                        for (ModelIDObject obj : dirtyObjects) {
                            obj.setDirty(true);
                        }
                    }
                }
                if (!clearDirtyFlag) {
                    physicalModel.setDirty(true);
                }
            }
            finally {
                physicalModel.setLoading(false);
            }
        }
    }

    private void clearPropertyMap(List list) {
        for (Object obj : list) {
            if (!(obj instanceof ModelIDObject)) continue;
            ((ModelIDObject)obj).clearProperties();
        }
    }

    public boolean savePhysicalModel(StorageDesign physicalModel) {
        boolean shouldSave;
        boolean result = false;
        Design des = physicalModel.getDesign();
        int pers = des.getModelPersistence();
        boolean bl = shouldSave = physicalModel.isOpen() && (!this.isCheckDirty() || this.isCheckDirty() && (physicalModel.isDirty() || physicalModel.hasDirtyStorableObjects()));
        if (des.isVersioned() || pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_MANY_FILES || !this.supportStorageDesignInSingleFile(physicalModel)) {
            result = this.savePhysicalModelMultiFiles(physicalModel);
            if (result && shouldSave && (pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE) && this.supportStorageDesignInSingleFile(physicalModel)) {
                result = this.savePhysicalModelSingleFile(physicalModel);
            }
        } else if (pers == Design.PERS_MODEL_IN_ONE_FILE) {
            result = this.savePhysicalModelSingleFile(physicalModel);
            try {
                physicalModel.synchronizeFilesMap(true);
            }
            catch (Exception e) {
                LOGGER.error("Error in cleaning files in model: " + physicalModel.getName(), e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePhysicalModelSingleFile(StorageDesign stDes) {
        if (stDes.isOpen()) {
            String storageName = stDes.getStoragePath() + File.separatorChar + stDes.getShortObjectID() + ".model.local";
            TimeLog.log("start save operation");
            try {
                MDTransformationManager trMan = this.getMDTransformationManager();
                File fPath = new File(storageName).getParentFile();
                if (!fPath.exists()) {
                    fPath.mkdirs();
                }
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    FileOutputStream fs = new FileOutputStream(new File(storageName));
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                    BufferedWriter bs = new BufferedWriter(osw, 8192);
                    XMLTransformationManager.writeContentAsStream(stDes, bs, trMan, true, null);
                    bs.flush();
                    bs.close();
                    if (stDes.isDirty()) {
                        this.saveObject(stDes);
                    }
                    try {
                        stDes.synchronizeFilesMap(true);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in cleaning files in model: " + stDes.getName(), e);
                    }
                    TimeLog.log("end save operation");
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
                MessageDialogs.showErrorMessage(message, true);
            }
        }
        return false;
    }

    public boolean savePhysicalModelMultiFiles(StorageDesign physicalModel) {
        try {
            saveFailed = false;
            ArrayList<StorageDesign> list = new ArrayList<StorageDesign>();
            if (physicalModel.isOpen()) {
                if (this.isCheckDirty()) {
                    if (physicalModel.isDirty() || physicalModel.hasDirtyStorableObjects()) {
                        list.addAll(physicalModel.getStorableObjects());
                    }
                } else {
                    list.addAll(physicalModel.getStorableObjects());
                }
                list.add(physicalModel);
                for (StorableObject storableObject : list) {
                    this.saveObject(storableObject);
                }
                this.saveObjectList(physicalModel);
                physicalModel.doAfterSave();
                if (saveFailed) {
                    MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectly"), true);
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Unable to save the Physical Model: " + physicalModel.getName(), ex);
            MessageDialogs.showErrorMessage("Unable to save the Physical Model: " + physicalModel.getName());
            return false;
        }
    }

    public static Document getDocument(File compressedFile) {
        try {
            int cnt;
            FileInputStream fin = new FileInputStream(compressedFile);
            InflaterInputStream iis = new InflaterInputStream((InputStream)fin);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int size = 1024;
            byte[] buffer = new byte[size];
            while ((cnt = iis.read(buffer)) != -1) {
                bos.write(buffer, 0, cnt);
            }
            ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            iis.close();
            bos.close();
            ((InputStream)in).close();
            return doc;
        }
        catch (Exception e) {
            Design.openFailed();
            LOGGER.error("Can not parse file:" + compressedFile.getAbsolutePath(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveDocument(String storageName, Document xmlContent, boolean useCompressedFiles) {
        if (storageName != null && xmlContent != null) {
            try {
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    File fPath = new File(storageName).getParentFile();
                    if (!fPath.exists()) {
                        fPath.mkdirs();
                    }
                    if (useCompressedFiles) {
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        Transformer transformer = transformerFactory.newTransformer();
                        transformer.setOutputProperty("indent", "yes");
                        transformer.setOutputProperty("encoding", "UTF-8");
                        DOMSource source = new DOMSource(xmlContent);
                        StringWriter sw = new StringWriter();
                        StreamResult result = new StreamResult(sw);
                        transformer.transform(source, result);
                        String xmlData = sw.getBuffer().toString();
                        sw.close();
                        byte[] input = xmlData.getBytes("UTF-8");
                        byte[] output = new byte[input.length];
                        Deflater compresser = new Deflater();
                        compresser.setInput(input);
                        compresser.finish();
                        int compressedDataLength = compresser.deflate(output);
                        if (!storageName.endsWith(EXTENSION_XML_FILES_COMPRESSED) && !storageName.endsWith(EXTENSION_DESIGN_FILE_COMPRESSED)) {
                            storageName = storageName + COMPRESSED_FILE_SUFIX;
                        }
                        FileOutputStream outStream = new FileOutputStream(storageName);
                        ((OutputStream)outStream).write(output, 0, compressedDataLength);
                        outStream.flush();
                        ((OutputStream)outStream).close();
                    } else {
                        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                        LSSerializer writer = impl.createLSSerializer();
                        LSOutput ls = impl.createLSOutput();
                        FileOutputStream fs = new FileOutputStream(new File(storageName));
                        ls.setEncoding("UTF-8");
                        writer.setNewLine("\n");
                        writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                        StringWriter stringWriter = new StringWriter();
                        ls.setCharacterStream(stringWriter);
                        writer.write(xmlContent, ls);
                        String result = ((Object)stringWriter).toString();
                        byte[] output = result.getBytes("UTF-8");
                        fs.write(output, 0, output.length - 1);
                        fs.flush();
                        fs.close();
                    }
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
                saveFailed = true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveContent(String storageName, String content, boolean useCompressedFiles) {
        if (storageName != null && content != null) {
            try {
                File fPath = new File(storageName).getParentFile();
                if (!fPath.exists()) {
                    fPath.mkdirs();
                }
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    if (useCompressedFiles) {
                        String xmlData = content;
                        byte[] input = xmlData.getBytes("UTF-8");
                        byte[] output = new byte[input.length];
                        Deflater compresser = new Deflater();
                        compresser.setInput(input);
                        compresser.finish();
                        int compressedDataLength = compresser.deflate(output);
                        FileOutputStream outStream = new FileOutputStream(storageName + COMPRESSED_FILE_SUFIX);
                        ((OutputStream)outStream).write(output, 0, compressedDataLength);
                        outStream.flush();
                        ((OutputStream)outStream).close();
                    } else {
                        FileOutputStream fs = new FileOutputStream(new File(storageName));
                        OutputStreamWriter bs = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                        bs.write(content);
                        bs.flush();
                        bs.close();
                    }
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
                saveFailed = true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveContentOfObject(String storageName, Object object, boolean useCompressedFiles, MDTransformationManager trMan) {
        if (storageName != null) {
            try {
                File fPath = new File(storageName).getParentFile();
                if (!fPath.exists()) {
                    fPath.mkdirs();
                }
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    if (useCompressedFiles) {
                        StringWriter sw = new StringWriter(8192);
                        XMLTransformationManager.writeContentAsStream(object, sw, trMan);
                        String xmlData = sw.getBuffer().toString();
                        sw.close();
                        byte[] input = xmlData.getBytes("UTF-8");
                        byte[] output = new byte[input.length];
                        Deflater compresser = new Deflater();
                        compresser.setInput(input);
                        compresser.finish();
                        int compressedDataLength = compresser.deflate(output);
                        FileOutputStream outStream = new FileOutputStream(storageName + COMPRESSED_FILE_SUFIX);
                        ((OutputStream)outStream).write(output, 0, compressedDataLength);
                        outStream.flush();
                        ((OutputStream)outStream).close();
                    } else {
                        FileOutputStream fs = new FileOutputStream(new File(storageName));
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                        BufferedWriter bs = new BufferedWriter(osw, 8192);
                        XMLTransformationManager.writeContentAsStream(object, bs, trMan);
                        bs.flush();
                        bs.close();
                    }
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
                saveFailed = true;
            }
        }
        return false;
    }

    public static void writeContentAsStream(Object object, Writer writer, MDTransformationManager trMan) {
        MDTransformationManager.TrObjects trs = trMan.getTransformersFor(object.getClass());
        if (trs != null && trs.getFromObjectToStreamTransformer() != null && trs.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer) {
            ((XMLObjToStreamTransformer)trs.getFromObjectToStreamTransformer()).transformFromObject(object, writer);
        }
    }

    private static void writeContentAsStream(Object object, Writer writer, MDTransformationManager trMan, boolean processExternals, List excludeProps_Collections) {
        MDTransformationManager.TrObjects trs = trMan.getTransformersFor(object.getClass());
        if (trs != null && trs.getFromObjectToStreamTransformer() != null && trs.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer) {
            ((XMLObjToStreamTransformer)trs.getFromObjectToStreamTransformer()).transformFromObject(object, writer, processExternals, excludeProps_Collections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveObjectWithExternals(String storageName, Object object) {
        TimeLog.log("start save operation");
        if (storageName != null) {
            try {
                MDTransformationManager trMan = this.getMDTransformationManager();
                File fPath = new File(storageName).getParentFile();
                if (!fPath.exists()) {
                    fPath.mkdirs();
                }
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    FileOutputStream fs = new FileOutputStream(new File(storageName));
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                    BufferedWriter bs = new BufferedWriter(osw, 8192);
                    XMLTransformationManager.writeContentAsStream(object, bs, trMan, true, null);
                    bs.flush();
                    bs.close();
                    TimeLog.log("end save operation");
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
                MessageDialogs.showErrorMessage(message, true);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transformObjectsToStreamXML(List objects, OutputStream outputStream, List excludePropsAndCollections, boolean closeTheStream) {
        TimeLog.log("start output operation");
        try {
            MDTransformationManager trMan = this.getMDTransformationManager();
            String old_sep = System.getProperty("line.separator");
            try {
                System.setProperty("line.separator", "\n");
                OutputStreamWriter osw = new OutputStreamWriter(outputStream, "UTF-8");
                BufferedWriter bs = new BufferedWriter(osw, 8192);
                try {
                    bs.write(XMLObjToStreamTransformer.header);
                    bs.write("\n<objects>");
                }
                catch (IOException e) {
                    // empty catch block
                }
                for (Object object : objects) {
                    MDTransformationManager.TrObjects trs = trMan.getTransformersFor(object.getClass());
                    if (trs == null || trs.getFromObjectToStreamTransformer() == null || !(trs.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer)) continue;
                    ((XMLObjToStreamTransformer)trs.getFromObjectToStreamTransformer()).transformFromObject(object, null, (Writer)bs, false, excludePropsAndCollections);
                }
                bs.write("\n</objects>");
                bs.flush();
                if (closeTheStream) {
                    bs.close();
                }
                TimeLog.log("end output operation");
            }
            finally {
                System.setProperty("line.separator", old_sep);
            }
            return true;
        }
        catch (Exception e) {
            String message = Messages.getString("XMLPersistenceManager.SaveError in ") + " ";
            LOGGER.error(message, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadObjectWithExternals(String storageName, Object object) {
        TimeLog.log("start load operation");
        int mb = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        System.out.println("start load operation memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
        if (storageName != null) {
            try {
                File file;
                if (object instanceof ModelIDObject) {
                    ((ModelIDObject)object).getDesign().setPropagatePKChahges(false);
                }
                ApplicationView.canLogging = false;
                ApplicationView.loading = true;
                MDTransformationManager trMan = this.getMDTransformationManager();
                MDTransformationManager.TrObjects trs = trMan.getTransformersFor(object.getClass());
                if (trs != null && trs.getToObjectTransformer() != null && (file = new File(storageName)).exists()) {
                    this.transformFromXMLToObjectSAX(object, file, null);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
                MessageDialogs.showErrorMessage(message);
            }
            finally {
                if (object instanceof ModelIDObject) {
                    ((ModelIDObject)object).getDesign().setPropagatePKChahges(true);
                }
                ApplicationView.canLogging = true;
                ApplicationView.loading = false;
                TimeLog.log("end load operation");
                System.out.println("end load operation memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
                this.getMetaDataManager().printTagMap();
            }
        }
        return false;
    }

    public void saveDomains(Design design) {
        boolean oldSaveFailed = saveFailed;
        saveFailed = false;
        HashMap<String, Domain> domainFileNames = new HashMap<String, Domain>();
        Iterator it = design.getDomainSet().iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            String fileName = domain.getFileName();
            if (domainFileNames.containsKey(fileName)) continue;
            domainFileNames.put(fileName, domain);
        }
        it = domainFileNames.keySet().iterator();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(XMLTransformationManager.EXTENSION_XML_FILES);
            }
        };
        FolderFilesListing domainFilesListing = new FolderFilesListing(design.getDomainSet().getStoragePath(), filter);
        ArrayList<String> domainFilesList = domainFilesListing.getFilesLis();
        while (it.hasNext()) {
            String fileName = (String)it.next();
            if ("".equals(fileName)) continue;
            if (!"defaultdomains".equalsIgnoreCase(fileName)) {
                this.saveDomain(design, fileName);
                domainFilesList.remove(fileName + EXTENSION_XML_FILES);
                if (!Extension.isSVNExtensionLoaded() || !design.isVersioned()) continue;
                SVNClientHelper.getInstance().saveProperties((ModelIDObject)domainFileNames.get(fileName), design.getDomainSet().getStorageName(fileName));
                continue;
            }
            this.saveDefaultDomain(this.getDefaultDomainsFileName(), design);
        }
        for (int i = 0; i < domainFilesList.size(); ++i) {
            File fileToDelete = new File(design.getDomainSet().getStoragePath(), (String)domainFilesList.get(i));
            if (Extension.isSVNExtensionLoaded()) {
                if (SVNClientHelper.getInstance().isVersioned(fileToDelete)) {
                    File[] files = new File[]{fileToDelete};
                    SVNClientHelper.getInstance().doRemove(files);
                    continue;
                }
                fileToDelete.delete();
                continue;
            }
            fileToDelete.delete();
        }
        if (saveFailed) {
            MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectly"), true);
        }
        saveFailed = oldSaveFailed;
    }

    public void saveDomain(Design design, String fileName) {
        DomainFileWrapper dw = new DomainFileWrapper(design, fileName);
        Document xmlContent = this.getXMLContent(dw);
        XMLTransformationManager.saveDocument(design.getDomainSet().getStorageName(fileName), xmlContent, false);
        for (Domain dom : dw.getDomains()) {
            dom.setDirty(false);
        }
    }

    public boolean saveDefaultDomain(String filePath, Design design) {
        DomainFileWrapper dw = new DomainFileWrapper(design, "defaultdomains");
        Document xmlContent = this.getXMLContent(dw);
        boolean res = XMLTransformationManager.saveDocument(filePath, xmlContent, false);
        if (res) {
            for (Domain dom : dw.getDomains()) {
                dom.setDirty(false);
            }
        }
        return res;
    }

    public String getDefaultDomainsFileName() {
        try {
            return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "defaultdomains.xml").getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error(e);
            return null;
        }
    }

    public String getDefaultMaskTemplatesFileName() {
        try {
            return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "maskTemplates.xml").getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error(e);
            return null;
        }
    }

    public static File getDefaultRDBMSFile() {
        return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "defaultRDBMSSites.xml");
    }

    public static File getDefaultTypesFile() {
        return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "types.xml");
    }

    public static String getDefaultSystemTypesPath() {
        return XMLTransformationManager.getDefaultSystemTypesPath(ApplicationView.getInstance().getSettings());
    }

    public static String getDefaultSystemTypesPath(Settings settings) {
        String sysTypesPath = settings.getDefaultSystemTypesPath();
        if (!"".equals(sysTypesPath)) {
            return sysTypesPath;
        }
        File fPath = new File(ApplicationView.basePath);
        return fPath.getAbsolutePath() + File.separatorChar + MDConfiguration.getDefaultInstance().get("typesPath");
    }

    public void loadDomains(Design design) {
        File domainsDir = new File(design.getDomainSet().getStoragePath());
        if (domainsDir.exists()) {
            File[] domains = domainsDir.listFiles();
            for (int i = 0; i < domains.length; ++i) {
                File file = domains[i];
                if (file.isDirectory()) continue;
                this.loadDomainFile(file, design);
            }
        }
    }

    public void loadDomainFile(File file, Design design) {
        try {
            Document doc = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            doc = db.parse(new InputSource(reader));
            reader.close();
            if (doc != null) {
                String fname = file.getName();
                int ind = fname.lastIndexOf(46);
                if (ind > 0) {
                    fname = fname.substring(0, ind);
                }
                this.loadDomains(design, fname, doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not load Domain file: " + file.getAbsolutePath(), e);
        }
    }

    public void loadDomains(Design design, String fileNameNoExt, Document doc) {
        DomainFileWrapper dw = new DomainFileWrapper(design, fileNameNoExt);
        MDTransformer tr = this.getMDTransformationManager().getToObjectTransformerFor(DomainFileWrapper.class);
        if (tr != null && tr instanceof XMLToObjectTransformer) {
            ((XMLToObjectTransformer)tr).transformToObject((Object)dw, doc, null);
        }
        for (Domain dom : dw.getDomains()) {
            dom.setDirty(false);
        }
    }

    public MDTransformationManager getXMLMapTransformationManager() {
        if (this.xmlMapManager == null) {
            this.xmlMapManager = new MDTransformationManager(this.metaDataManager);
            this.xmlMapManager.registerTransformer(ModelIDObject.class, XMLFromMapTransformer.class, XMLToMapTransformer.class, XMLFromMapToSteramTransformer.class);
            this.xmlMapManager.registerTransformer(Object.class, XMLFromMapTransformer.class, XMLToMapTransformer.class, XMLFromMapToSteramTransformer.class);
            MDTransformer.SKP_DEFAULTS = true;
        }
        return this.xmlMapManager;
    }

    public MDTransformationManager getObjectMapTransformationManager() {
        if (this.objectMapTransManager == null) {
            this.objectMapTransManager = new MDTransformationManager(this.metaDataManager);
            this.objectMapTransManager.registerTransformer(ModelIDObject.class, XMLObjToMapTransformer.class, XMLMapToObjTransformer.class, XMLObjToStreamTransformer.class);
            this.objectMapTransManager.registerTransformer(Object.class, XMLObjToMapTransformer.class, XMLMapToObjTransformer.class, XMLObjToStreamTransformer.class);
            MDTransformer.SKP_DEFAULTS = true;
        }
        return this.objectMapTransManager;
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public boolean hasDirtyStatus(Object object) {
        if (object instanceof RepositoryObject) {
            if (((RepositoryObject)object).isDirty()) {
                return true;
            }
            if (object instanceof DesignPartView) {
                return ((DesignPartView)object).isDirty();
            }
        }
        if (object instanceof StorableObject && ((StorableObject)object).isDirty()) {
            return true;
        }
        boolean dirty = this.hasDirtyProperty(object);
        if (dirty) {
            return true;
        }
        dirty = this.hasDirtyStructure(object);
        return dirty;
    }

    private boolean hasDirtyProperty(Object object) {
        ClassDescription cd = this.getMetaDataManager().getClassDescription(object.getClass().getName());
        if (cd != null) {
            List<ClassDescription.PropertyDescription> list = cd.getPropertiesList();
            for (ClassDescription.PropertyDescription pd : list) {
                boolean dirty;
                Object nested;
                if (pd.isReferred() || pd.isSimpleClass() || pd.isStringClass() || pd.isPropertyMap || pd.isMap || (nested = MDTransformer.getObjectForProperty(object, pd)) == null || !(dirty = this.hasDirtyStatus(nested))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasDirtyStructure(Object object) {
        ClassDescription cd = this.getMetaDataManager().getClassDescription(object.getClass().getName());
        if (cd != null) {
            List<ClassDescription.CollectionDescription> list = cd.getCollectionsList();
            for (ClassDescription.CollectionDescription cold : list) {
                if (cold.isExternalCollection || cold.itemIsRef || cold.isMapItem || cold.isProxyitem || cold.isObjectViewItem || cold.isTVDiagramItem || cold.isTVConnectorItem) continue;
                Iterator items = MDTransformer.getObjectsIterator(object, cold);
                while (items.hasNext()) {
                    Object nested = items.next();
                    boolean dirty = this.hasDirtyStatus(nested);
                    if (!dirty) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void clearDirtyStatus(Object object) {
        if (object instanceof RepositoryObject) {
            ((RepositoryObject)object).setDirty(false);
            if (object instanceof DesignPartView) {
                return;
            }
        }
        this.clearDirtyProperties(object);
        this.clearDirtyStructure(object);
    }

    private void clearDirtyProperties(Object object) {
        MDTransformer xmltr;
        ClassDescription cd;
        if (object != null && (cd = this.getMetaDataManager().getClassDescription(object.getClass().getName())) != null && (xmltr = this.getMDTransformationManager().getFromObjectTransformerFor(object.getClass())) != null) {
            List<ClassDescription.PropertyDescription> list = cd.getPropertiesList();
            for (ClassDescription.PropertyDescription pd : list) {
                Object nested;
                if (pd.isReferred() || pd.isSimpleClass() || pd.isStringClass() || pd.isPropertyMap || pd.isMap || pd.isExternalProperty || (nested = MDTransformer.getObjectForProperty(object, pd)) == null) continue;
                this.clearDirtyStatus(nested);
            }
        }
    }

    private boolean clearDirtyStructure(Object object) {
        ClassDescription cd;
        if (object != null && (cd = this.getMetaDataManager().getClassDescription(object.getClass().getName())) != null) {
            List<ClassDescription.CollectionDescription> list = cd.getCollectionsList();
            for (ClassDescription.CollectionDescription cold : list) {
                if (cold.isExternalCollection || cold.itemIsRef || cold.isMapItem || cold.isProxyitem || cold.isObjectViewItem || cold.isTVDiagramItem || cold.isTVConnectorItem) continue;
                Iterator items = MDTransformer.getObjectsIterator(object, cold);
                while (items.hasNext()) {
                    Object nested = items.next();
                    this.clearDirtyStatus(nested);
                }
            }
        }
        return false;
    }

    public void loadRDBMSSites(Design design) {
        File rdbmsSites;
        File rdbmsDir = new File(design.getStoragePath(), "rdbms");
        if (rdbmsDir.exists() && (rdbmsSites = new File(rdbmsDir, design.getName() + "_RDBMSSites" + EXTENSION_XML_FILES)).exists()) {
            try {
                Document doc = null;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(rdbmsSites), "UTF-8");
                doc = db.parse(new InputSource(reader));
                reader.close();
                if (doc != null) {
                    RDBMSTypeSet typeSet = Design.getDefaultRDBMSTypeSet();
                    RDBMSSiteSet set = design.getRDBMSSiteSet();
                    NodeList siteList = doc.getDocumentElement().getElementsByTagName("site");
                    int length = siteList.getLength();
                    for (int i = 0; i < length; ++i) {
                        this.recreateSite((Element)siteList.item(i), set, typeSet);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Can not load RDBMS Sites: " + rdbmsSites.getAbsolutePath(), e);
            }
        }
    }

    private void recreateSite(Element siteElm, RDBMSSiteSet set, RDBMSTypeSet typeSet) {
        String name = StringUtilities.decodeAttributeValue(siteElm.getAttribute("name"));
        String siteID = siteElm.getAttribute("oid");
        boolean exists = false;
        if (siteID != null && siteID.length() > 0) {
            boolean bl = exists = set.getByObjectID(siteID) != null;
        }
        if (!exists && !set.exists(name)) {
            String typeStr = siteElm.getAttribute("type");
            String pathIDStr = siteElm.getAttribute("pathid");
            RDBMSSite site = set.createSite(name, set.getDesign());
            site.setIsDefault(false);
            site.setDesignLevel(true);
            int type = 9;
            try {
                type = Integer.parseInt(typeStr);
            }
            catch (Exception e) {
                // empty catch block
            }
            RDBMSType rdbmsType = typeSet.get(type);
            site.setType(rdbmsType);
            site.setObjectID(siteID);
            int pathID = 0;
            try {
                pathID = Integer.parseInt(pathIDStr);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                type = Integer.parseInt(typeStr);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (pathID > 0) {
                site.setPathID(pathID);
                set.updateMaxIndex(pathID);
            } else {
                site.setPathID(set.nextIndex());
            }
            if (rdbmsType == null) {
                LOGGER.error("Unknown RDBMS type: " + type);
            }
        }
    }

    public void saveRDBMSSites(Design design) {
        try {
            RDBMSSiteSet set = design.getRDBMSSiteSet();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.getDocumentElement();
            root = doc.createElement("metadatadoc");
            root.setAttribute("version", "2.0");
            doc.appendChild(root);
            RDBMSSite[] array = (RDBMSSite[])set.toArray();
            for (int i = 0; i < array.length; ++i) {
                if (array[i].isDefault()) continue;
                this.appendSiteNode(root, array[i]);
            }
            XMLTransformationManager.saveDocument(new File(design.getStoragePath(), "rdbms" + File.separatorChar + design.getName() + "_RDBMSSites" + EXTENSION_XML_FILES).getCanonicalPath(), doc, false);
        }
        catch (Exception e) {
            LOGGER.error("Can not save RDBMS Sites for Design: " + design.getName());
        }
    }

    public void saveAdditionalFiles(Design design) {
        Path sourcePath;
        File file;
        if (design.getOldDesignPath() != null && !"".equalsIgnoreCase(design.getOldDesignPath()) && (file = (sourcePath = Paths.get(design.getOldDesignPath(), "files")).toFile()).exists()) {
            Path destPath = Paths.get(design.getStoragePath(), "files");
            try {
                FileUtils.copyFolder(sourcePath, destPath);
            }
            catch (Exception e) {
                LOGGER.error("Can not save the Additional Files Directory.", e);
            }
        }
    }

    public void appendSiteNode(Element root, RDBMSSite site) {
        Document doc = root.getOwnerDocument();
        Element siteElm = doc.createElement("site");
        siteElm.setAttribute("name", StringUtilities.encodeAttributeValue(site.getLongName()));
        if (site.getType() != null) {
            siteElm.setAttribute("type", String.valueOf(site.getType().getType()));
        }
        siteElm.setAttribute("oid", site.getObjectID());
        siteElm.setAttribute("pathid", site.getPathIDString());
        root.appendChild(siteElm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equal(Object object1, Object object2, boolean includeLoggingProps) {
        MDTransformer tr;
        if (object1.getClass().equals(object2.getClass()) && (tr = this.getMDTransformationManager().getFromObjectTransformerFor(object1.getClass())) != null) {
            try {
                MDTransformer.includeLoggingProps = includeLoggingProps;
                MDTransformer.includeID = false;
                String str1 = tr.transformFromObjectToString(object1, null);
                String str2 = tr.transformFromObjectToString(object2, null);
                if (str1.equals(str2)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                MDTransformer.includeLoggingProps = true;
                MDTransformer.includeID = true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilteredXMLString(Object object) {
        String str = null;
        MDTransformer tr = this.getMDTransformationManager().getFromObjectTransformerFor(object.getClass());
        if (tr != null) {
            try {
                MDTransformer.includeLoggingProps = false;
                MDTransformer.includeID = false;
                str = tr.transformFromObjectToString(object, null);
            }
            finally {
                MDTransformer.includeLoggingProps = true;
                MDTransformer.includeID = true;
            }
        }
        return str;
    }

    public XMLToObjectSAXTransformer getXMLToObjectSAXTransformer() {
        if (this.xMLToObjectSAXTransformer == null) {
            this.xMLToObjectSAXTransformer = new XMLToObjectSAXTransformer(this.getMetaDataManager());
        }
        return this.xMLToObjectSAXTransformer;
    }

    public static boolean isPhysicalDesign(Design design, String objectClass, String objID) {
        RDBMSType type;
        RDBMSSite site = design.getRDBMSSiteSet().getByShortObjectIDString(objID);
        return site != null && (type = site.getType()) != null && type.getStorageDesignClassName().equals(objectClass);
    }

    public static Document parseInputStreamToDocument(InputStream is) {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(is);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Error in parseInputStreamToDocument: " + is.toString(), e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Error in parseInputStreamToDocument: " + is.toString(), e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Error in parseInputStreamToDocument: " + is.toString(), e);
        }
        catch (SAXException e) {
            LOGGER.error("Error in parseInputStreamToDocument: " + is.toString(), e);
        }
        catch (IOException e) {
            LOGGER.error("Error in parseInputStreamToDocument: " + is.toString(), e);
        }
        return doc;
    }

    public static Document parseFileToDocument(File file) {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            doc = db.parse(new InputSource(reader));
            reader.close();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Error in parseStringToDocument: " + file.getAbsolutePath(), e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Error in parseStringToDocument: " + file.getAbsolutePath(), e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Error in parseStringToDocument: " + file.getAbsolutePath(), e);
        }
        catch (SAXException e) {
            LOGGER.error("Error in parseStringToDocument: " + file.getAbsolutePath(), e);
        }
        catch (IOException e) {
            LOGGER.error("Error in parseStringToDocument: " + file.getAbsolutePath(), e);
        }
        return doc;
    }

    public static class ObjectHelper {
        public String type;
        public String id;
        public String contID;
        public String refContID;
        public String name;
        public Object object;
        public boolean visible = false;
        public boolean markedGenerate = true;
        public String seq_name;
        public File file;
        public String propertyClassname = null;
        public String propertyParentid = null;
        public String propertySourceid = null;
        public String propertyTargetid = null;
    }

    public static class DesignPartHelper {
        public String type;
        public String id;
        public String parent_id;
        public String name;
        public String main_view_id;
        public boolean top_level_dfd_design;
        public boolean visible = false;
    }
}

