/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.metadata.NewObjectIDPropertiesPair;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SVNDMPropertiesManager {
    public static final String LAST_ADDED_OBJECTS = "lastAddedObjects";
    public static final String ALL_ADDED_OBJECTS = "allAddedObjects";
    public static final String DM_PROPERTIES = "dmProperties";
    public static final String LAST_SYNCED_HEAD_REVISION = "lastSyncedHeadRevision";
    public static final String LAST_ADDED_OBJECTS_FILE_NAME = "LastAddedObjects";
    public static final String ALL_ADDED_OBJECTS_FILE_NAME = "AllAddedObjects";
    private static Document lastAddedObjectsFileHEADRevDoc;
    private static Document allAddedObjectsFileDoc;
    private static final Logger LOGGER;

    public static boolean saveAddedObjectsProperties(Design design) {
        try {
            File mineLocalFile;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element rootElement = doc.createElement(LAST_ADDED_OBJECTS);
            rootElement.setAttribute("designName", design.getName());
            rootElement.setAttribute("objectID", design.getObjectID());
            doc.appendChild(rootElement);
            List<NewObjectIDPropertiesPair> newObjectsList = design.getNewSVNObjectsList();
            for (NewObjectIDPropertiesPair objIdPropsPair : newObjectsList) {
                String id = objIdPropsPair.id;
                String properties = objIdPropsPair.properties;
                Element child = doc.createElement("object");
                child.setAttribute("objectID", id);
                child.setAttribute(DM_PROPERTIES, properties);
                rootElement.appendChild(child);
            }
            File lastAddedObjectsFile = new File(design.getStoragePath(), "LastAddedObjects.xml");
            boolean addToVersionControl = false;
            if (design.isVersioned() && !lastAddedObjectsFile.exists()) {
                addToVersionControl = true;
            }
            XMLTransformationManager.saveDocument(lastAddedObjectsFile.getCanonicalPath(), doc, design.isCompressedDesign());
            SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();
            if (addToVersionControl) {
                SVN_CLIENT_HELPER.doAdd(lastAddedObjectsFile);
            }
            File[] fileToCommit = new File[]{lastAddedObjectsFile};
            SVN_CLIENT_HELPER.doUpdate(fileToCommit, false);
            List<SVNStatus> lastAddedObjectsFileSVNStatus = SVNClientHelper.getInstance().doStatusSVN(lastAddedObjectsFile, true);
            SVNStatus lastAddedObjectsFileISVNStatus = null;
            if (lastAddedObjectsFileSVNStatus.size() > 0) {
                lastAddedObjectsFileISVNStatus = lastAddedObjectsFileSVNStatus.get(0);
            }
            if (lastAddedObjectsFileISVNStatus != null && lastAddedObjectsFileISVNStatus.getNodeStatus() == SVNStatusType.STATUS_CONFLICTED && (mineLocalFile = new File(lastAddedObjectsFile.getAbsoluteFile() + ".mine")).exists()) {
                Files.copy(mineLocalFile.toPath(), lastAddedObjectsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                SVNClientHelper.getInstance().doResolved(lastAddedObjectsFile);
            }
            SVN_CLIENT_HELPER.doCommit(fileToCommit, "This file is committed authomatically. Does not require user interaction.", false, true);
            return true;
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Can not save newly added files list: " + design.getName(), e);
        }
        catch (IOException e) {
            LOGGER.error("Can not save newly added files list: " + design.getName(), e);
        }
        return false;
    }

    public static boolean saveAllAddedObjectsProperties(Design design) {
        Map<String, String> svnDMPropertiesCacheMap = design.getSVNDMPropertiesCache();
        Document allAddedObjectsFileDoc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Element rootElement = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            allAddedObjectsFileDoc = db.newDocument();
            rootElement = allAddedObjectsFileDoc.createElement(ALL_ADDED_OBJECTS);
            rootElement.setAttribute("designName", design.getName());
            rootElement.setAttribute("objectID", design.getObjectID());
            rootElement.setAttribute(LAST_SYNCED_HEAD_REVISION, "0");
            allAddedObjectsFileDoc.appendChild(rootElement);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Error in saveAllAddedObjectsProperties(...) can't create allAddedObjectsFileDoc ", e);
        }
        Set<String> keys = svnDMPropertiesCacheMap.keySet();
        for (String key : keys) {
            String parentID;
            String shortParentID;
            Object objectParent;
            DesignObject designObject;
            String objId;
            String value = svnDMPropertiesCacheMap.get(key);
            if (key.equalsIgnoreCase(LAST_SYNCED_HEAD_REVISION)) {
                if (rootElement == null) continue;
                rootElement.setAttribute(LAST_SYNCED_HEAD_REVISION, value);
                continue;
            }
            String objID = objId = SVNClientHelper.getInstance().getProperty(value, 0);
            String shortParentId = key.substring(objId.length());
            String objectClass = SVNClientHelper.getInstance().getProperty(value, 1);
            boolean physDesign = XMLTransformationManager.isPhysicalDesign(design, objectClass, objId);
            if (objectClass.equals(RelationalDesign.class.getName()) || physDesign) {
                String shortId;
                objId = shortId = objId.substring(0, objId.indexOf("-")) + objId.substring(objId.lastIndexOf("-"));
            }
            if ((designObject = design.getDesignObject(objID)) == null) {
                SVNDMPropertiesManager.addObjectToAllAddedObjectsFileDoc(design, allAddedObjectsFileDoc, objId, value);
                continue;
            }
            if (StringUtilities.isEmpty(shortParentId) || (objectParent = designObject.getParent()) == null || !(objectParent instanceof DesignObject) || !shortParentId.equalsIgnoreCase(shortParentID = (parentID = ((DesignObject)objectParent).getObjectID()).substring(0, parentID.indexOf("-")) + parentID.substring(parentID.lastIndexOf("-")))) continue;
            SVNDMPropertiesManager.addObjectToAllAddedObjectsFileDoc(design, allAddedObjectsFileDoc, objId, value);
        }
        File allAddedObjectsFileNew = new File(design.getStoragePath(), "AllAddedObjects.local");
        try {
            XMLTransformationManager.saveDocument(allAddedObjectsFileNew.getCanonicalPath(), allAddedObjectsFileDoc, design.isCompressedDesign());
            design.setAllAddedObjectsFileDocChanged(false);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Can not save all added objects files doc: " + design.getName(), e);
            return false;
        }
    }

    private static void addObjectToAllAddedObjectsFileDoc(Design design, Document allAddedObjectsFileDoc, String objId, String props) {
        Element child = allAddedObjectsFileDoc.createElement("object");
        child.setAttribute("objectID", objId);
        child.setAttribute(DM_PROPERTIES, props);
        allAddedObjectsFileDoc.getDocumentElement().appendChild(child);
        design.setAllAddedObjectsFileDocChanged(true);
    }

    public static String extractObjectPropertiesFromLastAddedObjectsFile(Design design, Document doc, String parentObjectShortID, String objID, boolean isHEADRevision) {
        String properties = null;
        NodeList objectsList = doc.getElementsByTagName("object");
        Map<String, String> svnDMPropertiesCache = design.getSVNDMPropertiesCache();
        for (int i = 0; i < objectsList.getLength(); ++i) {
            String shortParentID;
            Node object = objectsList.item(i);
            String id = object.getAttributes().getNamedItem("objectID").getTextContent();
            String objectClass = SVNClientHelper.getInstance().getProperty(object.getAttributes().getNamedItem(DM_PROPERTIES).getTextContent(), 1);
            String objectDMProperties = object.getAttributes().getNamedItem(DM_PROPERTIES).getTextContent();
            boolean physDesign = XMLTransformationManager.isPhysicalDesign(design, objectClass, objID);
            if (objectClass.equals(RelationalDesign.class.getName()) || physDesign) {
                String shortId;
                id = shortId = id.substring(0, id.indexOf("-")) + id.substring(id.lastIndexOf("-"));
            }
            if (svnDMPropertiesCache.get(id + parentObjectShortID) != null) continue;
            design.setAllAddedObjectsFileDocChanged(true);
            svnDMPropertiesCache.put(id + parentObjectShortID, objectDMProperties);
            if (!id.equalsIgnoreCase(objID)) continue;
            properties = object.getAttributes().getNamedItem(DM_PROPERTIES).getTextContent();
            String parentID = SVNClientHelper.getInstance().getProperty(properties, 2);
            if (StringUtilities.isEmpty(parentID) || parentObjectShortID.equals(shortParentID = parentID.substring(0, parentID.indexOf("-")) + parentID.substring(parentID.lastIndexOf("-")))) continue;
            properties = null;
        }
        return properties;
    }

    public static String extractObjectPropertiesFromAllAddedObjectsFile(Design design, String parentObjectShortID, String objID) {
        String properties = null;
        Map<String, String> svnDMPropertiesCache = design.getSVNDMPropertiesCache();
        properties = svnDMPropertiesCache.get(objID + parentObjectShortID);
        if (!StringUtilities.isEmpty(properties)) {
            return properties;
        }
        if (svnDMPropertiesCache.size() > 0) {
            return null;
        }
        allAddedObjectsFileDoc = null;
        File allAddedObjectsFile = new File(design.getStoragePath(), "AllAddedObjects.local");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document docAll = null;
        if (allAddedObjectsFile.exists()) {
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(allAddedObjectsFile), "UTF-8");
                docAll = db.parse(new InputSource(reader));
                reader.close();
            }
            catch (ParserConfigurationException e) {
                LOGGER.error("Error in extractObjectPropertiesFromLastAddedObjectsFile(...) can't create allAddedObjectsFileDoc: " + objID, e);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Error in extractObjectPropertiesFromLastAddedObjectsFile(...) can't create allAddedObjectsFileDoc: " + objID, e);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Error in extractObjectPropertiesFromLastAddedObjectsFile(...) can't create allAddedObjectsFileDoc: " + objID, e);
            }
            catch (SAXException e) {
                LOGGER.error("Error in extractObjectPropertiesFromLastAddedObjectsFile(...) can't create allAddedObjectsFileDoc: " + objID, e);
            }
            catch (IOException e) {
                LOGGER.error("Error in extractObjectPropertiesFromLastAddedObjectsFile(...) can't create allAddedObjectsFileDoc: " + objID, e);
            }
            allAddedObjectsFileDoc = docAll;
            properties = SVNDMPropertiesManager.getPropertiesFromAllAddedObjectsFileDoc(design, allAddedObjectsFileDoc, parentObjectShortID, objID);
        }
        return properties;
    }

    private static String getPropertiesFromAllAddedObjectsFileDoc(Design design, Document doc, String parentObjectShortID, String objID) {
        String properties = null;
        Map<String, String> svnDMPropertiesCache = design.getSVNDMPropertiesCache();
        NodeList allObjectsList = doc.getElementsByTagName("object");
        String lastSyncedHeadRevision = doc.getDocumentElement().getAttribute(LAST_SYNCED_HEAD_REVISION);
        svnDMPropertiesCache.put(LAST_SYNCED_HEAD_REVISION, lastSyncedHeadRevision);
        for (int i = 0; i < allObjectsList.getLength(); ++i) {
            String shortParentID;
            String parentID;
            Node aobject = allObjectsList.item(i);
            String aobjectID = aobject.getAttributes().getNamedItem("objectID").getTextContent();
            String aproperties = aobject.getAttributes().getNamedItem(DM_PROPERTIES).getTextContent();
            String aparentID = SVNClientHelper.getInstance().getProperty(aproperties, 2);
            String ashortParentID = "";
            if (!StringUtilities.isEmpty(parentObjectShortID) && !StringUtilities.isEmpty(aparentID)) {
                int firstHiphenIndex = aparentID.indexOf("-");
                int lastHiphenIndex = aparentID.lastIndexOf("-");
                if (firstHiphenIndex > 0 && lastHiphenIndex > 0 && firstHiphenIndex != lastHiphenIndex) {
                    ashortParentID = aparentID.substring(0, firstHiphenIndex) + aparentID.substring(lastHiphenIndex);
                }
            }
            svnDMPropertiesCache.put(aobjectID + ashortParentID, aproperties);
            if (!aobjectID.equalsIgnoreCase(objID)) continue;
            properties = aobject.getAttributes().getNamedItem(DM_PROPERTIES).getTextContent();
            if (StringUtilities.isEmpty(parentObjectShortID) || StringUtilities.isEmpty(parentID = SVNClientHelper.getInstance().getProperty(properties, 2))) continue;
            int firstHiphenIndex = parentID.indexOf("-");
            int lastHiphenIndex = parentID.lastIndexOf("-");
            if (firstHiphenIndex <= 0 || lastHiphenIndex <= 0 || firstHiphenIndex == lastHiphenIndex || parentObjectShortID.equals(shortParentID = parentID.substring(0, firstHiphenIndex) + parentID.substring(lastHiphenIndex))) continue;
            properties = null;
        }
        return properties;
    }

    public static String getLastSyncedHeadRevisionFromAllAddedObjectsFileDoc(Document doc) {
        String lastSyncedHeadRevision = null;
        if (doc != null) {
            lastSyncedHeadRevision = doc.getDocumentElement().getAttribute(LAST_SYNCED_HEAD_REVISION);
        }
        return lastSyncedHeadRevision;
    }

    public static String getLastSyncedHeadRevisionFromAllAddedObjectsMap(Design design) {
        String lastSyncedHeadRevision = null;
        Map<String, String> svnDMPropertiesCache = design.getSVNDMPropertiesCache();
        if (svnDMPropertiesCache != null) {
            lastSyncedHeadRevision = svnDMPropertiesCache.get(LAST_SYNCED_HEAD_REVISION);
        }
        return lastSyncedHeadRevision;
    }

    public static void setLastSyncedHeadRevisionInAllAddedObjectsFileDoc(Design design, String lastSyncedHeadRevision) {
        Map<String, String> svnDMPropertiesCacheMap = design.getSVNDMPropertiesCache();
        if (svnDMPropertiesCacheMap != null) {
            if (svnDMPropertiesCacheMap.containsKey(LAST_SYNCED_HEAD_REVISION)) {
                svnDMPropertiesCacheMap.replace(LAST_SYNCED_HEAD_REVISION, lastSyncedHeadRevision);
            } else {
                svnDMPropertiesCacheMap.put(LAST_SYNCED_HEAD_REVISION, lastSyncedHeadRevision);
            }
        }
    }

    public static void clearlastAddedObjectsFileHEADRevDoc() {
        lastAddedObjectsFileHEADRevDoc = null;
    }

    public static Document getlastAddedObjectsFileHEADRevDoc() {
        return lastAddedObjectsFileHEADRevDoc;
    }

    public static String extractObjectProperties(Document objectDoc) {
        Node firstChildNode;
        String properties = "";
        if (objectDoc != null && (firstChildNode = objectDoc.getFirstChild()) != null) {
            String objectName = firstChildNode.getAttributes().getNamedItem("name").getTextContent();
            String objectId = firstChildNode.getAttributes().getNamedItem("id").getTextContent();
            String objectClass = firstChildNode.getAttributes().getNamedItem("class").getTextContent();
            properties = objectId + ":::" + objectClass + "::::::::::::" + objectName;
        }
        return properties;
    }

    public static String extractObjectProperties(String objectDesc, Design design, String parentObjectShortID) {
        String properties = null;
        if (objectDesc != null) {
            String ID_ID = "id=\"";
            String UDP_PROPERTY_OBJECT_CLS = "class=\"";
            String NAME = "name=\"";
            String objectName = SVNDMPropertiesManager.findValueForAKey(objectDesc, NAME);
            String objectId = SVNDMPropertiesManager.findValueForAKey(objectDesc, ID_ID);
            String objectClass = SVNDMPropertiesManager.findValueForAKey(objectDesc, UDP_PROPERTY_OBJECT_CLS);
            properties = objectId + ":::" + objectClass + "::::::::::::" + objectName;
            SVNDMPropertiesManager.addObjPropsToDesignSVNDMPropertiesCacheAndDoc(design, objectId, parentObjectShortID, properties);
        }
        return properties;
    }

    private static void addObjPropsToDesignSVNDMPropertiesCacheAndDoc(Design design, String objectId, String parentObjectShortID, String properties) {
        Map<String, String> svnDMPropertiesCache = design.getSVNDMPropertiesCache();
        String objectClass = SVNClientHelper.getInstance().getProperty(properties, 1);
        boolean physDesign = XMLTransformationManager.isPhysicalDesign(design, objectClass, objectId);
        if (objectClass.equals(RelationalDesign.class.getName()) || physDesign) {
            String shortId;
            objectId = shortId = objectId.substring(0, objectId.indexOf("-")) + objectId.substring(objectId.lastIndexOf("-"));
        }
        if (svnDMPropertiesCache.get(objectId + parentObjectShortID) == null) {
            design.setAllAddedObjectsFileDocChanged(true);
            svnDMPropertiesCache.put(objectId + parentObjectShortID, properties);
        }
    }

    private static String findValueForAKey(String source, String key) {
        String w = source.substring(source.indexOf(key) + key.length());
        return w.substring(0, w.indexOf("\""));
    }

    public static String extractObjectPropertiesFromLocalFile(Design design, File file) {
        if ("subviews".equalsIgnoreCase(file.getParentFile().getName())) {
            return SVNDMPropertiesManager.extractObjectPropertiesFromLocalDiagramsFile(design, file);
        }
        String properties = "";
        File localFile = file;
        File parentFile = file;
        String objID = file.getName();
        int dotIndex = objID.lastIndexOf(".");
        if (dotIndex > 0) {
            objID = objID.substring(0, dotIndex);
        }
        while (parentFile != null) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                localFile = null;
                break;
            }
            if (!parentFile.isDirectory() || !(localFile = new File(parentFile.toString() + File.separator + "Objects.local")).exists()) continue;
        }
        if (localFile != null) {
            try {
                String fpath = localFile.getCanonicalPath();
                HashMap<String, String> map = design.getLocalObjectFilesMap().get(fpath);
                if (map == null) {
                    Document doc = null;
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(localFile), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                    if (doc != null) {
                        map = new HashMap<String, String>();
                        design.getLocalObjectFilesMap().put(fpath, map);
                        NodeList objectsList = doc.getElementsByTagName("object");
                        for (int i = 0; i < objectsList.getLength(); ++i) {
                            String name;
                            String tid;
                            String sid;
                            String parentid;
                            Element el;
                            String id;
                            Node object = objectsList.item(i);
                            if (!(object instanceof Element) || (id = (el = (Element)object).getAttribute("objectID")) == null || id.isEmpty()) continue;
                            String clname = el.getAttribute("propertyClassName");
                            if (clname == null) {
                                clname = "";
                            }
                            if ((parentid = el.getAttribute("propertyParentId")) == null) {
                                parentid = "";
                            }
                            if ((sid = el.getAttribute("propertySourceId")) == null) {
                                sid = "";
                            }
                            if ((tid = el.getAttribute("propertyTargetId")) == null) {
                                tid = "";
                            }
                            if ((name = el.getAttribute("name")) == null) {
                                name = "";
                            }
                            String prop = id + ":::" + clname + ":::" + parentid + ":::" + sid + ":::" + tid + ":::" + name;
                            map.put(id, prop);
                        }
                    }
                }
                if (map != null) {
                    properties = (String)map.get(objID);
                }
            }
            catch (Exception e) {
                LOGGER.error("Can not extract object properties: " + file.toString(), e);
            }
        }
        return properties;
    }

    public static String extractObjectPropertiesFromLocalDiagramsFile(Design design, File file) {
        String properties = "";
        File localFile = file;
        File parentFile = file;
        String objID = file.getName();
        int dotIndex = objID.lastIndexOf(".");
        if (dotIndex > 0) {
            objID = objID.substring(0, dotIndex);
        }
        if (!"subviews".equalsIgnoreCase(file.getParentFile().getName())) {
            return "";
        }
        while (parentFile != null) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                localFile = null;
                break;
            }
            if (!parentFile.isDirectory() || !(localFile = new File(parentFile.toString() + File.separator + "Diagrams.local")).exists()) continue;
        }
        if (localFile != null) {
            try {
                String fpath = localFile.getCanonicalPath();
                HashMap<String, String> map = design.getLocalObjectFilesMap().get(fpath);
                if (map == null) {
                    Document doc = null;
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(localFile), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                    if (doc != null) {
                        map = new HashMap<String, String>();
                        design.getLocalObjectFilesMap().put(fpath, map);
                        NodeList objectsList = doc.getElementsByTagName("object");
                        String clname = "";
                        String parentid = "";
                        String modelid = localFile.getParentFile().getName();
                        ModelIDObject par = design.getModelByIdName(modelid);
                        if (par != null) {
                            clname = par.getClass().getName();
                            parentid = par.getObjectID();
                        }
                        for (int i = 0; i < objectsList.getLength(); ++i) {
                            Element el;
                            String id;
                            Node object = objectsList.item(i);
                            if (!(object instanceof Element) || (id = (el = (Element)object).getAttribute("objectID")) == null || id.isEmpty()) continue;
                            if (clname == null) {
                                clname = "";
                            }
                            if (parentid == null) {
                                parentid = "";
                            }
                            String sid = "";
                            String tid = "";
                            String name = el.getAttribute("name");
                            if (name == null) {
                                name = "";
                            }
                            String prop = id + ":::" + clname + ":::" + parentid + ":::" + sid + ":::" + tid + ":::" + name;
                            map.put(id, prop);
                        }
                    }
                }
                if (map != null) {
                    properties = (String)map.get(objID);
                }
            }
            catch (Exception e) {
                LOGGER.error("Can not extract object properties: " + file.toString(), e);
            }
        }
        return properties;
    }

    static {
        LOGGER = new Logger(SVNDMPropertiesManager.class);
    }
}

