/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRPartitionListColumnsTypeOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "D641DC9A-8E7D-1E68-2D0F-366BA58C139E";
    private static final String[] DATA_TYPE = new String[]{"ROWID", "UROWID", "LONG", "BLOB", "CLOB", "NCLOB", "BFILES"};
    private static Set dataTypeSet = null;

    public DRPartitionListColumnsTypeOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRPartitionListColumnsTypeOracle.CheckPartitionListColumnsType"));
        this.setDescription(Messages.getString("DRPartitionListColumnsTypeOracle.DataTypeCanNotBe"));
    }

    public static String[] getDataTypes() {
        return DATA_TYPE;
    }

    private boolean checkDataType(String value) {
        if (dataTypeSet == null) {
            dataTypeSet = new HashSet();
            dataTypeSet.addAll(Arrays.asList(DRPartitionListColumnsTypeOracle.getDataTypes()));
        }
        return dataTypeSet.contains(value);
    }

    private ColumnProxyOracle getColumn(String columnName, PartitionListOracle partitionList) {
        ColumnProxy[] columnProxies = partitionList.getTable().getColumnProxies();
        String tableName = partitionList.getTable().getName();
        String longColumnName = new StringBuffer(tableName).append('.').append(columnName).toString();
        for (int i = 0; i < columnProxies.length; ++i) {
            ColumnProxy column = columnProxies[i];
            if (!longColumnName.equalsIgnoreCase(column.getLongName())) continue;
            return (ColumnProxyOracle)column;
        }
        return null;
    }

    @Override
    public CheckResult doCheck(Object object) {
        PartitionListOracle partitionList = (PartitionListOracle)object;
        StringTokenizer st = new StringTokenizer(partitionList.getColumnList(), ",");
        StringBuffer wrongColumns = new StringBuffer();
        if (st.hasMoreTokens()) {
            while (st.hasMoreTokens()) {
                String columnName = st.nextToken().trim();
                ColumnProxyOracle column = this.getColumn(columnName, partitionList);
                if (column == null || !this.checkDataType(column.getDataType().getName())) continue;
                wrongColumns.append(columnName).append(':').append(column.getDataType()).append(' ');
            }
            if (!"".equalsIgnoreCase(wrongColumns.toString())) {
                return CheckResult.createFailed(object, this, new StringBuffer(Messages.getString("DRPartitionListColumnsTypeOracle.PartitionListContainsColumnsWithWrongDataType")).append("(").append(wrongColumns).append(").").toString());
            }
            return CheckResult.createOk(object, this, this.getDescription());
        }
        return CheckResult.createOk(object, this, Messages.getString("DRPartitionListColumnsTypeOracle.PartitionListDoesNotContainsAnyColumns"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "D641DC9A-8E7D-1E68-2D0F-366BA58C139E";
    }
}

