/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRIndexProxySetLocalIndexOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "56E560E5-B451-BC5B-355B-9D69307AA4D9";

    public DRIndexProxySetLocalIndexOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRIndexProxySetLocalIndexOracle.SetLocalIndex"));
        this.setDescription(Messages.getString("DRIndexProxySetLocalIndexOracle.IndexLocalTableMustBePartitioned"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        IndexProxyOracle index = (IndexProxyOracle)object;
        if ("LOCAL".equalsIgnoreCase(index.getIndexPartitioned())) {
            if ("Yes".equalsIgnoreCase(((TableProxyOracle)index.getTableProxy()).getPartitioned())) {
                return CheckResult.createOk(object, this, this.getDescription());
            }
            return CheckResult.createFailed(object, this, Messages.getString("DRIndexProxySetLocalIndexOracle.TableMustBePartitioned"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRIndexProxySetLocalIndexOracle.IndexNotLOCALSpecified"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "56E560E5-B451-BC5B-355B-9D69307AA4D9";
    }
}

