/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRPrimaryKeyNamingStandard
extends DesignRule {
    private final String RULE_ID = "579BA374-4A07-4FC1-DDE9-F01D46886788";
    private NamingStandardRule namingRule;
    private String tableName = "";
    private String tableAbbr = "";
    private String modelName = "";

    public DRPrimaryKeyNamingStandard() {
        this.setName(Messages.getString("DRPrimaryKeyNamingStandard.IdentifyPKWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRPrimaryKeyNamingStandard.PKWithWrongNamingStandardsNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Index index = (Index)object;
        if (index.isPK()) {
            Table table = index.getTable();
            this.namingRule = table.getDesign().getDesignLevelSettings().getNamingStandardRule();
            String result = this.namingRule.getPkConstr();
            this.tableName = table.getName();
            this.tableAbbr = table.getAbbreviation();
            result = ApplyNamingStandards.createPK_Name(this.tableName, table.getDesign().getDesignLevelSettings().getNamingStandardRule(), table.getDesignPart().getName(), this.tableAbbr);
            if (index.getElements().length > 0) {
                Column pkColumn = (Column)table.getPK().getElement(0);
                String columnName = pkColumn.getShortName();
                String columnAbbr = pkColumn.getAbbreviation();
                if (columnAbbr.equals("")) {
                    columnAbbr = columnName;
                }
                columnName = columnName.replaceAll("\\$", "\\\\\\$");
                result = result.replaceAll("\\{column\\}", columnName);
                columnAbbr = columnAbbr.replaceAll("\\$", "\\\\\\$");
                result = result.replaceAll("\\{column abbr\\}", columnAbbr);
                result = result.replaceAll("\\\\\\$", "\\$");
            }
            if (index.getName().equalsIgnoreCase(result)) {
                return CheckResult.createOk(index, this, Messages.getString("DRPrimaryKeyNamingStandard.PKNameIsInValidFormat"));
            }
            return CheckResult.createWarning(index, this, this.getDescription());
        }
        return CheckResult.createOk(index, this, Messages.getString("DRPrimaryKeyNamingStandard.PKNameIsInValidFormat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "579BA374-4A07-4FC1-DDE9-F01D46886788";
    }
}

