/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DRObjectMaxNameLength;

public class DRColumnMaxNameLength
extends DRObjectMaxNameLength {
    private final String RULE_ID = "406FA96D-BB54-55C6-0D47-69B21AF8268C";
    private NamingOptionsHolder holder;

    public DRColumnMaxNameLength() {
        this.setName(Messages.getString("DRColumnMaxNameLength.CheckForColumnMaximumNameLength"));
        this.setDescription(Messages.getString("DRColumnMaxNameLength.ColumnNameHasTooManyCharacters"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        int dot;
        DesignObject designObject = (DesignObject)object;
        String name = designObject.getName();
        if (designObject instanceof Column && ((Column)designObject).isNested() && (dot = name.lastIndexOf(46)) > -1) {
            name = name.substring(dot + 1);
        }
        if (name.length() > 0) {
            this.holder = designObject.getDesignPart().getNamingOptionsHolderFor(designObject.getClass().getName());
            if (this.holder.getMaxNameLength() > 0 && name.length() > this.holder.getMaxNameLength()) {
                return CheckResult.createFailed(designObject, this, new StringBuffer(MessageFormat.format(Messages.getString("DRColumnMaxNameLength.NameHasMoreThan"), this.holder.getMaxNameLength())).toString());
            }
        } else {
            return CheckResult.createFailed(designObject, this, Messages.getString("DRColumnMaxNameLength.ThereIsNoNameSpecified"));
        }
        return CheckResult.createOk(designObject, this, Messages.getString("DRColumnMaxNameLength.TheLengthOfTheNameIsOk"));
    }

    @Override
    public String getRuleId() {
        return "406FA96D-BB54-55C6-0D47-69B21AF8268C";
    }
}

