/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.logical.DREntity;

public class DREntityNoAttribute
extends DREntity {
    private final String RULE_ID = "ACB60AC9-1649-4021-009C-AA019E6E3228";

    public DREntityNoAttribute() {
        this.setName(Messages.getString("DREntityNoAttribute.IdentifyEntitiesWithoutAttributes"));
        this.setDescription(Messages.getString("DREntityNoAttribute.EntitiesWithoutAttributesAreNotAllowed"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Entity entity = (Entity)object;
        this.setEntityToCheck(entity);
        Entity entityToCheck = this.getEntityToCheck();
        if (entity.size() > 0) {
            this.clearEntityToCheck();
            return CheckResult.createOk(entityToCheck, this, Messages.getString("DREntityNoAttribute.EntityHasAtLeastOneAttribute"));
        }
        Entity superEntity = entity.getHierarchicalParent();
        if (superEntity != null) {
            return this.doCheck(superEntity);
        }
        this.clearEntityToCheck();
        return CheckResult.createFailed(entityToCheck, this, this.getDescription());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "ACB60AC9-1649-4021-009C-AA019E6E3228";
    }
}

