/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.domains;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRDomainNamingStandard
extends DesignRule
implements NamingConstants {
    private final String RULE_ID = "11C997DB-7967-6159-2D54-B7ACB29F4585";
    private NamingStandardRule namingRule;

    public DRDomainNamingStandard() {
        this.setName(Messages.getString("DRDomainNamingStandard.IdentifyDomainsWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRDomainNamingStandard.WrongNamingAtandardsNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Domain domain = (Domain)object;
        this.namingRule = domain.getDesign().getDesignLevelSettings().getNamingStandardRule();
        Iterator it = this.namingRule.getGlossaries().iterator();
        String errors = "";
        char logSep = this.namingRule.getLogicalSeparatorChar();
        boolean titleCaseSep = "Title Case".equalsIgnoreCase(this.namingRule.getLogicalSep());
        while (it.hasNext()) {
            Glossary glossary = (Glossary)it.next();
            String error = glossary.checkValidName(domain.getName(), this.namingRule.getDomainsList(), logSep, titleCaseSep, false, false, false);
            if (error == null) {
                return CheckResult.createOk(domain, this, Messages.getString("DRDomainNamingStandard.DomainNameIsInValidFormat"));
            }
            if (errors.length() == 0) {
                errors = error;
                continue;
            }
            errors = errors + ". " + error;
        }
        return CheckResult.createOk(domain, this, Messages.getString("DRDomainNamingStandard.DomainNameIsInValidFormat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "11C997DB-7967-6159-2D54-B7ACB29F4585";
    }
}

