/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.util.regex.Pattern;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRObjectValidCharacters
extends DesignRule {
    private final String RULE_ID = "FAA62A9E-6C0F-6504-C2E5-498B495F40A0";
    private NamingOptionsHolder holder;

    public DRObjectValidCharacters() {
        this.setName(Messages.getString("DRObjectValidCharacters.IdentifyObjectNamesWithInvalidCharacters"));
        this.setDescription(Messages.getString("DRObjectValidCharacters.ObjectNameHaInvalidCharacters"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        return this.doCheck(object, object.getClass(), null);
    }

    public CheckResult doCheck(Object object, Class namingOptionsHolderClass, String subName) {
        DesignObject designObject = (DesignObject)object;
        String name = subName != null ? subName : designObject.getName();
        this.holder = designObject.getDesignPart().getNamingOptionsHolderFor(namingOptionsHolderClass.getName());
        if (!this.holder.getIsValid() && !Pattern.matches("[" + this.holder.getValidChars() + "]*", name)) {
            return CheckResult.createFailed(designObject, this, Messages.getString("DRObjectValidCharacters.NameHasInvalidCharacters"));
        }
        return CheckResult.createOk(designObject, this, Messages.getString("DRObjectValidCharacters.TheNameIsValid"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "FAA62A9E-6C0F-6504-C2E5-498B495F40A0";
    }
}

