/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.model.design.undo.relational.FKUpdateEdit;
import oracle.dbtools.crest.model.design.undo.relational.IndexColumnPreserver;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.swingui.DesignPartView;

public class IndexUpdateEdit
extends UpdateDO_Edit {
    private IndexMemento oldmem;
    private IndexMemento newmem;
    private Index index;
    private boolean first = true;
    private List fkedits = new ArrayList();
    private List newColumns = new ArrayList();
    private List toremoveCols = new ArrayList();
    private List preservers = new ArrayList();
    private List columns = new ArrayList();
    private Table table;
    private String index_id;

    public IndexUpdateEdit(Index index, IndexMemento mem) {
        super(index);
        this.index = index;
        DesignPartView dpv = index.getDesignPart().getMainView();
        this.oldmem = (IndexMemento)index.getIndexMemento();
        this.newmem = new IndexMemento(index);
        mem.copyto(this.newmem);
        this.index_id = index.getObjectID();
        for (Column col : index.getElementsCollection()) {
            IndexMemento.ColWr cwr = this.getColWr(mem.columns, col.getObjectID());
            if (cwr == null) {
                this.toremoveCols.add(col.getObjectID());
                IndexColumnPreserver ip = new IndexColumnPreserver(index, col);
                this.preservers.add(ip);
            }
            IndexMemento.ColWr nwr = new IndexMemento.ColWr(mem);
            nwr.col_id = col.getObjectID();
            nwr.sort_order = index.getColumnSortOrder(col);
        }
        for (IndexMemento.ColWr cwr : mem.columns) {
            this.columns.add(cwr);
            Column col = (Column)index.getElementByID(cwr.col_id);
            if (col != null) continue;
            this.newColumns.add(cwr);
        }
        this.table = (Table)index.getContainerWithKeyObject();
        if (!index.isPK() && "Primary Constraint".equalsIgnoreCase(mem.index_state) && index.hasColumnInOptionalFK()) {
            for (IndexMemento.ColWr wr : mem.columns) {
                Column column = (Column)this.table.getElementByID(wr.col_id);
                if (column == null) continue;
                for (FKIndexAssociation fk : column.getAllFKs()) {
                    if (fk.isMandatory()) continue;
                    FKIndexAssociation.FKMemento fmem = fk.getFKMemento(dpv);
                    fmem.mandatory = true;
                    FKUpdateEdit edit = new FKUpdateEdit(fk, fmem);
                    edit.end();
                    this.fkedits.add(edit);
                }
            }
        }
    }

    @Override
    public void applyUpdates() {
        Column col;
        Index nindex = null;
        if (this.index_id != null) {
            nindex = (Index)this.table.getKeySet().getObjectByID(this.index_id);
        }
        if (nindex != null) {
            this.index = nindex;
        }
        for (String id : this.toremoveCols) {
            col = (Column)this.index.getElementByID(id);
            if (col == null) continue;
            this.index.remove(col);
        }
        for (IndexMemento.ColWr wr : this.newColumns) {
            col = (Column)this.table.getElementByID(wr.col_id);
            if (col == null) continue;
            this.index.add(col);
            this.index.setColumnSortOrder(col, wr.sort_order);
        }
        if (this.index != null) {
            this.index.restoreFromMemento(this.newmem);
        }
        for (FKUpdateEdit edit : this.fkedits) {
            if (this.first) {
                edit.applyUpdates();
                continue;
            }
            edit.redo();
        }
        this.first = false;
    }

    @Override
    protected void restoreObject() {
        Index nindex = (Index)this.table.getKeySet().getObjectByID(this.index_id);
        if (nindex != null) {
            this.index = nindex;
        }
        for (IndexMemento.ColWr wr : this.newColumns) {
            Column col = (Column)this.index.getElementByID(wr.col_id);
            if (col == null) continue;
            this.index.remove(col);
        }
        for (IndexColumnPreserver ip : this.preservers) {
            ip.restore();
        }
        this.index.restoreFromMemento(this.oldmem);
        for (FKUpdateEdit edit : this.fkedits) {
            edit.undo();
        }
    }

    private IndexMemento.ColWr getColWr(List list, String id) {
        for (IndexMemento.ColWr wr : list) {
            if (!wr.col_id.equals(id)) continue;
            return wr;
        }
        return null;
    }
}

