/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.text.MessageFormat;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.NoteRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.ColumnRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKArcRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.IndexRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableViewRemoveEdit;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class RemoveDO_Edit
extends DesignObjectEdit {
    private static final Logger LOGGER = new Logger(RemoveDO_Edit.class);
    private DesignObject designObject;

    public RemoveDO_Edit(DesignObject designObject) {
        this.designObject = designObject;
    }

    protected abstract void restoreObject();

    protected abstract void removeObject();

    @Override
    public String getRedoPresentationName() {
        return MessageFormat.format(Messages.getString("RemoveDO_Edit.RedoRemove"), this.designObject.getLongName());
    }

    @Override
    public String getUndoPresentationName() {
        return MessageFormat.format(Messages.getString("RemoveDO_Edit.UndoRemove"), this.designObject.getLongName());
    }

    @Override
    public void redo() throws CannotRedoException {
        try {
            super.redo();
            this.removeObject();
        }
        catch (Exception e) {
            LOGGER.error("Error in RemoveDO_Edit.redo \n" + this.getUndoPresentationName() + "\n" + e.getMessage());
        }
    }

    @Override
    public void undo() {
        try {
            DesignObjectEdit.UNDOABLE_ADD = true;
            super.undo();
            this.restoreObject();
        }
        catch (Exception e) {
            LOGGER.error("Error in RemoveDO_Edit.undo \n" + this.getUndoPresentationName() + "\n" + e.getMessage());
        }
        finally {
            DesignObjectEdit.UNDOABLE_ADD = false;
        }
    }

    public static void addUndoableRemoveEditForObject(CompoundEdit target, DesignObject object) {
        RemoveDO_Edit edit = null;
        if (object instanceof Note) {
            edit = new NoteRemoveEdit((Note)object);
        } else if (object instanceof Table) {
            edit = new TableRemoveEdit((Table)object);
        } else if (object instanceof TableView) {
            edit = new TableViewRemoveEdit((TableView)object);
        } else if (object instanceof FKIndexAssociation) {
            edit = new FKRemoveEdit((FKIndexAssociation)object);
        } else if (object instanceof Column) {
            edit = new ColumnRemoveEdit((Column)object);
        } else if (object instanceof Index) {
            edit = new IndexRemoveEdit((Index)object);
        } else if (object instanceof FKArc) {
            edit = new FKArcRemoveEdit((FKArc)object);
        }
        if (edit != null) {
            if (edit instanceof CompoundEdit) {
                ((CompoundEdit)edit).end();
            }
            target.addEdit(edit);
        }
    }
}

