/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;

public class FormatTV_Edit
extends UpdateDO_Edit {
    Object[] topViews;
    Object[] initialViews;
    List dpvs = new ArrayList();
    List savedItems = new ArrayList();
    List fonts;
    boolean useCustomFormat;
    boolean useDefault;
    Color bgColor;
    Color fgColor;
    boolean noBackgroundColor;
    boolean noForegroundColor;

    public FormatTV_Edit(Object[] topViews, boolean useCustomFormat, boolean useDefault, Color bgColor, Color fgColor, List fonts, boolean noBackgroundColor, boolean noForegroundColor) {
        super(((TopView)topViews[0]).getModel());
        this.initialViews = topViews;
        if (!useCustomFormat) {
            this.topViews = this.getAllTopViews(topViews);
        } else {
            this.topViews = topViews;
            if (topViews.length > 0) {
                this.dpvs.add(((TopView)topViews[0]).getDesignPartView());
            }
        }
        this.fonts = fonts;
        this.useCustomFormat = useCustomFormat;
        this.useDefault = useDefault;
        this.bgColor = bgColor;
        this.fgColor = fgColor;
        this.noBackgroundColor = noBackgroundColor;
        this.noForegroundColor = noForegroundColor;
        this.saveState();
    }

    public Object[] getTopViews() {
        return this.topViews;
    }

    @Override
    public String getRedoPresentationName() {
        if (this.initialViews.length > 1) {
            return "Redo Format Group Of Objects";
        }
        if (this.initialViews.length == 1) {
            TopView tv = (TopView)this.initialViews[0];
            return "Redo Format " + tv.toString();
        }
        return "Redo Format";
    }

    @Override
    public String getUndoPresentationName() {
        if (this.initialViews.length > 1) {
            return "Undo Format Group of Objects";
        }
        if (this.initialViews.length == 1) {
            TopView tv = (TopView)this.initialViews[0];
            return "Undo Format " + tv.toString();
        }
        return "Undo Format";
    }

    @Override
    public void applyUpdates() {
        TopView topView;
        int i;
        if (this.useDefault) {
            for (i = 0; i < this.topViews.length; ++i) {
                topView = (TopView)this.topViews[i];
                topView.setUseCustomFormat(false);
                topView.setUseDefaultColor(true);
                topView.setBackgroundColor(null);
                topView.setForegroundColor(null);
                topView.setNoBackgroundColor(this.noBackgroundColor);
                topView.setNoForegroundColor(this.noForegroundColor);
                topView.getEditableFonts().clear();
            }
        } else {
            for (i = 0; i < this.topViews.length; ++i) {
                topView = (TopView)this.topViews[i];
                topView.setUseCustomFormat(true);
                topView.setUseDefaultColor(false);
                topView.setBackgroundColor(this.bgColor);
                topView.setForegroundColor(this.fgColor);
                topView.setNoBackgroundColor(this.noBackgroundColor);
                topView.setNoForegroundColor(this.noForegroundColor);
            }
            if (this.fonts.size() > 0) {
                for (i = 0; i < this.topViews.length; ++i) {
                    topView = (TopView)this.topViews[i];
                    topView.getEditableFonts().clear();
                    if (!(topView.getModel() instanceof EditableFonts)) continue;
                    for (FontObject next : this.fonts) {
                        topView.getEditableFonts().add(next.copy());
                    }
                }
            }
        }
        if (this.topViews.length > 0) {
            for (DesignPartView dpv : this.dpvs) {
                dpv.repaint();
            }
        }
    }

    @Override
    protected void restoreObject() {
        for (TVWrap wr : this.savedItems) {
            if (wr.useDefault) {
                wr.tv.setUseCustomFormat(wr.useCustomFormat);
                wr.tv.setUseDefaultColor(true);
                wr.tv.setBackgroundColor(null);
                wr.tv.setForegroundColor(null);
                wr.tv.setNoBackgroundColor(true);
                wr.tv.setNoForegroundColor(true);
            } else {
                wr.tv.setUseCustomFormat(wr.useCustomFormat);
                wr.tv.setUseDefaultColor(false);
                wr.tv.setBackgroundColor(wr.bgColor);
                wr.tv.setForegroundColor(wr.fgColor);
                wr.tv.setNoBackgroundColor(wr.noBackground);
                wr.tv.setNoForegroundColor(wr.noBorder);
            }
            if (!(wr.tv.getModel() instanceof EditableFonts)) continue;
            this.restoreFonts(wr.tv, wr.fonts);
        }
        if (this.topViews.length > 0) {
            for (DesignPartView dpv : this.dpvs) {
                dpv.repaint();
            }
        }
    }

    private void saveState() {
        for (int i = 0; i < this.topViews.length; ++i) {
            TopView topView = (TopView)this.topViews[i];
            TVWrap wr = new TVWrap();
            wr.useCustomFormat = topView.useCustomFormat();
            wr.useDefault = topView.useDefaultColor();
            wr.bgColor = topView.getBackgroundColor();
            wr.fgColor = topView.getForegroundColor();
            wr.noBackground = topView.getNoBackgroundColor();
            wr.noBorder = topView.getNoForegroundColor();
            wr.tv = topView;
            if (topView.getModel() instanceof EditableFonts) {
                this.saveFonts(topView, wr.fonts);
            }
            this.savedItems.add(wr);
        }
    }

    private Object[] getAllTopViews(Object[] tviews) {
        ArrayList<TopView> list = new ArrayList<TopView>();
        for (int i = 0; i < tviews.length; ++i) {
            TopView topView = (TopView)tviews[i];
            DesignObject dobj = topView.getModel();
            if (dobj instanceof MultiShapedDesignObject) {
                list.addAll(((MultiShapedDesignObject)dobj).getAllTopViews());
                continue;
            }
            list.add(topView);
        }
        for (TopView topView : list) {
            if (this.dpvs.contains(topView.getDesignPartView())) continue;
            this.dpvs.add(topView.getDesignPartView());
        }
        return list.toArray();
    }

    class TVWrap {
        TopView tv;
        boolean useCustomFormat;
        boolean useDefault;
        Color bgColor;
        Color fgColor;
        boolean noBackground;
        boolean noBorder;
        List fonts = new ArrayList();

        TVWrap() {
        }
    }
}

