/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.text.MessageFormat;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.ImageCreateEdit;
import oracle.dbtools.crest.model.design.undo.NoteCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKArcCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableViewCreateEdit;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class CreateDO_Edit
extends DesignObjectEdit {
    private static final Logger LOGGER = new Logger(CreateDO_Edit.class);
    private DesignObject designObject;

    public CreateDO_Edit(DesignObject designObject) {
        this.designObject = designObject;
    }

    protected abstract void restoreObject();

    protected abstract void removeObject();

    @Override
    public String getRedoPresentationName() {
        return MessageFormat.format(Messages.getString("CreateDO_Edit.RedoCreate"), this.designObject.getLongName());
    }

    @Override
    public String getUndoPresentationName() {
        return MessageFormat.format(Messages.getString("CreateDO_Edit.UndoCreate"), this.designObject.getLongName());
    }

    @Override
    public void redo() throws CannotRedoException {
        try {
            DesignObjectEdit.UNDOABLE_ADD = true;
            this.restoreObject();
            super.redo();
        }
        catch (Exception e) {
            LOGGER.error("Error in CreateDO_Edit.redo \n" + this.getUndoPresentationName() + "\n" + e.getMessage());
        }
        finally {
            DesignObjectEdit.UNDOABLE_ADD = false;
        }
    }

    @Override
    public void undo() {
        try {
            super.undo();
            this.removeObject();
        }
        catch (Exception e) {
            LOGGER.error("Error in CreateDO_Edit.undo \n" + this.getUndoPresentationName() + "\n" + e.getMessage());
        }
    }

    public static void addUndoableCreateEditForObject(CompoundEdit target, DesignObject object) {
        CreateDO_Edit edit = null;
        if (object instanceof ImageObject) {
            edit = new ImageCreateEdit((ImageObject)object);
        } else if (object instanceof Note) {
            edit = new NoteCreateEdit((Note)object);
        } else if (object instanceof Table) {
            edit = new TableCreateEdit((Table)object);
        } else if (object instanceof TableView) {
            edit = new TableViewCreateEdit((TableView)object);
        } else if (object instanceof FKIndexAssociation) {
            edit = new FKCreateEdit((FKIndexAssociation)object);
        } else if (!(object instanceof Column) && !(object instanceof Index) && object instanceof FKArc) {
            edit = new FKArcCreateEdit((FKArc)object);
        }
        if (edit != null) {
            if (edit instanceof CompoundEdit) {
                ((CompoundEdit)edit).end();
            }
            target.addEdit(edit);
        }
    }
}

