/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.MethodProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;

public class MethodProxyUDBv81
extends MethodProxyUDB {
    public static final String NO_SQL = "NO SQL";
    public static final String SQL = "SQL";
    public static final String FENCED_THREAD_SAFE = "FENCED THREAD SAFE";
    public static final String FENCED_NOT_THREAD_SAFE = "FENCED NOT THREAD SAFE";

    public MethodProxyUDBv81(Method method, StorageDesign storageDesign) {
        super(method, storageDesign);
    }

    public MethodProxyUDBv81(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public String[] getSQL_STATEMENT_TYPES() {
        return new String[]{"READS SQL DATA", "CONTAINS SQL", NO_SQL};
    }

    @Override
    public String[] getEXT_R_PARAMETER_STYLES() {
        return new String[]{"DB2GENERAL", SQL};
    }

    @Override
    public String[] getEXT_R_SAFENESS() {
        return new String[]{"FENCED", FENCED_THREAD_SAFE, FENCED_NOT_THREAD_SAFE, "NOT FENCED"};
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        MethodProxyUDBv81 method = null;
        MethodProxy stObject = ((StorageDesignUDBv81)targetDesign).getMethodProxySet().getByName(this.getName());
        if (stObject != null && !this.isRawObject()) {
            method = (MethodProxyUDBv81)stObject;
        }
        if (method != null) {
            method.setName(this.getName());
            method.setSpecificName(this.getSpecificName());
            method.setReturnValue(this.getReturnValue());
            method.setReturnSelfAsResult(this.getReturnSelfAsResult());
            method.setLanguage(this.getLanguage());
            method.setDeterministic(this.getDeterministic());
            method.setExternalAction(this.getExternalAction());
            method.setSqlStatementType(this.getSqlStatementType());
            method.setNullParametersTreatment(this.getNullParametersTreatment());
            method.setFederated(this.getFederated());
            method.setExt_R_ParameterStyle(this.getExt_R_ParameterStyle());
            method.setExt_R_Scratchpad(this.getExt_R_Scratchpad());
            method.setExt_R_Safeness(this.getExt_R_Safeness());
            method.setExt_R_FinalCall(this.getExt_R_FinalCall());
            method.setExt_R_ParallelInvocation(this.getExt_R_ParallelInvocation());
            method.setExt_R_DBInfo(this.getExt_R_DBInfo());
            method.setExt_R_Name(this.getExt_R_Name());
            method.setExt_R_TransformGroup(this.getExt_R_TransformGroup());
            method.setSqlMethodBody(this.getSqlMethodBody());
            method.setComment(this.getComment());
            method.setRawObject(false);
        }
    }
}

