/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.Arrays;
import java.util.List;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.BufferPoolPropertyDialogUDBv81;

public class BufferPoolUDBv81
extends BufferPoolUDB {
    public static final String YES = "YES";
    public static final String NO = "NO";
    private String createImmediate = "YES";
    private static final String[] YES_NO_CHOICES = new String[]{"YES", "NO"};
    private static final List YES_NO_LIST = Arrays.asList(YES_NO_CHOICES);

    private static final boolean checkYesNo(String value) {
        return YES_NO_LIST.contains(value);
    }

    public String getCreateImmediate() {
        return this.createImmediate;
    }

    public void setCreateImmediate(String createImmediate) {
        if (BufferPoolUDBv81.checkYesNo(createImmediate)) {
            this.createImmediate = createImmediate;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            BufferPoolPropertyDialogUDBv81 dialog = new BufferPoolPropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        BufferPoolUDBv81 bufferPool = null;
        StorageObject storageObject = (StorageObject)((StorageDesignUDBv81)targetDesign).getBufferPoolSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                bufferPool = (BufferPoolUDBv81)storageObject;
            }
        } else {
            bufferPool = (BufferPoolUDBv81)((StorageDesignUDBv81)targetDesign).getBufferPoolSet().createBufferPool();
        }
        if (bufferPool != null) {
            bufferPool.setName(this.getName());
            bufferPool.setCreateImmediate(this.getCreateImmediate());
            bufferPool.setSize(this.getSize());
            bufferPool.setNodesWithDiffSize(this.getNodesWithDiffSize());
            bufferPool.setPageSize(this.getPageSize());
            bufferPool.setExtendedStorage(this.getExtendedStorage());
            bufferPool.recreateScopeSet(this.getScopeSet().toString());
            bufferPool.setComment(this.getComment());
            bufferPool.setRawObject(false);
        }
    }

    protected static class SystemBufferPoolUDBv81
    extends BufferPoolUDBv81 {
        protected SystemBufferPoolUDBv81() {
        }

        @Override
        public boolean isSystemBufferPool() {
            return true;
        }
    }
}

