/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v71;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.SchemaUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;

public class TableViewProxyUDBv71
extends TableViewProxyUDB {
    public TableViewProxyUDBv71(TableView tableView, StorageDesign storageDesign) {
        super(tableView, storageDesign);
    }

    public TableViewProxyUDBv71(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableView view = (TableView)((StorageDesignUDBv71)targetDesign).getPhysicalDesign().getTableViewSet().getByName(this.getObject().getName());
        TableViewProxyUDBv71 viewProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignUDBv71)targetDesign).getTableViewProxySet().getProxy(view.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            viewProxy = (TableViewProxyUDBv71)storageObject;
        }
        if (viewProxy != null) {
            viewProxy.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv71 scheme = (SchemaUDBv71)((StorageDesignUDBv71)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (scheme == null) {
                    SchemaUDBv71 newScheme = (SchemaUDBv71)((StorageDesignUDBv71)targetDesign).getSchemaSet().createSchema();
                    newScheme.setName(this.getSchema().getName());
                    newScheme.setRawObject(true);
                    viewProxy.setSchema(newScheme);
                } else {
                    viewProxy.setSchema(scheme);
                }
            }
            viewProxy.setCheckOption(this.getCheckOption());
            viewProxy.setCheckOptionScope(this.getCheckOptionScope());
            viewProxy.setOidColumnName(this.getOidColumnName());
            viewProxy.setOidColumnUniqueness(this.isOidColumnUniqueness());
            viewProxy.setDefinition(this.getDefinition());
            viewProxy.setComment(this.getComment());
            viewProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            viewProxy.setRawObject(false);
        }
    }
}

