/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.TablePropertyDialogUDB;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyUDB
extends TableProxy
implements ModelObjectSetListener,
StorageObjectListener,
PropertiesPropagator {
    public static final String DATA_CAPTURE_NONE = "NONE";
    public static final String DATA_CAPTURE_CHANGES = "CHANGES";
    private static String[] availableDataCaptureValues = new String[]{"NONE", "CHANGES"};
    private OwnerUDB owner = null;
    private SchemaUDB schema = null;
    private String partitioningKey = "";
    private ColumnSet partitioningKeySet = null;
    private boolean partKeyHashing = false;
    private TableSpaceUDB tableSpace = null;
    private TableSpaceUDB indexInTableSpace = null;
    private TableSpaceUDB longInTableSpace = null;
    private boolean initialLogging = true;
    private String dataCapture = "NONE";
    private static Set dataCaptureSet = null;
    protected StorageObjectCollection fkeys;
    protected StorageObjectCollection triggers;
    private static Set yesNoSet = null;
    protected String summaryQuery = "NO";
    private boolean summaryQueryChanged = false;
    private boolean summaryQueryDefinitionChanged = false;
    protected String summaryQueryDefinition = "";
    protected String summaryMaintenance = SUMMARY_MAINTENANCE_STATES[0];
    protected String summaryStatus = SUMMARY_STATUS_STATES[0];
    protected String summaryRefreshOptions = SUMMARY_REFRESH_OPTIONS_STATES[0];
    protected String summaryQueryOptimization = SUMMARY_QUERY_OPTIMIZATION_STATES[0];
    protected String summaryIdentityColumn = SUMMARY_IDENTITY_COLUMN_STATES[0];
    protected String summaryCopyColumnDefaults = SUMMARY_COPY_COLUMN_DEFAULTS_STATES[0];
    protected String replicated = "NO";
    protected String federated = FEDERATED_STATES[0];
    public static final String[] SUMMARY_STATUS_STATES = new String[]{"MATERIALIZED QUERY", "DEFINITION ONLY"};
    private static Set summaryStatusSet = null;
    public static final String[] SUMMARY_MAINTENANCE_STATES = new String[]{"BY SYSTEM", "BY USER"};
    private static Set summaryMaintenanceSet = null;
    public static final String[] SUMMARY_REFRESH_OPTIONS_STATES = new String[]{"DEFERRED", "IMMEDIATE"};
    private static Set summaryRefreshOptionsSet = null;
    public static final String[] SUMMARY_QUERY_OPTIMIZATION_STATES = new String[]{"ENABLE", "DISABLE"};
    private static Set summaryQueryOptimizationSet = null;
    public static final String[] SUMMARY_IDENTITY_COLUMN_STATES = new String[]{"EXCLUDING", "INCLUDING"};
    private static Set summaryIdentityColumnSet = null;
    public static final String[] SUMMARY_COPY_COLUMN_DEFAULTS_STATES = new String[]{"NONE", "EXCLUDING", "INCLUDING"};
    private static Set summaryCopyColumnDefaultsSet = null;
    public static final String[] FEDERATED_STATES = new String[]{"NONE", "FEDERATED", "NOT FEDERATED"};
    private static Set federatedSet = null;
    private String hierarchyName = "";
    private List propertyWrapperList = null;
    protected StorageObjectCollection stagingTables;
    protected StorageObjectCollection tableCheckConstraints;

    public TableProxyUDB(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyOracle.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.addFKProxyFromDesign(((StorageDesignUDB)storageDesign).getFKProxySet());
        ((StorageDesignUDB)storageDesign).getFKProxySet().addSetListener(this);
        this.triggers = new StorageObjectCollection(((StorageDesignUDB)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableProxyUDB.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignUDB)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignUDB)storageDesign).getTriggerSet());
    }

    public TableProxyUDB(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyOracle.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.addFKProxyFromDesign(((StorageDesignUDB)storageDesign).getFKProxySet());
        ((StorageDesignUDB)storageDesign).getFKProxySet().addSetListener(this);
        this.triggers = new StorageObjectCollection(((StorageDesignUDB)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableProxyUDB.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignUDB)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignUDB)storageDesign).getTriggerSet());
    }

    public void setOwner(OwnerUDB owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public OwnerUDB getOwner() {
        return this.owner;
    }

    public void setSchema(SchemaUDB schema) {
        this.schema = schema;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    private void addColumn(String column) {
        String columnName = column.substring(column.lastIndexOf(46) + 1, column.length());
        if (!this.getColumnSet().contains(columnName)) {
            this.getColumnSet().add(columnName);
        }
    }

    protected void recreateColumnListSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    public String getPartitioningKey() {
        return this.partitioningKey;
    }

    public void setPartitioningKey(String partitioningKey) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnListSet(partitioningKey);
        } else {
            this.addColumn(partitioningKey);
        }
        this.partitioningKey = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public void setPartKeyHashing(boolean partKeyHashing) {
        this.partKeyHashing = partKeyHashing;
    }

    public boolean getPartKeyHashing() {
        return this.partKeyHashing;
    }

    public static String[] getAvailableDataCaptureValues() {
        return availableDataCaptureValues;
    }

    protected boolean checkDataCaptureValue(String value) {
        if (dataCaptureSet == null) {
            dataCaptureSet = new HashSet();
            dataCaptureSet.addAll(Arrays.asList(TableProxyUDB.getAvailableDataCaptureValues()));
        }
        return dataCaptureSet.contains(value);
    }

    public void setDataCapture(String dataCapture) {
        if (this.checkDataCaptureValue(dataCapture)) {
            this.dataCapture = dataCapture;
            this.fireDataFieldChange();
        }
    }

    public String getDataCapture() {
        return this.dataCapture;
    }

    public void setTableSpace(TableSpaceUDB tableSpace) {
        this.tableSpace = tableSpace;
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getTableSpace() {
        return this.tableSpace;
    }

    public void setIndexInTableSpace(TableSpaceUDB tableSpace) {
        this.indexInTableSpace = tableSpace;
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getIndexInTableSpace() {
        return this.indexInTableSpace;
    }

    public void setLongInTableSpace(TableSpaceUDB tableSpace) {
        this.longInTableSpace = tableSpace;
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getLongInTableSpace() {
        return this.longInTableSpace;
    }

    public void setInitialLogging(boolean initialLogging) {
        this.initialLogging = initialLogging;
    }

    public boolean getInitialLogging() {
        return this.initialLogging;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        Table table = (Table)this.getObject();
        SchemaObject so = table.getSchemaObject();
        if (so != null) {
            StorageObject user = ((StorageDesignUDB)this.getStorageDesign()).getSchemaSet().getBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public ColumnSet getColumnSet() {
        if (this.partitioningKeySet == null) {
            this.partitioningKeySet = new ColumnSet();
        }
        return this.partitioningKeySet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.partitioningKey = "";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogUDB dialog = new TablePropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 2;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == this.getNumberOfChildren() - 1) {
            return this.fkeys;
        }
        if (index == this.getNumberOfChildren() - 2) {
            return this.triggers;
        }
        return super.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.fkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (child == this.triggers) {
            return this.getNumberOfChildren() - 2;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.fkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (child == this.triggers) {
            return this.getNumberOfChildren() - 2;
        }
        return super.getIndexForChild(child);
    }

    protected void addTriggersFromDesign(StorageObjectSet set) {
        for (TriggerUDB trigger : set) {
            trigger.addObjectListener(this);
            if (trigger.getTable() != null && trigger.getTable() == this) {
                trigger.setParent(this.triggers);
                this.triggers.add(trigger);
                continue;
            }
            this.triggers.remove(trigger);
        }
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof ColumnProxy) {
                ColumnProxy cp = (ColumnProxy)event.getAffected();
                if (((Table)this.getObject()).getElementsCollection().contains(cp.getObject()) && this.getObject() == ((Column)cp.getObject()).getContainerWithKeyObject()) {
                    this.columns.add(event.getAffected());
                }
            } else if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                if (this.getObject() == ((Index)ip.getObject()).getContainerWithKeyObject()) {
                    if (((Index)ip.getObject()).isFK()) {
                        if (!this.fkeys.contains(ip)) {
                            ip.setParent(this.fkeys);
                            this.fkeys.add(event.getAffected());
                        }
                    } else if (!this.indexes.contains(ip)) {
                        ip.setParent(this.indexes);
                        this.indexes.add(event.getAffected());
                    }
                }
            } else if (event.getAffected() instanceof TriggerUDB) {
                TriggerUDB tr = (TriggerUDB)event.getAffected();
                tr.addObjectListener(this);
                if (tr.getTable() != null && tr.getTable() == this) {
                    tr.setParent(this.triggers);
                    this.triggers.add(tr);
                } else {
                    this.triggers.remove(tr);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof ColumnProxy) {
                this.columns.remove(((ColumnProxy)event.getAffected()).getObject().getObjectID());
            } else if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                if (this.indexes.contains(ip)) {
                    this.indexes.remove(event.getAffected());
                }
                if (this.fkeys.contains(ip)) {
                    this.fkeys.remove(event.getAffected());
                }
            } else if (event.getAffected() instanceof TriggerUDB) {
                TriggerUDB tr = (TriggerUDB)event.getAffected();
                this.triggers.remove(tr);
                tr.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof TriggerUDB) {
            TriggerUDB tr = (TriggerUDB)event.getAffected();
            if (tr.getTable() != null && tr.getTable() == this) {
                tr.setParent(this.triggers);
                this.triggers.add(tr);
            } else {
                this.triggers.remove(tr);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TriggerUDB) {
                TriggerUDB tr = (TriggerUDB)event.getAffected();
                tr.addObjectListener(this);
                if (tr.getTable() != null && tr.getTable() == this) {
                    tr.setParent(this.triggers);
                    this.triggers.add(tr);
                } else {
                    this.triggers.remove(tr);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof TriggerUDB) {
            TriggerUDB tr = (TriggerUDB)event.getAffected();
            this.triggers.remove(tr);
            tr.removeObjectListener(this);
        }
    }

    protected void addFKProxyFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            IndexProxy ip = (IndexProxy)it.next();
            if (this.getObject() != ((Index)ip.getObject()).getContainerWithKeyObject() || !((Index)ip.getObject()).isFK()) continue;
            ip.setParent(this.fkeys);
            this.fkeys.add(ip);
        }
    }

    public static String[] getSummaryStatusChoices() {
        return SUMMARY_STATUS_STATES;
    }

    protected boolean checkSummaryStatus(String value) {
        if (summaryStatusSet == null) {
            summaryStatusSet = new HashSet();
            summaryStatusSet.addAll(Arrays.asList(TableProxyUDB.getSummaryStatusChoices()));
        }
        return summaryStatusSet.contains(value);
    }

    public static String[] getSummaryRefreshOptionsChoices() {
        return SUMMARY_REFRESH_OPTIONS_STATES;
    }

    protected boolean checkSummaryRefreshOptions(String value) {
        if (summaryRefreshOptionsSet == null) {
            summaryRefreshOptionsSet = new HashSet();
            summaryRefreshOptionsSet.addAll(Arrays.asList(TableProxyUDB.getSummaryRefreshOptionsChoices()));
        }
        return summaryRefreshOptionsSet.contains(value);
    }

    public static String[] getSummaryQueryOptimizationChoices() {
        return SUMMARY_QUERY_OPTIMIZATION_STATES;
    }

    protected boolean checkSummaryQueryOptimization(String value) {
        if (summaryQueryOptimizationSet == null) {
            summaryQueryOptimizationSet = new HashSet();
            summaryQueryOptimizationSet.addAll(Arrays.asList(TableProxyUDB.getSummaryQueryOptimizationChoices()));
        }
        return summaryQueryOptimizationSet.contains(value);
    }

    public static String[] getSummaryIdentityColumnChoices() {
        return SUMMARY_IDENTITY_COLUMN_STATES;
    }

    protected boolean checkSummaryIdentityColumn(String value) {
        if (summaryIdentityColumnSet == null) {
            summaryIdentityColumnSet = new HashSet();
            summaryIdentityColumnSet.addAll(Arrays.asList(TableProxyUDB.getSummaryIdentityColumnChoices()));
        }
        return summaryIdentityColumnSet.contains(value);
    }

    public static String[] getSummaryColumnDefaultsChoices() {
        return SUMMARY_COPY_COLUMN_DEFAULTS_STATES;
    }

    protected boolean checkSummaryColumnDefaults(String value) {
        if (summaryCopyColumnDefaultsSet == null) {
            summaryCopyColumnDefaultsSet = new HashSet();
            summaryCopyColumnDefaultsSet.addAll(Arrays.asList(TableProxyUDB.getSummaryColumnDefaultsChoices()));
        }
        return summaryCopyColumnDefaultsSet.contains(value);
    }

    public static String[] getFederatedChoices() {
        return FEDERATED_STATES;
    }

    protected boolean checkFederated(String value) {
        if (federatedSet == null) {
            federatedSet = new HashSet();
            federatedSet.addAll(Arrays.asList(TableProxyUDB.getFederatedChoices()));
        }
        return federatedSet.contains(value);
    }

    public String getSummaryCopyColumnDefaults() {
        return this.summaryCopyColumnDefaults;
    }

    public void setSummaryCopyColumnDefaults(String summaryColumnDefaults) {
        if (this.checkSummaryColumnDefaults(summaryColumnDefaults)) {
            this.summaryCopyColumnDefaults = summaryColumnDefaults;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryIdentityColumn() {
        return this.summaryIdentityColumn;
    }

    public void setSummaryIdentityColumn(String summaryIdentityColumn) {
        if (this.checkSummaryIdentityColumn(summaryIdentityColumn)) {
            this.summaryIdentityColumn = summaryIdentityColumn;
            this.fireDataFieldChange();
        }
    }

    public boolean isSummaryQueryDefinitionChanged() {
        return this.summaryQueryDefinitionChanged;
    }

    public void setSummaryQueryDefinitionChanged(boolean summaryQueryDefinitionChanged) {
        this.summaryQueryDefinitionChanged = summaryQueryDefinitionChanged;
    }

    public String getSummaryQueryDefinition() {
        Table table;
        if (!this.summaryQueryDefinitionChanged && (table = (Table)this.getObject()) != null) {
            return table.getUserDefinedSQL();
        }
        return this.summaryQueryDefinition;
    }

    public void setSummaryQueryDefinition(String summaryQueryDefinition) {
        String tableSQL;
        Table table = (Table)this.getObject();
        String string = tableSQL = table != null ? table.getUserDefinedSQL() : "";
        if (summaryQueryDefinition.isEmpty() || summaryQueryDefinition.equals(tableSQL)) {
            this.summaryQueryDefinitionChanged = false;
        } else {
            this.summaryQueryDefinitionChanged = true;
            this.summaryQueryDefinition = summaryQueryDefinition;
        }
        this.fireDataFieldChange();
    }

    public String getSummaryRefreshOptions() {
        return this.summaryRefreshOptions;
    }

    public void setSummaryRefreshOptions(String summaryRefreshOptions) {
        if (this.checkSummaryRefreshOptions(summaryRefreshOptions)) {
            this.summaryRefreshOptions = summaryRefreshOptions;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryQueryOptimization() {
        return this.summaryQueryOptimization;
    }

    public void setSummaryQueryOptimization(String summaryQueryOptimization) {
        if (this.checkSummaryQueryOptimization(summaryQueryOptimization)) {
            this.summaryQueryOptimization = summaryQueryOptimization;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryStatus() {
        return this.summaryStatus;
    }

    public static String[] getSummaryMaintenanceChoices() {
        return SUMMARY_MAINTENANCE_STATES;
    }

    protected boolean checkSummaryMaintenance(String value) {
        if (summaryMaintenanceSet == null) {
            summaryMaintenanceSet = new HashSet();
            summaryMaintenanceSet.addAll(Arrays.asList(TableProxyUDB.getSummaryMaintenanceChoices()));
        }
        return summaryMaintenanceSet.contains(value);
    }

    public void setSummaryStatus(String summaryStatus) {
        if (this.checkSummaryStatus(summaryStatus)) {
            this.summaryStatus = summaryStatus;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryMaintenance() {
        return this.summaryMaintenance;
    }

    public void setSummaryMaintenance(String summaryMaintenance) {
        if (this.checkSummaryMaintenance(summaryMaintenance)) {
            this.summaryMaintenance = summaryMaintenance;
            this.fireDataFieldChange();
        }
    }

    public String getSummaryQuery() {
        if (!this.summaryQueryChanged) {
            Table table = (Table)this.getObject();
            return table.isMaterializedQueryTable() ? "YES" : "NO";
        }
        return this.summaryQuery;
    }

    public void setSummaryQuery(String summaryQuery) {
        if (this.checkYesNo(summaryQuery)) {
            this.summaryQuery = summaryQuery;
            boolean isMQTable = ((Table)this.getObject()).isMaterializedQueryTable();
            this.summaryQueryChanged = summaryQuery.equals("YES") ? !isMQTable : isMQTable;
            this.fireDataFieldChange();
        }
    }

    public boolean isSummaryQueryChanged() {
        return this.summaryQueryChanged;
    }

    public void setSummaryQueryChanged(boolean summaryQueryChanged) {
        this.summaryQueryChanged = summaryQueryChanged;
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(StorageObjectConstantsUDB.YES_NO));
        }
        return yesNoSet.contains(value);
    }

    public String getReplicated() {
        return this.replicated;
    }

    public void setReplicated(String replicated) {
        if (this.checkYesNo(replicated)) {
            this.replicated = replicated;
            this.fireDataFieldChange();
        }
    }

    public String getFederated() {
        return this.federated;
    }

    public void setFederated(String federated) {
        this.federated = federated;
        this.fireDataFieldChange();
    }

    public ColumnProxyUDB getColumn(String colName) {
        for (int i = 0; i < this.getColumnProxies().length; ++i) {
            if (!colName.equalsIgnoreCase(this.getColumnProxies()[i].getName())) continue;
            return (ColumnProxyUDB)this.getColumnProxies()[i];
        }
        return null;
    }

    @Override
    public StorageObject getUserSchema() {
        if (this.getSchema() != null) {
            return this.getSchema();
        }
        return this.getOwner();
    }

    public String getHierarchyName() {
        return this.hierarchyName;
    }

    public void setHierarchyName(String hierarchyName) {
        this.hierarchyName = hierarchyName;
    }

    public String getSuperTableName() {
        Table table = (Table)this.getObject();
        if (!table.isRoot() && table.getTypeSubstitution() != null) {
            return table.getTypeSubstitution().getParentContainerObject().getName();
        }
        return "";
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Part. Key Hashing", this, "getPartKeyHashing", "setPartKeyHashing", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Index TableSpace", this, "getIndexInTableSpace", "setIndexInTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Long TableSpace", this, "getLongInTableSpace", "setLongInTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Initial Logging", this, "getInitialLogging", "setInitialLogging", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Data Capture", this, "getDataCapture", "setDataCapture", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Federated", this, "getFederated", "setFederated", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Summary Query", this, "getSummaryQuery", "setSummaryQuery", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void remove() {
        Object[] trigs = this.triggers.toArray();
        for (int i = 0; i < trigs.length; ++i) {
            TriggerUDB trig = (TriggerUDB)trigs[i];
            trig.remove();
            trig.setTable(null);
            this.triggers.remove(trig);
        }
        super.remove();
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            if (this.tableCheckConstraints != null) {
                this.tableCheckConstraints.addAllElementsTo(list);
            }
            if (this.stagingTables != null) {
                this.stagingTables.addAllElementsTo(list);
            }
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    public StorageObjectCollection getFKeys() {
        return this.fkeys;
    }

    @Override
    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    public class ColumnSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

