/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public class IndexProxySetUDB
extends IndexProxySet
implements ObjectListener {
    public IndexProxySetUDB(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected void add(Index[] array) {
        for (int i = 0; i < array.length; ++i) {
            Index ind = array[i];
            if (ind.isPK() || ind.isUnique()) continue;
            this.add(ind);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isAdded()) {
            Index ind = (Index)event.getAffected();
            ind.addObjectListener(this);
            if (!ind.isPK() && !ind.isUnique()) {
                this.add(ind);
                this.fireUpdate();
            }
        } else if (event.isRemoved()) {
            Index ind = (Index)event.getAffected();
            ind.removeObjectListener(this);
            if (this.containsId(ind.getObjectID())) {
                this.remove((Index)event.getAffected());
                this.fireUpdate();
            }
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (object instanceof Index) {
            Index ind = (Index)object;
            if (event == ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE || event == ObjectChangeEvent.KEY_CHANGED_TO_PK) {
                if (ind.isPK() || ind.isUnique()) {
                    this.remove(ind);
                }
            } else if (!(event != ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE && event != ObjectChangeEvent.KEY_CHANGED_NO_PK || ind.isPK() || ind.isUnique())) {
                this.add(ind);
            }
        }
    }
}

