/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import javax.swing.Icon;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.IObjectWithBody;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.FunctionPropertyDialogUDB;

public class FunctionUDB
extends StorageObject
implements IObjectWithBody {
    public static final String TYPE_NAME = "Function";
    public static final String SPECIFIC = "SPECIFIC";
    protected OwnerUDB owner;
    protected SchemaUDB schema;
    protected String specificName = "";
    protected String body = "";

    public FunctionUDB(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FunctionPropertyDialogUDB dialog = new FunctionPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("FUNCTION_ICON", 16);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public OwnerUDB getOwner() {
        return this.owner;
    }

    public void setOwner(OwnerUDB owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public void setSchema(SchemaUDB schema) {
        this.schema = schema;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getSchema() != null) {
            name = this.getSchema().getName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    public String getSpecificName() {
        return this.specificName;
    }

    public void setSpecificName(String specificName) {
        this.specificName = specificName;
    }

    public String getSpecificNameFromBody(String body) {
        return Token.getQuotedNameAfterToken(body, SPECIFIC).trim();
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public void setBody(String body) {
        this.body = body;
    }
}

