/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.AliasPropertyDialogUDB;

public class AliasUDB
extends AbstractStorageObjectDB2 {
    private StorageObject referencedObject;
    private SchemaUDB schema = null;
    public static final String TYPE_NAME = "Alias";

    @Override
    public String getIDPrefix() {
        return "AL";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setSchema(SchemaUDB schema) {
        this.schema = schema;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    protected boolean checkReferencedObject(StorageObject referencedObject) {
        if (referencedObject instanceof TableProxyUDB) {
            return true;
        }
        if (referencedObject instanceof TableViewProxyUDB) {
            return true;
        }
        return referencedObject instanceof AliasUDB && (AliasUDB)referencedObject != this;
    }

    public boolean isAliasReference() {
        return this.getReferencedObject() instanceof AliasUDB;
    }

    public boolean isTableProxyReference() {
        return this.referencedObject instanceof TableProxyUDB;
    }

    public boolean isTableViewProxyReference() {
        return this.referencedObject instanceof TableViewProxyUDB;
    }

    public void setReferencedObject(StorageObject referencedObject) {
        if (this.checkReferencedObject(referencedObject)) {
            this.referencedObject = referencedObject;
            this.fireDataFieldChange();
        }
    }

    public StorageObject getReferencedObject() {
        return this.referencedObject;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getSchema() != null) {
            name = this.getSchema().getName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AliasPropertyDialogUDB dialog = new AliasPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("ALIAS_ICON", 16);
    }
}

