/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import javax.swing.Icon;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.SynonymPropertyDialogSqlServer;

public class SynonymSqlServer
extends AbstractStorageObjectSqlServer {
    private SchemaSqlServer schema;
    private TableProxySqlServer table;
    private TableViewProxySqlServer view;
    private StoredProcedureSqlServer procedure;
    public static final String TYPE_NAME = "Synonym";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "SYN";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SynonymPropertyDialogSqlServer dialog = new SynonymPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public TableProxySqlServer getTable() {
        return this.table;
    }

    public void setTable(TableProxySqlServer table) {
        if (table != null) {
            this.table = table;
            this.view = null;
            this.procedure = null;
            this.setPAC_Element(table);
            this.fireDataFieldChange();
        }
    }

    public TableViewProxySqlServer getView() {
        return this.view;
    }

    public void setView(TableViewProxySqlServer view) {
        if (view != null) {
            this.view = view;
            this.table = null;
            this.procedure = null;
            this.setPAC_Element(view);
            this.fireDataFieldChange();
        }
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            if (this.getTable() != null) {
                return this.getTable().isDropEnabled() || this.getTable().shouldBeDroppedIndirectly();
            }
            if (this.getView() != null) {
                return this.getView().isDropEnabled() || this.getView().shouldBeDroppedIndirectly();
            }
        }
        return false;
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer owner) {
        this.schema = owner;
    }

    public StoredProcedureSqlServer getProcedure() {
        return this.procedure;
    }

    public void setProcedure(StoredProcedureSqlServer procedure) {
        if (procedure != null) {
            this.procedure = procedure;
            this.table = null;
            this.view = null;
            this.setPAC_Element(procedure);
            this.fireDataFieldChange();
        }
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        if (this.getTable() != null) {
            return this.getTable().getDatabase();
        }
        if (this.getProcedure() != null) {
            return this.getProcedure().getDatabase();
        }
        if (this.getView() != null) {
            return this.getView().getDataBase();
        }
        return null;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        SynonymSqlServer synonym = null;
        StorageObject stObject = (StorageObject)((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                synonym = (SynonymSqlServer)stObject;
            }
        } else {
            synonym = ((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet().createSynonym();
        }
        if (synonym != null) {
            synonym.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaSqlServerv2k5 targetSchema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (targetSchema == null) {
                    SchemaSqlServerv2k5 newSchema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().createSchema();
                    newSchema.setName(this.getSchema().getName());
                    newSchema.setRawObject(true);
                    synonym.setSchema(newSchema);
                } else {
                    synonym.setSchema(targetSchema);
                }
            }
            synonym.setComment(this.getComment());
            synonym.setRawObject(false);
        }
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.getSchema() != null && !this.getSchema().isNullInstance()) {
            return new StringBuffer().append(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return this.getName();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SYNONYM_ICON", 16);
    }
}

