/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.LoginPropertyDialogSqlServer;
import oracle.dbtools.crest.util.string.Crypt;

public class LoginSqlServer
extends AbstractStorageObjectSqlServer {
    public static final String[] AUTH_CHOICES = new String[]{"WINDOWS", "SQL Server"};
    private static List authList = Arrays.asList(AUTH_CHOICES);
    private static Set authSet = null;
    private static Crypt crypt = new Crypt();
    private String authentication = "SQL Server";
    private String password = "";
    private DataBaseSqlServer defaultDatabase;
    private String language = "English";
    private String users = "";
    private UserSet userSet = null;
    public static final String TYPE_NAME = "Login";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LoginPropertyDialogSqlServer dialog = new LoginPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public static List getAuthenticationValues() {
        return authList;
    }

    protected boolean checkAuth(String value) {
        if (authSet == null) {
            authSet = new HashSet();
            authSet.addAll(Arrays.asList(LoginSqlServer.getAuthChoices()));
        }
        return authSet.contains(value);
    }

    public static String[] getAuthChoices() {
        return AUTH_CHOICES;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        if (this.checkAuth(authentication)) {
            this.authentication = authentication;
            this.fireDataFieldChange();
        }
    }

    public DataBaseSqlServer getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public void setDefaultDatabase(DataBaseSqlServer defaultDatabase) {
        this.defaultDatabase = defaultDatabase;
        this.fireDataFieldChange();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        this.fireDataFieldChange();
    }

    public String getPassword() {
        return this.password;
    }

    public String decodePassword() {
        String result = this.getDesign().getLoadedVersion() < 3.3f ? this.password : crypt.decrypt(this.password);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setPassword(String password) {
        this.password = password;
        this.fireDataFieldChange();
    }

    public void encodePassword(String password) {
        this.password = crypt.encrypt(password);
        this.fireDataFieldChange();
    }

    private void addUser(String user) {
        String userName = user.substring(user.lastIndexOf(46) + 1, user.length());
        if (!this.getUserSet().contains(userName)) {
            this.getUserSet().add(userName);
        }
    }

    public void recreateUserSet(String users) {
        this.getUserSet().clear();
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            this.getUserSet().add(st.nextToken().trim());
        }
    }

    public void setUsers(String users) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(users);
        } else {
            this.addUser(users);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    public void clear() {
        this.getUserSet().removeAllElements();
        this.users = "";
        UserSqlServer[] userSet = (UserSqlServer[])((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().toArray();
        for (int i = 0; i < userSet.length; ++i) {
            UserSqlServer user = userSet[i];
            if (user.getLogin() != this) continue;
            ((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().remove(user);
        }
    }

    @Override
    public void remove() {
        UserSqlServer[] userSet = (UserSqlServer[])((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().toArray();
        for (int i = 0; i < userSet.length; ++i) {
            UserSqlServer user = userSet[i];
            if (user.getLogin() != this) continue;
            ((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().remove(user);
        }
        super.remove();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("USER_ICON", 16);
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

