/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v11g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.ColumnPropertyDialogOraclev11g;

public class ColumnProxyOraclev11g
extends ColumnProxyOraclev10g {
    public static final String BINARY_XML = "BINARY XML";
    public static final String SECUREFILE = "SECUREFILE";
    public static final String BASICFILE = "BASICFILE";
    public static final String FILESYSTEM_LIKE_LOGGING = "FILESYSTEM_LIKE_LOGGING";
    public static final String ENC_ALG_AES128 = "AES128";
    public static final String ENC_ALG_AES192 = "AES192";
    public static final String ENC_ALG_AES256 = "AES256";
    public static final String ENC_ALG_3DES168 = "3DES168";
    public static final String INT_ALG_SHA_1 = "SHA-1";
    public static final String INT_ALG_NOMAC = "NOMAC";
    private static final String[] STORE_AS_CHOICES = new String[]{"BINARY XML", "CLOB", "OBJECT RELATIONAL"};
    private static Set storeAsSet = null;
    private static final String[] LOB_STORAGE_CHOICES = new String[]{"", "SECUREFILE", "BASICFILE"};
    private static Set lobStorageTypeSet = null;
    private static final String[] LOGGING_CHOICES = new String[]{"", "YES", "NO", "FILESYSTEM_LIKE_LOGGING"};
    private static final String[] ENC_ALG_CHOICES = new String[]{"", "AES192", "AES128", "AES256", "3DES168"};
    private static final String[] INT_ALG_CHOICES = new String[]{"", "SHA-1", "NOMAC"};
    private String lobStorageType = "";
    private String encrypt = "";
    private String encryptionAlgorithm = "";
    private String integrityAlgorithm = "";
    private String useSalt = "";
    private String allowAnySchema = "";
    private String allowNonSchema = "";
    private boolean expressionChanged = false;
    private String columnExpression = "";

    public ColumnProxyOraclev11g(Column column, StorageDesign storage) {
        super(column, storage);
        this.storeAs = BINARY_XML;
    }

    public ColumnProxyOraclev11g(Design design, String id, String longName, StorageDesign storage) {
        super(design, id, longName, storage);
        this.storeAs = BINARY_XML;
    }

    public boolean isComputed() {
        return this.getColumn().isComputed();
    }

    @Override
    public boolean isVirtual() {
        String columnExpression;
        return this.isComputed() && (columnExpression = this.getColumnExpression()) != null && columnExpression.trim().length() > 0;
    }

    public boolean isExpressionChanged() {
        return this.expressionChanged;
    }

    public void setExpressionChanged(boolean expressionChanged) {
        this.expressionChanged = expressionChanged;
    }

    public String getColumnExpression() {
        if (this.expressionChanged) {
            return this.columnExpression;
        }
        return this.getColumn().getFormulaDesc();
    }

    public void setColumnExpression(String columnExpression) {
        this.columnExpression = columnExpression;
        this.fireDataFieldChange();
    }

    public String getEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(String value) {
        if (!this.encrypt.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.encrypt = value;
            this.fireDataFieldChange();
        }
    }

    public static String[] getEncryptionAlgorithmChoices() {
        return ENC_ALG_CHOICES;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String value) {
        if (!this.encryptionAlgorithm.equals(value)) {
            this.encryptionAlgorithm = value;
        }
    }

    public static String[] getIntegrityAlgorithmChoices() {
        return INT_ALG_CHOICES;
    }

    public String getIntegrityAlgorithm() {
        return this.integrityAlgorithm;
    }

    public void setIntegrityAlgorithm(String value) {
        if (!this.integrityAlgorithm.equals(value)) {
            this.integrityAlgorithm = value;
        }
    }

    public String getUseSalt() {
        return this.useSalt;
    }

    public void setUseSalt(String value) {
        if (!this.useSalt.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.useSalt = value;
            this.fireDataFieldChange();
        }
    }

    public String getLobStorageType() {
        return this.lobStorageType;
    }

    public void setLobStorageType(String lobStorageType) {
        if (!this.lobStorageType.equals(lobStorageType) && this.checkLobStorageType(lobStorageType)) {
            this.lobStorageType = lobStorageType;
            this.fireDataFieldChange();
        }
    }

    public String getAllowAnySchema() {
        return this.allowAnySchema;
    }

    public void setAllowAnySchema(String value) {
        if (!this.allowAnySchema.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.allowAnySchema = value;
            this.fireDataFieldChange();
        }
    }

    public String getAllowNonSchema() {
        return this.allowNonSchema;
    }

    public void setAllowNonSchema(String value) {
        if (!this.allowNonSchema.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.allowNonSchema = value;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogOraclev11g dialog = new ColumnPropertyDialogOraclev11g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.init();
            dialog.show();
        }
    }

    public static String[] getStoreAsValues11g() {
        return STORE_AS_CHOICES;
    }

    @Override
    protected boolean checkStoreAs(String value) {
        if (storeAsSet == null) {
            storeAsSet = new HashSet();
            storeAsSet.addAll(Arrays.asList(ColumnProxyOraclev11g.getStoreAsValues11g()));
        }
        return storeAsSet.contains(value);
    }

    public static String[] getLobStorageValues11g() {
        return LOB_STORAGE_CHOICES;
    }

    private boolean checkLobStorageType(String value) {
        if (lobStorageTypeSet == null) {
            lobStorageTypeSet = new HashSet();
            lobStorageTypeSet.addAll(Arrays.asList(ColumnProxyOraclev11g.getLobStorageValues11g()));
        }
        return lobStorageTypeSet.contains(value);
    }

    public static String[] getLoggingChoices11g() {
        return LOGGING_CHOICES;
    }

    @Override
    public void setLogging(String value) {
        super.setLogging(value);
        if (!this.logging.equals(value) && FILESYSTEM_LIKE_LOGGING.equals(value)) {
            this.logging = FILESYSTEM_LIKE_LOGGING;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Column column = (Column)targetDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxyOraclev11g columnProxy = null;
        RelationalObjectProxy storageObject = targetDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            columnProxy = (ColumnProxyOraclev11g)storageObject;
        }
        if (columnProxy != null) {
            super.copy(targetDesign);
            columnProxy.setColumnExpression(this.getColumnExpression());
            columnProxy.setExpressionChanged(this.isExpressionChanged());
            columnProxy.setEncrypt(this.getEncrypt());
            columnProxy.setEncryptionAlgorithm(this.getEncryptionAlgorithm());
            columnProxy.setIntegrityAlgorithm(this.getIntegrityAlgorithm());
            columnProxy.setUseSalt(this.getUseSalt());
            columnProxy.setLobStorageType(this.getLobStorageType());
        }
    }
}

