/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DirectoryOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableColumnOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.ExternalTableOraclePropertyDialogv10g;

public class ExternalTableOraclev10g
extends ExternalTableOracle
implements ModelObjectSetListener,
StorageObjectListener {
    public ExternalTableOraclev10g(StorageDesign storage) {
        this.setStorageDesign(storage);
        this.cols = new StorageObjectCollection(((StorageDesignOraclev10g)storage).getExternalColumnSet());
        this.cols.setParent(this);
        this.cols.setName(Messages.getString("TableProxy.Columns"));
        this.cols.setClassForParent(ExternalTableOracle.class);
        this.cols.setSetMethod("setExternalTable");
        this.cols.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON", 16));
        ((StorageDesignOraclev10g)storage).getExternalColumnSet().addSetListener(this);
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof ExternalTableColumnOraclev10g) {
            ExternalTableColumnOraclev10g col = (ExternalTableColumnOraclev10g)event.getAffected();
            if (col.getExternalTable() != null && col.getExternalTable() == this) {
                col.setParent(this.cols);
                this.cols.add(col);
            } else {
                this.cols.remove(col);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof ExternalTableColumnOraclev10g) {
                ExternalTableColumnOraclev10g col = (ExternalTableColumnOraclev10g)event.getAffected();
                col.addObjectListener(this);
                if (col.getExternalTable() != null && col.getExternalTable() == this) {
                    col.setParent(this.cols);
                    this.cols.add(col);
                } else {
                    this.cols.remove(col);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof ExternalTableColumnOraclev10g) {
            ExternalTableColumnOraclev10g col = (ExternalTableColumnOraclev10g)event.getAffected();
            this.cols.remove(col);
            col.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.cols;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.cols) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.cols) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.cols.removeAll();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ExternalTableOraclePropertyDialogv10g dialog = new ExternalTableOraclePropertyDialogv10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public StorageObjectCollection getColumns() {
        return this.cols;
    }

    public ExternalTableColumnOracle createColumn() {
        if (this.cols.getStorageObjectSet() != null) {
            return (ExternalTableColumnOracle)this.cols.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        ExternalTableOraclev10g extTable = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getExternalTableSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                extTable = (ExternalTableOraclev10g)stObject;
            }
        } else {
            extTable = (ExternalTableOraclev10g)((StorageDesignOraclev10g)targetDesign).getExternalTableSet().createExternalTable();
        }
        if (extTable != null) {
            extTable.setName(this.getName());
            for (ExternalTableColumnOraclev10g extTableColumn : this.getColumns()) {
                ExternalTableColumnOraclev10g targetExtColumn = (ExternalTableColumnOraclev10g)((StorageDesignOraclev10g)targetDesign).getExternalColumnSet().getByName(extTableColumn.getName());
                if (targetExtColumn == null) {
                    ExternalTableColumnOraclev10g newExtColumn = (ExternalTableColumnOraclev10g)((StorageDesignOraclev10g)targetDesign).getExternalColumnSet().createExternalColumn();
                    newExtColumn.setName(extTableColumn.getName());
                    newExtColumn.setExternalTable(extTable);
                    newExtColumn.setRawObject(true);
                    extTable.getColumns().add(newExtColumn);
                    continue;
                }
                targetExtColumn.setExternalTable(extTable);
                extTable.getColumns().add(targetExtColumn);
            }
            if (this.getOwner() != null) {
                UserOraclev10g targetUser = (UserOraclev10g)((StorageDesignOraclev10g)targetDesign).getUserSet().getByName(this.getOwner().getName());
                if (targetUser == null) {
                    UserOraclev10g newUser = (UserOraclev10g)((StorageDesignOraclev10g)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getName());
                    newUser.setRawObject(true);
                    extTable.setOwner(newUser);
                } else {
                    extTable.setOwner(targetUser);
                }
            }
            extTable.setAccessDriverType(this.getAccessDriverType());
            if (this.getDefaultDir() != null) {
                DirectoryOraclev10g directory = (DirectoryOraclev10g)((StorageDesignOraclev10g)targetDesign).getDirectorySet().getByName(this.getDefaultDir().getName());
                if (directory == null) {
                    DirectoryOraclev10g newDirectory = (DirectoryOraclev10g)((StorageDesignOraclev10g)targetDesign).getDirectorySet().createDirectory();
                    newDirectory.setName(this.getName());
                    newDirectory.setRawObject(true);
                    extTable.setDefaultDir(newDirectory);
                } else {
                    extTable.setDefaultDir(directory);
                }
            }
            extTable.setOpaqueFormatSpec(this.getOpaqueFormatSpec());
            extTable.setClobSubquery(this.getClobSubquery());
            extTable.setAccessParametersType(this.getAccessParametersType());
            extTable.setLocation(this.getLocation());
            extTable.setParallel(this.getParallel());
            extTable.setParallelNum(this.getParallelNum());
            extTable.setRejectLimit(this.getRejectLimit());
            extTable.setComment(this.getComment());
            extTable.setRawObject(this.isRawObject());
        }
    }
}

