/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageEvent;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;

public abstract class TableSpaceOracle
extends AbstractStorageObjectOracle
implements RelationalObjectProxySetListener,
ModelObjectSetListener,
StorageObjectListener,
StatementsConstants,
PropertiesPropagator {
    public static final String PERMANENT = "PERMANENT";
    public static final String AUTOALLOCATE = "AUTOALLOCATE";
    private static final String[] LOG_STATES = new String[]{"LOGGING", "NOLOGGING"};
    private static final String[] STATUS_STATES = new String[]{"ONLINE", "OFFLINE"};
    private static final String[] CONTENTS_STATES = new String[]{"PERMANENT", "TEMPORARY"};
    protected static final String[] EXTEND_MANAGE_STATES = new String[]{"DICTIONARY", "LOCAL"};
    private static final String[] EM_SUBTYPE_STATES = new String[]{"AUTOALLOCATE", "UNIFORM"};
    private static List loggingList = Arrays.asList(LOG_STATES);
    private static List statusList = Arrays.asList(STATUS_STATES);
    private static List contentsList = Arrays.asList(CONTENTS_STATES);
    private static List extendManageList = Arrays.asList(EXTEND_MANAGE_STATES);
    private static List emLocalSubtypeList = Arrays.asList(EM_SUBTYPE_STATES);
    private Map tableMap = new HashMap();
    private List tables = new ArrayList();
    private int minExtLen = 0;
    private static Set logSet = null;
    private String logging = LOG_STATES[0];
    private static Set statusSet = null;
    private String status = STATUS_STATES[0];
    private static Set contentsSet = null;
    private String contents = CONTENTS_STATES[0];
    private long dsInitialExtent = 0L;
    private long dsNextExtent = 0L;
    private int dsMinExtents = 1;
    private String dsMaxExtents = "UNLIMITED";
    private int dsPctIncrease = 0;
    private static Set extManageSet = null;
    protected String extentManagement = EXTEND_MANAGE_STATES[0];
    private static Set emSubtypeSet = null;
    private String emLocalSubtype = EM_SUBTYPE_STATES[0];
    private int emUniformSize = 0;
    private StorageObjectCollection tabcoll;
    private StorageObjectCollection dfiles;
    public static final String NAME_SUBSTITUTION_TYPE = "Tablespace";
    private String defaultForTable;
    public static final String TYPE_NAME = "TSpace";
    public static final String OLD_TYPE_NAME = "TableSpaceOracle";

    public TableSpaceOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.setParent(((StorageDesignOracle)storageDesign).getTableSpaceSet());
        this.tabcoll = new StorageObjectCollection();
        this.tabcoll.setParent(this);
        this.tabcoll.setName(Messages.getString("TableSpaceOracle.Tables"));
        this.tabcoll.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
        this.registerToTableProxyFromDesign(storageDesign.getTableProxySet());
        storageDesign.getTableProxySet().addSetListener(this);
        this.dfiles = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getDataFileSet());
        this.dfiles.setParent(this);
        this.dfiles.setName(Messages.getString("TableSpaceOracle.DataFiles"));
        this.dfiles.setSetMethod("setTableSpace");
        this.dfiles.setClassForParent(TableSpaceOracle.class);
        this.dfiles.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        ((StorageDesignOracle)storageDesign).getDataFileSet().addSetListener(this);
    }

    @Override
    public boolean setName(String name) {
        if ("SYSAUX".equalsIgnoreCase(name) || "SYSTEM".equalsIgnoreCase(name) || "USERS".equalsIgnoreCase(name)) {
            this.setMarkedGenerate(false);
        }
        return super.setName(name);
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof TableProxy) {
            TableProxyOracle tp = (TableProxyOracle)event.getAffected();
            if (tp.getTableSpace() != null && tp.getTableSpace() == this) {
                StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(tp);
                ph.setParent(this.tabcoll);
                this.tabcoll.add(ph);
            } else if (tp.getTableSpace() == null || tp.getTableSpace() != null && tp.getTableSpace() != this) {
                this.tabcoll.removePlaceHolderFor(tp);
            }
        } else if (event.getAffected() instanceof DataFileOracle) {
            DataFileOracle df = (DataFileOracle)event.getAffected();
            if (df.getTableSpace() != null && df.getTableSpace() == this) {
                df.setParent(this.dfiles);
                this.dfiles.add(df);
            } else {
                this.dfiles.remove(df);
            }
        }
    }

    @Override
    public String getIDPrefix() {
        return "TableSpace";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public int getMinExtLen() {
        return this.minExtLen;
    }

    public void setMinExtLen(int minExtLen) {
        this.minExtLen = minExtLen;
    }

    public static String[] getLogStates() {
        return LOG_STATES;
    }

    protected boolean checkLogState(String value) {
        if (logSet == null) {
            logSet = new HashSet();
            logSet.addAll(Arrays.asList(TableSpaceOracle.getLogStates()));
        }
        return logSet.contains(value);
    }

    public void setLogging(String value) {
        if (this.checkLogState(value)) {
            this.logging = value;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public static String[] getStatusStates() {
        return STATUS_STATES;
    }

    protected boolean checkStatusState(String value) {
        if (statusSet == null) {
            statusSet = new HashSet();
            statusSet.addAll(Arrays.asList(TableSpaceOracle.getStatusStates()));
        }
        return statusSet.contains(value);
    }

    public void setStatus(String value) {
        if (this.checkStatusState(value)) {
            this.status = value;
            this.fireDataFieldChange();
        }
    }

    public String getStatus() {
        return this.status;
    }

    public static String[] getContentsStates() {
        return CONTENTS_STATES;
    }

    protected boolean checkContentsState(String value) {
        if (contentsSet == null) {
            contentsSet = new HashSet();
            contentsSet.addAll(Arrays.asList(TableSpaceOracle.getContentsStates()));
        }
        return contentsSet.contains(value);
    }

    public void setContents(String value) {
        if (this.checkContentsState(value)) {
            this.contents = value;
            this.fireDataFieldChange();
        }
    }

    public String getContents() {
        return this.contents;
    }

    public long getDSInitialExtent() {
        return this.dsInitialExtent;
    }

    public void setDSInitialExtent(long dsInitialExtent) {
        this.dsInitialExtent = dsInitialExtent;
    }

    public long getDSNextExtent() {
        return this.dsNextExtent;
    }

    public void setDSNextExtent(long dsNextExtent) {
        this.dsNextExtent = dsNextExtent;
    }

    public int getDSMinExtents() {
        return this.dsMinExtents;
    }

    public void setDSMinExtents(int dsMinExtents) {
        this.dsMinExtents = dsMinExtents;
    }

    public String getDSMaxExtents() {
        return this.dsMaxExtents;
    }

    public void setDSMaxExtents(String dsMaxExtents) {
        try {
            this.dsMaxExtents = Integer.parseInt(dsMaxExtents) > 0 ? dsMaxExtents : "UNLIMITED";
        }
        catch (NumberFormatException E) {
            this.dsMaxExtents = "UNLIMITED";
        }
    }

    public int getDSPctIncrease() {
        return this.dsPctIncrease;
    }

    public void setDSPctIncrease(int dsPctIncrease) {
        this.dsPctIncrease = dsPctIncrease;
    }

    public static String[] getExtManageStates() {
        return EXTEND_MANAGE_STATES;
    }

    protected boolean checkExtManageState(String value) {
        if (extManageSet == null) {
            extManageSet = new HashSet();
            extManageSet.addAll(Arrays.asList(TableSpaceOracle.getExtManageStates()));
        }
        return extManageSet.contains(value);
    }

    public void setExtentManagement(String value) {
        if (this.checkExtManageState(value)) {
            this.extentManagement = value;
            this.fireDataFieldChange();
        }
    }

    public String getExtentManagement() {
        return this.extentManagement;
    }

    public static String[] getEmLocalSubtypeStates() {
        return EM_SUBTYPE_STATES;
    }

    protected boolean checkEmLocalSubtypeState(String value) {
        if (emSubtypeSet == null) {
            emSubtypeSet = new HashSet();
            emSubtypeSet.addAll(Arrays.asList(TableSpaceOracle.getEmLocalSubtypeStates()));
        }
        return emSubtypeSet.contains(value);
    }

    public void setEMLocalSubtype(String value) {
        if (this.checkEmLocalSubtypeState(value)) {
            this.emLocalSubtype = value;
            this.fireDataFieldChange();
        }
    }

    public String getEMLocalSubtype() {
        return this.emLocalSubtype;
    }

    public int getEMUniformSize() {
        return this.emUniformSize;
    }

    public void setEMUniformSize(int emUniformSize) {
        this.emUniformSize = emUniformSize;
    }

    public static List getLoggingValues() {
        return loggingList;
    }

    public static List getStatusValues() {
        return statusList;
    }

    public static List getContentsValues() {
        return contentsList;
    }

    public static List getExtendManageValues() {
        return extendManageList;
    }

    public static List getEmLocalSubtypeValues() {
        return emLocalSubtypeList;
    }

    public boolean willAcceptTable() {
        return true;
    }

    public void removeTable(TableProxy table) {
        this.tableMap.remove(table.getObjectID());
        this.tables.remove(table);
        StorageEvent event = StorageEvent.TS_TABLE_REMOVED;
        event.setAffected(table);
        this.fireChange(event);
        event.setAffected(null);
    }

    public void addTable(TableProxy table) {
        if (this.willAcceptTable()) {
            this.tableMap.put(table.getObjectID(), table);
            this.tables.add(table);
            StorageEvent event = StorageEvent.TS_TABLE_ADDED;
            event.setAffected(table);
            this.fireChange(event);
            event.setAffected(null);
        }
    }

    public String getDefaultForTable() {
        return this.defaultForTable;
    }

    public void setDefaultForTable(String defaultForTable) {
        this.defaultForTable = defaultForTable;
    }

    public boolean isDefaultFor(TableProxy tableProxy) {
        return this.tables.size() == 1 && this.tables.contains(tableProxy) && this.getDefaultForTable() != null && this.getDefaultForTable().equals(tableProxy.getObjectID());
    }

    @Override
    public int getMaxNameLength() {
        return this.getStorageDesign() instanceof StorageDesignOraclev12cR2 ? 128 : 30;
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.tabcoll;
            }
            case 1: {
                return this.dfiles;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.tabcoll) {
            return 0;
        }
        if (child == this.dfiles) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.tabcoll) {
            return 0;
        }
        if (child == this.dfiles) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void registerToTableProxyFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TableProxy tp = (TableProxy)it.next();
            tp.addObjectListener(this);
        }
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TableProxy) {
                TableProxyOracle tp = (TableProxyOracle)event.getAffected();
                tp.addObjectListener(this);
                if (this == tp.getTableSpace()) {
                    StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(tp);
                    ph.setParent(this.tabcoll);
                    this.tabcoll.add(ph);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof TableProxy) {
            TableProxyOracle tp = (TableProxyOracle)event.getAffected();
            tp.removeObjectListener(this);
            this.tabcoll.removePlaceHolderFor(tp);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof DataFileOracle) {
                DataFileOracle df = (DataFileOracle)event.getAffected();
                df.addObjectListener(this);
                if (df.getTableSpace() != null && df.getTableSpace() == this) {
                    df.setParent(this.dfiles);
                    this.dfiles.add(df);
                } else {
                    this.dfiles.remove(df);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof DataFileOracle) {
            DataFileOracle df = (DataFileOracle)event.getAffected();
            this.dfiles.remove(df);
            df.removeObjectListener(this);
        }
    }

    public StorageObjectCollection getTabcoll() {
        return this.tabcoll;
    }

    public StorageObjectCollection getDfiles() {
        return this.dfiles;
    }

    public DataFileOracle createDataFile() {
        if (this.dfiles.getStorageObjectSet() != null) {
            return (DataFileOracle)this.dfiles.createElement(null);
        }
        return null;
    }

    @Override
    public String getNameSubstitutionType() {
        return NAME_SUBSTITUTION_TYPE;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLESPACE_ICON", 16);
    }

    public List getDataFiles() {
        ArrayList<DataFileOracle> list = new ArrayList<DataFileOracle>();
        DataFileSetOracle dataFileSet = ((StorageDesignOracle)this.getStorageDesign()).getDataFileSet();
        for (DataFileOracle df : dataFileSet) {
            TableSpaceOracle ts = df.getTableSpace();
            if (ts == null || ts != this) continue;
            list.add(df);
        }
        return list;
    }

    @Override
    public void clearNoneMergableStructure() {
        this.dfiles.removeAll();
    }
}

