/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFKOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBFunctionOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBNoneTransferableFKOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBPackageBodyOracle;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHExternalTableOraclev9i;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.MethodParamProxy;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.TypeElementProxy;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ContextOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ContextSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataBaseOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataBaseSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectorySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexPropertiesSet;
import oracle.dbtools.crest.model.design.storage.oracle.NotNullConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ReservedWordsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracleEstimates;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;

public abstract class StorageDesignOracle
extends StorageDesign {
    private PropertyHolder propertyholder = null;
    private ReservedWordsOracle reserved = new ReservedWordsOracle();
    private LocalIndexPropertiesSet lipSet;
    private PackageSetOracle packagesSet = null;
    private FunctionSetOracle functionsSet = null;
    protected static final String PACKAGES = Messages.getString("StorageDesignOracle.Packages");
    protected static final String FUNCTIONS = Messages.getString("StorageDesignOracle.Functions");
    private StorageDesignOracleEstimates storageDesignOracleEstimates = new StorageDesignOracleEstimates();
    static String AQ_ADMINISTRATOR_ROLE = "AQ_ADMINISTRATOR_ROLE";
    static String AQ_USER_ROLE = "AQ_USER_ROLE";
    static String AUTHENTICATEDUSER = "AUTHENTICATEDUSER";
    static String CONNECT = "CONNECT";
    static String CTXAPP = "CTXAPP";
    static String DBA = "DBA";
    static String DELETE_CATALOG_ROLE = "DELETE_CATALOG_ROLE";
    static String EJBCLIENT = "EJBCLIENT";
    static String EXECUTE_CATALOG_ROLE = "EXECUTE_CATALOG_ROLE";
    static String EXP_FULL_DATABASE = "EXP_FULL_DATABASE";
    static String GATHER_SYSTEM_STATISTICS = "GATHER_SYSTEM_STATISTICS";
    static String GLOBAL_AQ_USER_ROLE = "GLOBAL_AQ_USER_ROLE";
    static String HS_ADMIN_ROLE = "HS_ADMIN_ROLE";
    static String IMP_FULL_DATABASE = "IMP_FULL_DATABASE";
    static String JAVADEBUGPRIV = "JAVADEBUGPRIV";
    static String JAVAIDPRIV = "JAVAIDPRIV";
    static String JAVASYSPRIV = "JAVASYSPRIV";
    static String JAVAUSERPRIV = "JAVAUSERPRIV";
    static String JAVA_ADMIN = "JAVA_ADMIN";
    static String JAVA_DEPLOY = "JAVA_DEPLOY";
    static String LOGSTDBY_ADMINISTRATOR = "LOGSTDBY_ADMINISTRATOR";
    static String MGMT_USER = "MGMT_USER";
    static String OEM_ADVISOR = "OEM_ADVISOR";
    static String OEM_MONITOR = "OEM_MONITOR";
    static String OLAP_DBA = "OLAP_DBA";
    static String OLAP_USER = "OLAP_USER";
    static String OWBR_OWB = "OWBR_OWB";
    static String OWB_A_OWB = "OWB_A_OWB";
    static String OWB_D_OWB = "OWB_D_OWB";
    static String OWB_OWB = "OWB_OWB";
    static String OWB_O_OWB = "OWB_O_OWB";
    static String RECOVERY_CATALOG_OWNER = "RECOVERY_CATALOG_OWNER";
    static String RESOURCE = "RESOURCE";
    static String SCHEDULER_ADMIN = "SCHEDULER_ADMIN";
    static String SELECT_CATALOG_ROLE = "SELECT_CATALOG_ROLE";
    static String WM_ADMIN_ROLE = "WM_ADMIN_ROLE";
    static String XDBADMIN = "XDBADMIN";
    static String XDBWEBSERVICES = "XDBWEBSERVICES";
    private static String[] SEEDED_ROLES = new String[]{AQ_ADMINISTRATOR_ROLE, AQ_USER_ROLE, AUTHENTICATEDUSER, CONNECT, CTXAPP, DBA, DELETE_CATALOG_ROLE, EJBCLIENT, EXECUTE_CATALOG_ROLE, EXP_FULL_DATABASE, GATHER_SYSTEM_STATISTICS, GLOBAL_AQ_USER_ROLE, HS_ADMIN_ROLE, IMP_FULL_DATABASE, JAVADEBUGPRIV, JAVAIDPRIV, JAVASYSPRIV, JAVAUSERPRIV, JAVA_ADMIN, JAVA_DEPLOY, LOGSTDBY_ADMINISTRATOR, MGMT_USER, OEM_ADVISOR, OEM_MONITOR, OLAP_DBA, OLAP_USER, OWBR_OWB, OWB_A_OWB, OWB_D_OWB, OWB_OWB, OWB_O_OWB, RECOVERY_CATALOG_OWNER, RESOURCE, SCHEDULER_ADMIN, SELECT_CATALOG_ROLE, WM_ADMIN_ROLE, XDBADMIN, XDBWEBSERVICES};
    private Map substitutionMap = new TreeMap();
    boolean shouldCreateHiveUDPLibrary = false;

    public StorageDesignOracle(RelationalDesign physicalDesign, RDBMSSite site, Design design) {
        super(physicalDesign, site, design);
    }

    @Override
    public abstract String getName();

    @Override
    public PropertyHolder getPropertyHolder() {
        return this.propertyholder;
    }

    public abstract DataFileSetOracle getDataFileSet();

    public abstract RedoLogGroupSetOracle getRedoLogGroupSet();

    public abstract DataBaseSetOracle getDataBaseSet();

    public abstract UserSetOracle getUserSet();

    public abstract QuotaItemSetOracle getQuotaItemSet();

    public abstract TableSpaceSetOracle getTableSpaceSet();

    public abstract ClusterSetOracle getClusterSet();

    public abstract SegmentSetOracle getSegmentSet();

    public abstract PartitionListSetOracle getPartitionListSet();

    public abstract PartitionSetOracle getPartitionSet();

    public abstract LobStorageSetOracle getLobStorageSet();

    public abstract HashPartitionSetOracle getHashPartitionSet();

    public abstract HashPartitionLobItemSetOracle getHashPartitionLobItemSet();

    public abstract RoleSetOracle getRoleSet();

    public abstract PermissionsSetOracle getPermissionsSet();

    public abstract SequenceSetOracle getSequenceSet();

    public abstract ClusterIndexSetOracle getClusterIndexSet();

    public abstract IndexGlobalPartitionsListSetOracle getIndexGlobalPartitionsListSet();

    public abstract IndexGlobalPartitionSetOracle getIndexGlobalPartitionSet();

    public abstract ListPartitionSetOracle getListPartitionSet();

    public abstract ListStorageTemplatePartitionSetOracle getListStorageTemplatePartitionSet();

    public abstract ClusterColumnSetOracle getClusterColumnSet();

    public abstract SynonymSetOracle getSynonymSet();

    public abstract PKProxySetOracle getPKProxySet();

    public abstract FKProxySetOracle getFKProxySet();

    public abstract TableCheckConstraintSetOracle getTableCheckConstraintSet();

    public abstract TriggerSetOracle getTriggerSet();

    public abstract StoredProcedureSetOracle getStoredProcedureSet();

    public abstract DimensionSetOracle getDimensionSet();

    public abstract LevelSetOracle getLevelSet();

    public abstract HierarchySetOracle getHierarchySet();

    public abstract DimensionAttributeSetOracle getDimensionAttributeSet();

    public abstract SnapshotSetOracle getSnapshotSet();

    public abstract BitmapJoinIndexSetOracle getBitmapJoinIndexSet();

    public abstract ContextSetOracle getContextSet();

    public abstract DirectorySetOracle getDirectorySet();

    public abstract TemporaryTablespaceSetOracle getTemporaryTablespaceSet();

    public abstract RollbackSegmentSetOracle getRollbackSegmentSet();

    public abstract UndoTablespaceSetOracle getUndoTablespaceSet();

    public abstract ExternalTableSetOracle getExternalTableSet();

    public abstract void updateGeneralRule();

    public UniqueSetOracle getUniqueSet() {
        return null;
    }

    public NotNullConstraintSetOracle getNotNullConstraintSet() {
        return null;
    }

    @Override
    public void doAfterNew() {
        this.generateSnapshots();
    }

    @Override
    public void doAfterLoad() {
        super.doAfterLoad();
        Iterator it = this.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyOracle table = (TableProxyOracle)it.next();
            ArrayList<ModelObject> partitions = new ArrayList<ModelObject>();
            int size = table.getPartitions().size();
            for (int i = 0; i < size; ++i) {
                partitions.add(table.getPartitions().getElement(0));
                table.getPartitions().justRemove(table.getPartitions().getElement(0));
            }
            Collections.sort(partitions, new PartitionComparator());
            for (int i = 0; i < partitions.size(); ++i) {
                if (partitions.get(i) instanceof PartitionOracle) {
                    PartitionOracle p = (PartitionOracle)partitions.get(i);
                    p.addObjectListener(table);
                    p.setParent(table.getPartitions());
                    table.getPartitions().add(p);
                    continue;
                }
                if (partitions.get(i) instanceof HashPartitionOracle) {
                    HashPartitionOracle hp = (HashPartitionOracle)partitions.get(i);
                    hp.addObjectListener(table);
                    hp.setParent(table.getPartitions());
                    table.getPartitions().add(hp);
                    continue;
                }
                if (!(partitions.get(i) instanceof ListPartitionOracle)) continue;
                ListPartitionOracle lp = (ListPartitionOracle)partitions.get(i);
                lp.addObjectListener(table);
                lp.setParent(table.getPartitions());
                table.getPartitions().add(lp);
            }
        }
        this.setDirty(false);
        this.setAllStorableObjectsDirty(false);
    }

    @Override
    public void load() {
        super.load();
        Iterator it = this.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyOracle table = (TableProxyOracle)it.next();
            ArrayList<ModelObject> partitions = new ArrayList<ModelObject>();
            int size = table.getPartitions().size();
            for (int i = 0; i < size; ++i) {
                partitions.add(table.getPartitions().getElement(0));
                table.getPartitions().justRemove(table.getPartitions().getElement(0));
            }
            Collections.sort(partitions, new PartitionComparator());
            for (int i = 0; i < partitions.size(); ++i) {
                if (partitions.get(i) instanceof PartitionOracle) {
                    PartitionOracle p = (PartitionOracle)partitions.get(i);
                    p.addObjectListener(table);
                    p.setParent(table.getPartitions());
                    table.getPartitions().add(p);
                    continue;
                }
                if (partitions.get(i) instanceof HashPartitionOracle) {
                    HashPartitionOracle hp = (HashPartitionOracle)partitions.get(i);
                    hp.addObjectListener(table);
                    hp.setParent(table.getPartitions());
                    table.getPartitions().add(hp);
                    continue;
                }
                if (!(partitions.get(i) instanceof ListPartitionOracle)) continue;
                ListPartitionOracle lp = (ListPartitionOracle)partitions.get(i);
                lp.addObjectListener(table);
                lp.setParent(table.getPartitions());
                table.getPartitions().add(lp);
            }
        }
        this.setDirty(false);
        this.setAllStorableObjectsDirty(false);
    }

    @Override
    public Iterator ddlObjects() {
        return this.getListOfDDLObjects().iterator();
    }

    public PackageBodyOracle[] getPackageBodies() {
        ArrayList<PackageBodyOracle> packageBodyList = new ArrayList<PackageBodyOracle>();
        for (PackageOracle packageOracle : this.getPackageSet()) {
            PackageBodyOracle packageBody = packageOracle.getBody();
            if (packageBody == null) continue;
            packageBodyList.add(packageBody);
        }
        return packageBodyList.toArray(new PackageBodyOracle[0]);
    }

    @Override
    protected final DDLGenerator createDDLGenerator() {
        DDLGeneratorSpecific generator = new DDLGeneratorSpecific(this);
        this.appendAll(generator);
        this.appendDefault(generator);
        generator.setLabel("Oracle Generic");
        return generator;
    }

    protected void appendDefault(DDLGenerator generator) {
        generator.append(new SSBFunctionOracle());
        generator.append(new SSBPackageBodyOracle());
    }

    protected abstract void appendAll(DDLGenerator var1);

    @Override
    public List getAllSetsList() {
        ArrayList<StorageObjectSet> list = new ArrayList<StorageObjectSet>();
        list.add(this.getPackageSet());
        list.add(this.getFunctionSet());
        return list;
    }

    public String getFormattedNameList(String nameList) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(nameList, ",");
        while (tokenizer.hasMoreTokens()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(this.getFormatedName(tokenizer.nextToken().trim()));
        }
        return result.toString();
    }

    public String getFormatedColumnNamesFromIDs(String idList) {
        return this.getFormatedNamesFromIDs(idList, this.getColumnProxySet());
    }

    public String getFormatedColumnNamesNoLogFromIDs(String idList) {
        return this.getFormatedNamesNoLogFromIDs(idList, this.getColumnProxySet());
    }

    public String getFormatedTablespaceNamesFromIDs(String idList) {
        return this.getFormatedNamesFromIDs(idList, this.getTableSpaceSet());
    }

    @Override
    public String getFormatedName(String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        String ready = "";
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            ready = first ? this.getFormatedSubname(tokenizer.nextToken()) : ready + "." + this.getFormatedSubname(tokenizer.nextToken());
            first = false;
        }
        return ready;
    }

    public String getFormatedSubname(String name) {
        if (!name.startsWith("\"") && (this.startsWithNumber(name) || StorageDesignOracle.hasForbiddenCharsOracle(name) || name.indexOf(95) == 0 || name.indexOf(36) == 0 || name.indexOf(35) == 0 || name.indexOf(64) > -1 || this.reserved.isReservedWord(name) || this.getDesign().getAppView().getSettings().isUseQuotedIdentifiers())) {
            return "\"" + name + "\"";
        }
        return name;
    }

    @Override
    public boolean isValidName(String name) {
        return !this.startsWithNumber(name) && !StorageDesignOracle.hasForbiddenCharsOracle(name) && name.indexOf(95) != 0 && name.indexOf(36) != 0 && name.indexOf(35) != 0 && name.indexOf(64) <= -1 && !this.reserved.isReservedWord(name);
    }

    public LocalIndexPropertiesSet getLocalIndexPropertiesSet() {
        if (this.lipSet == null) {
            this.lipSet = new LocalIndexPropertiesSet();
            this.lipSet.setDesign(this.getDesign());
            this.lipSet.setStorageDesign(this);
        }
        return this.lipSet;
    }

    @Override
    public Map getNameSubstituionTypes() {
        if (this.substitutionMap.isEmpty()) {
            this.substitutionMap.put("Table", new StorageDesign.ObjectType("Table"));
            this.substitutionMap.put("Tablespace", new StorageDesign.ObjectType("Tablespace"));
            this.substitutionMap.put("User", new StorageDesign.ObjectType("User"));
            this.substitutionMap.put("Role", new StorageDesign.ObjectType("Role"));
            this.substitutionMap.put("Index", new StorageDesign.ObjectType("Index"));
        }
        return this.substitutionMap;
    }

    public List getNNC_ColumnsWithExceptionsTableForDDL() {
        ArrayList<ColumnProxyOracle> list = new ArrayList<ColumnProxyOracle>();
        Iterator it = this.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxy tp = (TableProxy)it.next();
            if (!tp.isMarkedGenerate()) continue;
            ColumnProxy[] proxies = tp.getColumnProxies();
            for (int i = 0; i < proxies.length; ++i) {
                String cpNncName;
                ColumnProxyOracle cp = (ColumnProxyOracle)proxies[i];
                if (cp.getNncExceptionsTable() == null || cp.getColumn().getNullsAllowed()) continue;
                String string = cpNncName = cp.isNotNullConstraintNameChanged() ? cp.getNncName() : cp.getColumn().getNotNullConstraintName();
                if (cpNncName == null || "".equals(cpNncName)) continue;
                list.add(cp);
            }
        }
        return list;
    }

    @Override
    public List getDropableSets() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        list.add(this.getTableProxySet());
        list.add(this.getIndexProxySet());
        list.add(this.getFKProxySet());
        list.add(this.getSnapshotSet());
        list.add(this.getTableViewProxySet());
        list.add(this.getSequenceSet());
        list.add(this.getTableSpaceSet());
        return list;
    }

    @Override
    protected DDLGenerator createDDLTriggerGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific(this);
        ddlGenerator.append(new SSBNoneTransferableFKOracle(this));
        ddlGenerator.append(new SSBArcFKOracle(this));
        return ddlGenerator;
    }

    @Override
    protected DDLGenerator createDDLAutoIncrementColumnGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific(this);
        ddlGenerator.append(new SSBAutoIncrementColumnOracle(this));
        return ddlGenerator;
    }

    @Override
    public List getUniqueList() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objects = this.getUniqueSet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    @Override
    public List getFKProxyList() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objects = this.getFKProxySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    @Override
    public List getPKProxyList() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objects = this.getPKProxySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    public boolean isSeededRole(String role) {
        if (role != null && !"".equals(role)) {
            for (int i = 0; i < SEEDED_ROLES.length; ++i) {
                if (!SEEDED_ROLES[i].equalsIgnoreCase(role)) continue;
                return true;
            }
        }
        return false;
    }

    public UserOracle getDefaultUser() {
        return this.getDefaultUser(true);
    }

    public UserOracle getDefaultUser(boolean create) {
        UserOracle user = null;
        String name = this.getDesign().getAppView().getSettings().getDefaultOracleUser();
        if (name != null && !"".equalsIgnoreCase(name) && (user = (UserOracle)this.getUserSet().getByName(name)) == null && create) {
            user = (UserOracle)this.getUserSet().createElement(null);
            user.setName(name);
        }
        return user;
    }

    public TableSpaceOracle getDefaultTableSpace() {
        return this.getDefaultTableSpace(true);
    }

    public TableSpaceOracle getDefaultTableSpace(boolean create) {
        TableSpaceOracle ts = null;
        String name = this.getDesign().getAppView().getSettings().getDefaultOracleTablespace();
        if (name != null && !"".equalsIgnoreCase(name) && (ts = (TableSpaceOracle)this.getTableSpaceSet().getByName(name)) == null && create) {
            ts = this.getTableSpaceSet().createTableSpace(name);
            ts.setName(name);
        }
        return ts;
    }

    public PackageSetOracle getPackageSet() {
        if (this.packagesSet == null) {
            this.packagesSet = new PackageSetOracle();
            this.packagesSet.setDesign(this.getDesign());
            this.packagesSet.setStorageDesign(this);
        }
        return this.packagesSet;
    }

    public FunctionSetOracle getFunctionSet() {
        if (this.functionsSet == null) {
            this.functionsSet = new FunctionSetOracle();
            this.functionsSet.setDesign(this.getDesign());
            this.functionsSet.setStorageDesign(this);
        }
        return this.functionsSet;
    }

    public PackageOracle createPackageOracle() {
        return (PackageOracle)this.getPackageSet().createElement(null);
    }

    public FunctionOracle createFunctionOracle() {
        return (FunctionOracle)this.getFunctionSet().createElement(null);
    }

    @Override
    public void reloadAllProxies() {
        super.reloadAllProxies();
        this.getPKProxySet().setDesign(this.getDesign());
        this.getUniqueSet().setDesign(this.getDesign());
        this.getFKProxySet().setDesign(this.getDesign());
    }

    @Override
    protected List<ElementSet> createDDLSelectionSetsList() {
        List<ElementSet> objectSets = super.createDDLSelectionSetsList();
        objectSets.add(this.getContextSet());
        objectSets.add(this.getDirectorySet());
        objectSets.add(this.getRoleSet());
        objectSets.add(this.getRollbackSegmentSet());
        objectSets.add(this.getTableSpaceSet());
        objectSets.add(this.getTemporaryTablespaceSet());
        objectSets.add(this.getUserSet());
        objectSets.add(this.getClusterSet());
        objectSets.add(this.getDimensionSet());
        objectSets.add(this.getSequenceSet());
        objectSets.add(this.getSnapshotSet());
        objectSets.add(this.getPackageSet());
        objectSets.add(this.getStoredProcedureSet());
        objectSets.add(this.getFunctionSet());
        objectSets.add(this.getSynonymSet());
        objectSets.add(this.getStructuredTypeProxySet());
        this.addDDLSelectionTableSetsList(objectSets);
        this.addDDLSelectionViewSetsList(objectSets);
        return objectSets;
    }

    protected void addDDLSelectionTableSetsList(List<ElementSet> objectSets) {
        TableProxySet tableProxySet = this.getTableProxySet();
        Iterator tableProxySetIterator = tableProxySet.iterator();
        while (tableProxySetIterator.hasNext()) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)tableProxySetIterator.next();
            objectSets.add(tableProxyOracle.getPrimaryKeys());
            objectSets.add(tableProxyOracle.getUniqueKeys());
            objectSets.add(tableProxyOracle.getIndexes());
            objectSets.add(tableProxyOracle.getFKeys());
            objectSets.add(tableProxyOracle.getTriggers());
        }
        objectSets.add(tableProxySet);
    }

    protected void addDDLSelectionViewSetsList(List<ElementSet> objectSets) {
        TableViewProxySet tableViewProxySet = this.getTableViewProxySet();
        Iterator tableViewProxySetIterator = tableViewProxySet.iterator();
        while (tableViewProxySetIterator.hasNext()) {
            TableViewProxyOracle tableViewProxyOracle = (TableViewProxyOracle)tableViewProxySetIterator.next();
            objectSets.add(tableViewProxyOracle.getTriggers());
        }
        objectSets.add(tableViewProxySet);
    }

    @Override
    public void sortCollections() {
        this.getTableProxySet().sort();
        this.getTableViewProxySet().sort();
        this.getIndexGlobalPartitionsListSet().sort();
        this.getIndexGlobalPartitionSet().sort();
        this.getSnapshotSet().sort();
        this.getDataFileSet().sort();
        this.getRedoLogGroupSet().sort();
        this.getDataBaseSet().sort();
        this.getUserSet().sort();
        this.getQuotaItemSet().sort();
        this.getTableSpaceSet().sort();
        this.getClusterSet().sort();
        this.getSegmentSet().sort();
        this.getPartitionListSet().sort();
        this.getPartitionSet().sort();
        this.getListPartitionSet().sort();
        this.getLobStorageSet().sort();
        this.getHashPartitionSet().sort();
        this.getHashPartitionLobItemSet().sort();
        this.getRoleSet().sort();
        this.getPermissionsSet().sort();
        this.getSequenceSet().sort();
        this.getClusterIndexSet().sort();
        this.getBitmapJoinIndexSet().sort();
        this.getClusterColumnSet().sort();
        this.getSynonymSet().sort();
        this.getTableCheckConstraintSet().sort();
        this.getTriggerSet().sort();
        this.getStoredProcedureSet().sort();
        this.getLevelSet().sort();
        this.getHierarchySet().sort();
        this.getDimensionSet().sort();
        this.getDimensionAttributeSet().sort();
        this.getContextSet().sort();
        this.getDirectorySet().sort();
        this.getTemporaryTablespaceSet().sort();
        this.getRollbackSegmentSet().sort();
        this.getListStorageTemplatePartitionSet().sort();
        this.getLocalIndexPropertiesSet().sort();
        this.getPackageSet().sort();
    }

    @Override
    public StorageObjectSet getUserSchemaSet() {
        return this.getUserSet();
    }

    public DataBaseOracle createDataBaseOracle() {
        return this.getDataBaseSet().createDataBase();
    }

    public TableSpaceOracle createTableSpaceOracle() {
        return this.getTableSpaceSet().createTableSpace();
    }

    public TemporaryTablespaceOracle createTemporaryTablespaceOracle() {
        return this.getTemporaryTablespaceSet().createTemporaryTablespace();
    }

    public UserOracle createUserOracle() {
        return this.getUserSet().createUser();
    }

    public ClusterOracle createClusterOracle() {
        return this.getClusterSet().createCluster();
    }

    public SegmentOracle createSegmentOracle() {
        return this.getSegmentSet().createSegment();
    }

    public SnapshotOracle createSnapshotOracle() {
        return this.getSnapshotSet().createSnapshot();
    }

    public RoleOracle createRoleOracle() {
        return this.getRoleSet().createRole();
    }

    public SequenceOracle createSequenceOracle() {
        return this.getSequenceSet().createSequence();
    }

    public SynonymOracle createSynonymOracle() {
        return this.getSynonymSet().createSynonym();
    }

    public DirectoryOracle createDirectoryOracle() {
        return this.getDirectorySet().createDirectory();
    }

    public TriggerOracle createTriggerOracle() {
        return this.getTriggerSet().createTrigger();
    }

    public StoredProcedureOracle createStoredProcedureOracle() {
        return this.getStoredProcedureSet().createStoredProcedure();
    }

    public DimensionOracle createDimensionOracle() {
        return this.getDimensionSet().createDimension();
    }

    public ContextOracle createContextOracle() {
        return this.getContextSet().createContext();
    }

    public UndoTablespaceOracle createUndoTablespaceOracle() {
        return this.getUndoTablespaceSet().createTablespace();
    }

    public ExternalTableOracle createExternalTableOracle() {
        return this.getExternalTableSet().createExternalTable();
    }

    @Override
    public List getMatchByNameSets() {
        ArrayList<BitmapJoinIndexSetOracle> list = new ArrayList<BitmapJoinIndexSetOracle>();
        list.add(this.getBitmapJoinIndexSet());
        return list;
    }

    @Override
    public String[] getFKDeleteRules() {
        return FKIndexAssociation.DELETE_RULES_ORACLE;
    }

    @Override
    public String[] getFKDeleteRulesMandatory() {
        return FKIndexAssociation.DELETE_RULES_WITHOUT_NULL_ORACLE;
    }

    @Override
    public String[] getFKDeleteRulesNonTransferable() {
        return FKIndexAssociation.DELETE_RULES_NOACTION_CASCADE;
    }

    @Override
    public String getValidFKRule(String fkRule) {
        if ("RESTRICT".equals(fkRule)) {
            return "NO ACTION";
        }
        if ("SET DEFAULT".equals(fkRule)) {
            return "NO ACTION";
        }
        return fkRule;
    }

    @Override
    public void parse(List<ModelIDObject> objects) {
        for (ModelIDObject obj : objects) {
            if (obj.isParsedForDependency()) continue;
            String sql = null;
            if (obj instanceof StorageObject) {
                sql = this.getSQL((StorageObject)obj);
            } else if (obj instanceof DesignObject) {
                sql = this.getSQL((DesignObject)obj);
            }
            if (sql != null) {
                if ((sql = sql.trim()).length() <= 0) continue;
                List<SQLAnalyzer.PDescriptor> list = SQLAnalyzer.getTablesAndFunctions(sql);
                this.processDependencies(obj, list, null);
                if (obj instanceof TableViewProxyOracle) {
                    List<ModelIDObject> dependOnList;
                    TableViewProxyOracle parentProxy;
                    TableView parentView;
                    TableView tableView = (TableView)((TableViewProxyOracle)obj).getObject();
                    if (!tableView.isBST() || tableView.getTypeSubstitution() == null || (parentView = (TableView)tableView.getTypeSubstitution().getParentContainerObject()) == null || (parentProxy = (TableViewProxyOracle)this.getTableViewProxySet().getProxy(parentView.getObjectID())) == null || (dependOnList = obj.getParsedDependOnList()).contains(parentProxy)) continue;
                    dependOnList.add(parentProxy);
                    continue;
                }
                if (!(obj instanceof PlSqlSourceStorageObjectOracle) && !(obj instanceof SnapshotOracle)) continue;
                obj.setParsedForDependency(true);
                continue;
            }
            if (!(obj instanceof TableProxyOracle)) continue;
            this.processDependencies(obj, Collections.EMPTY_LIST, null);
        }
    }

    private String getSQL(StorageObject sto) {
        if (sto instanceof TableProxyOracle) {
            Table table = (Table)((TableProxyOracle)sto).getObject();
            if (table.getShouldGenerateScript()) {
                return this.prepareScriptForParsing(table.getBeforeCreate()) + this.prepareScriptForParsing(table.getAfterCreate());
            }
            return null;
        }
        if (sto instanceof SnapshotOracle) {
            return ((SnapshotOracle)sto).getSubquery();
        }
        if (sto instanceof TableViewProxyOracle) {
            TableView tableView = (TableView)((TableViewProxyOracle)sto).getObject();
            String sql = tableView.isBST() ? tableView.getUserDefinedSQL() : ((TableViewProxyOracle)sto).getDefinition();
            if (tableView.getShouldGenerateScript()) {
                sql = sql.trim();
                StringBuffer sqlBuffer = new StringBuffer(sql);
                if (sql.length() > 0 && !sql.endsWith(";")) {
                    sqlBuffer.append(";");
                }
                sqlBuffer.append(this.prepareScriptForParsing(tableView.getBeforeCreate()));
                sqlBuffer.append(this.prepareScriptForParsing(tableView.getAfterCreate()));
                sql = sqlBuffer.toString();
            }
            return sql;
        }
        if (sto instanceof FunctionOracle || sto instanceof StoredProcedureOracle || sto instanceof PackageOracle) {
            return ((PlSqlSourceStorageObjectOracle)sto).getSource();
        }
        return null;
    }

    private String getSQL(DesignObject sto) {
        return null;
    }

    private String prepareScriptForParsing(String script) {
        String trimmedScript = script.trim();
        if (trimmedScript.length() > 0) {
            boolean doCommentCheck = true;
            while (doCommentCheck) {
                doCommentCheck = false;
                if (trimmedScript.endsWith("*/")) {
                    int startIndex = trimmedScript.lastIndexOf("/*");
                    if (startIndex <= -1) continue;
                    trimmedScript = trimmedScript.substring(0, startIndex).trim();
                    doCommentCheck = true;
                    continue;
                }
                int lastCommentStart = trimmedScript.lastIndexOf("--");
                if (lastCommentStart <= -1 || lastCommentStart <= trimmedScript.lastIndexOf(13) || lastCommentStart <= trimmedScript.lastIndexOf(10)) continue;
                trimmedScript = trimmedScript.substring(0, lastCommentStart).trim();
                doCommentCheck = true;
            }
            if (trimmedScript.length() > 0) {
                if (!trimmedScript.endsWith(";") && !trimmedScript.endsWith("/")) {
                    trimmedScript = trimmedScript + ";";
                }
                trimmedScript = trimmedScript + "\n";
            }
        }
        return trimmedScript;
    }

    @Override
    public void processDependencies(ModelIDObject obj, List<SQLAnalyzer.PDescriptor> dependencies, List<StructuredTypeProxy> refList) {
        if (obj instanceof StorageObject) {
            List<ModelIDObject> list = obj.getParsedDependOnList();
            list.clear();
            if (dependencies.size() > 0) {
                String owner = this.getOwnerName(obj.getLongName());
                for (SQLAnalyzer.PDescriptor descr : dependencies) {
                    SynonymOracle syn;
                    String objectName;
                    StorageObject dep = null;
                    String schema = descr.schema;
                    if (schema == null) {
                        schema = owner;
                    }
                    if (descr.type.equals("table")) {
                        dep = schema != null ? this.findBySchemaAndName(schema, descr.name, "table") : this.findByName(descr.name, "table");
                    } else if (descr.type.equals("function")) {
                        if (schema != null) {
                            if (descr.pack != null) {
                                dep = this.findBySchemaAndName(schema, descr.pack, "package");
                            } else {
                                dep = this.findBySchemaAndName(schema, descr.name, descr.type);
                                if (dep == null && descr.schema != null) {
                                    dep = owner != null ? this.findBySchemaAndName(owner, descr.schema, "package") : this.findByName(descr.schema, "package");
                                }
                            }
                        } else {
                            dep = this.findByName(descr.name, descr.type);
                        }
                    }
                    if (dep == null || list.contains(dep)) continue;
                    if (dep instanceof SynonymOracle && (objectName = (syn = (SynonymOracle)dep).getObject()) != null && !"".equals(objectName)) {
                        UserOracle user = syn.getObjectUser();
                        if (user == null) {
                            user = syn.getUser();
                        }
                        StorageObject synObject = null;
                        synObject = user != null ? this.findBySchemaAndName(user.getName(), objectName, descr.type) : this.findByName(objectName, descr.type);
                        if (synObject != null && !list.contains(synObject)) {
                            list.add(synObject);
                        }
                    }
                    list.add(dep);
                }
            }
            if (obj instanceof TableProxyOracle) {
                if (obj.isMarkedGenerate()) {
                    TableProxyOracle remoteTableProxy;
                    FKContainer remoteTable;
                    FKProxyOracle refConstraint;
                    PartitionListOracle partitionList;
                    TableProxyOracle tableProxy = (TableProxyOracle)obj;
                    if (tableProxy.getPartitioned().equalsIgnoreCase("YES") && (partitionList = tableProxy.getPartitionList()) instanceof PartitionListOraclev11g && partitionList.getPartitionType().equalsIgnoreCase("REFERENCE") && (refConstraint = ((PartitionListOraclev11g)partitionList).getRefConstraint()) != null && (remoteTable = refConstraint.getFKTable()) != null && (remoteTableProxy = (TableProxyOracle)this.getTableProxySet().getProxy(remoteTable.getObjectID())) != null && !list.contains(remoteTableProxy)) {
                        list.add(remoteTableProxy);
                    }
                    for (TableCheckConstraintOracle tableCheck : tableProxy.getTableCheckConstraints()) {
                        TableProxyOracle exceptionsTable = tableCheck.getExceptionsTable();
                        if (exceptionsTable == null || list.contains(exceptionsTable)) continue;
                        list.add(exceptionsTable);
                    }
                    ColumnProxy[] columnProxies = tableProxy.getColumnProxies();
                    for (int i = 0; i < columnProxies.length; ++i) {
                        ColumnProxy columnProxy = columnProxies[i];
                        TableProxyOracle exceptionsTable = ((ColumnProxyOracle)columnProxy).getExceptionsTable();
                        if (exceptionsTable == null || list.contains(exceptionsTable)) continue;
                        list.add(exceptionsTable);
                    }
                }
            } else if (obj instanceof StructuredTypeProxyOracle) {
                StructuredTypeProxyOracle structTypeProxy = (StructuredTypeProxyOracle)obj;
                StructuredTypeProxy parentType = structTypeProxy.getParentType();
                if (parentType != null) {
                    list.add(parentType);
                }
                for (TypeElementProxy typeElementProxy : structTypeProxy.getElements()) {
                    TypeElement typeElement = (TypeElement)typeElementProxy.getObject();
                    this.addTypeProxyToList(typeElement, list, refList, structTypeProxy);
                }
                for (MethodProxy methodProxy : structTypeProxy.getMethods()) {
                    for (MethodParamProxy methodParamProxy : methodProxy.getParams()) {
                        MethodParam methodParam = methodParamProxy.getMethodParam();
                        this.addTypeProxyToList(methodParam, list, refList, structTypeProxy);
                    }
                    MethodParam returnParam = methodProxy.getMethod().getReturnValue();
                    if (returnParam == null) continue;
                    this.addTypeProxyToList(returnParam, list, refList, structTypeProxy);
                }
            } else if (obj instanceof CollectionTypeProxyOracle) {
                CollectionTypeProxyOracle collTypeProxy = (CollectionTypeProxyOracle)obj;
                TypeElement typeElement = collTypeProxy.getCollectionType().getElementType();
                this.addTypeProxyToList(typeElement, list, refList, collTypeProxy);
            }
        }
    }

    private void addTypeProxyToList(DataTypeObject dataTypeObject, List list, List<StructuredTypeProxy> refList, RelationalObjectProxy excludedProxy) {
        RelationalObjectProxy dataTypeProxy = null;
        DesignObject dataType = dataTypeObject.getType();
        if (dataType instanceof StructuredType) {
            dataTypeProxy = this.getStructuredTypeProxySet().getProxy(dataType.getObjectID());
            if (dataTypeObject.isReference()) {
                if (refList != null && !refList.contains(dataTypeProxy)) {
                    refList.add((StructuredTypeProxy)dataTypeProxy);
                }
                dataTypeProxy = null;
            }
        } else if (dataType instanceof CollectionType) {
            dataTypeProxy = this.getCollectionTypeProxySet().getProxy(dataType.getObjectID());
        }
        if (dataTypeProxy != null && dataTypeProxy != excludedProxy && !list.contains(dataTypeProxy)) {
            list.add(dataTypeProxy);
        }
    }

    private StorageObject findBySchemaAndName(String schema, String name, String objectType) {
        StorageObject dep = null;
        if (this.getUserSet().getByName(schema) != null || this.getPhysicalDesign().getSchemaObjectSet().getByName(schema) != null) {
            if (objectType.equals("table")) {
                dep = this.getSnapshotSet().getBySchemaAndName(schema, name);
                if (dep == null && (dep = this.getTableViewProxySet().getBySchemaAndName(schema, name)) == null && (dep = this.getTableProxySet().getByUserSchemaAndName(schema, name)) == null) {
                    dep = this.getExternalTableSet().getByOwnerAndName(schema, name);
                }
            } else if (objectType.equals("function")) {
                dep = this.getFunctionSet().getByOwnerAndName(schema, name);
                if (dep == null) {
                    dep = this.getStoredProcedureSet().getByOwnerAndName(schema, name);
                }
            } else if (objectType.equals("package")) {
                dep = this.getPackageSet().getByOwnerAndName(schema, name);
            }
            if (dep == null) {
                dep = this.getSynonymSet().getByUserAndName(schema, name);
            }
        }
        return dep;
    }

    private StorageObject findByName(String name, String objectType) {
        StorageObject dep = null;
        if (objectType.equals("table")) {
            dep = (StorageObject)this.getSnapshotSet().getByName(name);
            if (dep == null && (dep = (StorageObject)this.getTableViewProxySet().getByName(name)) == null && (dep = (StorageObject)this.getTableProxySet().getByName(name)) == null) {
                dep = (StorageObject)this.getExternalTableSet().getByName(name);
            }
        } else if (objectType.equals("function")) {
            dep = (StorageObject)this.getFunctionSet().getByName(name);
            if (dep == null) {
                dep = (StorageObject)this.getStoredProcedureSet().getByName(name);
            }
        } else if (objectType.equals("package")) {
            dep = (StorageObject)this.getPackageSet().getByName(name);
        }
        if (dep == null) {
            dep = (StorageObject)this.getSynonymSet().getByName(name);
        }
        return dep;
    }

    private String getOwnerName(String longName) {
        int ind = longName.indexOf(46);
        if (ind > 0) {
            return longName.substring(0, ind);
        }
        return null;
    }

    public void migrateOlderExternalTables() {
        if (this.getExternalTableSet().size() > 0) {
            this.shouldCreateHiveUDPLibrary = false;
            ArrayList list = new ArrayList();
            this.getExternalTableSet().addAllElementsTo(list);
            for (ExternalTableOracle et : list) {
                TableProxyOracle tp = ((TableProxySetOracle)this.getTableProxySet()).getTP_UsingFromExternalTableID(et.getObjectID());
                if (tp != null) continue;
                Table table = this.getPhysicalDesign().createTable();
                this.copyExtTableToTable(et, table);
                tp = (TableProxyOracle)this.getStorageObject(table.getObjectID());
                if (tp != null) {
                    tp.setOrganization("EXTERNAL");
                    this.copyExtTableToProxyTable(et, tp);
                    tp.setFromExternalTableID(et.getObjectID());
                }
                this.setObjectListChanged(true);
                et.remove();
            }
            if (this.shouldCreateHiveUDPLibrary) {
                try {
                    if (this.getDesign() != null) {
                        MOHTable.createHiveUDPLibrary(this.getDesign());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void copyExtTableToTable(ExternalTableOracle ext, Table table) {
        String com;
        table.setName(ext.getName());
        UserOracle user = ext.getUser();
        if (user != null && user.getSchemaObject() != null) {
            table.setSchemaObject(user.getSchemaObject());
        }
        if ((com = ext.getComment()).length() < 4000) {
            table.setCommentInRDBMS(com);
        } else {
            table.setComment(com);
        }
        table.setTypeID("6");
        this.copyColumns(ext, table);
    }

    private void copyColumns(ExternalTableOracle ext, Table table) {
        for (ExternalTableColumnOracle ec : ext.getColumns()) {
            Column col = table.createColumn();
            col.setName(ec.getName());
            col.setCommentInRDBMS(ec.getCommentInRDBMS());
            this.copyLogicalType(ec, col);
        }
    }

    private void copyLogicalType(ExternalTableColumnOracle ec, Column col) {
        String dataType = ec.getDatatype();
        LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getRDBMSType(), dataType);
        if (logDatatype != null) {
            col.setUse((short)1);
            col.setLogicalDatatype(logDatatype);
            if (ec.isSizeAllowed(dataType)) {
                String units;
                String size = String.valueOf(ec.getSize());
                col.setDataTypeSize(size);
                if (ec.isUnitsAllowed(dataType) && !"".equals(units = ec.getUnits())) {
                    col.setDataTypeSize(size + " " + units.trim());
                }
            } else if (ec.isPrecisionAllowed(dataType)) {
                String prec = String.valueOf(ec.getPrecision());
                col.setDataTypePrecision(prec);
                if (ec.isScaleAllowed(dataType)) {
                    String scale = String.valueOf(ec.getScale());
                    col.setDataTypeScale(scale);
                }
            }
        }
    }

    private void copyExtTableToProxyTable(ExternalTableOracle ext, TableProxyOracle tp) {
        UserOracle user = ext.getUser();
        if (user != null && user.getSchemaObject() == null) {
            tp.setUser(user);
        }
        tp.setDefaultDir(ext.getDefaultDir());
        String driverType = ext.getAccessDriverType();
        tp.setAccessDriverType(driverType);
        tp.setAccessParametersType(ext.getAccessParametersType());
        String spec = ext.getOpaqueFormatSpec();
        spec = MOHExternalTableOraclev9i.processAndClearHiveAccessParams(tp, spec, driverType);
        if ("ORAcLE_HIVE".equalsIgnoreCase(driverType)) {
            this.shouldCreateHiveUDPLibrary = true;
        }
        tp.setOpaqueFormatSpec(spec);
        tp.setClobSubquery(ext.getClobSubquery());
        tp.setLocation(ext.getLocation());
        tp.setParallel(ext.getParallel());
        if (ext.getParallelNum() > 0) {
            tp.setDegree(String.valueOf(ext.getParallelNum()));
        }
        tp.setRejectLimit(ext.getRejectLimit());
        tp.setComment(ext.getComment());
        tp.setRawObject(ext.isRawObject());
    }

    public void migrateOldSnapshotQueries() {
        for (SnapshotOracle snapshot : this.getSnapshotSet()) {
            if (!snapshot.isSubqueryNeedsMigration()) continue;
            String subquery = snapshot.getSubquery();
            if (!subquery.isEmpty()) {
                Table table;
                TableProxyOracle tableProxy = snapshot.getOnPrebuildTable();
                if (tableProxy == null) {
                    tableProxy = snapshot.getImplementedTable();
                }
                if (tableProxy != null && (table = (Table)tableProxy.getObject()) != null && table.getUserDefinedSQL().isEmpty()) {
                    table.setUserDefinedSQL(subquery);
                    table.setOnPrebuiltTable(snapshot.getOnPrebuildTable() != null);
                    table.setMaterializedQueryTable(true);
                }
            }
            snapshot.setSubqueryNeedsMigration(false);
        }
    }

    public void generateSnapshots() {
        Iterator it = this.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyOracle tableProxy = (TableProxyOracle)it.next();
            Table table = (Table)tableProxy.getObject();
            if (!table.isMaterializedQueryTable() || tableProxy.getLocalMaterializedQueryTable()) continue;
            tableProxy.generateSnapshot();
        }
    }

    public void refreshSynonymReferences() {
        this.refreshLongNameMaps();
        SynonymSetOracle synonymSet = this.getSynonymSet();
        for (SynonymOracle synonymOracle : synonymSet) {
            if (synonymOracle.getReferredObjectID().length() == 0) {
                synonymOracle.fillReferedObjectID();
                continue;
            }
            synonymOracle.addSynonymToReferredObjectsSynonymSet();
        }
    }

    private void refreshLongNameMaps() {
        this.getTableProxySet().refreshLongNameMap();
        this.getTableViewProxySet().refreshLongNameMap();
        this.getSequenceSet().refreshLongNameMap();
        this.getStoredProcedureSet().refreshLongNameMap();
        this.getFunctionSet().refreshLongNameMap();
        this.getPackageSet().refreshLongNameMap();
        this.getSnapshotSet().refreshLongNameMap();
        this.getStructuredTypeProxySet().refreshLongNameMap();
        this.getCollectionTypeProxySet().refreshLongNameMap();
        this.getSynonymSet().refreshLongNameMap();
    }

    public StorageDesignOracleEstimates getStorageDesignOracleEstimates() {
        return this.storageDesignOracleEstimates;
    }

    public int getMaxNameLength(Class holderClass) {
        int maxLength = 30;
        NamingOptionsHolder namingOptionsHolder = this.getPhysicalDesign().getNamingOptionsHolderFor(holderClass);
        if (namingOptionsHolder != null && (maxLength = namingOptionsHolder.getMaxNameLength()) > 30) {
            maxLength = 30;
        }
        return maxLength;
    }

    static class PartitionComparator
    implements Comparator {
        PartitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (one instanceof PartitionOracle && two instanceof PartitionOracle) {
                if (((PartitionOracle)one).getPosition() > ((PartitionOracle)two).getPosition()) {
                    return 1;
                }
                if (((PartitionOracle)one).getPosition() < ((PartitionOracle)two).getPosition()) {
                    return -1;
                }
            }
            return 0;
        }
    }
}

