/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.MethodPropertyDialogOraclev9i;

public class MethodProxyOracle
extends MethodProxy {
    private String isStatic = "NO";
    private String implLanguage = "PL/SQL";
    private String PLSQLBody = "";
    private String javaName = "";
    private String cName = "";
    private String cLibrary = "";
    private String withContext = "NO";
    private String cPartemeters = "";
    private String pragmaClause = "";
    public static final String[] METHOD_TYPES = new String[]{"Function", "Procedure"};
    public static final String[] IMPL_LANGUAGES = new String[]{"PL/SQL", "Java", "C"};
    private static Set languagesSet = null;
    public static final String PL_SQL = "PL/SQL";
    public static final String JAVA = "Java";
    public static final String C = "C";

    public MethodProxyOracle(Method method, StorageDesign storageDesign) {
        super(method, storageDesign);
    }

    public MethodProxyOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public String getCLibrary() {
        return this.cLibrary;
    }

    public void setCLibrary(String library) {
        this.cLibrary = library;
        this.fireDataFieldChange();
    }

    public String getCName() {
        return this.cName;
    }

    public void setCName(String name) {
        this.cName = name;
        this.fireDataFieldChange();
    }

    public String getCPartemeters() {
        return this.cPartemeters;
    }

    public void setCPartemeters(String partemeters) {
        this.cPartemeters = partemeters;
        this.fireDataFieldChange();
    }

    public String getImplLanguage() {
        return this.implLanguage;
    }

    public void setImplLanguage(String implLanguage) {
        if (this.checkImplLanguage(implLanguage)) {
            this.implLanguage = implLanguage;
            this.fireDataFieldChange();
        }
    }

    public String getIsStatic() {
        return this.isStatic;
    }

    public void setIsStatic(String isStatic) {
        if (ConstantsOracle.checkYesNo(isStatic)) {
            this.isStatic = isStatic;
            this.fireDataFieldChange();
        }
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
        this.fireDataFieldChange();
    }

    public String getMethodType() {
        if (((Method)this.getObject()).getReturnValue() != null) {
            return METHOD_TYPES[0];
        }
        return METHOD_TYPES[1];
    }

    public String getPLSQLBody() {
        if (this.isBodyChanged()) {
            return this.PLSQLBody;
        }
        return this.getMethod().getBody();
    }

    public void setPLSQLBody(String body) {
        if (!body.equals(this.getMethod().getBody())) {
            this.PLSQLBody = body;
            this.setBodyChanged(true);
            this.fireDataFieldChange();
        } else {
            this.setBodyChanged(false);
        }
    }

    public String getPragmaClause() {
        return this.pragmaClause;
    }

    public void setPragmaClause(String pragmaClause) {
        this.pragmaClause = pragmaClause;
        this.fireDataFieldChange();
    }

    public String getWithContext() {
        return this.withContext;
    }

    public void setWithContext(String withContext) {
        if (ConstantsOracle.checkYesNo(withContext)) {
            this.withContext = withContext;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkImplLanguage(String value) {
        if (languagesSet == null) {
            languagesSet = new HashSet();
            languagesSet.addAll(Arrays.asList(IMPL_LANGUAGES));
        }
        return languagesSet.contains(value);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MethodPropertyDialogOraclev9i dialog = new MethodPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

