/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.NotNullConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.options.Settings;

public class ColumnProxyOracle
extends ColumnProxy {
    private int position = 0;
    private String defaultValue = "";
    private String deferrable = "NO";
    public static final String IMMEDIATE = "IMMEDIATE";
    public static final String DEFERRED = "DEFERRED";
    private static final String[] INITIALLY = new String[]{"IMMEDIATE", "DEFERRED"};
    private static Set initiallySet = null;
    private String initially = INITIALLY[0];
    private String enable = "YES";
    private String validate = "YES";
    private TableProxyOracle exceptionsTable = null;
    private NotNullConstraintOracle notNullConstraintOracle = null;
    private String nncInitially = INITIALLY[0];
    private String nncDeferrable = "NO";
    private String nncEnable = "YES";
    private String nncValidate = "YES";
    private String nncRely = "NO";
    private TableProxyOracle nncExceptionsTable = null;
    private String nncName = "";
    protected String withRowId = "NO";
    public static final String TRIGGER = "TRIGGER";
    private static final String[] AUTOINCREMENTDDL = new String[]{"", "NONE", "TRIGGER"};
    private String autoIncrementDDL = "";
    protected UserOracle autoIncrementUser;
    private boolean notNullConstraintNameChanged = false;
    private int maxLengthAsString = 0;

    public ColumnProxyOracle(Column column, StorageDesign storage) {
        super(column, storage);
    }

    public ColumnProxyOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public String getComments() {
        Column column = this.getColumn();
        return column.getComment();
    }

    public boolean getNullsAllowed() {
        Column column = this.getColumn();
        return column.getNullsAllowed();
    }

    public int getColno() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        return table.getIndexOf(column) + 1;
    }

    public String getCluster() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        TableProxyOracle tableProxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
        StringTokenizer st = new StringTokenizer(tableProxy.getClusterColumns(), ",");
        int count = 0;
        while (st.hasMoreTokens()) {
            ++count;
            if (!st.nextToken().trim().equalsIgnoreCase(column.getObjectID())) continue;
            this.position = count;
            return tableProxy.getCluster().getName();
        }
        this.position = 0;
        return "";
    }

    public TableProxyOracle getTableProxy() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        return (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
    }

    public int getPositionInCluster() {
        return this.position;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        this.fireChangeNoDirty(event);
    }

    public void setDefaultValue(String defaultValue) {
        String dval = this.getDefaultValue();
        if (dval != null && !dval.equals(defaultValue)) {
            this.defaultValue = defaultValue;
            this.fireDataFieldChange();
        }
    }

    public String getDefaultValue() {
        if (this.defaultValue == null || "".equalsIgnoreCase(this.defaultValue)) {
            return this.getColumn().getDefaultValue();
        }
        return this.defaultValue;
    }

    public static String[] getInitiallyChoices() {
        return INITIALLY;
    }

    protected boolean checkInitially(String value) {
        if (initiallySet == null) {
            initiallySet = new HashSet();
            initiallySet.addAll(Arrays.asList(ColumnProxyOracle.getInitiallyChoices()));
        }
        return initiallySet.contains(value);
    }

    public void setInitially(String initially) {
        if (this.checkInitially(initially)) {
            this.initially = initially;
            this.fireDataFieldChange();
        }
    }

    public String getInitially() {
        return this.initially;
    }

    public void setDeferrable(String deferrable) {
        if (ConstantsOracle.checkYesNo(deferrable)) {
            this.deferrable = deferrable;
            this.fireDataFieldChange();
        }
    }

    public String getDeferrable() {
        return this.deferrable;
    }

    public void setEnable(String enable) {
        if (ConstantsOracle.checkYesNo(enable)) {
            this.enable = enable;
            this.fireDataFieldChange();
        }
    }

    public String getEnable() {
        return this.enable;
    }

    public void setValidate(String validate) {
        if (ConstantsOracle.checkYesNo(validate)) {
            this.validate = validate;
            this.fireDataFieldChange();
        }
    }

    public String getValidate() {
        return this.validate;
    }

    public TableProxyOracle getExceptionsTable() {
        return this.exceptionsTable;
    }

    public void setExceptionsTable(TableProxyOracle exceptionsTable) {
        this.exceptionsTable = exceptionsTable;
        this.fireDataFieldChange();
    }

    public String getWithRowId() {
        return this.withRowId;
    }

    public void setWithRowId(String withRowId) {
        if (ConstantsOracle.checkYesNo(withRowId)) {
            this.withRowId = withRowId;
            this.fireDataFieldChange();
        }
    }

    @Override
    public int getMaxNameLength() {
        return ((StorageDesignOracle)this.getStorageDesign()).getMaxNameLength(Column.class);
    }

    public NotNullConstraintOracle getNotNullConstraintOracle() {
        return this.notNullConstraintOracle;
    }

    public void setNotNullConstraintOracle(NotNullConstraintOracle notNullConstraintOracle) {
        this.notNullConstraintOracle = notNullConstraintOracle;
        if (this.getTableProxyR() != null && notNullConstraintOracle != null) {
            this.getTableProxyR().addObject(notNullConstraintOracle);
        }
    }

    public String getNncDeferrable() {
        return this.nncDeferrable;
    }

    public void setNncDeferrable(String nncDeferrable) {
        if (ConstantsOracle.checkYesNo(nncDeferrable)) {
            this.nncDeferrable = nncDeferrable;
        }
    }

    public String getNncEnable() {
        return this.nncEnable;
    }

    public void setNncEnable(String nncEnable) {
        if (ConstantsOracle.checkYesNo(nncEnable)) {
            this.nncEnable = nncEnable;
        }
    }

    public TableProxyOracle getNncExceptionsTable() {
        return this.nncExceptionsTable;
    }

    public void setNncExceptionsTable(TableProxyOracle nncExceptionsTable) {
        this.nncExceptionsTable = nncExceptionsTable;
    }

    public String getNncInitially() {
        return this.nncInitially;
    }

    public void setNncInitially(String nncInitially) {
        if (this.checkInitially(nncInitially)) {
            this.nncInitially = nncInitially;
        }
    }

    public String getNncRely() {
        return this.nncRely;
    }

    public void setNncRely(String rely) {
        if (ConstantsOracle.checkYesNo(rely)) {
            this.nncRely = rely;
        }
    }

    public String getNncValidate() {
        return this.nncValidate;
    }

    public void setNncValidate(String nncValidate) {
        if (ConstantsOracle.checkYesNo(nncValidate)) {
            this.nncValidate = nncValidate;
        }
    }

    public String getNncName() {
        return this.nncName;
    }

    public void setNncName(String nncName) {
        this.nncName = nncName;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public String[] getAutoIncrementDDLChoices() {
        return AUTOINCREMENTDDL;
    }

    public String getDDLTypeForAutoIncCol() {
        String autoIncrementDDL = this.getAutoIncrementDDL();
        if (autoIncrementDDL.equals("")) {
            Settings settings = this.getAppView().getSettings();
            Column column = (Column)this.getObject();
            autoIncrementDDL = column.isIdentityColumn() ? settings.getDefaultOracleIdentityDDL() : settings.getDefaultOracleAutoIncDDL();
            if (!"NONE".equals(autoIncrementDDL)) {
                autoIncrementDDL = TRIGGER;
            }
        }
        return autoIncrementDDL;
    }

    public String getAutoIncrementDDL() {
        return this.autoIncrementDDL;
    }

    public void setAutoIncrementDDL(String autoIncrementDDL) {
        this.autoIncrementDDL = autoIncrementDDL;
    }

    public UserOracle getAutoIncrementUser() {
        return this.autoIncrementUser;
    }

    public void setAutoIncrementUser(UserOracle autoIncrementUser) {
        this.autoIncrementUser = autoIncrementUser;
    }

    public boolean isNotNullConstraintNameChanged() {
        return this.notNullConstraintNameChanged;
    }

    public void setNotNullConstraintNameChanged(boolean notNullConstraintNameChanged) {
        this.notNullConstraintNameChanged = notNullConstraintNameChanged;
    }

    public int getMaxLengthAsString() {
        if (this.maxLengthAsString == 0) {
            CollectionType st;
            Column col = (Column)this.getObject();
            if (col != null && col.getUse() == 3) {
                StructuredType st2 = col.getStructuredType();
                if (st2 != null) {
                    return st2.getMaxLengthAsString();
                }
            } else if (col != null && col.getUse() == 4 && (st = col.getCollectionType()) != null) {
                return st.getMaxLengthAsString();
            }
        }
        return this.maxLengthAsString;
    }

    public void setMaxLengthAsString(int maxLengthAsString) {
        if (maxLengthAsString > 0) {
            CollectionType st;
            Column col = (Column)this.getObject();
            if (col != null && col.getUse() == 3) {
                StructuredType st2 = col.getStructuredType();
                if (st2 != null && st2.getMaxLengthAsString() == maxLengthAsString) {
                    this.maxLengthAsString = 0;
                    return;
                }
            } else if (col != null && col.getUse() == 4 && (st = col.getCollectionType()) != null && st.getMaxLengthAsString() == maxLengthAsString) {
                this.maxLengthAsString = 0;
                return;
            }
        }
        this.maxLengthAsString = maxLengthAsString;
    }
}

