/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxySetDB2v80;
import oracle.dbtools.crest.swingui.editor.storage.db2.v80.TableSpacePropertyDialogDB2v80;

public class TableSpaceDB2v80
extends TableSpaceDB2 {
    private TableProxyDB2v80 partTable = null;

    public TableSpaceDB2v80(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public int getNumParts() {
        if (this.partTable != null) {
            return this.partTable.getNumParts();
        }
        return this.numParts;
    }

    public TableProxyDB2v80 getPartTable() {
        return this.partTable;
    }

    public void setPartTable(TableProxyDB2v80 partTable) {
        if (this.partTable != partTable) {
            this.partTable = partTable;
            if (partTable != null) {
                this.setMaxPartitionCount(this.getNumParts());
            } else {
                this.setMaxPartitionCount(0);
            }
            this.fireDataFieldChange();
        }
        if (this.partTable != null && !this.isPartitioned()) {
            this.type = "PARTITIONED";
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setPartIndex(IndexProxyDB2 partIndex) {
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableSpacePropertyDialogDB2v80 dialog = new TableSpacePropertyDialogDB2v80(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableSpaceDB2v80 tableSpace = null;
        StorageObject stObject = (StorageObject)((StorageDesignDB2v80)targetDesign).getTableSpaceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                tableSpace = (TableSpaceDB2v80)stObject;
            }
        } else {
            tableSpace = (TableSpaceDB2v80)((StorageDesignDB2v80)targetDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpace != null) {
            tableSpace.setName(this.getName());
            for (PartitionDB2 partition : this.getPartitionsList()) {
                PartitionDB2 targetPartition = (PartitionDB2)((StorageDesignDB2v80)targetDesign).getPartitionSet().getByName(partition.getName());
                if (targetPartition == null) {
                    PartitionDB2 newPartition = ((StorageDesignDB2v80)targetDesign).getPartitionSet().createPartition();
                    newPartition.setName(partition.getName());
                    newPartition.setTableSpace(tableSpace);
                    newPartition.setRawObject(true);
                    ((StorageDesignDB2v80)targetDesign).getPartitionSet().add(newPartition);
                    tableSpace.getPartitionsList().add(newPartition);
                    continue;
                }
                targetPartition.setTableSpace(tableSpace);
                ((StorageDesignDB2v80)targetDesign).getPartitionSet().add(targetPartition);
                tableSpace.getPartitionsList().add(targetPartition);
            }
            tableSpace.setType(this.getType());
            tableSpace.setClustered(this.getClustered());
            if (this.getDataBase() != null) {
                DataBaseDB2 database = (DataBaseDB2)((StorageDesignDB2v80)targetDesign).getDataBaseSet().getByName(this.getDataBase().getName());
                if (database == null) {
                    DataBaseDB2 newDataBase = ((StorageDesignDB2v80)targetDesign).getDataBaseSet().createDataBase();
                    newDataBase.setName(this.getDataBase().getName());
                    newDataBase.setRawObject(true);
                    tableSpace.setDataBase(newDataBase);
                } else {
                    tableSpace.setDataBase(database);
                }
            }
            if (this.getStorageTemplate() != null) {
                StorageTemplateDB2 stTemplate = (StorageTemplateDB2)((StorageDesignDB2v80)targetDesign).getStorageTemplateSet().getByName(this.getStorageTemplate().getName());
                if (stTemplate == null) {
                    StorageTemplateDB2 newStorageTempl = ((StorageDesignDB2v80)targetDesign).getStorageTemplateSet().createStorageTemplate();
                    newStorageTempl.setName(this.getStorageTemplate().getName());
                    newStorageTempl.setRawObject(true);
                    tableSpace.setStorageTemplate(newStorageTempl);
                } else {
                    tableSpace.setStorageTemplate(stTemplate);
                }
            }
            tableSpace.setLobLogging(this.isLobLogging());
            tableSpace.setDsSize(this.getDsSize());
            tableSpace.setSegSize(this.getSegSize());
            if (this.getPartTable() != null) {
                TableProxyDB2v80 table = (TableProxyDB2v80)((TableProxySetDB2v80)((StorageDesignDB2v80)targetDesign).getTableProxySet()).getByName(this.getPartTable().getName());
                if (table == null) {
                    TableProxyDB2v80 newTable = (TableProxyDB2v80)((TableProxySetDB2v80)((StorageDesignDB2v80)targetDesign).getTableProxySet()).createProxy(this.getPartTable().getObject());
                    newTable.setName(this.getPartTable().getName());
                    newTable.setRawObject(true);
                    tableSpace.setPartTable(newTable);
                } else {
                    tableSpace.setPartTable(table);
                }
            }
            tableSpace.setNumParts(this.getNumParts());
            if (this.getBufferPool() != null) {
                BufferPoolDB2 targetBufferPool = (BufferPoolDB2)((StorageDesignDB2v80)targetDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (targetBufferPool == null) {
                    BufferPoolDB2 newBuffPool = (BufferPoolDB2)((StorageDesignDB2v80)targetDesign).getBufferPoolSet().createElement(null);
                    newBuffPool.setName(this.getBufferPool().getName());
                    newBuffPool.setRawObject(true);
                    tableSpace.setBufferPool(newBuffPool);
                } else {
                    tableSpace.setBufferPool(targetBufferPool);
                }
            }
            tableSpace.setLockSize(this.getLockSize());
            tableSpace.setLockMax(this.getLockMax());
            tableSpace.setClose(this.isClose());
            tableSpace.setCompress(this.isCompress());
            tableSpace.setCcsid(this.getCcsid());
            tableSpace.setLockPart(this.isLockPart());
            tableSpace.setMaxRows(this.getMaxRows());
            tableSpace.recreateUserSet(this.getUserSet().toString());
            tableSpace.setGrantOption(this.getGrantOption());
            tableSpace.setComment(this.getComment());
            tableSpace.setRawObject(false);
        }
    }
}

