/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.SynonymPropertyDialogDB2;

public class SynonymDB2
extends AbstractStorageObjectDB2 {
    private OwnedObjectImpl owner;
    private TableProxyDB2 table;
    private TableViewProxyDB2 view;
    private AliasDB2 alias;
    public static final String TYPE_NAME = "Synonym";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "SYN";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SynonymPropertyDialogDB2 dialog = new SynonymPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.owner == null) {
            this.owner = new OwnedObjectImpl();
            this.owner.setOwnerSet(this.getStorageDesignDB2().getOwnerSet());
        }
        return this.owner;
    }

    public AliasDB2 getAlias() {
        return this.alias;
    }

    public void setAlias(AliasDB2 alias) {
        if (alias != null) {
            this.table = null;
            this.view = null;
            this.alias = alias;
            this.setPAC_Element(alias);
            this.fireDataFieldChange();
        }
    }

    public TableProxyDB2 getTable() {
        return this.table;
    }

    public void setTable(TableProxyDB2 table) {
        if (table != null) {
            this.table = table;
            this.setPAC_Element(table);
            this.view = null;
            this.alias = null;
            this.fireDataFieldChange();
        }
    }

    public TableViewProxyDB2 getView() {
        return this.view;
    }

    public void setView(TableViewProxyDB2 view) {
        if (view != null) {
            this.view = view;
            this.setPAC_Element(view);
            this.table = null;
            this.alias = null;
            this.fireDataFieldChange();
        }
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            if (this.getTable() != null) {
                return this.getTable().isDropEnabled() || this.getTable().shouldBeDroppedIndirectly();
            }
            if (this.getView() != null) {
                return this.getView().isDropEnabled() || this.getView().shouldBeDroppedIndirectly();
            }
        }
        return false;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        SynonymDB2 synonym = null;
        StorageObject stObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getSynonymSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                synonym = (SynonymDB2)stObject;
            }
        } else {
            synonym = ((AbstractStorageDesignDB2)targetDesign).getSynonymSet().createSynonym();
        }
        if (synonym != null) {
            synonym.setName(this.getName());
            if (this.getOwner() != null) {
                Owner targetOwner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (targetOwner == null) {
                    Owner newOwner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    synonym.setOwner(newOwner);
                } else {
                    synonym.setOwner(targetOwner);
                }
            }
            synonym.setComment(this.getComment());
            synonym.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SYNONYM_ICON", 16);
    }
}

