/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public abstract class SequenceDB2
extends AbstractStorageObjectDB2
implements OwnedObject,
PropertiesPropagator {
    protected OwnedObjectImpl owner;
    protected String datatype = "INTEGER";
    protected int startWith = 1;
    protected int incrementBy = 1;
    protected String maxValue = "NO";
    protected String minValue = "NO";
    protected String cycle = YES_NO_STATES[1];
    protected int cache = 20;
    protected String order = YES_NO_STATES[1];
    protected static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List propertyWrapperList = null;
    public static final String TYPE_NAME = "Sequence";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(SequenceDB2.getYesNoChoices()));
        }
        return yesNoSet.contains(value);
    }

    public int getCache() {
        return this.cache;
    }

    public void setCache(int cache) {
        if (cache != 1) {
            this.cache = cache;
            this.fireDataFieldChange();
        }
    }

    public String getCycle() {
        return this.cycle;
    }

    public void setCycle(String cycle) {
        if (this.checkYesNo(cycle)) {
            this.cycle = cycle;
            this.fireDataFieldChange();
        }
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
        this.fireDataFieldChange();
    }

    public int getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(int incrementBy) {
        if (incrementBy >= 1 && this.incrementBy != incrementBy) {
            this.incrementBy = incrementBy;
            this.fireDataFieldChange();
        }
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        if (maxValue != null && maxValue.equals(this.maxValue)) {
            return;
        }
        this.maxValue = maxValue;
        this.fireDataFieldChange();
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        if (minValue != null && minValue.equals(this.minValue)) {
            return;
        }
        this.minValue = minValue;
        this.fireDataFieldChange();
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        if (this.checkYesNo(order)) {
            this.order = order;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.owner == null) {
            this.owner = new OwnedObjectImpl();
            this.owner.setOwnerSet(((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet());
        }
        return this.owner;
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        Owner owner;
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!(isLongName || this.getOwner() == null || this.getOwner().isNullInstance() || (owner = this.getOwner()).isNullInstance())) {
            name = owner.getSchemaObject() != null ? owner.getSchemaObject().getName() + '.' + name : owner.getName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    public int getStartWith() {
        return this.startWith;
    }

    public void setStartWith(int startWith) {
        if (this.startWith != startWith) {
            this.startWith = startWith;
            this.fireDataFieldChange();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getOwner", "setOwner", Owner.class));
            this.propertyWrapperList.add(new PropertyWrapper("Data Type", this, "getDatatype", "setDatatype", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Start with", this, "getStartWith", "setStartWith", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Increment by", this, "getIncrementBy", "setIncrementBy", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Min Value", this, "getMinValue", "setMinValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Max Value", this, "getMaxValue", "setMaxValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cycle", this, "getCycle", "setCycle", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cache", this, "getCache", "setCache", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Order", this, "getOrder", "setOrder", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SEQUENCE_ICON", 16);
    }
}

