/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsDB2;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.OwnerPropertyDialogDB2;

public class Owner
extends StorageObject {
    private String systemPrivileges = "";
    private PrivilegesSet systemPrivilegesSet = null;
    private static final String[] PRIVILEGES = new String[]{"ARCHIVE", "BINDADD", "BINDAGENT", "BSDS", "CREATEALIAS", "CREATEDBA", "CREATEDBC", "CREATESG", "CREATEMTAB", "DISPLAY", "MONITOR1", "MONITOR2", "RECOVER", "STOPALL", "STOSPACE", "SYSADMIN", "SYSCTRL", "SYSOPR", "TRACE"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    public static final String NAME_SUBSTITUTION_TYPE = "Owner";
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "Owner";

    @Override
    public String getIDPrefix() {
        return "Owner";
    }

    @Override
    public String getObjectTypeName() {
        return "Owner";
    }

    private void addSystemPrivileges(String systemPrivileges) {
        if (!this.getSystemPrivilegesSet().contains(systemPrivileges)) {
            this.getSystemPrivilegesSet().add(systemPrivileges);
        }
    }

    private void recreateSystemPrivilegesSet(String privileges) {
        this.getSystemPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        this.systemPrivilegesSet = new PrivilegesSet();
        while (st.hasMoreTokens()) {
            String privilege = st.nextToken().trim();
            if (!this.checkPrivileges(privilege)) continue;
            this.getSystemPrivilegesSet().add(privilege);
        }
    }

    public void setSystemPrivileges(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(privilege);
        } else if (this.checkPrivileges(privilege)) {
            this.addSystemPrivileges(privilege);
        }
        this.systemPrivileges = this.getSystemPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public PrivilegesSet getSystemPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new PrivilegesSet();
        }
        return this.systemPrivilegesSet;
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    protected boolean checkPrivileges(String value) {
        return PRIVILEGESLIST.contains(value);
    }

    public void clear() {
        this.getSystemPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(Owner.getYesNoChoices()));
        }
        return yesNoSet.contains(value);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String grantOption) {
        if (grantOption != null && grantOption.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(grantOption)) {
            this.grantOption = grantOption;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            OwnerPropertyDialogDB2 dialog = new OwnerPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Owner owner = null;
        StorageObject stObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                owner = (Owner)stObject;
            }
        } else {
            owner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().createElement(null);
        }
        if (owner != null) {
            owner.setName(this.getName());
            owner.recreateSystemPrivilegesSet(this.getSystemPrivilegesSet().toString());
            owner.setGrantOption(this.getGrantOption());
            owner.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("USER_ICON", 16);
    }

    private List getPermissions() {
        ArrayList<PermissionsDB2> list = new ArrayList<PermissionsDB2>();
        for (PermissionsDB2 perm : ((AbstractStorageDesignDB2)this.getStorageDesign()).getPermissionsSet()) {
            if (perm.getUser() != this) continue;
            list.add(perm);
        }
        return list;
    }

    public List getSortedByIDPermisions() {
        List list = this.getPermissions();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    private List getDBPrivileges() {
        ArrayList<PrivilegesDB2> list = new ArrayList<PrivilegesDB2>();
        for (PrivilegesDB2 priv : ((AbstractStorageDesignDB2)this.getStorageDesign()).getPrivilegesSet()) {
            if (priv.getUser() != this) continue;
            list.add(priv);
        }
        return list;
    }

    public List getSortedByID_DBPrivileges() {
        List list = this.getDBPrivileges();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    public PermissionsDB2 createPermission() {
        PermissionsDB2 perm = ((AbstractStorageDesignDB2)this.getStorageDesign()).getPermissionsSet().createPermissions();
        perm.setUser(this);
        return perm;
    }

    public PrivilegesDB2 createDBPrivilege() {
        PrivilegesDB2 priv = ((AbstractStorageDesignDB2)this.getStorageDesign()).getPrivilegesSet().createPriv();
        priv.setUser(this);
        return priv;
    }

    @Override
    public String getNameSubstitutionType() {
        return "Owner";
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object one, Object two) {
            return String.valueOf(one).compareTo(String.valueOf(two));
        }
    }

    public class PrivilegesSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

