/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.swingui.editor.storage.db2.ColumnPropertyDialogDB2;

public class ColumnProxyDB2
extends ColumnProxy {
    private static String[] bitDataChoices = new String[]{"", "SBCS", "BIT", "MIXED"};
    private static Set bitDataChoicesSet = null;
    private String bitData = bitDataChoices[0];
    private boolean containDefault = false;
    private static String[] defaultValueChoices = new String[]{"", "constant", "USER", "CURRENT SQLID", "CAST FUNCTION"};
    private String defaultValue = defaultValueChoices[0];
    private String defaultConstant = "";
    private String label = "";
    private String program = "";
    private String constant = "";
    private float updatRatePercent = 0.0f;
    private float averageLength = -1.0f;
    private float growthPercent = 0.0f;
    private long initial = 1L;
    private long frequencyCount = 1L;
    private float frequencyPercent = 0.0f;
    protected ColumnIdentityDB2 identity = null;
    private boolean useIdentity = true;

    public ColumnProxyDB2(Column column, StorageDesign storage) {
        super(column, storage);
    }

    public ColumnProxyDB2(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public int getColno() {
        Column column = (Column)this.getObject();
        Table table = (Table)column.getContainer();
        return table.getIndexOf(column) + 1;
    }

    public int getKeyseq() {
        Column column = (Column)this.getObject();
        ContainerWithKeyObject key = column.getContainerWithKeyObject();
        KeyObject pk = key.getPK();
        if (pk != null && pk.getIndexOf(column) != -1) {
            return pk.getIndexOf(column) + 1;
        }
        return 0;
    }

    public static String[] getBitDataChoices() {
        return bitDataChoices;
    }

    protected boolean checkBitData(String value) {
        if (bitDataChoicesSet == null) {
            bitDataChoicesSet = new HashSet();
            bitDataChoicesSet.addAll(Arrays.asList(ColumnProxyDB2.getBitDataChoices()));
        }
        return bitDataChoicesSet.contains(value);
    }

    public void setBitData(String value) {
        if (this.checkBitData(value)) {
            this.bitData = value;
            this.fireDataFieldChange();
        }
    }

    public String getBitData() {
        return this.bitData;
    }

    public void setDefault(boolean value) {
        this.containDefault = value;
        this.fireDataFieldChange();
    }

    public boolean getDefault() {
        return this.containDefault;
    }

    public static String[] getDefaultValueChoices() {
        return defaultValueChoices;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
        this.fireDataFieldChange();
    }

    public void setDefaultValueConstant(String value) {
        this.defaultConstant = value;
        this.fireDataFieldChange();
    }

    public String getDefaultValueConstant() {
        if ((this.defaultConstant == null || "".equalsIgnoreCase(this.defaultConstant)) && this.isLoaded()) {
            this.defaultConstant = this.getColumn().getDefaultValue();
            this.fireDataFieldChange();
        }
        return this.defaultConstant;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setLabel(String value) {
        this.label = value;
        this.fireDataFieldChange();
    }

    public String getLabel() {
        return this.label;
    }

    public void setProgram(String value) {
        this.program = value;
        this.fireDataFieldChange();
    }

    public String getProgram() {
        return this.program;
    }

    public void setConstant(String value) {
        this.constant = value;
        this.fireDataFieldChange();
    }

    public String getConstant() {
        return this.constant;
    }

    public boolean checkUpdateRatePercent(float value) {
        return value >= 0.0f && value < 10000.0f;
    }

    public void setUpdateRatePercent(float value) {
        if (this.checkUpdateRatePercent(value)) {
            this.updatRatePercent = value;
            this.fireDataFieldChange();
        }
    }

    public float getUpdateRatePercent() {
        return this.updatRatePercent;
    }

    public boolean checkAverageLength(float value) {
        return value >= -1.0f && value <= 32704.0f;
    }

    public void setAverageLength(float value) {
        if (this.checkAverageLength(value)) {
            this.averageLength = value;
            this.fireDataFieldChange();
        }
    }

    public float getAverageLength() {
        return this.averageLength;
    }

    public boolean checkGrowthPercent(float value) {
        return value >= 0.0f && value <= 100.0f;
    }

    public void setGrowthPercent(float value) {
        if (this.checkGrowthPercent(value)) {
            this.growthPercent = value;
            this.fireDataFieldChange();
        }
    }

    public float getGrowthPercent() {
        return this.growthPercent;
    }

    public boolean checkInitial(long value) {
        return value >= 1L && value <= 0xFFFFFFFEL;
    }

    public void setInitial(long value) {
        if (this.checkInitial(value)) {
            this.initial = value;
            this.fireDataFieldChange();
        }
    }

    public long getInitial() {
        return this.initial;
    }

    public boolean checkFrequencyCount(long value) {
        return value >= 1L && value <= 0xFFFFFFFEL;
    }

    public void setFrequencyCount(long value) {
        if (this.checkFrequencyCount(value)) {
            this.frequencyCount = value;
            this.fireDataFieldChange();
        }
    }

    public long getFrequencyCount() {
        return this.frequencyCount;
    }

    public boolean checkFrequencyPercent(float value) {
        return value >= 0.0f && value <= 100.0f;
    }

    public void setFrequencyPercent(float value) {
        if (this.checkFrequencyPercent(value)) {
            this.frequencyPercent = value;
            this.fireDataFieldChange();
        }
    }

    public float getFrequencyPercent() {
        return this.frequencyPercent;
    }

    public ColumnIdentityDB2 getColumnIdentity() {
        return this.identity;
    }

    public void setColumnIdentity(ColumnIdentityDB2 identity) {
        if (!(identity == null && this.getStorageDesign().isLoading() || this.identity == identity)) {
            this.identity = identity;
            if (identity != null) {
                identity.setColumn(this);
            }
            this.fireDataFieldChange();
        }
    }

    public boolean isUseIdentity() {
        return this.useIdentity;
    }

    public void setUseIdentity(boolean useIdentity) {
        this.useIdentity = useIdentity;
    }

    public DistinctTypeDB2 getDistinctType() {
        if (this.getColumn().getUse() == 0) {
            Domain dom = this.getColumn().getDomain();
            DistinctTypeSetDB2 types = ((AbstractStorageDesignDB2)this.getStorageDesign()).getDistinctTypeSet();
            return types.getDistinctType(dom);
        }
        return null;
    }

    @Override
    public String getDatatypeString() {
        Column column = this.getColumn();
        if (column.isOid() || column.isReference()) {
            return "DECIMAL(31 , 0)";
        }
        return this.getDataType().toString();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogDB2 dialog = new ColumnPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void changed(DesignObject obj, ObjectChangeEvent event) {
        super.changed(obj, event);
        if (event.isType(ObjectChangeEvent.USE_DEFAULT_CHANGED) && obj == this.getColumn()) {
            this.setDefault(this.getColumn().getUsesDefaultValue());
        }
    }

    public ColumnIdentityDB2 createColumnIdentity() {
        if (this.identity == null) {
            this.identity = ((StorageDesignDB2v70)this.getStorageDesign()).getColumnIdentitySet().createColumnIdentity();
        }
        return this.identity;
    }

    public void removeColumnIdentity() {
        if (this.identity != null) {
            this.identity.remove(true);
        }
        this.identity = null;
    }
}

