/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalContainerProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public class IndexProxy
extends RelationalContainerProxy {
    private boolean clustered = false;
    private boolean partitioned = false;
    private boolean markGenerateIfFK = true;
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    public static final String TYPE_NAME = "Index";

    public IndexProxy(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxy(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public boolean isIndex() {
        return true;
    }

    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public boolean isUnique() {
        return this.getIndex().isUnique();
    }

    public void setClustered(boolean value) {
        this.clustered = value;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setMarkGenerateIfFK(boolean generate) {
        this.markGenerateIfFK = generate;
    }

    public boolean getMarkGenerateIfFK() {
        return this.markGenerateIfFK;
    }

    public Index getIndex() {
        return (Index)this.getObject();
    }

    public Table getTable() {
        return (Table)this.getIndex().getContainerObject();
    }

    public TableProxy getTableProxy() {
        return (TableProxy)this.getStorageDesign().getTableProxySet().getProxy(this.getTable().getObjectID());
    }

    @Override
    public ColumnProxy[] getColumnProxies() {
        return super.getColumnProxies();
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean commentChanged) {
        this.commentChanged = commentChanged;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean commentInRDBMSChanged) {
        this.commentInRDBMSChanged = commentInRDBMSChanged;
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getTableProxy().isDropEnabled() || this.getTableProxy().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        Table table;
        if (this.pac_Element == null && (table = this.getTable()) != null) {
            StorageObject obj = this.getStorageDesign().getStorageObject(table.getObjectID());
            if (obj == null) {
                this.getStorageDesign().getTableProxySet().getObjectGeneratedBy(table);
            }
            if (obj != null && obj instanceof TableProxy) {
                this.setPAC_Element(obj);
            }
        }
        return super.getPAC_Element();
    }
}

