/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.editor.process.ProcessPropertiesDialogEx;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class Process
extends Transformation
implements SetListener,
EditableFonts {
    public static final String[] FREQUENCY_TIME_UNITS_DISPLAY = new String[]{Messages.getString("Process.Second"), Messages.getString("Process.Minute"), Messages.getString("Process.Hour"), Messages.getString("Process.Day"), Messages.getString("Process.Week"), Messages.getString("Process.Month"), Messages.getString("Process.Quarter"), Messages.getString("Process.HalfYear"), Messages.getString("Process.Year")};
    public static final String[] FREQUENCY_TIME_UNITS = new String[]{"Second", "Minute", "Hour", "Day", "Week", "Month", "Quarter", "Half Year", "Year"};
    public static final String[] BATCH_TIME_UNITS_DISPLAY = new String[]{Messages.getString("Process.Second"), Messages.getString("Process.Minute"), Messages.getString("Process.Hour"), Messages.getString("Process.Day")};
    public static final String[] BATCH_TIME_UNITS = new String[]{"Second", "Minute", "Hour", "Day"};
    public static final String[] INTERACTIVE_RESPONSE_TIME_UNITS_DISPLAY = new String[]{Messages.getString("Process.Second"), Messages.getString("Process.Minute")};
    public static final String[] INTERACTIVE_RESPONSE_TIME_UNITS = new String[]{"Second", "Minute"};
    public static final String[] PRIORITY_DISPLAY = new String[]{Messages.getString("Process.None"), Messages.getString("Process.Low"), Messages.getString("Process.Medium"), Messages.getString("Process.High")};
    public static final String[] PRIORITY = new String[]{"None", "Low", "Medium", "High"};
    public static final String[] MODES_DISPLAY = new String[]{Messages.getString("Process.Unknown"), Messages.getString("Process.Batch"), Messages.getString("Process.Interactive"), Messages.getString("Process.Manual")};
    public static final String[] MODES = new String[]{"Unknown", "Batch", "Interactive", "Manual"};
    public static final String[] PROCESS_TYPE_NAMES = new String[]{Messages.getString("Process.TypePrimitive"), Messages.getString("Process.TypeComposite"), Messages.getString("Process.TypeUseTransformationTask")};
    public static final int USE_TRANSFORMATION_TASK_TYPE = 2;
    private int type = 0;
    private DataFlowDesign diagram;
    private String footNote = "";
    private int frequencyTimes = 0;
    private String frequencyTimeUnit = FREQUENCY_TIME_UNITS[3];
    private String priority = PRIORITY[1];
    private String mode = MODES[0];
    private int batchMinimumTransactions = 1000;
    private String batchTimeUnit = BATCH_TIME_UNITS[0];
    private int interactiveLongestResponseTime = 5;
    private String interactiveResponseTimeUnit = INTERACTIVE_RESPONSE_TIME_UNITS[0];
    private boolean[] peakPeriods = new boolean[24];
    private List events = new ArrayList();
    private TransformationTask transformationTask;
    private List paramsWrappers = new ArrayList();
    private String paramsWrappersString = "";
    private boolean paramsWrappersPreset = false;
    private List editableFonts = new ArrayList();
    public static final String TYPE_NAME = "Process";

    public Process(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
    }

    public void initDiagram() {
        if (this.diagram == null) {
            this.diagram = this.getDesign().getProcessModel().addDataFlowDesign(null, false);
            this.diagram.setName(MessageFormat.format(Messages.getString("Process.Diagram"), this.getName()));
            this.diagram.setProcess(this);
            this.diagram.setDirty(true);
            this.fireChange(ObjectChangeEvent.PROCESS_DECOMPOSED);
        }
    }

    public void clearDiagram() {
        if (this.diagram != null) {
            ((DataFlowDesign)this.getDesignPart()).getProcessModel().removeDataFlowDesign(this.diagram);
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isLeaf() {
        return this.type == 0;
    }

    @Override
    public int getNumberOfChildren() {
        return this.diagram != null ? 1 : 0;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == 0 && this.diagram != null) {
            return this.diagram;
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.diagram) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "PRO";
    }

    public int getBatchMinimumTransactions() {
        return this.batchMinimumTransactions;
    }

    public void setBatchMinimumTransactions(int batchMinimumTransactions) {
        this.batchMinimumTransactions = batchMinimumTransactions;
    }

    public String getBatchTimeUnit() {
        return this.batchTimeUnit;
    }

    public void setBatchTimeUnit(String batchTimeUnit) {
        this.batchTimeUnit = batchTimeUnit;
    }

    public String getFootNote() {
        return this.footNote;
    }

    public void setFootNote(String footNote) {
        this.footNote = footNote;
    }

    public int getFrequencyTimes() {
        return this.frequencyTimes;
    }

    public void setFrequencyTimes(int frequencyTimes) {
        this.frequencyTimes = frequencyTimes;
    }

    public String getFrequencyTimeUnit() {
        return this.frequencyTimeUnit;
    }

    public void setFrequencyTimeUnit(String frequencyTimeUnit) {
        this.frequencyTimeUnit = frequencyTimeUnit;
    }

    public int getInteractiveLongestResponseTime() {
        return this.interactiveLongestResponseTime;
    }

    public void setInteractiveLongestResponseTime(int interactiveLongestResponseTime) {
        this.interactiveLongestResponseTime = interactiveLongestResponseTime;
    }

    public String getInteractiveResponseTimeUnit() {
        return this.interactiveResponseTimeUnit;
    }

    public void setInteractiveResponseTimeUnit(String interactiveResponseTimeUnit) {
        this.interactiveResponseTimeUnit = interactiveResponseTimeUnit;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public boolean[] getPeakPeriods() {
        return this.peakPeriods;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public String getProcessTypeName() {
        return PROCESS_TYPE_NAMES[this.type];
    }

    public void setType(int type) {
        if (type == 1) {
            this.type = type;
            this.setTransformationTask(null);
            if (!this.getDesign().isLoading()) {
                this.initDiagram();
                this.addConnectedToComposite();
            }
        } else if (type == 0) {
            this.type = type;
            this.setTransformationTask(null);
        } else if (type == 2) {
            this.type = type;
        }
    }

    public DataFlowDesign getDiagram() {
        return this.diagram;
    }

    public void setDiagram(DataFlowDesign diagram) {
        this.diagram = diagram;
        if (diagram != null) {
            diagram.setProcess(this);
        }
        if (diagram == null) {
            this.fireChange(ObjectChangeEvent.PROCESS_DIAGRAM_REMOVED);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ProcessPropertiesDialogEx dialog = new ProcessPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
    }

    public void clearEvents(Process process) {
        Iterator it = this.events.iterator();
        while (it.hasNext()) {
            ((Event)it.next()).removeProcess(process);
        }
        this.events.clear();
    }

    public List getFlowEvents() {
        ArrayList<Event> list = new ArrayList<Event>();
        List flows = this.getIncomingFlows();
        for (Flow flow : flows) {
            if (flow.getEvent() == null || list.contains(flow.getEvent())) continue;
            list.add(flow.getEvent());
        }
        return list;
    }

    public List getAllEvents() {
        ArrayList list = new ArrayList();
        list.addAll(this.getEvents());
        list.addAll(this.getFlowEvents());
        return list;
    }

    public List getEvents() {
        return this.events;
    }

    public void addEvent(Event event) {
        if (event != null && !this.events.contains(event)) {
            this.events.add(event);
            event.addProcess(this);
        }
    }

    public void removeEvent(Event event) {
        this.events.remove(event);
    }

    public Event getEventByID(String id) {
        for (Event ev : this.events) {
            if (!ev.getObjectID().equals(id)) continue;
            return ev;
        }
        return null;
    }

    @Override
    public List getInfoStructures() {
        ArrayList<InfoStructure> result = new ArrayList<InfoStructure>();
        for (int i = 0; i < this.getAllFlows().length; ++i) {
            Flow flow = this.getAllFlows()[i].getFlow();
            for (InfoStructure structure : flow.getInfoStructures()) {
                if (result.contains(structure)) continue;
                result.add(structure);
            }
        }
        return result;
    }

    public String getProcessedAttributesAsString() {
        String result = null;
        for (ProcessedObject po : this.getProcessedAttributes(false)) {
            if (result == null) {
                result = po.getStringPresentation();
                continue;
            }
            result = result + "\n" + po.getStringPresentation();
        }
        return result;
    }

    @Override
    public List getProcessedAttributes(boolean flowsToStoreOnly) {
        HashMap<String, Flow> map = new HashMap<String, Flow>(50);
        ArrayList<ProcessedObject> result = new ArrayList<ProcessedObject>();
        ArrayList<Flow> storeFlows = new ArrayList<Flow>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof InfoStore) && (flowsToStoreOnly || !(flow.getSourceProcessObject() instanceof Process)) || storeFlows.contains(flow)) continue;
            storeFlows.add(flow);
            map.put(flow.getObjectID(), flow);
        }
        for (Flow flow : this.getOutgoingFlows()) {
            if (!(flow.getTargetProcessObject() instanceof InfoStore) && (flowsToStoreOnly || !(flow.getTargetProcessObject() instanceof Process)) || storeFlows.contains(flow)) continue;
            storeFlows.add(flow);
        }
        for (Flow flow : storeFlows) {
            List flowlist = flow.getInfoStructures();
            Iterator is = flowlist.iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    ProcessedObject po = this.getProcessedObjectFor(result, attribute);
                    if (po == null) {
                        po = new ProcessedObject();
                        po.setObject(attribute);
                        result.add(po);
                    }
                    po.setOpCreate(flow.isOpCreate() || po.isOpCreate());
                    po.setOpRead(flow.isOpRead() || po.isOpRead());
                    po.setOpUpdate(flow.isOpUpdate() || po.isOpUpdate());
                    po.setOpDelete(flow.isOpDelete() || po.isOpDelete());
                    po.setFlow(flow);
                    if (map.get(flow.getObjectID()) == null) continue;
                    po.setInbound(true);
                }
            }
        }
        return result;
    }

    public List getProcessedAttributesAndFlows(boolean flowsToStoreOnly) {
        HashMap<String, Flow> map = new HashMap<String, Flow>(4000);
        TreeMap<String, ProcessedObject> pmap = new TreeMap<String, ProcessedObject>();
        ArrayList result = new ArrayList();
        ArrayList<Flow> storeFlows = new ArrayList<Flow>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof InfoStore) && (flowsToStoreOnly || !(flow.getSourceProcessObject() instanceof Process)) || storeFlows.contains(flow)) continue;
            storeFlows.add(flow);
            map.put(flow.getObjectID(), flow);
        }
        for (Flow flow : this.getOutgoingFlows()) {
            if (!(flow.getTargetProcessObject() instanceof InfoStore) && (flowsToStoreOnly || !(flow.getTargetProcessObject() instanceof Process)) || storeFlows.contains(flow)) continue;
            storeFlows.add(flow);
        }
        for (Flow flow : storeFlows) {
            List flowlist = flow.getInfoStructures();
            Iterator is = flowlist.iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    ProcessedObject po = (ProcessedObject)pmap.get(attribute.getObjectID() + flow.getObjectID());
                    if (po == null) {
                        po = new ProcessedObject();
                        po.setObject(attribute);
                        pmap.put(attribute.getObjectID() + flow.getObjectID(), po);
                    }
                    po.setOpCreate(flow.isOpCreate() || po.isOpCreate());
                    po.setOpRead(flow.isOpRead() || po.isOpRead());
                    po.setOpUpdate(flow.isOpUpdate() || po.isOpUpdate());
                    po.setOpDelete(flow.isOpDelete() || po.isOpDelete());
                    po.setFlow(flow);
                    if (map.get(flow.getObjectID()) == null) continue;
                    po.setInbound(true);
                }
            }
        }
        result.addAll(pmap.values());
        return result;
    }

    public List getProcessedAttributesAndFlows(boolean flowsToStoreOnly, Attribute attr) {
        HashMap<String, Flow> map = new HashMap<String, Flow>(4000);
        TreeMap<String, ProcessedObject> pmap = new TreeMap<String, ProcessedObject>();
        ArrayList result = new ArrayList();
        ArrayList<Flow> storeFlows = new ArrayList<Flow>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof InfoStore) && (flowsToStoreOnly || !(flow.getSourceProcessObject() instanceof Process)) || storeFlows.contains(flow)) continue;
            storeFlows.add(flow);
            map.put(flow.getObjectID(), flow);
        }
        for (Flow flow : this.getOutgoingFlows()) {
            if (!(flow.getTargetProcessObject() instanceof InfoStore) && (flowsToStoreOnly || !(flow.getTargetProcessObject() instanceof Process)) || storeFlows.contains(flow)) continue;
            storeFlows.add(flow);
        }
        for (Flow flow : storeFlows) {
            List flowlist = flow.getInfoStructures();
            Iterator is = flowlist.iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    if (attr != attribute) continue;
                    ProcessedObject po = (ProcessedObject)pmap.get(attribute.getObjectID() + flow.getObjectID());
                    if (po == null) {
                        po = new ProcessedObject();
                        po.setObject(attribute);
                        pmap.put(attribute.getObjectID() + flow.getObjectID(), po);
                    }
                    po.setOpCreate(flow.isOpCreate() || po.isOpCreate());
                    po.setOpRead(flow.isOpRead() || po.isOpRead());
                    po.setOpUpdate(flow.isOpUpdate() || po.isOpUpdate());
                    po.setOpDelete(flow.isOpDelete() || po.isOpDelete());
                    po.setFlow(flow);
                    if (map.get(flow.getObjectID()) == null) continue;
                    po.setInbound(true);
                }
            }
        }
        result.addAll(pmap.values());
        return result;
    }

    public List getProcessedAttributesAndFlows(boolean flowsToStoreOnly, Entity entity) {
        HashMap<String, Flow> map = new HashMap<String, Flow>(4000);
        TreeMap<String, ProcessedObject> pmap = new TreeMap<String, ProcessedObject>();
        ArrayList result = new ArrayList();
        ArrayList<Flow> storeFlows = new ArrayList<Flow>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof InfoStore) && (flowsToStoreOnly || !(flow.getSourceProcessObject() instanceof Process)) || storeFlows.contains(flow)) continue;
            storeFlows.add(flow);
            map.put(flow.getObjectID(), flow);
        }
        for (Flow flow : this.getOutgoingFlows()) {
            if (!(flow.getTargetProcessObject() instanceof InfoStore) && (flowsToStoreOnly || !(flow.getTargetProcessObject() instanceof Process)) || storeFlows.contains(flow)) continue;
            storeFlows.add(flow);
        }
        for (Flow flow : storeFlows) {
            List flowlist = flow.getInfoStructures();
            Iterator is = flowlist.iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    if (attribute.getContainerWithKeyObject() != entity) continue;
                    ProcessedObject po = (ProcessedObject)pmap.get(attribute.getObjectID() + flow.getObjectID());
                    if (po == null) {
                        po = new ProcessedObject();
                        po.setObject(attribute);
                        pmap.put(attribute.getObjectID() + flow.getObjectID(), po);
                    }
                    po.setOpCreate(flow.isOpCreate() || po.isOpCreate());
                    po.setOpRead(flow.isOpRead() || po.isOpRead());
                    po.setOpUpdate(flow.isOpUpdate() || po.isOpUpdate());
                    po.setOpDelete(flow.isOpDelete() || po.isOpDelete());
                    po.setFlow(flow);
                    if (map.get(flow.getObjectID()) == null) continue;
                    po.setInbound(true);
                }
            }
        }
        result.addAll(pmap.values());
        return result;
    }

    private List getTargets() {
        ArrayList<DesignObject> result = new ArrayList<DesignObject>();
        for (Flow flow : this.getOutgoingFlows()) {
            if (flow.getExternalData().size() < 1) {
                Iterator is = flow.getInfoStructures().iterator();
                while (is.hasNext()) {
                    for (DesignObject dobj : ((InfoStructure)is.next()).getAttributes()) {
                        if (result.contains(dobj)) continue;
                        result.add(dobj);
                    }
                }
                continue;
            }
            for (DesignObject dobj : flow.getExternalData()) {
                if (result.contains(dobj)) continue;
                result.add(dobj);
            }
        }
        return result;
    }

    private ProcessedObject getProcessedObjectFor(List polist, DesignObject po) {
        for (ProcessedObject obj : polist) {
            if (obj.getObject() != po) continue;
            return obj;
        }
        return null;
    }

    public String getProcessedEntitiesAsString() {
        String result = null;
        for (ProcessedObject po : this.getProcessedEntities(false)) {
            if (result == null) {
                result = po.getStringPresentation();
                continue;
            }
            result = result + "\n" + po.getStringPresentation();
        }
        return result;
    }

    @Override
    public List getProcessedEntities(boolean flowsToStoreOnly) {
        ArrayList<ProcessedObject> result = new ArrayList<ProcessedObject>();
        for (ProcessedObject po : this.getProcessedAttributes(flowsToStoreOnly)) {
            ContainerObject ent = ((Attribute)po.getObject()).getContainer();
            ProcessedObject pe = this.getProcessedObjectFor(result, ent);
            if (pe == null) {
                pe = new ProcessedObject();
                pe.setObject(ent);
                result.add(pe);
            }
            pe.setObject(((Attribute)po.getObject()).getContainer());
            pe.setOpCreate(po.isOpCreate() || pe.isOpCreate());
            pe.setOpRead(po.isOpRead() || pe.isOpRead());
            pe.setOpUpdate(po.isOpUpdate() || pe.isOpUpdate());
            pe.setOpDelete(po.isOpDelete() || pe.isOpDelete());
        }
        return result;
    }

    public List getProcessedEntitiesAndFlows(boolean flowsToStoreOnly) {
        TreeMap<String, ProcessedObject> map = new TreeMap<String, ProcessedObject>();
        ArrayList result = new ArrayList();
        for (ProcessedObject po : this.getProcessedAttributesAndFlows(flowsToStoreOnly)) {
            ContainerObject ent = ((Attribute)po.getObject()).getContainer();
            ProcessedObject pe = (ProcessedObject)map.get(ent.getObjectID() + po.getFlow().getObjectID());
            if (pe == null) {
                pe = new ProcessedObject();
                pe.setObject(ent);
                pe.setFlow(po.getFlow());
                pe.setInbound(po.isInbound());
                map.put(ent.getObjectID() + po.getFlow().getObjectID(), pe);
            }
            pe.setOpCreate(po.isOpCreate() || pe.isOpCreate());
            pe.setOpRead(po.isOpRead() || pe.isOpRead());
            pe.setOpUpdate(po.isOpUpdate() || pe.isOpUpdate());
            pe.setOpDelete(po.isOpDelete() || pe.isOpDelete());
        }
        result.addAll(map.values());
        return result;
    }

    public List getProcessedEntitiesAndFlows(boolean flowsToStoreOnly, Entity entity) {
        TreeMap<String, ProcessedObject> map = new TreeMap<String, ProcessedObject>();
        ArrayList result = new ArrayList();
        for (ProcessedObject po : this.getProcessedAttributesAndFlows(flowsToStoreOnly, entity)) {
            ContainerObject ent = ((Attribute)po.getObject()).getContainer();
            ProcessedObject pe = (ProcessedObject)map.get(ent.getObjectID() + po.getFlow().getObjectID());
            if (pe == null) {
                pe = new ProcessedObject();
                pe.setObject(ent);
                pe.setFlow(po.getFlow());
                pe.setInbound(po.isInbound());
                map.put(ent.getObjectID() + po.getFlow().getObjectID(), pe);
            }
            pe.setOpCreate(po.isOpCreate() || pe.isOpCreate());
            pe.setOpRead(po.isOpRead() || pe.isOpRead());
            pe.setOpUpdate(po.isOpUpdate() || pe.isOpUpdate());
            pe.setOpDelete(po.isOpDelete() || pe.isOpDelete());
        }
        result.addAll(map.values());
        return result;
    }

    @Override
    public void addProcessedEntitiesToList(List list, boolean flowsToStoreOnly) {
        for (ProcessedObject po : this.getProcessedEntities(flowsToStoreOnly)) {
            DesignObject ent = po.getObject();
            ProcessedObject pe = this.getProcessedObjectFor(list, ent);
            if (pe == null) {
                pe = new ProcessedObject();
                pe.setObject(ent);
                list.add(pe);
            }
            pe.setObject(po.getObject());
            pe.setOpCreate(po.isOpCreate() || pe.isOpCreate());
            pe.setOpRead(po.isOpRead() || pe.isOpRead());
            pe.setOpUpdate(po.isOpUpdate() || pe.isOpUpdate());
            pe.setOpDelete(po.isOpDelete() || pe.isOpDelete());
        }
    }

    @Override
    public String getProcessNumber() {
        DataFlowDesign dfd;
        String levelNumber = Integer.toString(((DataFlowDesign)this.getDesignPart()).getProcessNumber(this));
        String parentNumber = "";
        if (this.getDesignPart() != null && (dfd = (DataFlowDesign)this.getDesignPart()).getProcess() != null) {
            parentNumber = dfd.getProcess().getProcessNumber();
        }
        if (!"".equalsIgnoreCase(parentNumber)) {
            return parentNumber + "." + levelNumber;
        }
        return levelNumber;
    }

    public Process getParentProcess() {
        DataFlowDesign dfd;
        if (this.getDesignPart() != null && (dfd = (DataFlowDesign)this.getDesignPart()).getProcess() != null) {
            return dfd.getProcess();
        }
        return null;
    }

    public Process getParentProcessInDFD(DataFlowDesign pdfd) {
        if (pdfd != null) {
            if (this.getDesignPart() == pdfd) {
                return this;
            }
            Process p = this.getParentProcess();
            if (p != null) {
                return p.getParentProcessInDFD(pdfd);
            }
        }
        return null;
    }

    @Override
    public boolean isComposite() {
        return this.type == 1;
    }

    private void addConnectedToComposite() {
        for (Flow flow : ((DataFlowDesign)this.getDesignPart()).getFlowsForProcessObject(this)) {
            flow.addSynonymToCompositeProcDiagram();
        }
    }

    @Override
    public void remove() {
        this.removeFlows();
        this.clearDiagram();
        super.remove();
    }

    public void remove(boolean moveOnly) {
        if (moveOnly) {
            super.remove();
        } else {
            this.remove();
        }
    }

    public boolean hasEvent() {
        return this.events.size() > 0 || this.getFlowEvents().size() > 0;
    }

    public Collection getComponentFlowsFor(Flow flow) {
        ArrayList col = new ArrayList();
        if (this.getDiagram() != null) {
            return this.getDiagram().getComponentFlowsFor(flow);
        }
        return col;
    }

    @Override
    public void updateTargetElements() {
        this.removeInvalidElements();
        for (Flow flow : this.getOutgoingFlows()) {
            if (flow.getExternalData().size() < 1) {
                for (InfoStructure structure : flow.getInfoStructures()) {
                    for (Attribute attribute : structure.getAttributes()) {
                        if (this.containsTarget(attribute)) continue;
                        this.targetElements.add(new TargetElement(attribute, this));
                    }
                }
                continue;
            }
            for (DesignObject dobj : flow.getExternalData()) {
                if (this.containsTarget(dobj)) continue;
                this.targetElements.add(new TargetElement(dobj, this));
            }
        }
    }

    @Override
    public void removeInvalidElements() {
        List targets = this.getTargets();
        for (int i = this.targetElements.size() - 1; i >= 0; --i) {
            TargetElement target = (TargetElement)this.targetElements.get(i);
            if (targets.contains(target.getTarget())) continue;
            this.targetElements.remove(target);
        }
        List sources = this.getSourceElements_WithParams();
        for (int i = 0; i < this.targetElements.size(); ++i) {
            TargetElement target = (TargetElement)this.targetElements.get(i);
            for (int j = target.getSources().size() - 1; j >= 0; --j) {
                DesignObject source = (DesignObject)target.getSources().get(j);
                if (sources.contains(source)) continue;
                target.getSources().remove(j);
            }
        }
    }

    private boolean containsTarget(DesignObject attribute) {
        for (TargetElement target : this.targetElements) {
            if (target.getTarget() != attribute) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getSourceElements() {
        ArrayList<DesignObject> result = new ArrayList<DesignObject>();
        for (Flow flow : this.getIncomingFlows()) {
            Iterator is = flow.getInfoStructures().iterator();
            if (flow.getExternalData().size() < 1) {
                while (is.hasNext()) {
                    InfoStructure structure = (InfoStructure)is.next();
                    for (Attribute attribute : structure.getAttributes()) {
                        if (result.contains(attribute)) continue;
                        result.add(attribute);
                    }
                }
                continue;
            }
            for (DesignObject dobj : flow.getExternalData()) {
                if (result.contains(dobj)) continue;
                result.add(dobj);
            }
        }
        return result;
    }

    @Override
    public List getSourceElements_WithParams() {
        ArrayList<DesignObject> result = new ArrayList<DesignObject>();
        for (Flow flow : this.getIncomingFlows()) {
            Iterator is = flow.getInfoStructures().iterator();
            if (flow.getExternalData().size() < 1) {
                while (is.hasNext()) {
                    InfoStructure structure = (InfoStructure)is.next();
                    for (Attribute attribute : structure.getAttributes()) {
                        if (result.contains(attribute)) continue;
                        result.add(attribute);
                    }
                }
            } else {
                for (DesignObject dobj : flow.getExternalData()) {
                    if (result.contains(dobj)) continue;
                    result.add(dobj);
                }
            }
            if (this.transformationTask == null) continue;
            result.addAll(this.transformationTask.getOutputParameters());
        }
        return result;
    }

    @Override
    public List getTargetElements() {
        return this.targetElements;
    }

    public List getUpdatedTargetElements() {
        this.updateTargetElements();
        return this.targetElements;
    }

    @Override
    public boolean isConnectedToStore() {
        Flow.Connection[] conns = this.getAllFlows();
        for (int i = 0; i < conns.length; ++i) {
            Flow flow = conns[i].getFlow();
            if (!flow.isConnectedToInfoStore()) continue;
            return true;
        }
        return false;
    }

    public TransformationTask getTransformationTask() {
        return this.transformationTask;
    }

    public void setTransformationTask(TransformationTask transformationTask) {
        if (this.transformationTask != transformationTask) {
            this.paramsWrappers.clear();
        }
        this.transformationTask = transformationTask;
        if (transformationTask != null) {
            this.type = 2;
        }
    }

    public List getParamsWrappers() {
        if (this.paramsWrappersPreset && this.transformationTask != null) {
            this.paramsWrappers.clear();
            if (!"".equalsIgnoreCase(this.paramsWrappersString)) {
                StringTokenizer tokenizer = new StringTokenizer(this.paramsWrappersString, ";");
                while (tokenizer.hasMoreTokens()) {
                    String wrap = tokenizer.nextToken();
                    String[] pars = wrap.split(",");
                    if (pars.length != 2) continue;
                    ParameterObject param = this.transformationTask.getParameterObjectById(pars[0]);
                    DesignObject dobj = this.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(pars[1]);
                    if (dobj == null) {
                        dobj = this.getDesign().getProcessModel().getExternalDataSet().getObjectByID(pars[1]);
                    }
                    if (param == null || dobj == null) continue;
                    ParamWrapper wr = new ParamWrapper(param);
                    wr.setMappedObject(dobj);
                    this.paramsWrappers.add(wr);
                }
            }
            this.paramsWrappersPreset = false;
        }
        return this.paramsWrappers;
    }

    public void addParamWrapper(ParamWrapper paramWrapper) {
        this.paramsWrappers.add(paramWrapper);
    }

    public DesignObject getParamMapping(ParameterObject param) {
        for (ParamWrapper wrapper : this.getParamsWrappers()) {
            if (wrapper.getParam() != param) continue;
            return wrapper.getMappedObject();
        }
        return null;
    }

    public String getParamsWrappersString() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.getParamsWrappers().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(';');
            }
            ParamWrapper wrap = (ParamWrapper)it.next();
            buffer.append(wrap.getParam().getObjectID()).append(",");
            if (wrap.getMappedObject() == null) {
                buffer.append("null");
                continue;
            }
            buffer.append(wrap.getMappedObject().getObjectID());
        }
        return buffer.toString();
    }

    public void setParamsWrappersString(String paramsWrappersString) {
        this.paramsWrappersString = paramsWrappersString;
        this.paramsWrappersPreset = true;
    }

    private void initEditableFonts() {
        DefaultFontAndColor dfc;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && this.getDesignPart().getAppView() != null && (dfc = this.getDesignPart().getDesign().getDesignLevelSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fo : dfc.getEditableFonts()) {
                this.editableFonts.add(fo.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    public void resetFontsAndColors() {
        DefaultFontAndColor dfc;
        this.editableFonts.clear();
        if (this.getDesignPart() != null && (dfc = this.getDesignPart().getDesign().getDesignLevelSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fo : dfc.getEditableFonts()) {
                this.editableFonts.add(fo.copy());
            }
        }
        this.setUseDefaultColor(true);
    }

    protected List createTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("RecordStructure");
        list.add("ExternalData");
        list.add("Event");
        list.add("InfoStructure");
        list.add("InfoStore");
        list.add("Role");
        list.add("TransformationPackage");
        list.add("Note");
        list.add("MainView");
        list.add("SubView");
        return list;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "process" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        ModelIDObject object = null;
        if (propertyName != null && propertyName.equals("targetMapping")) {
            return this.getTargetElementByID(id);
        }
        if (this.transformationTask != null) {
            object = this.transformationTask.getParameterObjectById(id);
        }
        if (object != null) {
            return object;
        }
        object = this.getDesign().getDesignObject(id);
        if (object != null) {
            return object;
        }
        if ("diagram".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getProcessModel().getDataFlowDesigns().getById(id);
        } else if ("transformationtask".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getProcessModel().getTransformationTaskById(id);
        }
        if (object != null) {
            return object;
        }
        return super.translateIdToObject(propertyName, id);
    }

    public String getPeakPeriodsString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.peakPeriods.length; ++i) {
            buffer.append(this.peakPeriods[i] ? "1" : "0");
        }
        return buffer.toString();
    }

    public void setPeakPeriodsString(String peakPeriods) {
        if (peakPeriods != null && !"".equalsIgnoreCase(peakPeriods) && peakPeriods.length() == this.getPeakPeriods().length) {
            for (int i = 0; i < peakPeriods.length(); ++i) {
                char pp = peakPeriods.charAt(i);
                this.getPeakPeriods()[i] = "1".equalsIgnoreCase(String.valueOf(pp));
            }
        }
    }

    @Override
    public TargetElement createTargetElement() {
        TargetElement te = new TargetElement(this.getDesignPart());
        te.setProcess(this);
        return te;
    }

    @Override
    public void addTargetElement(TargetElement te) {
        if (!this.targetElements.contains(te) && te.getTarget() != null) {
            this.targetElements.add(te);
        }
    }

    @Override
    public void removeTargetElement(TargetElement te) {
        this.targetElements.remove(te);
    }

    @Override
    public TargetElement getTargetElementByID(String id) {
        for (TargetElement te : this.targetElements) {
            if (te.getObjectID() == null || !te.getObjectID().equals(id)) continue;
            return te;
        }
        return null;
    }

    @Override
    public boolean setName(String name) {
        boolean result = super.setName(name);
        if (this.isComposite() && this.diagram != null && result) {
            this.diagram.setName(MessageFormat.format(Messages.getString("Process.Diagram"), this.getName()));
        }
        return result;
    }

    @Override
    public void copy(DesignObject desObject) {
        Process process = (Process)desObject;
        super.copy(desObject);
        process.setSynonym(this.getSynonym());
        process.setFilterCondition(this.getFilterCondition());
        process.setJoinCondition(this.getJoinCondition());
        process.setType(this.getType());
        process.setTransformationTask(this.getTransformationTask());
        process.setFootNote(this.getFootNote());
        process.setMode(this.getMode());
        process.setBatchMinimumTransactions(this.getBatchMinimumTransactions());
        process.setBatchTimeUnit(this.getBatchTimeUnit());
        process.setInteractiveLongestResponseTime(this.getInteractiveLongestResponseTime());
        process.setInteractiveResponseTimeUnit(this.getInteractiveResponseTimeUnit());
        process.setFrequencyTimes(this.getFrequencyTimes());
        process.setFrequencyTimeUnit(this.getFrequencyTimeUnit());
        process.setPriority(this.getPriority());
        process.setPeakPeriodsString(this.getPeakPeriodsString());
        for (Event event : this.getEvents()) {
            process.addEvent(event);
        }
    }

    public class ParamWrapper {
        ParameterObject param;
        DesignObject mappedObject;

        public ParamWrapper(ParameterObject param) {
            this.param = param;
        }

        public DesignObject getMappedObject() {
            return this.mappedObject;
        }

        public void setMappedObject(DesignObject mappedObject) {
            this.mappedObject = mappedObject;
        }

        public ParameterObject getParam() {
            return this.param;
        }
    }

    public class ProcessedObject {
        private DesignObject object;
        private boolean opCreate;
        private boolean opRead;
        private boolean opUpdate;
        private boolean opDelete;
        private Flow flow;
        private boolean inbound = false;

        public DesignObject getObject() {
            return this.object;
        }

        public void setObject(DesignObject object) {
            this.object = object;
        }

        public boolean isOpCreate() {
            return this.opCreate;
        }

        public void setOpCreate(boolean opCreate) {
            this.opCreate = opCreate;
        }

        public boolean isOpDelete() {
            return this.opDelete;
        }

        public void setOpDelete(boolean opDelete) {
            this.opDelete = opDelete;
        }

        public boolean isOpRead() {
            return this.opRead;
        }

        public void setOpRead(boolean opRead) {
            this.opRead = opRead;
        }

        public boolean isOpUpdate() {
            return this.opUpdate;
        }

        public void setOpUpdate(boolean opUpdate) {
            this.opUpdate = opUpdate;
        }

        public Flow getFlow() {
            return this.flow;
        }

        public void setFlow(Flow flow) {
            this.flow = flow;
        }

        public boolean isInbound() {
            return this.inbound;
        }

        public void setInbound(boolean inbound) {
            this.inbound = inbound;
        }

        public String getStringPresentation() {
            if (this.object != null) {
                String result = this.object.getLongName() + " / ";
                if (this.isOpCreate()) {
                    result = result + "C";
                }
                if (this.isOpRead()) {
                    result = result + "R";
                }
                if (this.isOpUpdate()) {
                    result = result + "U";
                }
                if (this.isOpDelete()) {
                    result = result + "D";
                }
                return result;
            }
            return "";
        }
    }
}

