/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.cwddesign.MergingCWDDesigns;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.HierarchicalStrategy;
import oracle.dbtools.crest.model.design.logical.ApplyAttributesNamingStandards;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeSet;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.CandidateKeySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.InheritanceRelationSet;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.editor.logical.EntityPropertiesDialogEx;

public class Entity
extends ContainerWithKeyObject
implements HierarchicalStrategy,
SetListener,
EditableFonts {
    public static final KeyObject[] KEY_PROTOTYPE = new CandidateKey[0];
    private List relationConnections = new ArrayList();
    private Entity hierarchicalParent = null;
    private List hierarchicalChildren = new ArrayList();
    private String fwdEngineeringStrategyName = "Single Table";
    private Relation inheritanceRelation;
    private KeyObjectSet allkeys;
    private DesignObjectCollection pkSet;
    private DesignObjectCollection unSet;
    private DesignObjectCollection inhSetParent;
    private DesignObjectCollection inhSetChild;
    private DesignObjectCollection relations;
    private Map referIDMap;
    private String synonym = "";
    private String owner = "";
    private String source = "";
    private String minVolumes = "0";
    private String expectedVolumes = "0";
    private String maxVolumes = "9999999";
    private int growthPercent = 0;
    private String growthType = GROWTH_TYPES[2];
    private String normalForm = NORMAL_FORMS[3];
    private String adequatelyNormalized = YES_NO_STATES[1];
    private String scope = "";
    public static final String[] GROWTH_TYPES = new String[]{"Day", "Month", "Year"};
    private static Set growthSet = null;
    public static final String[] NORMAL_FORMS = new String[]{"None", "First", "Second", "Third", "Fourth"};
    private static Set normalFormSet = null;
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List arcs;
    private static final int ARC_SIZE_INDEX = 20;
    private List editableFonts = new ArrayList();
    private String preferredAbbreviation = "";
    private List relationsList;
    private String synonymToDisplay = "";
    private String shortName = "";
    private String hierarchicalParentID = "";
    private Map foldedAttributesMap = new TreeMap();
    public static final String REF_TYPE_NONE = "None";
    public static final String REF_TYPE_IDENTIFYING = "Identifying";
    public static final String REF_TYPE_ARC = "Arc implementation";
    private String subtypesRefType = "Identifying";
    public static final String ATTR_INH_TYPE_PK = "Primary attributes only";
    public static final String ATTR_INH_TYPE_ALL = "All atributes";
    private String attributeInherType = "Primary attributes only";
    private boolean generateDiscriminatorColumn = false;
    private String discriminatorAttributeID;
    private String discriminatorColumnName = "";
    private Attribute discriminatorAttribute;
    private String discriminatorValue;
    private boolean completeSubtypes = false;
    private boolean createSurrogateKey = false;
    private Relation containerRelation;
    public static final String TYPE_NAME = "Entity";
    public static final Entity NULL_ENTITY = new NullEntity(null);

    public Entity(DesignPart designPart) {
        super(designPart);
        this.arcs = new ArrayList();
        if (designPart != null) {
            this.setCreateSurrogateKey(designPart.getAppView().getSettings().isDefaultCreateSurrogateKey());
        }
    }

    @Override
    public KeyObject[] getKeyArrayPrototype() {
        return KEY_PROTOTYPE;
    }

    @Override
    public Class getContainedClass() {
        return Attribute.class;
    }

    public AttributeSet getAttributeSet() {
        return this.getDesign().getLogicalDesign().getAttributeSet();
    }

    public List getAttributes() {
        return Arrays.asList(this.getElements());
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getAttributeSet();
    }

    public Attribute createNestedAttribute() {
        Attribute nestedAttribute = this.createAttribute(null);
        this.getElementsCollection().remove(nestedAttribute);
        this.getNestedElements().add(nestedAttribute);
        return nestedAttribute;
    }

    public Attribute createAttribute() {
        return this.createAttribute(null);
    }

    public void initIndexFilters() {
        this.allkeys = this.getKeySet();
        this.pkSet = new DesignObjectCollection();
        this.unSet = new DesignObjectCollection();
        this.inhSetParent = new DesignObjectCollection();
        this.inhSetChild = new DesignObjectCollection();
        this.relations = new DesignObjectCollection();
        this.pkSet.setParent(this);
        this.pkSet.setDesign(this.getDesign());
        this.pkSet.setName(Messages.getString("Entity.PrimaryKeys"));
        this.unSet.setParent(this);
        this.unSet.setDesign(this.getDesign());
        this.unSet.setName(Messages.getString("Entity.AlternateKeys"));
        this.relations.setParent(this);
        this.relations.setDesign(this.getDesign());
        this.relations.setName(Messages.getString("Entity.Relations"));
        this.inhSetParent.setParent(this);
        this.inhSetParent.setDesign(this.getDesign());
        this.inhSetParent.setName(Messages.getString("Entity.InheritanceFromSupertype"));
        this.inhSetChild.setParent(this);
        this.inhSetChild.setDesign(this.getDesign());
        this.inhSetChild.setName(Messages.getString("Entity.InheritancesToSubtypes"));
        this.allkeys.addSetListener(this);
        this.unSet.setElementDescriptor(CandidateKey.class);
        this.pkSet.setElementDescriptor(CandidateKey.class);
        this.relations.setElementDescriptor(Relation.class);
        this.inhSetParent.setElementDescriptor(InheritanceRelation.class);
        this.inhSetChild.setElementDescriptor(InheritanceRelation.class);
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (object instanceof StructuredType) {
            super.changed(object, event);
            return;
        }
        if (object instanceof CandidateKey) {
            if (event == ObjectChangeEvent.KEY_CHANGED_TO_PK) {
                if (!this.pkSet.containsPlaceHolderFor(object)) {
                    this.pkSet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), object));
                }
                this.unSet.removePlaceHolderFor(object);
            } else if (event == ObjectChangeEvent.KEY_CHANGED_NO_PK) {
                this.pkSet.removePlaceHolderFor(object);
            }
            if (event == ObjectChangeEvent.PK_REMOVED) {
                if (!this.unSet.containsPlaceHolderFor(object)) {
                    this.unSet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), object));
                }
                this.pkSet.removePlaceHolderFor(object);
            }
            if (event == ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE) {
                if (!this.unSet.containsPlaceHolderFor(object)) {
                    this.unSet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), object));
                }
                this.pkSet.removePlaceHolderFor(object);
            }
        } else if (object instanceof Arc && event == ObjectChangeEvent.OBJECT_REMOVED) {
            this.removeArc((Arc)object);
        }
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (set instanceof StructuredTypeSet) {
            super.changed(set, event);
            return;
        }
        if (event == SetEvent.OBJECT_ADDED) {
            CandidateKey obj = (CandidateKey)event.getAffected();
            obj.addObjectListener(this);
            if (obj.isPK()) {
                this.pkSet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), obj));
            } else {
                this.unSet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), obj));
            }
        } else if (event == SetEvent.OBJECT_REMOVED) {
            CandidateKey obj = (CandidateKey)event.getAffected();
            if (obj.isPK()) {
                this.pkSet.removePlaceHolderFor(obj);
                this.setPK(null);
            } else {
                this.unSet.removePlaceHolderFor(obj);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 4;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index < super.getNumberOfChildren() - 1) {
            return super.getChild(index);
        }
        if (index == this.getNumberOfChildren() - 5) {
            return this.pkSet;
        }
        if (index == this.getNumberOfChildren() - 4) {
            return this.unSet;
        }
        if (index == this.getNumberOfChildren() - 3) {
            return this.relations;
        }
        if (index == this.getNumberOfChildren() - 2) {
            return this.inhSetParent;
        }
        return this.inhSetChild;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.pkSet) {
            return this.getNumberOfChildren() - 5;
        }
        if (child == this.unSet) {
            return this.getNumberOfChildren() - 4;
        }
        if (child == this.relations) {
            return this.getNumberOfChildren() - 3;
        }
        if (child == this.inhSetParent) {
            return this.getNumberOfChildren() - 2;
        }
        if (child == this.inhSetChild) {
            return this.getNumberOfChildren() - 1;
        }
        return super.getIndexForChild(child);
    }

    public void addRelationToRelationCollections(Relation rel) {
        if (rel instanceof InheritanceRelation) {
            if (rel.getTargetEntity() == this) {
                this.inhSetParent.add(new DesignObjectPlaceHolder(this.getDesignPart(), rel));
            } else if (rel.getSourceEntity() == this) {
                this.inhSetChild.add(new DesignObjectPlaceHolder(this.getDesignPart(), rel));
            }
            return;
        }
        if (!this.relations.containsPlaceHolderFor(rel)) {
            this.relations.add(new DesignObjectPlaceHolder(this.getDesignPart(), rel));
        }
    }

    public void updateRelationStatus(Relation rel) {
        this.relations.removePlaceHolderFor(rel);
        this.addRelationToRelationCollections(rel);
    }

    public void removeRelationFromRelationCollections(Relation rel) {
        if (rel instanceof InheritanceRelation) {
            if (rel.getTargetEntity() == this) {
                this.inhSetParent.removePlaceHolderFor(rel);
            } else if (rel.getSourceEntity() == this) {
                this.inhSetChild.removePlaceHolderFor(rel);
            }
            this.fireChange(ObjectChangeEvent.ENTITY_IN_RELATION_REMOVED);
            return;
        }
        this.relations.removePlaceHolderFor(rel);
        this.fireChange(ObjectChangeEvent.ENTITY_IN_RELATION_REMOVED);
    }

    public void remove(boolean removeRelations) {
        if (removeRelations) {
            this.removeAllRelations();
        }
        this.clearViews();
        this.deleteAllArcs();
        super.remove();
    }

    @Override
    public void remove() {
        ArrayList list = null;
        if (!this.getDesign().isClosing() && this.relations.size() > 0) {
            list = new ArrayList();
            this.relations.addAllElementsTo(list);
        }
        this.clearViews();
        this.deleteAllArcs();
        super.remove();
        if (list != null) {
            for (Object rel : list) {
                if (!(rel instanceof Relation)) continue;
                ((Relation)rel).remove();
            }
        }
        this.relations.removeAll();
    }

    public Attribute createAttribute(String name) {
        Attribute attribute = new Attribute(this.getDesignPart());
        attribute.setDesign(this.getDesign());
        attribute.setContainer(this);
        this.add(attribute);
        this.getAttributeSet().add(attribute);
        if (name != null) {
            attribute.setName(name);
        }
        return attribute;
    }

    public Attribute recreateAttribute(String id) {
        Attribute attribute = new Attribute(this.getDesignPart());
        attribute.setObjectID(id);
        attribute.setDesign(this.getDesign());
        attribute.setContainer(this);
        this.add(attribute);
        this.getAttributeSet().add(attribute);
        return attribute;
    }

    @Override
    public ContainedObject createContainedObject(String id) {
        if (!this.isReadOnly()) {
            return this.recreateAttribute(id);
        }
        return null;
    }

    @Override
    public KeyObject createKeyObject(String id) {
        return this.createCandidateKey(id);
    }

    public CandidateKey createCandidateKey(String id) {
        CandidateKey key = new CandidateKey(this.getDesignPart());
        key.setObjectID(id);
        key.setDesign(this.getDesign());
        key.setContainerObject(this);
        key.setUnique(true);
        this.add(key);
        return key;
    }

    public CandidateKey createCandidateKeyNoAddToKeys(String id) {
        CandidateKey key = new CandidateKey(this.getDesignPart());
        key.setObjectID(id);
        key.setDesign(this.getDesign());
        key.setContainerObject(this);
        key.setUnique(true);
        return key;
    }

    public CandidateKey createCandidateKey() {
        return this.createCandidateKey(null);
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("entity id prefix");
    }

    void add(Relation.Connection connection) {
        this.relationConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(null);
    }

    void remove(Relation.Connection connection) {
        this.relationConnections.remove(connection);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(null);
    }

    public Relation.Connection[] getRelationConnections() {
        return (Relation.Connection[])this.relationConnections.toArray(Relation.CONNECTION_PROTO_ARRAY);
    }

    public int getNumberOfRelationConnections() {
        return this.relationConnections.size();
    }

    public int getNumberOfNormalRelationConnections() {
        int allRelations = this.getNumberOfRelationConnections();
        int children = this.getHierarchicalChildrenCount();
        int parents = this.hasHierarchicalParent() ? 1 : 0;
        return allRelations - children - parents;
    }

    @Override
    public int countRelationsWith(ContainerWithKeyObject other) {
        if (other != null && other instanceof Entity) {
            Entity otherEntity = (Entity)other;
            int count = 0;
            Relation.Connection[] connections = this.getRelationConnections();
            for (int i = 0; i < connections.length; ++i) {
                if (!otherEntity.equals(connections[i].getOtherEntity())) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public List getRelations() {
        this.relationsList = new ArrayList();
        Relation.Connection[] connections = this.getRelationConnections();
        for (int i = 0; i < connections.length; ++i) {
            Relation.Connection connection = connections[i];
            Relation relation = connection.getRelation();
            if (this.relationsList.contains(relation)) continue;
            this.relationsList.add(relation);
        }
        return this.relationsList;
    }

    public Relation getRelationTo(Entity otherEntity) {
        if (otherEntity != null) {
            Relation.Connection[] connections = this.getRelationConnections();
            for (int i = 0; i < connections.length; ++i) {
                if (!otherEntity.equals(connections[i].getOtherEntity())) continue;
                return connections[i].getRelation();
            }
        }
        return null;
    }

    public List getAllRelationsTo(Entity otherEntity) {
        ArrayList<Relation> list = new ArrayList<Relation>();
        if (otherEntity != null) {
            Relation.Connection[] connections = this.getRelationConnections();
            for (int i = 0; i < connections.length; ++i) {
                if (!otherEntity.equals(connections[i].getOtherEntity())) continue;
                list.add(connections[i].getRelation());
            }
        }
        return list;
    }

    @Override
    public int countRelations() {
        return this.getNumberOfRelationConnections();
    }

    public int getIndexOf(Relation.Connection connection) {
        return this.relationConnections.indexOf(connection);
    }

    @Override
    protected KeyObjectSet createKeySet() {
        return new CandidateKeySet(this.getDesignPart());
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setHierarchicalParent(Entity parent) {
        AbstractCellView cellView;
        TopView topView;
        if (parent instanceof NullEntity || parent == null) {
            parent = null;
            this.hierarchicalParentID = "";
        }
        if (this.hierarchicalParent != parent) {
            Entity oldParent = this.hierarchicalParent;
            Entity newParent = parent;
            if (parent != null) {
                this.hierarchicalParentID = parent.getObjectID();
            }
            if (!(newParent == this || newParent != null && this.isHierarchicalAncestorOf(newParent))) {
                if (oldParent != null) {
                    oldParent.removeHierarchicalChild(this);
                }
                this.hierarchicalParent = newParent;
                this.updateInheritanceRelation(oldParent, newParent);
                if (newParent != null) {
                    newParent.addHierarchicalChild(this);
                }
                this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
            }
        }
        if ((topView = this.getFirstViewForDPV(this.getDesign().getAppView().getCurrentDPV())) == null) {
            topView = this.getTopView();
        }
        if ((cellView = topView.getCellView()) != null) {
            cellView.setNewBounds(cellView.getBounds().getBounds());
        }
    }

    public void setHierarchicalParent(Entity parent, InheritanceRelation relation) {
        if (parent instanceof NullEntity) {
            parent = null;
        }
        if (this.hierarchicalParent != parent) {
            AbstractCellView cellView;
            TopView topView;
            Entity oldParent = this.hierarchicalParent;
            Entity newParent = parent;
            if (!(newParent == this || newParent != null && this.hasHierarchicalRelationWith(newParent))) {
                if (oldParent != null) {
                    oldParent.removeHierarchicalChild(this);
                }
                this.hierarchicalParent = newParent;
                this.inheritanceRelation = relation;
                this.updateInheritanceRelation(oldParent, newParent);
                if (newParent != null) {
                    newParent.addHierarchicalChild(this);
                }
                this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
            }
            if ((topView = this.getFirstViewForDPV(this.getDesign().getAppView().getCurrentDPV())) == null) {
                topView = this.getTopView();
            }
            if ((cellView = topView.getCellView()) != null) {
                cellView.setNewBounds(cellView.getBounds().getBounds());
            }
        }
    }

    protected void updateInheritanceRelation(Entity oldParent, Entity newParent) {
        if (newParent == null) {
            if (this.inheritanceRelation != null) {
                this.inheritanceRelation.remove();
                this.inheritanceRelation = null;
            }
        } else if (oldParent != newParent) {
            if (this.inheritanceRelation == null) {
                this.inheritanceRelation = ((InheritanceRelationSet)this.getDesign().getLogicalDesign().getInheritanceRelationSet()).createRelation(null, newParent, this);
            } else {
                this.inheritanceRelation.setSourceEntity(newParent);
                this.inheritanceRelation.setSourceTV(this.inheritanceRelation.getSourceTVEntity());
            }
        }
    }

    public void setHierarchicalParentToNull() {
        this.inheritanceRelation = null;
        if (this.hierarchicalParent != null) {
            this.hierarchicalParent.removeHierarchicalChild(this);
            this.hierarchicalParent = null;
        }
    }

    public void joinInheritanceRelation(Relation inheritance, Entity superType) {
        if (inheritance instanceof InheritanceRelation) {
            this.inheritanceRelation = inheritance;
            this.hierarchicalParent = superType;
            this.hierarchicalParent.addHierarchicalChild(this);
        }
    }

    public Entity getHierarchicalParent() {
        return this.hierarchicalParent;
    }

    public void addHierarchicalChild(Entity child) {
        this.hierarchicalChildren.add(child);
    }

    public void removeHierarchicalChild(Entity child) {
        this.hierarchicalChildren.remove(child);
        if (this.inhSetChild.containsPlaceHolderFor(child)) {
            this.inhSetChild.removePlaceHolderFor(child);
        }
    }

    public boolean hasHierarchicalChildren() {
        return this.hierarchicalChildren.size() > 0;
    }

    public int getHierarchicalChildrenCount() {
        return this.hierarchicalChildren.size();
    }

    public Entity getHierarchicalChild(int index) {
        return (Entity)this.hierarchicalChildren.get(index);
    }

    public List getHierarchicalAttributes() {
        ArrayList list = new ArrayList();
        list.addAll(this.getElementsCollection());
        if (this.isHierarchicalEntityType()) {
            List entList = this.getHierarchicalLeaves();
            for (Entity ent : entList) {
                list.addAll(ent.getElementsCollection());
            }
        }
        return list;
    }

    public List getHierarchicalLeaves() {
        ArrayList list = new ArrayList();
        if (this.isHierarchicalEntityType()) {
            this.addHiearachicalLeavesFor(this, list);
        }
        return list;
    }

    private void addHiearachicalLeavesFor(Entity entity, List list) {
        int count = entity.getHierarchicalChildrenCount();
        if (count == 0) {
            list.add(entity);
        } else {
            for (int i = 0; i < count; ++i) {
                Entity ch_ent = entity.getHierarchicalChild(i);
                this.addHiearachicalLeavesFor(ch_ent, list);
            }
        }
    }

    public List getDiscriminatorColumnValues() {
        ArrayList list = new ArrayList();
        if (this.isHierarchicalEntityType()) {
            this.addDiscriminatorValuesFor(this, list);
        }
        return list;
    }

    public static String generateDiscriminatorValue(Entity ent) {
        String value = ent.getDiscriminatorValue();
        if (value != null && !"".equals(value)) {
            return value;
        }
        String shname = ent.getShortName();
        if ("".equals(shname)) {
            shname = ent.getDesign().transformNameFromLogicalToRelational(ent);
        }
        return shname;
    }

    private void addDiscriminatorValuesFor(Entity entity, List list) {
        int count = entity.getHierarchicalChildrenCount();
        list.add(Entity.generateDiscriminatorValue(entity));
        for (int i = 0; i < count; ++i) {
            Entity ch_ent = entity.getHierarchicalChild(i);
            this.addDiscriminatorValuesFor(ch_ent, list);
        }
    }

    public boolean isInheriting() {
        return this.hasHierarchicalParent();
    }

    public boolean hasHierarchicalParent() {
        return this.getHierarchicalParent() != null;
    }

    public boolean isHierarchicalRoot() {
        return !this.hasHierarchicalParent() && this.hasHierarchicalChildren();
    }

    public boolean isHierarchicalEntityType() {
        return this.isInheriting() || this.hasHierarchicalChildren();
    }

    public boolean isHierarchicalAncestorOf(Entity entity) {
        if (entity != null && entity.isHierarchicalEntityType()) {
            int numChild = this.getHierarchicalChildrenCount();
            for (int i = 0; i < numChild; ++i) {
                if (this.getHierarchicalChild(i) != entity && !this.getHierarchicalChild(i).isHierarchicalAncestorOf(entity)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasHierarchicalRelationWith(Entity entity) {
        if (entity != null && entity.isHierarchicalEntityType()) {
            Entity root = this.getHierarchicalRoot();
            return root == entity || root.isHierarchicalAncestorOf(entity);
        }
        return false;
    }

    @Override
    public Map getReferIDMap() {
        if (this.referIDMap == null) {
            this.referIDMap = new HashMap();
        }
        return this.referIDMap;
    }

    public Entity getHierarchicalRoot() {
        if (this.getHierarchicalParent() != null) {
            return this.getHierarchicalParent().getHierarchicalRoot();
        }
        return this;
    }

    public boolean hasHierarchicalPK() {
        return this.hasPK() || this.hasHierarchicalParent() && this.getHierarchicalParent().hasHierarchicalPK();
    }

    public boolean hasHierarchicalFK() {
        return this.hasUnique() || this.hasHierarchicalParent() && this.getHierarchicalParent().hasHierarchicalFK();
    }

    public KeyObject getHierarchicalPK() {
        if (this.hasPK()) {
            return this.getPK();
        }
        if (this.hasHierarchicalPK()) {
            return this.getHierarchicalParent().getHierarchicalPK();
        }
        return null;
    }

    public KeyObject getHierarchicalFK() {
        if (this.getFirstFK() != null) {
            return this.getFirstFK();
        }
        if (this.hasHierarchicalParent()) {
            return this.getHierarchicalParent().getHierarchicalFK();
        }
        return null;
    }

    public List getAllElementsList() {
        if (this.isInheriting()) {
            List list = this.getHierarchicalParent().getAllElementsList();
            list.addAll(Arrays.asList(this.getElements()));
            return list;
        }
        ArrayList<ContainedObject> list = new ArrayList<ContainedObject>();
        list.addAll(Arrays.asList(this.getElements()));
        return list;
    }

    public String getFwdEngineeringStrategyName() {
        if (this.isInheriting()) {
            return this.getHierarchicalParent().getFwdEngineeringStrategyName();
        }
        return this.fwdEngineeringStrategyName;
    }

    public void setFwdEngineeringStrategyName(String name) {
        if (this.isInheriting()) {
            this.getHierarchicalParent().setFwdEngineeringStrategyName(name);
            return;
        }
        if (!this.fwdEngineeringStrategyName.equals(name)) {
            this.fwdEngineeringStrategyName = name;
            this.setDirty(true);
        }
    }

    public void applyEngineeringStrategyToHierarchy(String name) {
        Entity root = this.getHierarchicalRoot();
        if (root != null) {
            root.setFwdEngineeringStrategyName(name);
            root.applyEngineeringStrategyToChilds(name);
        } else {
            this.setFwdEngineeringStrategyName(name);
            this.applyEngineeringStrategyToChilds(name);
        }
    }

    private void applyEngineeringStrategyToChilds(String name) {
        int count = this.getHierarchicalChildrenCount();
        for (int i = 0; i < count; ++i) {
            Entity ent = this.getHierarchicalChild(i);
            if (ent == null) continue;
            ent.setFwdEngineeringStrategyName(name);
            ent.applyEngineeringStrategyToChilds(name);
        }
    }

    public Attribute getFKAttributeByDelegateGenerator(String delegateID) {
        for (Attribute attr : this.getElementsAndNestedElementsCollection()) {
            if (!attr.isFKAttribute() || !delegateID.equals(attr.getDelegate().getGeneratorID())) continue;
            return attr;
        }
        return null;
    }

    public Attribute getAttributeReferingDelegate(String delegateID) {
        for (Attribute attr : this.getElementsAndNestedElementsCollection()) {
            String refid = attr.getReferedAttribute();
            if (refid == null || !refid.equals(delegateID)) continue;
            return attr;
        }
        return null;
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String synonym) {
        if (!this.synonym.equals(synonym)) {
            this.synonym = synonym;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    private boolean checkGrowth(String value) {
        if (growthSet == null) {
            growthSet = new HashSet();
            growthSet.addAll(Arrays.asList(GROWTH_TYPES));
        }
        return growthSet.contains(value);
    }

    private boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(value);
    }

    private boolean checkNormalForm(String value) {
        if (normalFormSet == null) {
            normalFormSet = new HashSet();
            normalFormSet.addAll(Arrays.asList(NORMAL_FORMS));
        }
        return normalFormSet.contains(value);
    }

    public String getAdequatelyNormalized() {
        return this.adequatelyNormalized;
    }

    public void setAdequatelyNormalized(String adequatelyNormalized) {
        if (this.checkYesNo(adequatelyNormalized)) {
            this.adequatelyNormalized = adequatelyNormalized;
        }
    }

    public String getExpectedVolumes() {
        return this.expectedVolumes;
    }

    public void setExpectedVolumes(String expectedVolumes) {
        try {
            if (expectedVolumes != null) {
                this.expectedVolumes = expectedVolumes;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getGrowthPercent() {
        return Integer.toString(this.growthPercent);
    }

    public int getGrowthPercentInt() {
        return this.growthPercent;
    }

    public void setGrowthPercent(String growthPercent) {
        try {
            this.growthPercent = Integer.parseInt(growthPercent);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getGrowthType() {
        return this.growthType;
    }

    public void setGrowthType(String growthType) {
        if (this.checkGrowth(growthType)) {
            this.growthType = growthType;
        }
    }

    public String getMaxVolumes() {
        return this.maxVolumes;
    }

    public void setMaxVolumes(String maxVolumes) {
        try {
            if (maxVolumes != null) {
                this.maxVolumes = maxVolumes;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getMinVolumes() {
        return this.minVolumes;
    }

    public void setMinVolumes(String minVolumes) {
        try {
            if (minVolumes != null) {
                this.minVolumes = minVolumes;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getNormalForm() {
        return this.normalForm;
    }

    public void setNormalForm(String normalForm) {
        if (this.checkNormalForm(normalForm)) {
            this.normalForm = normalForm;
        }
    }

    @Override
    public boolean hasAliveGenerator() {
        DesignObject obj;
        TableSet set = this.getDesign().getRelationalDesign().getTableSet();
        return "User generated".equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            EntityPropertiesDialogEx dialog = new EntityPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (scope != null && scope.equals(this.scope)) {
            return;
        }
        this.scope = scope;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public boolean canPaste() {
        for (Object obj : this.getAppView().getCopiedObjects()) {
            if (obj == null || !(obj instanceof Attribute)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copy(DesignObject desObject) {
        this.copy(desObject, null);
    }

    public void copy(DesignObject desObject, Map copyMap) {
        this.copy(desObject, copyMap, false);
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject) {
        Attribute att;
        Attribute old;
        int i;
        Entity entity = (Entity)desObject;
        super.copy(entity);
        entity.setOwner(this.getOwner());
        entity.setSynonym(this.getSynonym());
        entity.setFwdEngineeringStrategyName(this.getFwdEngineeringStrategyName());
        entity.setSource(this.getSource());
        entity.setTypeID(this.getTypeID());
        entity.getAdditionalClassificationTypes().clear();
        entity.getAdditionalClassificationTypes().addAll(this.getAdditionalClassificationTypes());
        entity.setScope(this.getScope());
        entity.setBasedOnStructuredType(this.getBasedOnStructuredType());
        entity.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        entity.setMinVolumes(this.getMinVolumes());
        entity.setExpectedVolumes(this.getExpectedVolumes());
        entity.setMaxVolumes(this.getMaxVolumes());
        entity.setGrowthPercent(this.getGrowthPercent());
        entity.setGrowthType(this.getGrowthType());
        entity.setNormalForm(this.getNormalForm());
        entity.setAdequatelyNormalized(this.getAdequatelyNormalized());
        entity.setShortName(this.getShortName());
        if (!this.isBST() && remoteObject) {
            ContainedObject[] columns = entity.getElements();
            for (i = columns.length - 1; i >= 0; --i) {
                ContainedObject rc;
                ContainedObject column = columns[i];
                String rcID = column.getRemoteObjectID();
                if ("".equalsIgnoreCase(rcID) || (rc = this.getElementByID(rcID)) != null) continue;
                column.remove();
            }
        }
        ContainedObject[] cos = this.getElements();
        for (i = 0; i < cos.length; ++i) {
            old = (Attribute)cos[i];
            att = null;
            if (this.isBST()) {
                if (old.isOid()) {
                    att = (Attribute)entity.getOidElement();
                } else {
                    String typeElemId = old.getStructAttributeID();
                    if (!"".equals(typeElemId)) {
                        att = (Attribute)entity.getElementByStructAttributeID(typeElemId);
                    }
                }
            } else {
                att = (Attribute)entity.getElementByRemoteObjectID(old.getObjectID());
                if (att == null) {
                    att = entity.createAttribute(old.getName());
                }
                if (remoteObject) {
                    if (old.isRemoteObject()) {
                        att.setRemoteObjectID(old.getRemoteObjectID());
                    } else {
                        att.setRemoteObjectID(old.getObjectID());
                    }
                }
            }
            if (att == null) continue;
            if (copyMap != null) {
                copyMap.put(old.getObjectID(), att);
            }
            if (old.getDesign() == att.getDesign()) {
                old.copy(att);
                continue;
            }
            MergingCWDDesigns.copyPropertiesFromAttributeToAttribute(old, att, copyMap);
        }
        if (copyMap != null) {
            for (i = 0; i < cos.length; ++i) {
                Attribute delegate;
                old = (Attribute)cos[i];
                att = (Attribute)copyMap.get(old.getObjectID());
                if (att != null && old.getReferedAttribute() != null) {
                    delegate = (Attribute)copyMap.get(old.getReferedAttribute());
                    if (delegate == null) continue;
                    att.setReferedAttribute(delegate.getObjectID());
                    continue;
                }
                if (att == null || old.getDelegate() == null || (delegate = (Attribute)copyMap.get(old.getDelegate().getObjectID())) == null) continue;
                att.setReferedAttribute(delegate.getObjectID());
            }
        }
        for (int i2 = 0; i2 < this.getKeySet().size(); ++i2) {
            KeyObject oldKey = (KeyObject)this.getKeySet().getElement(i2);
            if (oldKey.isFK() && !remoteObject) continue;
            KeyObject key = null;
            if (oldKey.isOidKey()) {
                key = entity.getOidKey();
            }
            if (key == null) {
                key = entity.createKeyObject();
            }
            if (oldKey.isOidKey() && key != null) {
                key.setOidKey(true);
            }
            oldKey.copy(key);
            if (remoteObject) {
                if (oldKey.isRemoteObject()) {
                    key.setRemoteObjectID(oldKey.getRemoteObjectID());
                } else {
                    key.setRemoteObjectID(oldKey.getObjectID());
                }
            }
            if (copyMap != null) {
                copyMap.put(oldKey.getObjectID(), key);
            }
            key.setContainerObject(entity);
            ContainedObject[] attributes = oldKey.getElements();
            for (int j = 0; j < attributes.length; ++j) {
                Attribute att2 = null;
                if (copyMap != null) {
                    att2 = (Attribute)copyMap.get(attributes[j].getObjectID());
                }
                if (att2 == null) {
                    att2 = (Attribute)entity.getElementByName(attributes[j].getName());
                }
                if (att2 == null) continue;
                key.add(att2);
            }
            if (!(oldKey instanceof CandidateKey)) continue;
            ((CandidateKey)key).setKeyState(((CandidateKey)oldKey).getKeyState());
        }
    }

    @Override
    public void paste() {
        for (Object obj : this.getAppView().getCopiedObjects()) {
            if (obj == null || !(obj instanceof Attribute)) continue;
            Attribute attribute = this.createAttribute();
            Attribute copied = (Attribute)obj;
            copied.copy(attribute);
        }
    }

    public Attribute getAttributeForDelegate(Attribute delegate, Relation rel) {
        for (Attribute attr : this.getElementsAndNestedElementsCollection()) {
            if (attr.getDelegateElement() != delegate || !rel.getObjectID().equals(attr.getGeneratorID())) continue;
            return attr;
        }
        return null;
    }

    public Attribute getAttributeForDelegate(Attribute delegate) {
        for (Attribute attr : this.getElementsAndNestedElementsCollection()) {
            if (attr.getDelegateElement() != delegate) continue;
            return attr;
        }
        return null;
    }

    public Table getEngTable(RelationalDesign pdes) {
        XtdMapping mapping;
        Table tab;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        if (list.size() > 0 && (tab = (Table)(mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null) {
            return tab;
        }
        Table table = (Table)pdes.getTableSet().getObjectByID(this.getGeneratorID());
        if (table != null && table.getDesignPart() == pdes) {
            return table;
        }
        table = (Table)pdes.getTableSet().getObjectGeneratedBy(this.getObjectID());
        return table;
    }

    public Table getEngTable(RelationalDesign pdes, int inhType) {
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        if (list.size() > 0) {
            for (XtdMapping mapping : list) {
                Table tab;
                if (mapping.getInheritanceType() != inhType && mapping.getInheritanceType() != 0 || (tab = (Table)mapping.getObjectMappedTo(this)) == null) continue;
                return tab;
            }
        }
        return null;
    }

    public List getEngTables(RelationalDesign pdes) {
        ArrayList<XtdMapping> temp = new ArrayList<XtdMapping>();
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        for (XtdMapping mapping : list) {
            DesignObject obj = mapping.getObjectMappedTo(this);
            if (obj == null || !(obj instanceof Table)) continue;
            temp.add(mapping);
        }
        return temp;
    }

    public List getEngTables(RelationalDesign pdes, int inhType) {
        ArrayList<XtdMapping> temp = new ArrayList<XtdMapping>();
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        for (XtdMapping mapping : list) {
            DesignObject obj = mapping.getObjectMappedTo(this);
            if (mapping.getInheritanceType() != inhType && mapping.getInheritanceType() != 0 || obj == null || !(obj instanceof Table)) continue;
            temp.add(mapping);
        }
        return temp;
    }

    public List getAllMappedtables() {
        ArrayList<DesignObject> nlist = new ArrayList<DesignObject>();
        for (RelationalDesign rd : this.getDesign().getRelationalDesigns()) {
            List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, rd.getObjectID());
            for (XtdMapping mapping : list) {
                DesignObject obj = mapping.getObjectMappedTo(this);
                if (obj == null || !(obj instanceof Table)) continue;
                nlist.add(obj);
            }
        }
        return nlist;
    }

    public XtdMapping getMappingFor(Table table) {
        RelationalDesign pdes = (RelationalDesign)table.getDesignPart();
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        for (int i = 0; i < list.size(); ++i) {
            XtdMapping mapping = (XtdMapping)list.get(i);
            DesignObject tab = mapping.getObjectMappedTo(this);
            if (tab == null || tab != table) continue;
            return mapping;
        }
        return null;
    }

    public XtdMapping getMappingFor(Table table, int inherType) {
        RelationalDesign pdes = (RelationalDesign)table.getDesignPart();
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        for (int i = 0; i < list.size(); ++i) {
            XtdMapping mapping = (XtdMapping)list.get(i);
            DesignObject tab = mapping.getObjectMappedTo(this);
            if (tab == null || tab != table || inherType != mapping.getInheritanceType()) continue;
            return mapping;
        }
        return null;
    }

    @Override
    protected void clearStructure() {
        this.removeAllRelations();
        this.removeAllKeys();
        this.removeAll();
    }

    private void removeAllRelations() {
        for (Relation rel : this.getDesign().getLogicalDesign().getRelationSet().getRelationsTo(this)) {
            rel.remove();
        }
        for (Relation rel : this.getDesign().getLogicalDesign().getInheritanceRelationSet().getRelationsTo(this)) {
            rel.remove();
        }
    }

    @Override
    protected void updateStructure() {
        block8: {
            block7: {
                TypeElement te;
                int i;
                if (!this.isBST()) break block7;
                StructuredType st = this.getBasedOnStructuredType();
                if ("XMLTYPE".equalsIgnoreCase(st.getName())) break block8;
                List stElems = st.getAllElements();
                ContainedObject[] coar = this.getElements();
                for (i = 0; i < coar.length; ++i) {
                    if (coar[i].isOid() || (te = this.findTypeElement(stElems, coar[i].getStructAttributeID())) != null) continue;
                    coar[i].remove();
                }
                this.addOidAttribute();
                this.updateElements(stElems);
                for (i = 0; i < stElems.size(); ++i) {
                    te = (TypeElement)stElems.get(i);
                    ContainedObject co = this.getElementByStructAttributeID(te.getObjectID());
                    if (co == null) continue;
                    this.moveToIndex(co, i + 1);
                }
                break block8;
            }
            ContainedObject[] cols = this.getElements();
            for (int i = 0; i < cols.length; ++i) {
                Attribute attr = (Attribute)cols[i];
                if (!(attr.getDataType() instanceof StructuredType) || attr.isReference()) continue;
                List telems = ((StructuredType)attr.getDataType()).getAllElements();
                for (int j = 0; j < telems.size(); ++j) {
                    TypeElement te = (TypeElement)telems.get(j);
                    Attribute nestedAtt = (Attribute)this.getElementByStructAttributeID(te.getObjectID(), attr);
                    if (nestedAtt == null) {
                        nestedAtt = this.createNestedAttribute(te.getName(), attr);
                        nestedAtt.setStructAttributeID(te.getObjectID());
                    }
                    this.copyTEtoAttribute(te, nestedAtt);
                    try {
                        this.createNestedAttributes(te, nestedAtt);
                        continue;
                    }
                    catch (StackOverflowError e) {
                        return;
                    }
                }
            }
        }
    }

    public void createNestedAttributes(TypeElement te, Attribute parent) throws StackOverflowError {
        if (te.getType() instanceof StructuredType && !te.isReference()) {
            StructuredType st = (StructuredType)te.getType();
            TypeElement[] telems = st.getElements();
            for (int i = 0; i < telems.length; ++i) {
                TypeElement tel = telems[i];
                Attribute attr = (Attribute)this.getElementByStructAttributeID(tel.getObjectID(), parent);
                if (attr == null) {
                    attr = this.createNestedAttribute(te.getName(), parent);
                    attr.setStructAttributeID(tel.getObjectID());
                }
                this.copyTEtoAttribute(tel, attr);
                this.createNestedAttributes(tel, attr);
            }
        }
    }

    public void createNestedAttributes(StructuredType st, Attribute parent) {
        Object[] coar = parent.getNestedObjects().toArray();
        if (st == null || parent.isReference() || parent.getUse() != 3) {
            for (int j = 0; j < coar.length; ++j) {
                ContainedObject cob = (ContainedObject)coar[j];
                this.removeNestedCOFor(cob);
                cob.remove();
                this.nestedElements.remove(cob);
            }
        } else {
            List stElems = st.getAllElements();
            for (int j = 0; j < coar.length; ++j) {
                ContainedObject cob = (ContainedObject)coar[j];
                TypeElement te = this.findTypeElement(stElems, cob.getStructAttributeID());
                if (te != null) continue;
                this.removeNestedCOFor(cob);
                cob.remove();
                this.nestedElements.remove(cob);
            }
            TypeElement[] telems = st.getElements();
            for (int i = 0; i < telems.length; ++i) {
                TypeElement tel = telems[i];
                Attribute nestedAtt = (Attribute)this.getElementByStructAttributeID(tel.getObjectID(), parent);
                if (nestedAtt == null) {
                    nestedAtt = new Attribute(this.getDesignPart());
                    nestedAtt.setStructAttributeID(tel.getObjectID());
                    nestedAtt.setDesign(this.getDesign());
                    nestedAtt.setContainer(this);
                    nestedAtt.setParentObject(parent);
                    this.add(nestedAtt);
                }
                this.copyTEtoAttribute(tel, nestedAtt);
            }
        }
    }

    public Attribute createNestedAttribute(String name, Attribute parent) {
        Attribute attribute = new Attribute(this.getDesignPart());
        attribute.setDesign(this.getDesign());
        attribute.setContainer(this);
        attribute.setParentObject(parent);
        this.getAttributeSet().add(attribute);
        this.add(attribute);
        if (name != null) {
            attribute.setName(name);
        }
        return attribute;
    }

    private TypeElement findTypeElement(List list, String id) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement te = (TypeElement)list.get(i);
            if (!te.getObjectID().equalsIgnoreCase(id)) continue;
            return te;
        }
        return null;
    }

    private void addOidAttribute() {
        if (this.getElementsCollection().size() == 0) {
            Attribute attribute = new Attribute(this.getDesignPart());
            attribute.setName("Oid");
            attribute.setOid(true);
            attribute.setUse((short)3);
            attribute.setReference(true);
            attribute.setStructuredType(this.getBasedOnStructuredType());
            attribute.setDesign(this.getDesign());
            attribute.setContainer(this);
            attribute.setNullsAllowed(false);
            this.add(attribute);
            this.getDesign().getLogicalDesign().getAttributeSet().add(attribute);
            CandidateKey key = this.createCandidateKey();
            key.setPK(true);
            key.add(attribute);
            key.setName(ApplyAttributesNamingStandards.createPrimaryIdentifierName(this.getName(), this.getShortName(), this.getDesign().getDesignLevelSettings().getNamingStandardRule()));
            key.setOidKey(true);
        }
    }

    private void updateElements(List telems) {
        for (int i = 0; i < telems.size(); ++i) {
            TypeElement te = (TypeElement)telems.get(i);
            Attribute attribute = (Attribute)this.getElementByStructAttributeID(te.getObjectID());
            if (attribute == null) {
                attribute = new Attribute(this.getDesignPart());
                attribute.setName(te.getName());
                attribute.setStructAttributeID(te.getObjectID());
                attribute.setDesign(this.getDesign());
                attribute.setContainer(this);
                this.add(attribute);
                this.getAttributeSet().add(attribute);
            }
            this.copyTEtoAttribute(te, attribute);
            try {
                this.createNestedAttributes(te, attribute);
                continue;
            }
            catch (StackOverflowError e) {
                return;
            }
        }
    }

    private void copyTEtoAttribute(TypeElement te, Attribute attribute) {
        attribute.setName(te.getName());
        DesignObject teType = te.getType();
        if (teType instanceof LogicalDatatype) {
            attribute.setUse((short)1);
            attribute.setLogicalDatatype((LogicalDatatype)teType);
            attribute.setReference(false);
            String units = te.getUnits();
            if (units != null && !"".equals(units) && !te.getSize().equals("")) {
                attribute.setDataTypeParameter("size", te.getSize() + " " + units);
            } else {
                attribute.setDataTypeParameter("size", te.getSize());
            }
            attribute.setDataTypeParameter("precision", Integer.toString(te.getPrecision()));
            attribute.setDataTypeParameter("scale", Integer.toString(te.getScale()));
        } else if (teType instanceof DistinctType) {
            attribute.setUse((short)2);
            attribute.setDistinctType((DistinctType)teType);
            attribute.setReference(false);
        } else if (teType instanceof StructuredType) {
            attribute.setUse((short)3);
            attribute.setReference(te.isReference());
            attribute.setStructuredType((StructuredType)teType);
        } else if (teType instanceof CollectionType) {
            attribute.setUse((short)4);
            attribute.setCollectionType((CollectionType)teType);
        } else if (teType instanceof Domain) {
            Domain dom = (Domain)teType;
            attribute.setUse((short)0);
            attribute.setDomain(dom);
            attribute.setReference(false);
            attribute.setDataTypeParameter("size", dom.getSize());
            attribute.setDataTypeParameter("precision", dom.getPrecision());
            attribute.setDataTypeParameter("scale", dom.getScale());
        }
        attribute.setNullsAllowed(!te.isMandatory());
    }

    public Attribute getExactRefToStructurtedType(StructuredType type, Entity entity) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Attribute oid = (Attribute)entity.getOidElement();
        if (oid != null) {
            String oidId = oid.getObjectID();
            for (Attribute cod : this.getElementsAndNestedElementsCollection()) {
                ContainerWithKeyObject scope;
                if (cod.isOid() || !cod.isExactRefToStructuredType(type)) continue;
                if (cod.getScopeId() != null && (scope = (ContainerWithKeyObject)this.getDesign().getDesignObject(cod.getScopeId())) != null && scope.isBST() && scope.getBasedOnStructuredType() == type) {
                    String refid = cod.getReferedAttribute();
                    if (scope == entity && oidId.equalsIgnoreCase(refid)) {
                        return cod;
                    }
                }
                list.add(cod);
            }
            for (Attribute cod : list) {
                String refid = cod.getReferedAttribute();
                if (cod.getScopeId() != null || !oidId.equalsIgnoreCase(refid)) continue;
                return cod;
            }
            for (Attribute cod : list) {
                if (cod.getScopeId() != null) continue;
                cod.setReferedAttribute(oidId);
                return cod;
            }
            if (list.size() == 1) {
                Attribute cod;
                cod = (Attribute)list.get(0);
                cod.setReferedAttribute(oidId);
                return cod;
            }
        }
        return null;
    }

    public Attribute getRefToStructurtedType(StructuredType type, Entity entity) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Attribute oid = (Attribute)entity.getOidElement();
        if (oid != null) {
            String oidId = oid.getObjectID();
            for (Attribute cod : this.getElementsAndNestedElementsCollection()) {
                ContainerWithKeyObject scope;
                if (cod.isOid() || !cod.isRefToStructuredType(type)) continue;
                if (cod.getScopeId() != null && (scope = (ContainerWithKeyObject)this.getDesign().getDesignObject(cod.getScopeId())) != null && scope.isBST() && scope.getBasedOnStructuredType() == type) {
                    String refid = cod.getReferedAttribute();
                    if (scope == entity && oidId.equalsIgnoreCase(refid)) {
                        return cod;
                    }
                }
                list.add(cod);
            }
            if (list.size() == 1) {
                return (Attribute)list.get(0);
            }
            for (Attribute cod : list) {
                String refid = cod.getReferedAttribute();
                if (cod.getScopeId() != null || !oidId.equalsIgnoreCase(refid)) continue;
                return cod;
            }
            for (Attribute cod : list) {
                if (cod.getScopeId() != null) continue;
                return cod;
            }
        }
        return null;
    }

    public Attribute findBestMatchForFKattr(Attribute fkattr, List exclude) {
        if (!fkattr.isReference() && !(fkattr.getDataType() instanceof StructuredType)) {
            ArrayList<Attribute> list = new ArrayList<Attribute>();
            String fkid = fkattr.getObjectID();
            String fkdt = fkattr.getDataType().toString();
            String fkName = fkattr.getName();
            for (Attribute attr : this.getElementsAndNestedElementsCollection()) {
                if (attr.isOid() || exclude.contains(attr)) continue;
                if (fkid.equalsIgnoreCase(attr.getReferedAttribute())) {
                    return attr;
                }
                if (attr.isReference() || attr.getDataType() instanceof StructuredType || attr.isFKAttribute() || !attr.getDataType().toString().equalsIgnoreCase(fkdt)) continue;
                list.add(attr);
            }
            for (Attribute attr : list) {
                if (!fkName.equalsIgnoreCase(attr.getName())) continue;
                return attr;
            }
            for (Attribute attr : list) {
                if (attr.getName().indexOf(fkName) <= -1) continue;
                return attr;
            }
            for (Attribute attr : list) {
                if (attr.getName().toUpperCase().indexOf(fkName.toUpperCase()) <= -1) continue;
                return attr;
            }
            if (list.size() > 0) {
                return (Attribute)list.get(0);
            }
        }
        return null;
    }

    public Relation getInheritanceRelation() {
        return this.inheritanceRelation;
    }

    public XtdMapping getDeletedMapping(String designPartID) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, designPartID);
        if (list.size() > 0) {
            XtdMapping mapping = (XtdMapping)list.get(0);
            return mapping;
        }
        return null;
    }

    public List getAllDeletedMappings() {
        ArrayList list = new ArrayList();
        list.addAll(this.getDesign().getExtendedMap().getAllDeletedMappings(this));
        for (DesignObject dobj : this.getElementsCollection()) {
            list.addAll(this.getDesign().getExtendedMap().getAllDeletedMappings(dobj));
        }
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            DesignObject dobj;
            dobj = (DesignObject)it.next();
            list.addAll(this.getDesign().getExtendedMap().getAllDeletedMappings(dobj));
        }
        return list;
    }

    public void addArc(Arc arc) {
        if (!this.arcExists(arc)) {
            this.arcs.add(arc);
            arc.setEntity(this);
            arc.addObjectListener(this);
            this.updateArcSizeIndexes();
        }
    }

    public boolean arcExists(Arc arc) {
        if (this.arcs.contains(arc)) {
            return true;
        }
        for (Arc next : this.arcs) {
            if (next.getRelations().size() != arc.getRelations().size() || !next.getRelations().containsAll(arc.getRelations())) continue;
            return true;
        }
        return false;
    }

    public boolean arcExists(List relations) {
        for (Arc next : this.arcs) {
            if (!next.getRelations().containsAll(relations)) continue;
            return true;
        }
        return false;
    }

    public void removeArc(Arc arc) {
        this.arcs.remove(arc);
        arc.removeObjectListener(this);
        this.updateArcSizeIndexes();
    }

    public void deleteAllArcs() {
        Object[] allArcs = this.arcs.toArray();
        for (int i = allArcs.length - 1; i >= 0; --i) {
            Arc arc = (Arc)allArcs[i];
            arc.remove();
        }
    }

    public List getArcs() {
        return this.arcs;
    }

    public void clearArcs() {
        this.arcs.clear();
    }

    private void updateArcSizeIndexes() {
        Object[] allArcs = this.arcs.toArray();
        for (int i = 0; i < allArcs.length; ++i) {
            Arc arc = (Arc)allArcs[i];
            arc.setSizeIndex((i + 1) * 20);
        }
    }

    public boolean inArc(Relation relation) {
        for (Arc next : this.arcs) {
            if (!next.containsRelation(relation)) continue;
            return true;
        }
        return false;
    }

    public void showArcs(boolean show) {
        for (Arc next : this.arcs) {
            next.setVisible(show);
            if (show) {
                this.getDesignPart().getMainView().getWorkSpace().addArc(next, new Rectangle());
                continue;
            }
            this.getDesignPart().getMainView().getWorkSpace().removeArc(next);
        }
    }

    @Override
    public String getFCObjectType() {
        return TYPE_NAME;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    public boolean hasFKPathTo(Entity entity) {
        ArrayList list = new ArrayList();
        return this.hasFKPathTo(entity, list);
    }

    private boolean hasFKPathTo(Entity entity, List list) {
        if (this == entity) {
            return true;
        }
        list.add(this);
        KeyObject pk = this.getPK();
        if (pk == null) {
            return false;
        }
        for (Attribute attr : pk.getElementsCollection()) {
            boolean result;
            Entity ent;
            Attribute delegate;
            if (!attr.isFKAttribute() || (delegate = attr.getDelegate()) == null || list.contains(ent = (Entity)delegate.getContainerWithKeyObject()) || !(result = ent.hasFKPathTo(entity, list))) continue;
            return true;
        }
        return false;
    }

    public boolean hasRelPathTo(Entity entity) {
        ArrayList list = new ArrayList();
        return this.hasRelPathTo(entity, list);
    }

    private boolean hasRelPathTo(Entity entity, List list) {
        if (this == entity) {
            return true;
        }
        list.add(this);
        for (Relation.Connection conn : this.relationConnections) {
            boolean result;
            int[] ends;
            Relation rel;
            Entity ent = conn.getOtherEntity();
            if (ent == this || !(rel = conn.getRelation()).isIdentifying() || (ends = rel.getPKProviderEndPoint()).length != 1 || rel.getEntity(ends[0]) != ent || list.contains(ent) || !(result = ent.hasFKPathTo(entity, list))) continue;
            return true;
        }
        return false;
    }

    public boolean hasFK_Rel_PathTo(Entity entity) {
        return this.hasFKPathTo(entity) || this.hasRelPathTo(entity);
    }

    public Attribute getFKAttributeForOriginating(Attribute attribute) {
        for (Attribute attr : this.getElementsAndNestedElementsCollection()) {
            if (!attr.isFKAttribute() || attr.getOriginatingAttribute() != attribute) continue;
            return attr;
        }
        return null;
    }

    public Attribute getFKAttributeForOriginating(Attribute attribute, Relation relation) {
        String relid = relation.getObjectID();
        for (Attribute attr : this.getElementsAndNestedElementsCollection()) {
            if (!attr.isFKAttribute() || !attr.getGeneratorID().equalsIgnoreCase(relid) || attr.getOriginatingAttribute() != attribute) continue;
            return attr;
        }
        return null;
    }

    public String getPreferredAbbreviation() {
        return this.preferredAbbreviation;
    }

    public void setPreferredAbbreviation(String preferredAbbreviation) {
        this.preferredAbbreviation = preferredAbbreviation;
    }

    public List getPKProviderRelations() {
        ArrayList<Relation> list = new ArrayList<Relation>();
        Relation.Connection[] cons = this.getRelationConnections();
        for (int i = 0; i < cons.length; ++i) {
            Relation rel = cons[i].getRelation();
            if (rel instanceof InheritanceRelation || !rel.isPKConsumer(this)) continue;
            list.add(cons[i].getRelation());
        }
        return list;
    }

    public String getSynonymToDisplay() {
        return this.synonymToDisplay;
    }

    public void setSynonymToDisplay(String synonymToDisplay) {
        this.synonymToDisplay = synonymToDisplay;
    }

    public void clearViews() {
        Iterator it = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView view = (EntityView)it.next();
            view.clear(this);
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "entity" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public List getUniqueIdentifiers() {
        ArrayList list = new ArrayList();
        this.getKeySet().addAllElementsTo(list);
        return list;
    }

    public void applyKeyOrderFromList(List orderedKeys) {
        this.getKeySet().applyOrderFromList(orderedKeys);
    }

    public String getHierarchicalParentID() {
        if (this.getHierarchicalParent() != null) {
            this.hierarchicalParentID = this.getHierarchicalParent().getObjectID();
        }
        return this.hierarchicalParentID;
    }

    public void setHierarchicalParentID(String hierarchicalParentID) {
        this.hierarchicalParentID = hierarchicalParentID;
    }

    public Map getFoldedAttributesMap() {
        return this.foldedAttributesMap;
    }

    public List getHierarchicalChildren() {
        return this.hierarchicalChildren;
    }

    public List getAllHierarchicalChildren() {
        ArrayList list = new ArrayList();
        list.addAll(this.hierarchicalChildren);
        for (Entity ent : this.hierarchicalChildren) {
            list.addAll(ent.getAllHierarchicalChildren());
        }
        return list;
    }

    public Entity getTopShouldEngineeredHierarchcalParent() {
        if (this.isHierarchicalEntityType()) {
            Entity parent;
            Entity top = null;
            if (this.shouldBeEngineered()) {
                top = this;
            }
            if ((parent = this.getHierarchicalParent()) != null) {
                top = parent.shouldBeEngineered() ? parent : parent.getTopShouldEngineeredHierarchcalParent();
            }
            return top;
        }
        return null;
    }

    public List<Entity> getShouldEngineeredChildren() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (this.isHierarchicalEntityType()) {
            for (Entity child : this.hierarchicalChildren) {
                if (child.shouldBeEngineered()) {
                    list.add(child);
                    continue;
                }
                child.getShouldEngineeredChildren(list);
            }
        }
        return list;
    }

    private void getShouldEngineeredChildren(List<Entity> list) {
        for (Entity child : this.hierarchicalChildren) {
            if (child.shouldBeEngineered()) {
                list.add(child);
                continue;
            }
            child.getShouldEngineeredChildren(list);
        }
    }

    public String getSubtypesRefType() {
        return this.subtypesRefType;
    }

    public void setSubtypesRefType(String subtypesRefType) {
        this.subtypesRefType = subtypesRefType;
    }

    public String getAttributeInherType() {
        return this.attributeInherType;
    }

    public void setAttributeInherType(String attributeInherType) {
        this.attributeInherType = attributeInherType;
    }

    public boolean isGenerateDiscriminatorColumn() {
        return this.generateDiscriminatorColumn;
    }

    public void setGenerateDiscriminatorColumn(boolean generateDiscriminatorColumn) {
        this.generateDiscriminatorColumn = generateDiscriminatorColumn;
    }

    public String getDiscriminatorAttributeID() {
        if (this.discriminatorAttribute != null) {
            this.discriminatorAttributeID = this.discriminatorAttribute.getObjectID();
        }
        return this.discriminatorAttributeID;
    }

    public void setDiscriminatorAttributeID(String discriminatorAttributeID) {
        this.discriminatorAttributeID = discriminatorAttributeID;
    }

    public Attribute getDiscriminatorAttribute() {
        if (this.discriminatorAttribute == null) {
            this.discriminatorAttribute = (Attribute)this.getDesign().getDesignObject(this.discriminatorAttributeID);
        }
        return this.discriminatorAttribute;
    }

    public void setDiscriminatorAttribute(Attribute discriminatorAttribute) {
        if (this.discriminatorAttribute != null && discriminatorAttribute == null && !this.getDesign().isLoading()) {
            this.setDiscriminatorAttributeID(null);
        }
        this.discriminatorAttribute = discriminatorAttribute;
    }

    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    public void setDiscriminatorColumnName(String discriminatorColumnName) {
        this.discriminatorColumnName = discriminatorColumnName;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public boolean isCompleteSubtypes() {
        return this.completeSubtypes;
    }

    public void setCompleteSubtypes(boolean completeSubtypes) {
        this.completeSubtypes = completeSubtypes;
    }

    public boolean isCreateSurrogateKey() {
        return this.createSurrogateKey;
    }

    public void setCreateSurrogateKey(boolean createSurrogateKey) {
        this.createSurrogateKey = createSurrogateKey;
    }

    public Relation getContainerRelation() {
        return this.containerRelation;
    }

    public void setContainerRelation(Relation containerRelation) {
        this.containerRelation = containerRelation;
    }

    public List getKeysUsingRelationsip(Relation rel) {
        ArrayList<CandidateKey> list = null;
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            CandidateKey key = (CandidateKey)it.next();
            if (!key.getNewElementsCollection().contains(rel)) continue;
            if (list == null) {
                list = new ArrayList<CandidateKey>();
            }
            list.add(key);
        }
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getName() {
        Relation rel = this.getContainerRelation();
        if (rel != null) {
            return rel.getName();
        }
        return super.getName();
    }

    public void sortAttributes(boolean sortAscending) {
        List attributes = this.getAttributes();
        if (sortAscending) {
            Collections.sort(attributes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Attribute a1 = (Attribute)o1;
                    Attribute a2 = (Attribute)o2;
                    return a1.getName().compareTo(a2.getName());
                }
            });
        } else {
            Collections.sort(attributes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Attribute a1 = (Attribute)o1;
                    Attribute a2 = (Attribute)o2;
                    return -a1.getName().compareTo(a2.getName());
                }
            });
        }
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute a = (Attribute)attributes.get(i);
            Attribute attribute = (Attribute)this.getElementByID(a.getObjectID());
            attribute.moveToIndex(i);
        }
        this.setDirty(true);
    }

    public static class NullEntity
    extends Entity {
        public NullEntity(DesignPart designPart) {
            super(designPart);
        }

        @Override
        public String toString() {
            return " ";
        }

        @Override
        public String getName() {
            return " ";
        }
    }
}

