/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeSet;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.GlobalIndexSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.memento.Memento;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.editor.logical.KeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.TVRelation;

public class CandidateKey
extends KeyObject {
    private static Set keyStateSet = null;
    private String synonym = "";
    private List newElementsCollection = new ArrayList();
    private String newElementsIDs = "";
    private boolean isNewElementsIDsProcessed = false;
    private List tempObjects;

    public CandidateKey(DesignPart designPart) {
        super(designPart);
        this.unique = true;
    }

    @Override
    public String getObjectTypeName() {
        return "Candidate Key";
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("altkey id prefix");
    }

    protected AttributeSet getAttributeSet() {
        return this.getDesign().getLogicalDesign().getAttributeSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getAttributeSet();
    }

    private boolean checkKeyStateValue(String value) {
        if (keyStateSet == null) {
            keyStateSet = new HashSet();
            keyStateSet.addAll(Arrays.asList(KEY_STATES));
        }
        return keyStateSet.contains(value);
    }

    public void setKeyState(String keyState) {
        if (this.checkKeyStateValue(keyState)) {
            if ("Unique Key".equalsIgnoreCase(keyState)) {
                if (this.isPK()) {
                    this.setPK(false);
                }
                this.setColumnsState(true);
            } else if ("Primary Key".equalsIgnoreCase(keyState)) {
                this.setPK(true);
                if (this.getContainerWithKeyObject() != null) {
                    this.getContainerWithKeyObject().setPK(this);
                }
            }
        }
    }

    public String getKeyState() {
        return this.isPK() ? "Primary Key" : "Unique Key";
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String synonym) {
        if (!this.synonym.equals(synonym)) {
            this.synonym = synonym;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    @Override
    public boolean hasAliveGenerator() {
        ModelIDObject obj;
        GlobalIndexSet set = this.getDesign().getRelationalDesign().getGlobalIndexSet();
        return "User generated".equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null;
    }

    public Index getEngIndex(RelationalDesign pdes) {
        XtdMapping mapping;
        Index ind;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        if (list.size() > 0 && (ind = (Index)(mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null) {
            return ind;
        }
        Index index = (Index)this.getGenerator();
        if (index != null && index.getDesignPart() == pdes) {
            return index;
        }
        index = (Index)pdes.getGlobalIndexSet().getObjectGeneratedBy(this.getObjectID());
        return index;
    }

    public Index getEngIndex(RelationalDesign pdes, Table table) {
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        for (XtdMapping mapping : list) {
            Index ind = (Index)mapping.getObjectMappedTo(this);
            if (ind == null || ind.getContainerWithKeyObject() != table) continue;
            return ind;
        }
        Index index = (Index)this.getGenerator();
        if (index != null && index.getDesignPart() == pdes && index.getContainerWithKeyObject() == table) {
            return index;
        }
        index = (Index)pdes.getGlobalIndexSet().getObjectGeneratedBy(this.getObjectID());
        if (index != null && index.getContainerWithKeyObject() == table) {
            return index;
        }
        return null;
    }

    public XtdMapping getMappingFor(Table table) {
        if (table != null) {
            RelationalDesign pdes = (RelationalDesign)table.getDesignPart();
            List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
            for (XtdMapping mapping : list) {
                Index ind;
                DesignObject obj = mapping.getObjectMappedTo(this);
                if (!(obj instanceof Index) || (ind = (Index)obj) == null || ind.getContainerWithKeyObject() != table) continue;
                return mapping;
            }
        }
        return null;
    }

    public List getMappingsFor(Table table) {
        ArrayList<XtdMapping> temp = new ArrayList<XtdMapping>();
        if (table != null) {
            RelationalDesign pdes = (RelationalDesign)table.getDesignPart();
            List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
            for (XtdMapping mapping : list) {
                Index ind;
                DesignObject obj = mapping.getObjectMappedTo(this);
                if (!(obj instanceof Index) || (ind = (Index)obj) == null || ind.getContainerWithKeyObject() != table) continue;
                temp.add(mapping);
            }
        }
        return temp;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            KeyPropertiesDialogEx dialog = new KeyPropertiesDialogEx(this.getDesign().getAppView(), this);
            ArrayList columnsList = new ArrayList(this.getContainerObject().getElementsCollection());
            columnsList.addAll(this.getContainerObject().getNestedElements());
            dialog.setAttributesList(columnsList);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    protected void clearStructure() {
    }

    @Override
    protected void updateStructure() {
    }

    @Override
    public void clearElements() {
        super.clearElements();
        this.getNewElementsCollection().clear();
    }

    public List getNewElementsCollection() {
        if (!"".equals(this.newElementsIDs)) {
            boolean allExist = true;
            this.newElementsCollection.clear();
            String[] ids = this.newElementsIDs.split(",");
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i].trim();
                DesignObject obj = this.getDesign().getDesignObject(id);
                if (obj == null) {
                    obj = this.getFromTempObjects(this.getTempObjects(), id);
                }
                if (obj != null) {
                    this.newElementsCollection.add(obj);
                    continue;
                }
                allExist = false;
            }
            this.isNewElementsIDsProcessed = allExist;
            if (allExist) {
                this.newElementsIDs = "";
            }
        }
        return this.newElementsCollection;
    }

    private DesignObject getFromTempObjects(List tempObjects, String id) {
        if (tempObjects != null && id != null) {
            for (Object obj : tempObjects) {
                DesignObject dobj;
                if (!(obj instanceof DesignObject) || !id.equals((dobj = (DesignObject)obj).getObjectID())) continue;
                return dobj;
            }
        }
        return null;
    }

    @Override
    public void add(ContainedObject object) {
        if (!this.getNewElementsCollection().contains(object)) {
            if (object instanceof Attribute && ((Attribute)object).isFKAttribute()) {
                Relation rel = (Relation)this.getDesign().getDesignObject(object.getGeneratorID());
                if (rel != null && !this.getNewElementsCollection().contains(rel)) {
                    this.addElement(rel);
                }
            } else {
                this.getNewElementsCollection().add(object);
            }
        }
        if (!this.getElementsCollection().contains(object)) {
            super.add(object);
        }
    }

    @Override
    public void remove(ContainedObject object) {
        this.getNewElementsCollection().remove(object);
        super.remove(object);
    }

    public void addElement(DesignObject object) {
        block10: {
            block8: {
                block9: {
                    if (this.getNewElementsCollection().contains(object)) break block8;
                    if (object instanceof Relation) break block9;
                    this.getNewElementsCollection().add(object);
                    break block10;
                }
                Relation rel = (Relation)object;
                boolean foundexisting = false;
                Attribute[] attrs = rel.getFKAttributes((Entity)this.getContainerWithKeyObject());
                for (int i = 0; i < attrs.length; ++i) {
                    if (!this.getElementsCollection().contains(attrs[i])) {
                        super.add(attrs[i]);
                    }
                    if (!this.getNewElementsCollection().contains(attrs[i])) continue;
                    if (!foundexisting) {
                        int ind = this.getNewElementsCollection().indexOf(attrs[i]);
                        this.getNewElementsCollection().add(ind, object);
                        foundexisting = true;
                    }
                    this.getNewElementsCollection().remove(attrs[i]);
                }
                if (!foundexisting) {
                    this.getNewElementsCollection().add(object);
                }
                rel.addObjectListener(this);
                CandidateKey key = (CandidateKey)this.getContainerWithKeyObject().getPKorUnique();
                if (key != this) break block10;
                rel.setIdentifying(true);
                rel.setDirty(true);
                int endp = rel.getEndPointFor((Entity)this.getContainerWithKeyObject());
                rel.setOptional(endp, Boolean.FALSE);
                for (TVRelation tv : rel.getAllTVRelations()) {
                    if (tv == null) continue;
                    tv.resetEdgeParams(true);
                }
                break block10;
            }
            if (object instanceof Relation) {
                Relation rel = (Relation)object;
                Attribute[] attrs = rel.getFKAttributes((Entity)this.getContainerWithKeyObject());
                for (int i = 0; i < attrs.length; ++i) {
                    if (!this.getElementsCollection().contains(attrs[i])) {
                        this.add(attrs[i]);
                    }
                    if (!this.getNewElementsCollection().contains(attrs[i])) continue;
                    this.getNewElementsCollection().remove(attrs[i]);
                }
            }
        }
    }

    public void removeElement(DesignObject object) {
        if (this.getNewElementsCollection().contains(object)) {
            this.getNewElementsCollection().remove(object);
            if (object instanceof Relation) {
                Relation rel = (Relation)object;
                rel.removeObjectListener(this);
                Attribute[] attrs = rel.getFKAttributes((Entity)this.getContainerWithKeyObject());
                for (int i = 0; i < attrs.length; ++i) {
                    super.remove(attrs[i]);
                }
                if (rel.isIdentifying()) {
                    rel.setIdentifying(false);
                    rel.setDirty(true);
                    if (rel.getTopView() != null) {
                        ((TVRelation)rel.getTopView()).resetEdgeParams(true);
                    }
                }
            }
        }
    }

    public void updateElementsCollection() {
        super.getElementsCollection().clear();
        for (DesignObject dobj : this.getNewElementsCollection()) {
            if (dobj instanceof ContainedObject) {
                super.getElementsCollection().add(dobj);
                continue;
            }
            if (!(dobj instanceof Relation)) continue;
            Relation rel = (Relation)dobj;
            Attribute[] attrs = rel.getFKAttributes((Entity)this.getContainerWithKeyObject());
            for (int i = 0; i < attrs.length; ++i) {
                super.getElementsCollection().add(attrs[i]);
            }
        }
        Entity ent = (Entity)this.getContainerWithKeyObject();
        if (ent != null && ent.hasKey(this)) {
            this.sharedEvent.setType(9);
            this.fireChange(this.sharedEvent);
        }
    }

    public boolean moveElementToIndex(DesignObject object, int index) {
        if (this.getNewElementsCollection().contains(object) && this.getNewElementsCollection().size() > index && index >= 0) {
            this.getNewElementsCollection().remove(object);
            this.getNewElementsCollection().add(index, object);
            this.sharedEvent.setType(7);
            this.sharedEvent.setElement(object);
            return true;
        }
        return false;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.FK_ATTRIBUTES_CHANGED)) {
            this.updateElementsCollection();
        }
        if (event.isType(ObjectChangeEvent.OBJECT_REMOVED)) {
            object.removeObjectListener(this);
            this.removeElement(object);
        }
        super.changed(object, event);
    }

    public boolean shouldBeEngineered(XtdMapping tableMapping) {
        return !tableMapping.getKeys().contains(this.getObjectID());
    }

    public void updateContainedObjects() {
        Iterator it = this.getNewElementsCollection().iterator();
        ArrayList<DesignObject> list = new ArrayList<DesignObject>();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof Attribute) {
                Attribute attribute = (Attribute)next;
                if (attribute.isFKAttribute()) {
                    Relation rel = (Relation)this.getDesign().getDesignObject(attribute.getGeneratorID());
                    if (rel == null || list.contains(rel)) continue;
                    list.add(rel);
                    continue;
                }
                list.add(attribute);
                continue;
            }
            list.add((DesignObject)next);
        }
        this.getNewElementsCollection().clear();
        this.getNewElementsCollection().addAll(list);
    }

    @Override
    public void remove() {
        Entity ent = this.getEntity();
        if (ent != null) {
            for (Relation rel : this.getRelations()) {
                if (!rel.isIdentifying() || ent.getKeysUsingRelationsip(rel).size() != 1) continue;
                rel.setIdentifying(false);
            }
        }
        super.remove();
    }

    public List getRelations() {
        ArrayList<DesignObject> list = new ArrayList<DesignObject>();
        for (DesignObject dobj : this.getNewElementsCollection()) {
            if (!(dobj instanceof Relation)) continue;
            list.add(dobj);
        }
        return list;
    }

    public boolean hasRelations() {
        for (DesignObject dobj : this.getNewElementsCollection()) {
            if (!(dobj instanceof Relation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRelations(RelationalDesign rdes, Table table) {
        for (DesignObject dobj : this.getNewElementsCollection()) {
            KeyObject ind;
            Relation rel;
            FKIndexAssociation fk;
            if (!(dobj instanceof Relation) || (fk = (rel = (Relation)dobj).getEngFK(rdes, table)) == null || (ind = fk.getRemoteIndex()) == null || !ind.isSurrogateKey()) continue;
            return true;
        }
        return false;
    }

    public Entity getEntity() {
        return (Entity)this.getContainerWithKeyObject();
    }

    public List getAttributesInKey() {
        if (this.getElementsCollection().size() > 0) {
            return new ArrayList(this.getElementsCollection());
        }
        return Collections.EMPTY_LIST;
    }

    public List getAttributesAndRelationshipsInKey() {
        if (this.getNewElementsCollection().size() > 0) {
            return new ArrayList(this.getNewElementsCollection());
        }
        return Collections.EMPTY_LIST;
    }

    public String getNewElementsIDs() {
        if (this.getNewElementsCollection().size() > 0 && this.isNewElementsIDsProcessed) {
            Iterator it = this.getNewElementsCollection().iterator();
            boolean first = true;
            while (it.hasNext()) {
                DesignObject obj = (DesignObject)it.next();
                if (!first) {
                    this.newElementsIDs = this.newElementsIDs + "," + obj.getObjectID();
                    continue;
                }
                this.newElementsIDs = obj.getObjectID();
                first = false;
            }
        } else if (this.isNewElementsIDsProcessed) {
            this.newElementsIDs = "";
        }
        return this.newElementsIDs;
    }

    public void setNewElementsIDs(String newElementsIDs) {
        this.newElementsIDs = newElementsIDs;
    }

    public String getElemntsPresentationAsString() {
        String res = "";
        for (DesignObject obj : this.getNewElementsCollection()) {
            if ("".equals(res)) {
                res = obj.getName();
                continue;
            }
            res = res + " \n" + obj.getName();
        }
        return res;
    }

    public boolean isNewElementsIDsProcessed() {
        return this.isNewElementsIDsProcessed;
    }

    public void setNewElementsIDsProcessed(boolean isNewElementsIDsProcessed) {
        this.isNewElementsIDsProcessed = isNewElementsIDsProcessed;
    }

    public List getTempObjects() {
        return this.tempObjects;
    }

    public void setTempObjects(List tempObjects) {
        this.tempObjects = tempObjects;
    }

    @Override
    public boolean isSurrogateKey() {
        return false;
    }

    @Override
    public ContainedObject[] getColumns() {
        return null;
    }

    @Override
    public Memento getIndexMemento() {
        return null;
    }

    @Override
    public void synchronizeMarkedGenerate(boolean markedGenerate) {
    }

    @Override
    public String getColumnSortOrder(Object column) {
        return null;
    }

    @Override
    public String getIndexState() {
        return null;
    }

    @Override
    public void setColumnSortOrder(Object column, String sortOrder) {
    }
}

