/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_AttributeView
extends LongNameObjectSelection {
    private AttributeView attributeView;

    public ImpA_AttributeView(AttributeView attributeView, ModelIdObjectSelection parent) {
        super(attributeView);
        this.attributeView = attributeView;
        this.setParent(parent);
        this.addAttrViewNodes(this);
    }

    private void addAttrViewNodes(ImpA_AttributeView parent) {
        ArrayList<AttributeView> list = new ArrayList<AttributeView>();
        Iterator it = this.attributeView.getDesign().getLogicalDesign().getAttributeViewSet().iterator();
        while (it.hasNext()) {
            AttributeView attrView = (AttributeView)it.next();
            if (attrView.getReferencedColumnView() == null || attrView.getReferencedColumnView() != this.attributeView) continue;
            list.add(attrView);
        }
        if (list.size() > 0) {
            ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_AttributeView.DependentViewAttributes"));
            selection.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
            parent.addChild(selection);
            for (AttributeView view : list) {
                if (!selection.hasAsParent(view)) {
                    selection.addChild(new ImpA_AttributeView(view, selection));
                    continue;
                }
                selection.addChild(new ModelIdObjectSelection(view));
            }
        }
    }
}

