/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.glossary;

import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;

public class GlossaryWord
implements NamingConstants {
    public static String EMPTY = "";
    private String name = "";
    private String abbreviation = "";
    private String altAbbrevation = "";
    private String shortDescription = "";
    private String plural = "";
    private String id = "";
    private String importID = "";
    private String type = "";
    private boolean dirty;
    private Glossary glossary;
    private boolean classWord = false;
    private boolean primaryWord = false;
    private boolean modifier = false;
    private boolean qualifier = false;

    public GlossaryWord(Glossary glossary) {
        this.glossary = glossary;
        this.dirty = true;
        glossary.setDirty(true);
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        if (!abbreviation.equals(this.abbreviation)) {
            this.abbreviation = abbreviation;
            this.setDirty(true);
        }
    }

    public String getAltAbbrevation() {
        return this.altAbbrevation;
    }

    public void setAltAbbrevation(String altAbbrevation) {
        if (!altAbbrevation.equals(this.altAbbrevation)) {
            this.altAbbrevation = altAbbrevation;
            this.setDirty(true);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.setDirty(true);
            this.glossary.updateMaps(oldName, name, this);
        }
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        if (!shortDescription.equals(this.shortDescription)) {
            this.shortDescription = shortDescription;
            this.setDirty(true);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (!type.equals(this.type)) {
            this.type = type;
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            this.glossary.setDirty(true);
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isClassWord() {
        return this.classWord;
    }

    public void setClassWord(boolean classWord) {
        if (this.classWord != classWord) {
            this.classWord = classWord;
            this.setDirty(true);
        }
    }

    public boolean isModifier() {
        return this.modifier;
    }

    public void setModifier(boolean modifier) {
        if (this.modifier != modifier) {
            this.modifier = modifier;
            this.setDirty(true);
        }
    }

    public boolean isPrimaryWord() {
        return this.primaryWord;
    }

    public void setPrimaryWord(boolean primaryWord) {
        if (this.primaryWord != primaryWord) {
            this.primaryWord = primaryWord;
            this.setDirty(true);
        }
    }

    public boolean isQualifier() {
        return this.qualifier;
    }

    public void setQualifier(boolean qualifier) {
        if (this.qualifier != qualifier) {
            this.qualifier = qualifier;
            this.setDirty(true);
        }
    }

    public String getImportID() {
        return this.importID;
    }

    public void setImportID(String importID) {
        this.importID = importID;
    }

    public void copyTo(GlossaryWord word) {
        word.setName(this.getName());
        word.setAbbreviation(this.getAbbreviation());
        word.setAltAbbrevation(this.getAltAbbrevation());
        word.setPlural(this.getPlural());
        word.setClassWord(this.isClassWord());
        word.setPrimaryWord(this.isPrimaryWord());
        word.setModifier(this.isModifier());
        word.setQualifier(this.isQualifier());
        word.setShortDescription(this.getShortDescription());
    }

    public String getPlural() {
        return this.plural;
    }

    public void setPlural(String plural) {
        this.plural = plural;
    }
}

