/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.FK_RelationComparator;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.FKAttributeManager;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVFKContainer;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.Logger;

public class ReverseEngineering
extends AbstractEngineering {
    private boolean notForNewObjects = false;
    private String typeName = "";
    private List properties = new ArrayList();
    private static final Logger LOGGER = new Logger(ReverseEngineering.class);
    private List fkeys = new ArrayList();
    private List tablelist = new ArrayList();
    private List processedFkeys = new ArrayList();
    private List tableViewList = new ArrayList();
    DesignPartView processedDPV;
    private boolean entireRelational = true;
    private RelationalDesign phdes;

    public ReverseEngineering(Design design) {
        super(design);
    }

    @Override
    public void execute(Map comparatorsMap) {
        this.execute(comparatorsMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map comparatorsMap, DesignPartView dpv) {
        DesignObject rel;
        Iterator it;
        this.comparatorsMap = comparatorsMap;
        this.tablelist.clear();
        this.processedFkeys.clear();
        this.fkeys.clear();
        this.tableViewList.clear();
        AbstractEngineering.useSameOptionForAll = false;
        this.design.setPropagatePKChahges(false);
        this.phdes = this.design.getRelationalDesign();
        this.processedDPV = dpv;
        if (dpv == null) {
            this.processedDPV = this.phdes.getMainView();
        }
        if (dpv == null || dpv == this.phdes.getMainView()) {
            this.phdes.getTableSet().addAllElementsTo(this.tablelist);
            this.phdes.getFKIndexAssociationSet().addAllElementsTo(this.processedFkeys);
            this.phdes.getTableViewSet().addAllElementsTo(this.tableViewList);
            this.entireRelational = true;
        } else {
            FKContainer ent;
            this.entireRelational = false;
            it = this.phdes.getTableSet().iterator();
            while (it.hasNext()) {
                ent = (Table)it.next();
                if (ent.getFirstViewForDPV(dpv) == null) continue;
                this.tablelist.add(ent);
            }
            it = this.phdes.getFKIndexAssociationSet().iterator();
            while (it.hasNext()) {
                rel = (FKIndexAssociation)it.next();
                if (((FKIndexAssociation)rel).getFirstViewForDPV(dpv) == null) continue;
                this.processedFkeys.add(rel);
            }
            it = this.phdes.getTableViewSet().iterator();
            while (it.hasNext()) {
                ent = (TableView)it.next();
                if (ent.getFirstViewForDPV(dpv) == null) continue;
                this.tableViewList.add(ent);
            }
        }
        this.design.getLogicalDesign().getMainView().getUndoManager().setLocked(true);
        this.targetDesPartID = this.design.getLogicalDesign().getObjectID();
        try {
            this.xmap = this.design.getRelationalDesign().getRMExtendedMap();
            this.fkeys.clear();
            this.notForNewObjects = this.design.getNotForNewObjects();
            if (!this.design.getRelationalDesign().getMainView().isAutoRoute()) {
                this.design.getLogicalDesign().getMainView().setAutoRoute(false);
                this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
            }
            this.fkeys.addAll(this.processedFkeys);
            try {
                FKAttributeManager.CAN_SYNCHRONIZE = false;
                this.processTables();
                this.createRelations();
                this.processForeignKeys();
            }
            finally {
                FKAttributeManager.CAN_SYNCHRONIZE = true;
                try {
                    it = this.design.getLogicalDesign().getRelationSet().iterator();
                    while (it.hasNext()) {
                        rel = (Relation)it.next();
                        ((Relation)rel).getFKAttributeManager().reSync();
                    }
                }
                catch (Exception e) {}
            }
            for (int i = 0; i < this.fkeys.size(); ++i) {
                FKIndexAssociation fk = (FKIndexAssociation)this.fkeys.get(i);
                if (fk.getTable() instanceof TableView || fk.getRemoteTable() instanceof TableView) continue;
                this.processSelfRefColumns(fk);
            }
            this.processIndexSurrogateColumns();
            for (CandidateKey key : this.design.getLogicalDesign().getGlobalCandidateKeySet()) {
                key.updateContainedObjects();
            }
            this.setColumnsScopeId();
            this.processTableViews();
            this.processTypeSubstitutions();
            this.resetRelationTopViews();
            this.processArcs();
            this.processSQLNames();
            if (this.entireRelational) {
                this.engineerAllSubviews(this.design);
            }
            this.processArcs();
            if (this.design.getLogicalDesign().getMainView().isAutoRoute()) {
                this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("ReverseEngineering.execute()", e);
            e.printStackTrace();
        }
        finally {
            this.design.setPropagatePKChahges(true);
            this.design.getLogicalDesign().getMainView().getUndoManager().setLocked(false);
        }
    }

    private void processTables() {
        for (Table table : this.tablelist) {
            if (table.shouldEngineerToRelation() || table.isRemoteObject()) continue;
            this.processTable(table);
        }
    }

    private void processIndexSurrogateColumns() {
        for (Table table : this.tablelist) {
            Entity ent = table.getEngEntity();
            if (ent == null || table.shouldEngineerToRelation()) continue;
            KeyObject[] keys = table.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                CandidateKey key;
                Index index = (Index)keys[i];
                if (!index.isPK() && (!index.getIndexState().equalsIgnoreCase("Unique Constraint") || this.isResultFromInheritance(index)) || index.isSurrogateKey() || !index.hasSurrogateDelegateColumn() || (key = index.getEngCandidateKey(ent)) == null) continue;
                this.copyColumnsFromIndexToKey(index, key);
            }
        }
    }

    private static List getValidMappings(List mappings) {
        if (mappings.size() > 0) {
            ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
            for (XtdMapping mapping : mappings) {
                if (mapping.isDeleted() || mapping.getRelationalObject() == null || mapping.getLogicalObject() == null) continue;
                list.add(mapping);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    private void processTable(Table table) {
        if (!table.shouldEngineerToRelation()) {
            Relation relation = (Relation)table.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(table);
            if (relation != null) {
                relation.remove();
            }
            List list = this.xmap.getMappingsForDesignPart(table, this.targetDesPartID);
            if ((list = ReverseEngineering.getValidMappings(list)).size() == 0) {
                if (table.shouldBeEngineered()) {
                    XtdMapping del_mapping;
                    String newName = this.getDesign().transformNameFromRelationalToLogical(table);
                    Entity entity = this.design.getLogicalDesign().createEntity(newName);
                    XtdMapping entityMapping = this.xmap.createMapping(entity, table);
                    entityMapping.initializeContained();
                    this.copyPropertiesFromTableToEntity(table, entity);
                    if (this.design.isEngineerCoordinates()) {
                        this.setGraphicalPropertiesOnNewObject(table, entity);
                    }
                    if ((del_mapping = table.getDeletedMapping()) != null) {
                        table.updateDeletedMappings(del_mapping.getDeletedID(), entity.getObjectID(), entity.getDesignPartId());
                        this.xmap.removeMapping(del_mapping);
                    }
                    if (table.getBasedOnStructuredType() == null) {
                        this.processColumns(table, entity, entityMapping);
                    } else {
                        this.processColumnsBST(table, entity, entityMapping);
                    }
                    this.processIndexes(table, entity, entityMapping);
                }
            } else {
                for (XtdMapping mapping : list) {
                    EngPropertiesComparator comp;
                    if (!mapping.isRevEngineer()) continue;
                    DesignObject obj = mapping.getObjectMappedTo(table);
                    if (obj != null && obj instanceof Entity) {
                        Entity entity = (Entity)obj;
                        comp = (EngPropertiesComparator)this.comparatorsMap.get(table.getObjectID() + entity.getObjectID());
                        if (comp != null) {
                            comp.copySelectedProperties();
                        }
                        if (this.design.isEngineerCoordinates()) {
                            this.setGraphicalPropertiesOnNewObject(table, entity);
                        }
                        if (table.getBasedOnStructuredType() == null) {
                            this.processColumns(table, entity, mapping);
                        } else {
                            this.processColumnsBST(table, entity, mapping);
                        }
                        this.processIndexes(table, entity, mapping);
                        continue;
                    }
                    if (obj == null || !(obj instanceof Relation)) continue;
                    Relation rel = (Relation)obj;
                    comp = (EngPropertiesComparator)this.comparatorsMap.get(table.getObjectID() + rel.getObjectID());
                    if (comp != null) {
                        comp.copySelectedProperties();
                    }
                    this.copyRelationAttributes(rel, table);
                    TVRelation tvr = (TVRelation)rel.getTopView();
                    if (tvr == null) continue;
                    tvr.displayRelationAttributes();
                }
            }
        }
    }

    private void processTypeSubstitutions() {
        for (Table table : this.tablelist) {
            if (table.shouldEngineerToRelation() || !table.isBST()) continue;
            this.processTypeSubstitution(table);
        }
        for (TableView tableView : this.tableViewList) {
            if (!tableView.isBST()) continue;
            this.processTypeSubstitution(tableView);
        }
    }

    private void processTypeSubstitution(ContainerObject table) {
        List list = this.xmap.getMappingsForDesignPart(table, this.targetDesPartID);
        if ((list = ReverseEngineering.getValidMappings(list)).size() > 0) {
            for (XtdMapping mapping : list) {
                DesignPartView physdpv;
                DesignPartView ldpv;
                DesignObject obj;
                if (!mapping.isRevEngineer() || !((obj = mapping.getObjectMappedTo(table)) instanceof ContainerObject)) continue;
                ContainerObject entity = (ContainerObject)obj;
                EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(table.getObjectID() + entity.getObjectID());
                if (comp == null) {
                    comp = (EngPropertiesComparator)this.comparatorsMap.get(table.getObjectID());
                }
                if (comp == null) continue;
                EngPropertyHolder ph = comp.getPropertyHolderByName(EngPropertiesComparator.ENT_TABLE_TYPE_SUBSTITUTION);
                if (ph != null && ph.isSelected()) {
                    ldpv = this.getDesign().getLogicalDesign().getMainView();
                    physdpv = this.getDesign().getRelationalDesign().getMainView();
                    if (table.getTypeSubstitution() != null) {
                        TVTypeSubstitution tvc_s = (TVTypeSubstitution)table.getTypeSubstitution().getViewFor(physdpv);
                        ContainerObject tab = table.getTypeSubstitution().getParentContainerObject();
                        ContainerObject ent = null;
                        if (entity.getTypeSubstitution() != null) {
                            ent = entity.getTypeSubstitution().getParentContainerObject();
                            ContainerObject engent = this.getEngEntityOrEntityView(tab);
                            if (engent == null) continue;
                            entity.getTypeSubstitution().setParentCV((ContainerView)engent.getFirstViewForDPV(ldpv));
                            TVTypeSubstitution tvc_t = (TVTypeSubstitution)entity.getTypeSubstitution().getViewFor(ldpv);
                            if (!this.design.isEngineerCoordinates() || this.design.getLogicalDesign().getMainView().isAutoRoute()) continue;
                            ApplicationView.loading = true;
                            ReverseEngineering.copyConnectionPoints(tvc_s, tvc_t);
                            ApplicationView.loading = false;
                            continue;
                        }
                        ent = this.getEngEntityOrEntityView(tab);
                        if (ent == null) continue;
                        ApplicationView.loading = true;
                        TypeSubstitution ts = this.getDesign().getLogicalDesign().createTypeSubstitution();
                        ContainerView childTV = (ContainerView)entity.getFirstViewForDPV(ldpv);
                        ContainerView parentTV = (ContainerView)ent.getFirstViewForDPV(ldpv);
                        ts.setChildCV(childTV);
                        ts.setParentCV(parentTV);
                        ts.addToAllDPVs();
                        TVTypeSubstitution tvc_t = (TVTypeSubstitution)entity.getTypeSubstitution().getViewFor(ldpv);
                        if (this.design.isEngineerCoordinates() && !this.design.getLogicalDesign().getMainView().isAutoRoute()) {
                            ReverseEngineering.copyConnectionPoints(tvc_s, tvc_t);
                        }
                        ApplicationView.loading = false;
                        continue;
                    }
                    if (entity == null || entity.getTypeSubstitution() == null) continue;
                    entity.getTypeSubstitution().remove();
                    continue;
                }
                if (!this.design.isEngineerCoordinates() || entity.getTypeSubstitution() == null || table.getTypeSubstitution() == null) continue;
                ldpv = this.getDesign().getLogicalDesign().getMainView();
                physdpv = this.getDesign().getRelationalDesign().getMainView();
                TVTypeSubstitution tvc_t = (TVTypeSubstitution)entity.getTypeSubstitution().getViewFor(ldpv);
                TVTypeSubstitution tvc_s = (TVTypeSubstitution)table.getTypeSubstitution().getViewFor(physdpv);
                if (tvc_t == null || tvc_s == null || this.design.getLogicalDesign().getMainView().isAutoRoute()) continue;
                ReverseEngineering.copyConnectionPoints(tvc_s, tvc_t);
            }
        }
    }

    private ContainerObject getEngEntityOrEntityView(ContainerObject tableOrView) {
        if (tableOrView instanceof Table) {
            return ((Table)tableOrView).getEngEntity();
        }
        if (tableOrView instanceof TableView) {
            return ((TableView)tableOrView).getEngEntityView();
        }
        return null;
    }

    private void copyPropertiesFromTableToEntity(Table table, Entity entity) {
        entity.setGeneratorID(table.getObjectID());
        entity.setBasedOnStructuredType(table.getBasedOnStructuredType());
        if (!this.notForNewObjects) {
            this.typeName = Design.ENTITY_TABLE;
            this.properties = this.design.getEntTablePropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.MIN_VOLUMES)) {
                entity.setMinVolumes(table.getMinVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.EXPECTED_VOLUMES)) {
                entity.setExpectedVolumes(table.getExpectedVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.MAX_VOLUMES)) {
                entity.setMaxVolumes(table.getMaxVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.GROWTH_PERCENT)) {
                entity.setGrowthPercent(table.getGrowthPercent());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.GROWTH_TYPE)) {
                entity.setGrowthType(table.getGrowthType());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NORMAL_FORM)) {
                entity.setNormalForm(table.getNormalForm());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.ADEQUATELY_NORMALIZED)) {
                entity.setAdequatelyNormalized(table.getAdequatelyNormalized());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.TABLE_TYPE)) {
                entity.setTypeID(table.getTypeID());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.TEMP_TABLE_SCOPE)) {
                entity.setScope(table.getScope());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                entity.setComment(table.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                entity.setCommentInRDBMS(table.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                entity.setNotes(table.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.SHORT_NAME_ABBR)) {
                entity.setShortName(table.getAbbreviation());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.ALLOW_TYPE_SUBSTITUTION)) {
                entity.setAllowTypeSubstitution(table.isAllowTypeSubstitution());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.DEPRECATED)) {
                entity.setDeprecated(table.isDeprecated());
            }
        } else {
            entity.setMinVolumes(table.getMinVolumes());
            entity.setExpectedVolumes(table.getExpectedVolumes());
            entity.setMaxVolumes(table.getMaxVolumes());
            entity.setGrowthPercent(table.getGrowthPercent());
            entity.setGrowthType(table.getGrowthType());
            entity.setNormalForm(table.getNormalForm());
            entity.setAdequatelyNormalized(table.getAdequatelyNormalized());
            entity.setTypeID(table.getTypeID());
            entity.getAdditionalClassificationTypes().clear();
            entity.getAdditionalClassificationTypes().addAll(table.getAdditionalClassificationTypes());
            entity.setScope(table.getScope());
            entity.setComment(table.getComment());
            entity.setCommentInRDBMS(table.getCommentInRDBMS());
            entity.setNotes(table.getNotes());
            entity.setShortName(table.getAbbreviation());
            entity.setAllowTypeSubstitution(table.isAllowTypeSubstitution());
            entity.setDeprecated(table.isDeprecated());
        }
    }

    private void processColumns(Table table, Entity entity, XtdMapping entityMapping) {
        if (entity != null) {
            ContainedObject[] columns = table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                Column column = (Column)columns[i];
                if (column.isDiscriminatorColumn() || column.getDependOnForeignKey() != null || column.isSurrogateColumn() || column.getDelegate() != null && column.getDelegate().isSurrogateColumn()) continue;
                List list = column.getMappingsFor(entity);
                if ((list = ReverseEngineering.getValidMappings(list)).size() == 0) {
                    if (column.isFKColumn() && column.getFKIndexAssociation() != null && column.getFKIndexAssociation().getEngInheritanceRelation() != null || !column.shouldBeEngineered(entityMapping)) continue;
                    String newName = this.getDesign().transformNameFromRelationalToLogical(column);
                    Attribute attribute = entity.createAttribute(newName);
                    this.xmap.createMapping(attribute, column);
                    this.copyPropertiesFromColumnToAttribute(column, attribute);
                    XtdMapping del_mapping = column.getDeletedMapping(entity);
                    if (del_mapping == null) continue;
                    this.xmap.removeMapping(del_mapping);
                    continue;
                }
                for (XtdMapping mapping : list) {
                    if (!mapping.isRevEngineer()) continue;
                    EngPropertiesComparator comp = null;
                    Attribute attribute = (Attribute)mapping.getObjectMappedTo(column);
                    if (attribute != null) {
                        comp = (EngPropertiesComparator)this.comparatorsMap.get(column.getObjectID() + attribute.getObjectID());
                    }
                    if (comp == null) continue;
                    comp.copySelectedProperties();
                }
            }
        }
    }

    private void processColumnsBST(Table table, Entity entity, XtdMapping entityMapping) {
        if (entity != null) {
            ContainedObject[] columns = table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                Column column = (Column)columns[i];
                List list = column.getMappingsFor(entity);
                if ((list = ReverseEngineering.getValidMappings(list)).size() != 0) continue;
                Attribute attribute = null;
                if (column.isOid()) {
                    attribute = (Attribute)entity.getOidElement();
                } else {
                    String id = column.getStructAttributeID();
                    attribute = (Attribute)entity.getElementByStructAttributeID(id);
                }
                if (attribute == null) continue;
                this.xmap.createMapping(attribute, column);
                this.copyPropertiesFromColumnToAttribute(column, attribute);
            }
        }
    }

    private void copyPropertiesFromColumnToAttribute(Column column, Attribute attribute) {
        if (!column.isFKColumn()) {
            attribute.setGeneratorID(column.getObjectID());
        }
        attribute.setDomain(column.getDomain());
        attribute.setUnique(column.isUnique());
        attribute.setNullsAllowed(column.getNullsAllowed());
        if (column.getDependOnForeignKey() != null) {
            attribute.setMandatory(column.isDependOnFK_AsMandatory());
        }
        attribute.setUse(column.getUse());
        attribute.setReference(column.isReference());
        attribute.setLogicalDatatype(column.getLogicalDatatype());
        attribute.setStructuredType(column.getStructuredType());
        attribute.setCollectionType(column.getCollectionType());
        attribute.setDistinctType(column.getDistinctType());
        attribute.setAllowSubtypeSubstitution(column.isAllowSubtypeSubstitution());
        attribute.setRestrictedTypeSubstitution(column.isRestrictedTypeSubstitution());
        List list = attribute.getPermittedSubTypes();
        list.clear();
        list.addAll(column.getPermittedSubTypes());
        if (!column.isFKColumn()) {
            attribute.copyParametersFrom(column);
        }
        attribute.setDeprecated(column.isDeprecated());
        if (column.getStructuredType() != null && !column.isReference() && column.getUse() == 3) {
            Table table = (Table)column.getContainer();
            Entity entity = (Entity)attribute.getContainer();
            Iterator typeElemIt = column.getStructuredType().getAllElements().iterator();
            while (typeElemIt.hasNext()) {
                String typeElId = ((TypeElement)typeElemIt.next()).getObjectID();
                Column nestedCol = (Column)table.getElementByStructAttributeID(typeElId, column);
                Attribute nestedAtt = (Attribute)entity.getElementByStructAttributeID(typeElId, attribute);
                if (nestedAtt == null || nestedCol == null) continue;
                this.xmap.createMapping(nestedAtt, nestedCol);
                this.copyPropertiesFromColumnToAttribute(nestedCol, nestedAtt);
            }
        }
        attribute.setUseDomainConstraints(column.getUseDomainConstraints());
        if (!column.getUseDomainConstraints()) {
            EngCOPropertiesComparator.copyCheckConstraint(column, attribute);
            EngCOPropertiesComparator.copyRangeConstraint(column, attribute);
            EngCOPropertiesComparator.copyLOVConstraint(column, attribute);
        }
        if (!this.notForNewObjects) {
            this.typeName = Design.ATTRIBUTE_COLUMN;
            this.properties = this.design.getAttrColPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                attribute.setConstraintName(column.getConstraintName());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.USES_DEFUALT_VALUE)) {
                attribute.setUsesDefaultValue(column.getUsesDefaultValue());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.DEFAULT_VALUE)) {
                attribute.setDefaultValue(column.getDefaultValue());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                attribute.setComment(column.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                attribute.setCommentInRDBMS(column.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                attribute.setNotes(column.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.SOURCE_TYPE)) {
                attribute.setSourceType(column.getSourceType());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.FORMULA_DESC)) {
                this.copyFormulaDesc(column, attribute);
            }
        } else {
            attribute.setConstraintName(column.getConstraintName());
            attribute.setUsesDefaultValue(column.getUsesDefaultValue());
            attribute.setDefaultValue(column.getDefaultValue());
            attribute.setComment(column.getComment());
            attribute.setCommentInRDBMS(column.getCommentInRDBMS());
            attribute.setNotes(column.getNotes());
            attribute.setSourceType(column.getSourceType());
            this.copyFormulaDesc(column, attribute);
        }
    }

    private void copyFormulaDesc(Column column, Attribute attribute) {
        String attrType;
        String formulaDesc = column.getFormulaDesc();
        attribute.setFormulaDesc(formulaDesc);
        if (!(formulaDesc == null || formulaDesc.length() <= 0 || (attrType = attribute.getSourceType()) != null && attrType.equalsIgnoreCase("Aggregate"))) {
            attribute.setSourceType("Derived");
        }
    }

    private void setColumnsScopeId() {
        Iterator it = this.design.getRelationalDesign().getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            ContainedObject[] columns = table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                Column column = (Column)columns[i];
                Attribute attribute = column.getEngAttribute();
                if (attribute == null) continue;
                if (column.getScope() == null) {
                    attribute.setScopeId(null);
                    continue;
                }
                attribute.setScopeId(((Table)column.getScope()).getEngEntity().getObjectID());
            }
        }
    }

    private boolean isResultFromInheritance(Index index) {
        if (!index.isPK()) {
            return false;
        }
        for (Column col : index.getElementsCollection()) {
            if (!col.isFKColumn()) {
                return false;
            }
            if (col.getFKIndexAssociation().getEngInheritanceRelation() != null) continue;
            return false;
        }
        return true;
    }

    private void processIndexes(Table table, Entity entity, XtdMapping entityMapping) {
        if (entity != null) {
            KeyObject[] keys = table.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                Index index = (Index)keys[i];
                if (!index.isPK() && (!index.getIndexState().equalsIgnoreCase("Unique Constraint") || this.isResultFromInheritance(index)) || index.isSurrogateKey()) continue;
                List list = index.getMappingsFor(entity);
                if ((list = ReverseEngineering.getValidMappings(list)).size() == 0) {
                    XtdMapping del_mapping;
                    if (!index.shouldBeEngineered(entityMapping)) continue;
                    CandidateKey candidatekey = null;
                    if (index.isOidKey() && (candidatekey = (CandidateKey)entity.getOidKey()) != null) {
                        candidatekey.clearElements();
                    }
                    if (candidatekey == null) {
                        candidatekey = entity.createCandidateKeyNoAddToKeys(new GUID().toString());
                    }
                    if (index.isOidKey() && candidatekey != null) {
                        candidatekey.setOidKey(true);
                    }
                    String newName = this.getDesign().transformNameFromRelationalToLogical(index);
                    candidatekey.setName(newName);
                    this.xmap.createMapping(candidatekey, index);
                    this.copyPropertiesFromIndexToKey(index, candidatekey);
                    entity.add(candidatekey);
                    if (index.isPK()) {
                        entity.setPK(candidatekey);
                    }
                    if ((del_mapping = index.getDeletedMapping(entity)) == null) continue;
                    this.xmap.removeMapping(del_mapping);
                    continue;
                }
                for (XtdMapping mapping : list) {
                    CandidateKey entkey;
                    if (!mapping.isRevEngineer() || (entkey = (CandidateKey)mapping.getObjectMappedTo(index)) == null) continue;
                    EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(index.getObjectID() + entkey.getObjectID());
                    if (comp != null) {
                        comp.copySelectedProperties();
                        continue;
                    }
                    if (entkey == null) continue;
                    ReverseEngineering.synchronizeColumnsFromIndexToKey(index, entkey);
                }
            }
        }
    }

    private void copyPropertiesFromIndexToKey(KeyObject index, CandidateKey key) {
        key.setGeneratorID(index.getObjectID());
        if (!this.notForNewObjects) {
            this.typeName = Design.KEY_INDEX;
            this.properties = this.design.getKeyIdxPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                key.setCommentInRDBMS(index.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                key.setComment(index.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                key.setNotes(index.getNotes());
            }
        } else {
            key.setCommentInRDBMS(index.getCommentInRDBMS());
            key.setComment(index.getComment());
            key.setNotes(index.getNotes());
        }
        this.copyColumnsFromIndexToKey((Index)index, key);
        if (index.isPK()) {
            key.makePK();
        }
    }

    private void copyColumnsFromIndexToKey(Index index, CandidateKey key) {
        key.getElementsCollection().clear();
        key.getNewElementsCollection().clear();
        Column[] columns = (Column[])index.getColumns();
        for (int j = 0; j < columns.length; ++j) {
            Column column = columns[j];
            FKElement cref = column.getReferencedColumn();
            if (cref != null && cref.isSurrogateColumn()) {
                Relation rel;
                FKIndexAssociation fk = column.getAssocToColumn(cref);
                if (fk == null || (rel = fk.getEngRelation(key.getEntity())) == null) continue;
                rel.setUseSurrogateKey(true);
                key.addElement(rel);
                continue;
            }
            List attributes = this.xmap.getMappingsForDesignPart(column, this.targetDesPartID);
            if ((attributes = ReverseEngineering.getValidMappings(attributes)).size() <= 0) continue;
            for (XtdMapping mapping : attributes) {
                Attribute attribute = (Attribute)mapping.getObjectMappedTo(column);
                if (attribute == null || attribute.getContainer() != key.getContainerObject()) continue;
                key.add(attribute);
            }
        }
    }

    public static void synchronizeColumnsFromIndexToKey(Index index, KeyObject key) {
        int i;
        ContainedObject[] columns = index.getElements();
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Entity keyEntity = (Entity)key.getContainerWithKeyObject();
        for (int j = 0; j < columns.length; ++j) {
            Column column = (Column)columns[j];
            Attribute attribute = column.getEngAttribute(keyEntity);
            if (attribute == null) continue;
            list.add(attribute);
            key.add(attribute);
        }
        ContainedObject[] cols = key.getElements();
        for (i = 0; i < cols.length; ++i) {
            if (list.contains(cols[i])) continue;
            key.remove(cols[i]);
        }
        for (i = 0; i < list.size(); ++i) {
            key.moveToIndex((ContainedObject)list.get(i), i);
        }
    }

    private void processForeignKeys() {
        for (int i = 0; i < this.fkeys.size(); ++i) {
            Table tab;
            FKIndexAssociation fk = (FKIndexAssociation)this.fkeys.get(i);
            if (!(fk.getTable() instanceof Table) || !(fk.getRemoteTable() instanceof Table) || (tab = (Table)fk.getContainerWithKeyObject()).isRemoteObject() || !fk.shouldBeEngineered() || tab.getEngRelation() != null || fk.isRemoteObject()) continue;
            this.processFK(fk);
        }
    }

    private boolean isIdentifyingRelCandidate(FKIndexAssociation fk) {
        KeyObject pk = fk.getContainerWithKeyObject().getPK();
        if (pk == null) {
            return false;
        }
        for (Column col : fk.getLocalFKIndex().getElementsCollection()) {
            if (col.hasCircularRef()) {
                return false;
            }
            if (pk.contains(col)) continue;
            return false;
        }
        return true;
    }

    public void processSelfRefColumns(FKIndexAssociation fkAssociation) {
        if (fkAssociation.getEngInheritanceRelation() != null) {
            return;
        }
        Table tab = (Table)fkAssociation.getContainerWithKeyObject();
        if (!tab.shouldEngineerToRelation()) {
            List list = this.xmap.getMappingsForDesignPart(fkAssociation, this.targetDesPartID);
            list = ReverseEngineering.getValidMappings(list);
            for (XtdMapping mapping : list) {
                DesignObject dobj = mapping.getObjectMappedTo(fkAssociation);
                if (dobj == null) continue;
                Relation relation = (Relation)dobj;
                for (Column col : fkAssociation.getLocalFKIndex().getElementsCollection()) {
                    Attribute delegatedAttr;
                    Attribute attr;
                    Column delegatedCol;
                    if (col != (delegatedCol = (Column)col.getReferencedColumn(fkAssociation))) continue;
                    Table sourceTable = (Table)fkAssociation.getRemoteTable();
                    Table targetTable = (Table)fkAssociation.getContainerWithKeyObject();
                    Entity sourceEntity = sourceTable.getEngEntity();
                    Entity targetEntity = targetTable.getEngEntity();
                    if (sourceEntity == null || targetEntity != sourceEntity || (attr = sourceEntity.getAttributeForDelegate(delegatedAttr = delegatedCol.getEngAttribute(sourceEntity), relation)) == null) continue;
                    XtdMapping xmapping = attr.getMappingFor((RelationalDesign)targetTable.getDesignPart(), targetTable);
                    if (xmapping == null) {
                        xmapping = this.xmap.createMapping(attr, col);
                    }
                    xmapping.setRevEngineer(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFK(FKIndexAssociation fkAssociation) {
        block30: {
            List list;
            block31: {
                if (fkAssociation.getEngInheritanceRelation() != null) {
                    return;
                }
                Table tab = (Table)fkAssociation.getContainerWithKeyObject();
                if (tab.shouldEngineerToRelation()) break block30;
                list = this.xmap.getMappingsForDesignPart(fkAssociation, this.targetDesPartID);
                if ((list = ReverseEngineering.getValidMappings(list)).size() != 0) break block31;
                LogicalDesign ld = this.design.getLogicalDesign();
                Table sourceTable = (Table)fkAssociation.getRemoteTable();
                Table targetTable = (Table)fkAssociation.getContainerWithKeyObject();
                Entity sourceEntity = sourceTable.getEngEntity();
                Entity targetEntity = targetTable.getEngEntity();
                if (sourceEntity == null || targetEntity == null) break block30;
                Relation relation = ld.createRelation();
                relation.setFireCardinalityChange(false);
                try {
                    CandidateKey pkey;
                    relation.setName(fkAssociation.getName());
                    this.xmap.createMapping(relation, fkAssociation);
                    relation.setGeneratorID(fkAssociation.getObjectID());
                    relation.setTargetEntity(targetEntity);
                    relation.setSourceEntity(sourceEntity);
                    Index pk = (Index)fkAssociation.getRemoteIndex();
                    if (!pk.isPK() && (pkey = pk.getEngCandidateKey(sourceEntity)) != null) {
                        relation.setSourcePk(pkey);
                    }
                    if (!pk.isSurrogateKey()) {
                        this.prepareFKAttributes(fkAssociation, relation);
                    } else {
                        relation.setUseSurrogateKey(true);
                    }
                    this.copyRelationAttributes(relation, fkAssociation);
                    this.setOptionality(relation, fkAssociation);
                    relation.setTargetTransferable(fkAssociation.isTransferable());
                    relation.setCardinality(0, 1);
                    if (fkAssociation.isOneToOne()) {
                        relation.setCardinality(1, 1);
                        relation.setDominantRole(sourceEntity);
                    }
                    if (this.isIdentifyingRelCandidate(fkAssociation)) {
                        relation.setIdentifying(true);
                        if (fkAssociation.isOneToOne()) {
                            // empty if block
                        }
                    }
                    if (fkAssociation.getTable() == fkAssociation.getRemoteTable()) {
                        relation.setOptionalSource(true);
                        relation.setDominantRole(null);
                    }
                    relation.setDeleteRule(fkAssociation.getDeleteRule());
                }
                finally {
                    relation.setFireCardinalityChange(true);
                    relation.setTargetCardinality(relation.getTargetCardinality());
                }
                this.copyPropertiesFromFKToRelation(fkAssociation, relation);
                TVRelation tvr = (TVRelation)relation.getTopView();
                if (tvr == null || !this.design.isEngineerCoordinates() || this.design.getLogicalDesign().getMainView().isAutoRoute()) break block30;
                TVFKRelation tvf = (TVFKRelation)fkAssociation.getViewFor(fkAssociation.getDesignPart().getMainView());
                ReverseEngineering.copyConnectionPoints(tvf, tvr);
                tvr.resetEdgeParams();
                break block30;
            }
            for (XtdMapping mapping : list) {
                Relation relation;
                DesignObject dobj = mapping.getObjectMappedTo(fkAssociation);
                if (dobj == null) continue;
                EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(fkAssociation.getObjectID() + dobj.getObjectID());
                if (comp != null) {
                    TVRelation tvr;
                    comp.copySelectedProperties();
                    if (!(dobj instanceof Relation)) continue;
                    boolean hasMandatory = false;
                    FK_RelationComparator fkr_comp = null;
                    if (comp instanceof FK_RelationComparator) {
                        fkr_comp = (FK_RelationComparator)comp;
                        hasMandatory = fkr_comp.isMandatoryDefined();
                    }
                    Relation relation2 = (Relation)dobj;
                    Index pk = (Index)fkAssociation.getRemoteIndex();
                    if (!pk.isSurrogateKey()) {
                        this.prepareFKAttributes(fkAssociation, relation2);
                    } else {
                        relation2.setUseSurrogateKey(true);
                    }
                    relation2.setFireCardinalityChange(false);
                    try {
                        this.copyRelationAttributes(relation2, fkAssociation);
                        if (this.isIdentifyingRelCandidate(fkAssociation)) {
                            relation2.setIdentifying(true);
                        } else {
                            relation2.setIdentifying(false);
                        }
                        relation2.setCardinality(0, 1);
                        if (fkAssociation.isOneToOne()) {
                            relation2.setCardinality(1, 1);
                        }
                        if (!hasMandatory) {
                            this.setOptionality(relation2, fkAssociation);
                        } else {
                            EngPropertyHolder ph = comp.getPropertyHolderByName(PropertyNames.MANDATORY);
                            if (ph != null && (ph.isModified() && ph.isSelected() || !ph.isModified())) {
                                this.setOptionality(relation2, fkAssociation);
                            }
                            if ((ph = comp.getPropertyHolderByName(PropertyNames.DELETE_RULE)) != null && ph.isModified() && ph.isSelected()) {
                                relation2.setDeleteRule(fkAssociation.getDeleteRule());
                            }
                        }
                    }
                    finally {
                        relation2.setFireCardinalityChange(true);
                        relation2.setTargetCardinality(relation2.getTargetCardinality());
                    }
                    if ((tvr = (TVRelation)relation2.getTopView()) == null || !this.design.isEngineerCoordinates() || this.design.getLogicalDesign().getMainView().isAutoRoute()) continue;
                    TVFKRelation tvf = (TVFKRelation)fkAssociation.getViewFor(fkAssociation.getDesignPart().getMainView());
                    ReverseEngineering.copyConnectionPoints(tvf, tvr);
                    tvr.resetEdgeParams();
                    continue;
                }
                if (mapping.getObjectMappedTo(fkAssociation) instanceof InheritanceRelation || (relation = (Relation)mapping.getObjectMappedTo(fkAssociation)) == null) continue;
                if (this.isIdentifyingRelCandidate(fkAssociation)) {
                    relation.setIdentifying(true);
                } else {
                    relation.setIdentifying(false);
                }
                this.setOptionality(relation, fkAssociation);
            }
        }
    }

    private void copyRelationAttributes(Relation relation, FKIndexAssociation fkAssociation) {
        List rlist = fkAssociation.getTable().getColumnsDependinOn(fkAssociation);
        for (Column col : rlist) {
            EngPropertiesComparator comp;
            if (!col.shouldBeEngineered()) continue;
            Attribute attr = col.getEngAttribute();
            if (attr == null) {
                attr = relation.createAttribute();
                String newName = this.getDesign().transformNameFromRelationalToLogical(col);
                attr.setName(newName);
                this.design.getRelationalDesign().getRMExtendedMap().createMapping(col, attr);
            }
            if ((comp = (EngPropertiesComparator)this.comparatorsMap.get(col.getObjectID() + attr.getObjectID())) != null) {
                comp.copySelectedProperties();
                continue;
            }
            this.copyPropertiesFromColumnToAttribute(col, attr);
        }
    }

    private void copyRelationAttributes(Relation relation, Table table) {
        for (Column col : table.getElementsCollection()) {
            EngPropertiesComparator comp;
            if (!col.shouldBeEngineered() || col.isPKElement()) continue;
            Attribute attr = col.getEngAttribute();
            if (attr == null) {
                attr = relation.createAttribute();
                String newName = this.getDesign().transformNameFromRelationalToLogical(col);
                attr.setName(newName);
                this.design.getRelationalDesign().getRMExtendedMap().createMapping(col, attr);
            }
            if ((comp = (EngPropertiesComparator)this.comparatorsMap.get(col.getObjectID() + attr.getObjectID())) != null) {
                comp.copySelectedProperties();
                continue;
            }
            this.copyPropertiesFromColumnToAttribute(col, attr);
        }
    }

    private void setOptionality(Relation rel, FKIndexAssociation fk) {
        Table tab;
        Entity child_entity;
        Iterator it = fk.getLocalFKIndex().getElementsCollection().iterator();
        boolean optional = false;
        while (it.hasNext()) {
            Column col = (Column)it.next();
            if (!col.getNullsAllowed()) continue;
            optional = true;
            break;
        }
        if (fk.getArc() != null && fk.getArc().isMandatory()) {
            optional = false;
        }
        if ((child_entity = (tab = (Table)fk.getContainerWithKeyObject()).getEngEntity()) != null) {
            if (child_entity == rel.getSourceEntity()) {
                rel.setOptionalSource(optional);
                rel.setSourceTransferable(fk.isTransferable());
                if (!optional) {
                    if ("RESTRICT".equalsIgnoreCase(fk.getDeleteRule())) {
                        rel.setOptionalTarget(true);
                    } else if ("CASCADE".equalsIgnoreCase(fk.getDeleteRule())) {
                        rel.setOptionalTarget(false);
                    }
                }
            }
            if (child_entity == rel.getTargetEntity()) {
                rel.setOptionalTarget(optional);
                rel.setTargetTransferable(fk.isTransferable());
                if (!optional) {
                    if ("RESTRICT".equalsIgnoreCase(fk.getDeleteRule())) {
                        rel.setOptionalSource(true);
                    } else if ("CASCADE".equalsIgnoreCase(fk.getDeleteRule())) {
                        rel.setOptionalSource(false);
                    }
                }
            }
        }
    }

    private void copyPropertiesFromFKToRelation(FKIndexAssociation fkAssociation, Relation relation) {
        relation.setTemporaryWriteable(true);
        if (!this.notForNewObjects) {
            this.typeName = Design.RELATION_FK;
            this.properties = this.design.getRelFKPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                relation.setComment(fkAssociation.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                relation.setNotes(fkAssociation.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                relation.setCommentInRDBMS(fkAssociation.getCommentInRDBMS());
            }
        } else {
            relation.setComment(fkAssociation.getComment());
            relation.setNotes(fkAssociation.getNotes());
            relation.setCommentInRDBMS(fkAssociation.getCommentInRDBMS());
        }
        relation.setTemporaryWriteable(false);
    }

    private void copyPropertiesFromTableToRelation(Table table, Relation relation) {
        relation.setTemporaryWriteable(true);
        if (!this.notForNewObjects) {
            this.typeName = Design.RELATION_TABLE;
            this.properties = this.design.getRelTablePropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                relation.setComment(table.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                relation.setNotes(table.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                relation.setCommentInRDBMS(table.getCommentInRDBMS());
            }
        } else {
            relation.setComment(table.getComment());
            relation.setNotes(table.getNotes());
            relation.setCommentInRDBMS(table.getCommentInRDBMS());
        }
        relation.setTemporaryWriteable(false);
    }

    private void prepareFKAttributes(FKIndexAssociation fkAssociation, Relation relation) {
        for (Column col : fkAssociation.getLocalFKIndex().getElementsCollection()) {
            Attribute fkattr;
            Entity ent;
            Column delegatedCol;
            Attribute attr;
            if (col.getAssociationsCount() == 1) {
                attr = col.getEngAttribute();
                delegatedCol = (Column)col.getReferencedColumn(fkAssociation);
                if (col == delegatedCol) continue;
                if (attr != null) {
                    attr.setGeneratorID(relation.getObjectID());
                }
                if (attr == null || delegatedCol == null) continue;
                Attribute delegatedAttr = delegatedCol.getEngAttribute();
                if (delegatedAttr == null) {
                    delegatedAttr = delegatedCol.getEngAttribute();
                }
                if (delegatedAttr == null) continue;
                attr.setReferedAttribute(delegatedAttr.getObjectID());
                continue;
            }
            if (col.getAssociationsCount() <= 1) continue;
            attr = col.getEngAttribute();
            delegatedCol = (Column)col.getReferencedColumn(fkAssociation);
            String refid = null;
            if (attr != null) {
                refid = attr.getReferedAttribute();
            }
            Attribute delegatedAttr = delegatedCol.getEngAttribute();
            if (attr != null && refid == null) {
                if (attr != null) {
                    attr.setGeneratorID(relation.getObjectID());
                }
                if (delegatedAttr == null) {
                    delegatedAttr = delegatedCol.getEngAttribute();
                }
                if (delegatedAttr == null) continue;
                attr.setReferedAttribute(delegatedAttr.getObjectID());
                continue;
            }
            if (attr == null || delegatedAttr == null || attr.isFKAttribute() && attr.getDelegate() == delegatedAttr || refid != null && delegatedAttr.getObjectID().equals(refid) || (ent = ((Table)fkAssociation.getContainerWithKeyObject()).getEngEntity()) == null || (fkattr = ent.getAttributeReferingDelegate(delegatedAttr.getObjectID())) != null || ent.isBST()) continue;
            fkattr = ent.createAttribute(delegatedAttr.getLongName());
            fkattr.setReferedAttribute(delegatedAttr.getObjectID());
            this.copyPropertiesFromColumnToAttribute(col, fkattr);
            fkattr.setGeneratorID(relation.getObjectID());
            this.xmap.createMapping(fkattr, col);
        }
    }

    private void createRelations() {
        for (Table table : this.tablelist) {
            if (table.isRemoteObject() || !table.shouldBeEngineered() || !table.shouldEngineerToRelation()) continue;
            this.createRelation(table);
        }
    }

    private void createRelation(Table table) {
        block6: {
            block5: {
                if (table.getEngRelation() != null) break block5;
                Table tab1 = (Table)table.getFKAssociations()[0].getOriginalContainer();
                Table tab2 = (Table)table.getFKAssociations()[1].getOriginalContainer();
                LogicalDesign ld = this.design.getLogicalDesign();
                Entity target = tab1.getEngEntity();
                Entity source = tab2.getEngEntity();
                if (target == null || source == null) break block6;
                Relation relation = table.getEngRelation();
                if (relation == null) {
                    Entity ent = table.getEngEntity();
                    if (ent != null) {
                        ent.remove(true);
                    }
                    relation = ld.createRelation();
                    relation.setName(table.getName());
                    this.xmap.createMapping(relation, table);
                }
                relation.setGeneratorID(table.getObjectID());
                relation.setTargetEntity(target);
                relation.setSourceEntity(source);
                relation.setCardinality(0, 0);
                relation.setCardinality(1, 0);
                this.copyPropertiesFromTableToRelation(table, relation);
                this.copyRelationAttributes(relation, table);
                TVRelation tvr = (TVRelation)relation.getTopView();
                if (tvr == null) break block6;
                tvr.addConnection();
                tvr.displayRelationAttributes();
                break block6;
            }
            List list = this.xmap.getMappingsForDesignPart(table, this.targetDesPartID);
            if ((list = ReverseEngineering.getValidMappings(list)).size() > 0) {
                for (XtdMapping mapping : list) {
                    DesignObject obj = mapping.getObjectMappedTo(table);
                    if (!(obj instanceof Relation)) continue;
                    Relation rel = (Relation)obj;
                    EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(table.getObjectID() + rel.getObjectID());
                    if (comp != null) {
                        comp.copySelectedProperties();
                    }
                    this.copyRelationAttributes(rel, table);
                    TVRelation tvr = (TVRelation)rel.getTopView();
                    if (tvr == null) continue;
                    tvr.displayRelationAttributes();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void engineerAllSubviews(Design design) {
        DPVLogicalSubView logDPV;
        DPVRelational physDPV;
        Iterator it = design.getRelationalDesign().getPhysicalDesignSubviews().iterator();
        RelationalDesign pdes = design.getRelationalDesign();
        LogicalDesign ldes = design.getLogicalDesign();
        if (design.isEngineerAsSubView()) {
            physDPV = (DPVRelational)pdes.getMainView();
            logDPV = (DPVLogicalSubView)ldes.getSubViewGeneratedByDPV(physDPV.getDPVId());
            if (logDPV == null) {
                if (physDPV.getGeneratorId() != null && !"".equalsIgnoreCase(physDPV.getGeneratorId())) {
                    logDPV = (DPVLogicalSubView)ldes.getSubViewByID(physDPV.getGeneratorId());
                }
                if (logDPV == null) {
                    logDPV = (DPVLogicalSubView)ldes.createDesignPartSubView();
                    logDPV.setName("From_RM_" + physDPV.getName());
                    logDPV.setGeneratorId(physDPV.getDPVId());
                    this.xmap.createMapping(logDPV.getPlaceHolder(), pdes.getMainDPVPlaceHolder());
                }
            }
            try {
                logDPV.getUndoManager().setLocked(true);
                for (TVFKContainer tv : physDPV.getTVTables()) {
                    this.engineerTableSynonyms((TVTable)tv, logDPV);
                }
                for (TVFKContainer tv : physDPV.getTVViews()) {
                    this.engineerTableViewSynonyms((TVView)tv, logDPV);
                }
            }
            finally {
                logDPV.getUndoManager().setLocked(false);
            }
            logDPV.setVisible(true);
        }
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it.next();
            if (!dpvph.shouldBeEngineered()) continue;
            physDPV = (DPVRelationalSubView)dpvph.getDesignPartView();
            logDPV = (DPVLogicalSubView)ldes.getSubViewGeneratedByDPV(physDPV.getDPVId());
            if (logDPV == null) {
                if (physDPV.getGeneratorId() != null && !"".equalsIgnoreCase(physDPV.getGeneratorId())) {
                    logDPV = (DPVLogicalSubView)ldes.getSubViewByID(physDPV.getGeneratorId());
                }
                if (logDPV == null) {
                    logDPV = (DPVLogicalSubView)ldes.createDesignPartSubView();
                    logDPV.setName("From_RM_" + physDPV.getName());
                    logDPV.setGeneratorId(physDPV.getDPVId());
                    this.copyPropertiesFromSubViewToSubView((DPVRelationalSubView)dpvph.getDesignPartView(), logDPV);
                    this.xmap.createMapping(physDPV.getPlaceHolder(), logDPV.getPlaceHolder());
                }
            }
            try {
                logDPV.getUndoManager().setLocked(true);
                for (TopView tv : physDPV.getTVTables()) {
                    if (!tv.getModel().shouldBeEngineered()) continue;
                    this.engineerTableSynonyms((TVTable)tv, logDPV);
                }
                for (TopView tv : physDPV.getTVFKRelations()) {
                    FKIndexAssociation fk = (FKIndexAssociation)tv.getModel();
                    Relation relation = fk.getEngRelation();
                    if (relation == null) continue;
                    TVRelation tvr = (TVRelation)relation.getViewFor(logDPV);
                    if (tvr == null) {
                        relation.getSourceTV(logDPV);
                        relation.getTargetTV(logDPV);
                        tvr = (TVRelation)relation.getViewFor(logDPV);
                    }
                    if (tvr == null || !design.isEngineerCoordinates() || design.getLogicalDesign().getMainView().isAutoRoute()) continue;
                    ReverseEngineering.copyConnectionPoints((TVConnector)tv, tvr);
                    tvr.resetEdgeParams();
                }
                for (TopView tv : physDPV.getTVViews()) {
                    this.engineerTableViewSynonyms((TVView)tv, logDPV);
                }
            }
            finally {
                logDPV.getUndoManager().setLocked(false);
            }
            logDPV.setVisible(physDPV.isVisible());
        }
    }

    private void engineerTableSynonyms(TVTable tv, DesignPartView logDPV) {
        Entity ent;
        Table tab = (Table)tv.getModel();
        if ("User generated".equalsIgnoreCase(tab.getGeneratorID())) {
            ent = (Entity)tab.getDesign().getLogicalDesign().getEntitySet().getObjectGeneratedBy(tab.getObjectID());
        } else {
            ent = (Entity)tab.getDesign().getLogicalDesign().getEntitySet().getObjectByID(tab.getGeneratorID());
            if (ent == null) {
                ent = (Entity)tab.getDesign().getLogicalDesign().getEntitySet().getObjectGeneratedBy(tab.getObjectID());
            }
        }
        if (ent != null) {
            TVEntity topv = (TVEntity)ent.getTopViewByGeneratorID(logDPV, tv.getGeneratorID());
            if (topv == null) {
                topv = (TVEntity)ent.getTopViewByID(logDPV, tv.getViewID());
            }
            if (topv == null || topv.getDesignPartView() != logDPV) {
                topv = (TVEntity)ent.getTopView().createViewSynonim(logDPV);
                topv.setGeneratorID(tv.getViewID());
                topv.addTVRelations(logDPV);
            }
            if (tab.getDesign().isEngineerCoordinates()) {
                logDPV.getApplicationView().setGraphicalPropsFor(topv, logDPV.getApplicationView().getGraphicalPropsFor(tv));
            }
        } else if (tab.shouldEngineerToRelation()) {
            // empty if block
        }
    }

    private void resetRelationTopViews() {
        Iterator it = this.design.getLogicalDesign().getRelationSet().iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            for (TVRelation tv : rel.getAllTVRelations()) {
                tv.resetEdgeParams();
            }
        }
    }

    private void processTableViews() {
        for (TableView tableView : this.tableViewList) {
            if (tableView.isRemoteObject()) continue;
            this.processTableView(tableView);
        }
    }

    private void processTableView(TableView tableView) {
        block4: {
            List list;
            block3: {
                XtdMapping del_mapping;
                list = this.xmap.getMappingsForDesignPart(tableView, this.targetDesPartID);
                if ((list = ReverseEngineering.getValidMappings(list)).size() != 0) break block3;
                if (!tableView.shouldBeEngineered()) break block4;
                String newName = this.getDesign().transformNameFromRelationalToLogical(tableView);
                EntityView entityView = this.design.getLogicalDesign().createEntityView(newName);
                this.xmap.createMapping(entityView, tableView);
                this.copyPropertiesFromTableViewToEntityView(tableView, entityView);
                if (this.design.isEngineerCoordinates()) {
                    this.setGraphicalPropertiesOnNewObject(tableView, entityView);
                }
                if ((del_mapping = tableView.getDeletedMapping()) == null) break block4;
                tableView.updateDeletedMappings(del_mapping.getDeletedID(), entityView.getObjectID(), entityView.getDesignPartId());
                this.xmap.removeMapping(del_mapping);
                break block4;
            }
            for (XtdMapping mapping : list) {
                DesignObject obj;
                if (!mapping.isRevEngineer() || (obj = mapping.getObjectMappedTo(tableView)) == null || !(obj instanceof EntityView)) continue;
                EntityView entityView = (EntityView)obj;
                EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(tableView.getObjectID() + entityView.getObjectID());
                if (comp != null) {
                    comp.copySelectedProperties();
                }
                if (!this.design.isEngineerCoordinates()) continue;
                this.setGraphicalPropertiesOnNewObject(tableView, entityView);
            }
        }
    }

    private void copyPropertiesFromTableViewToEntityView(TableView tableView, EntityView entityView) {
        entityView.setGeneratorID(tableView.getObjectID());
        entityView.setBasedOnStructuredType(tableView.getBasedOnStructuredType());
        if (!this.notForNewObjects) {
            this.typeName = Design.ENTVIEW_TBLVIEW;
            this.properties = this.design.getViewPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                entityView.setComment(tableView.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                entityView.setCommentInRDBMS(tableView.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                entityView.setNotes(tableView.getNotes());
            }
        } else {
            entityView.setComment(tableView.getComment());
            entityView.setCommentInRDBMS(tableView.getCommentInRDBMS());
            entityView.setNotes(tableView.getNotes());
        }
        entityView.setWhere(tableView.getWhere());
        entityView.setGroupBy(tableView.getGroupBy());
        entityView.setHaving(tableView.getHaving());
        entityView.setUserDefined(tableView.getUserDefined());
        entityView.setUserDefinedSQL(tableView.getUserDefinedSQL());
        entityView.setLayoutSQL(tableView.getLayoutSQL());
        entityView.setParsed(tableView.isParsed());
        entityView.setIncorrectSQL(tableView.isIncorrectSQL());
        entityView.setValidSQL(tableView.isValidSQL());
        for (AbstractView.ContainerHolder ch : tableView.getUsedContainers()) {
            Entity entity;
            String alias = ch.getAlias();
            String cID = ch.getContainer().getObjectID();
            Table table = (Table)this.design.getRelationalDesign().getTableSet().getObjectByID(cID);
            if (table == null || (entity = table.getEngEntity()) == null) continue;
            entityView.addToContainers(entity, alias);
        }
        for (String id : tableView.getOrderByMap().keySet()) {
            ColumnView key = (ColumnView)tableView.getObjectByID(tableView.getOrderByList(), id);
            if (key != null) {
                AttributeView col = new AttributeView(entityView.getDesignPart());
                col.setDesign(entityView.getDesign());
                this.copyColumnToAttribute(key, col);
                col.setView(entityView);
                entityView.addToOrderBy(col, (String)tableView.getOrderByMap().get(id));
                continue;
            }
            LOGGER.error("ReverseEngineering.copyPropertiesFromTableViewToEntityView: Unable to find ColumnView: " + id);
        }
        if (!tableView.isBST()) {
            ContainedObject[] cols = tableView.getElements();
            for (int i = 0; i < cols.length; ++i) {
                AttributeView col = new AttributeView(entityView.getDesignPart());
                col.setDesign(entityView.getDesign());
                this.copyColumnToAttribute((ColumnView)cols[i], col);
                col.setView(entityView);
                col.setContainer(entityView);
                entityView.add(col);
            }
        }
        for (int i = 0; i < tableView.getGroupByList().size(); ++i) {
            AttributeView newcol;
            ColumnView col = (ColumnView)tableView.getGroupByList().get(i);
            if (col == null || (newcol = (AttributeView)entityView.getElementGeneratedBy(col.getObjectID())) == null) continue;
            entityView.addGroupByList(newcol);
        }
    }

    public void copyColumnToAttribute(ColumnView columnView, AttributeView attributeView) {
        ContainerWithKeyObject entity;
        DesignObject cob;
        attributeView.setGeneratorID(columnView.getObjectID());
        columnView.copyDefaults(attributeView);
        attributeView.setTableAlias(columnView.getTableAlias());
        attributeView.setAlias(columnView.getAlias());
        attributeView.setExpression(columnView.getExpression());
        attributeView.setDataType(columnView.getDataTypeString());
        if (columnView.getReferencedColumn() != null && (cob = columnView.getReferencedColumn()) != null) {
            ContainedObjectWithDomain attr;
            if (cob instanceof Column) {
                attr = ((Column)cob).getEngAttribute();
                if (attr != null) {
                    attributeView.setReferencedColumn(attr);
                }
            } else if (cob instanceof ColumnView && (attr = ((ColumnView)cob).getEngAttributeView()) != null) {
                attributeView.setReferencedColumn(attr);
            }
        }
        if (columnView.getTable() != null) {
            cob = columnView.getTable();
            if (cob instanceof Table) {
                entity = ((Table)cob).getEngEntity();
                attributeView.setEntity((Entity)entity);
            }
        } else if (columnView.getView() != null && (cob = columnView.getView()) instanceof TableView) {
            entity = ((TableView)cob).getEngEntityView();
            attributeView.setView((AbstractView)entity);
        }
        attributeView.setReference(columnView.isReference());
        attributeView.setStructuredType(columnView.getStructuredType());
    }

    public static void copyConnectionPoints(TVConnector tvc_s, TVConnector tvc_t) {
        DesignPartView.copyConnectionPoints(tvc_s, tvc_t);
    }

    private void engineerTableViewSynonyms(TVView tv, DesignPartView logDPV) {
        EntityView entityView;
        TableView tableView = (TableView)tv.getModel();
        if ("User generated".equalsIgnoreCase(tableView.getGeneratorID())) {
            entityView = (EntityView)tableView.getDesign().getLogicalDesign().getEntityViewSet().getObjectGeneratedBy(tableView.getObjectID());
        } else {
            entityView = (EntityView)tableView.getDesign().getLogicalDesign().getEntityViewSet().getObjectByID(tableView.getGeneratorID());
            if (entityView == null) {
                entityView = (EntityView)tableView.getDesign().getLogicalDesign().getEntityViewSet().getObjectGeneratedBy(tableView.getObjectID());
            }
        }
        if (entityView != null) {
            TVEntityView topView = (TVEntityView)entityView.getTopViewByGeneratorID(logDPV, tv.getGeneratorID());
            if (topView == null) {
                topView = (TVEntityView)entityView.getTopViewByID(logDPV, tv.getViewID());
            }
            if (topView == null || topView.getDesignPartView() != logDPV) {
                topView = (TVEntityView)entityView.getTopView().createViewSynonim(logDPV);
                topView.setGeneratorID(tv.getViewID());
            }
            if (tableView.getDesign().isEngineerCoordinates()) {
                logDPV.getApplicationView().setGraphicalPropsFor(topView, logDPV.getApplicationView().getGraphicalPropsFor(tv));
            }
        }
    }

    private void copyPropertiesFromSubViewToSubView(DPVRelationalSubView source, DPVLogicalSubView target) {
        target.getPlaceHolder().setComment(source.getPlaceHolder().getComment());
        target.getPlaceHolder().setNotes(source.getPlaceHolder().getNotes());
    }

    private boolean checkIfSelected(String name, List props, String propName) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!name.equalsIgnoreCase(Design.ENTITY_TABLE)) break block5;
                            for (EngPropertyHolder h : props) {
                                if (!h.getName().equalsIgnoreCase(propName) || !h.isSelected()) continue;
                                return true;
                            }
                            break block6;
                        }
                        if (!name.equalsIgnoreCase(Design.ATTRIBUTE_COLUMN)) break block7;
                        for (EngPropertyHolder h : props) {
                            if (!h.getName().equalsIgnoreCase(propName) || !h.isSelected()) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!name.equalsIgnoreCase(Design.ENTVIEW_TBLVIEW)) break block8;
                    for (EngPropertyHolder h : props) {
                        if (!h.getName().equalsIgnoreCase(propName) || !h.isSelected()) continue;
                        return true;
                    }
                    break block6;
                }
                if (!name.equalsIgnoreCase(Design.KEY_INDEX)) break block9;
                for (EngPropertyHolder h : props) {
                    if (!h.getName().equalsIgnoreCase(propName) || !h.isSelected()) continue;
                    return true;
                }
                break block6;
            }
            if (!name.equalsIgnoreCase(Design.RELATION_FK)) break block6;
            for (EngPropertyHolder h : props) {
                if (!h.getName().equalsIgnoreCase(propName) || !h.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    private void processArcs() {
        Iterator it = this.design.getRelationalDesign().getArcSet().iterator();
        String ld_id = this.design.getLogicalDesign().getObjectID();
        while (it.hasNext()) {
            Table table;
            FKArc fk_arc = (FKArc)it.next();
            if (fk_arc.isViewArc() || (table = (Table)fk_arc.getTable()) == null || !this.tablelist.contains(table)) continue;
            List list = this.xmap.getMappingsForDesignPart(fk_arc, ld_id);
            if ((list = ReverseEngineering.getValidMappings(list)).size() == 0) {
                this.createNewArc(fk_arc);
                continue;
            }
            for (XtdMapping mapping : list) {
                DesignObject dobj = mapping.getObjectMappedTo(fk_arc);
                if (dobj == null || !(dobj instanceof Arc)) continue;
                ((Arc)dobj).addToAllDPVs();
            }
        }
    }

    private void createNewArc(FKArc arc) {
        Entity ent;
        Table table = (Table)arc.getTable();
        if (table != null && (ent = table.getEngEntity()) != null) {
            Arc larc;
            ArrayList<DesignObject> rels = new ArrayList<DesignObject>();
            for (FKIndexAssociation fk : arc.getFkeys()) {
                Relation rel = fk.getEngRelation(ent);
                if (rel == null || rel instanceof InheritanceRelation || rels.contains(rel)) continue;
                rels.add(rel);
            }
            if (rels.size() > 1) {
                rels.add(0, ent);
            }
            if ((larc = ((LogicalDesign)ent.getDesignPart()).createArc(rels.toArray())) != null) {
                larc.setName(arc.getName());
                this.xmap.createMapping(larc, arc);
                larc.addToAllDPVs();
            }
        }
    }

    private void processSQLNames() {
        for (TableView tableView : this.tableViewList) {
            this.processSQLNamesForView(tableView);
        }
    }

    private void processSQLNamesForView(TableView tableView) {
        List list = this.xmap.getMappingsForDesignPart(tableView, this.targetDesPartID);
        list = ReverseEngineering.getValidMappings(list);
        for (XtdMapping mapping : list) {
            DesignObject obj;
            if (!mapping.isRevEngineer() || (obj = mapping.getObjectMappedTo(tableView)) == null || !(obj instanceof EntityView)) continue;
            EntityView entityView = (EntityView)obj;
            entityView.getSQLNames().clear();
            entityView.setValidSQL(false);
            for (SQLNameHelper helper : tableView.getSQLNames()) {
                DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
                if (desObj != null) {
                    SQLNameHelper newHelper;
                    if (desObj instanceof Table) {
                        Table table = (Table)desObj;
                        Entity entity = table.getEngEntity();
                        if (entity != null) {
                            newHelper = new SQLNameHelper(true, false);
                            newHelper.setID(entity.getObjectID());
                            newHelper.setTableName(table.getName());
                            newHelper.setDeprecated(table.isDeprecated());
                            if (tableView.canSetSchemaToTablesOnRE() && table.getSchemaObject() != null) {
                                newHelper.setSchema(table.getSchemaObject().getName());
                            }
                            entityView.getSQLNames().add(newHelper);
                            entity.addObjectListener(entityView);
                            continue;
                        }
                        entityView.setIncorrectSQL(true);
                        continue;
                    }
                    if (desObj instanceof TableView) {
                        TableView tbView = (TableView)desObj;
                        EntityView enView = tbView.getEngEntityView();
                        if (enView != null) {
                            newHelper = new SQLNameHelper(true, true);
                            newHelper.setID(enView.getObjectID());
                            newHelper.setTableName(tbView.getName());
                            newHelper.setDeprecated(tbView.isDeprecated());
                            if (tableView.canSetSchemaToTablesOnRE() && enView.getSchemaObject() != null) {
                                newHelper.setSchema(enView.getSchemaObject().getName());
                            }
                            entityView.getSQLNames().add(newHelper);
                            enView.addObjectListener(entityView);
                            continue;
                        }
                        entityView.setIncorrectSQL(true);
                        continue;
                    }
                    if (desObj instanceof Column) {
                        Column column = (Column)desObj;
                        Attribute attribute = column.getEngAttribute();
                        if (attribute != null) {
                            newHelper = new SQLNameHelper(false, false);
                            newHelper.setID(attribute.getObjectID());
                            newHelper.setTableName(column.getContainer().getName());
                            newHelper.setColumnName(column.getName());
                            entityView.getSQLNames().add(newHelper);
                            attribute.addObjectListener(entityView);
                            continue;
                        }
                        entityView.setIncorrectSQL(true);
                        continue;
                    }
                    if (!(desObj instanceof ColumnView)) continue;
                    ColumnView columnView = (ColumnView)desObj;
                    TableView tbView = (TableView)columnView.getContainer();
                    ContainedObject attributeView = tbView.getElementByName(columnView.getName());
                    if (attributeView != null) {
                        SQLNameHelper newHelper2 = new SQLNameHelper(false, false);
                        newHelper2.setID(attributeView.getObjectID());
                        newHelper2.setTableName(columnView.getContainer().getName());
                        newHelper2.setColumnName(columnView.getName());
                        entityView.getSQLNames().add(newHelper2);
                        attributeView.addObjectListener(entityView);
                        continue;
                    }
                    entityView.setIncorrectSQL(true);
                    continue;
                }
                SQLNameHelper newHelper = helper.clone();
                entityView.getSQLNames().add(newHelper);
            }
        }
    }
}

