/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.FWDEngineering;
import oracle.dbtools.crest.model.design.engineering.ReverseEngineering;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.relational.Index;

public class IndexKeyComparator
extends EngPropertiesComparator {
    private Index index;
    private CandidateKey key;

    public IndexKeyComparator(Index index, CandidateKey key) {
        super(index, key);
        this.index = index;
        this.key = key;
        this.initPropertiesList();
    }

    public IndexKeyComparator(Index index, CandidateKey key, List filters) {
        this(index, key);
        this.applyCompareFilter(filters, index.getDesign().getShowSelPropsOnly());
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initDeprecated();
        this.initCommentsAndNotes();
        EngPropertyHolder ph = new EngPropertyHolder(PRIMARY_KEY);
        ph.setLeftValue(this.index != null ? (this.index.isPK() ? YES : NO) : "");
        ph.setRightValue(this.key != null ? (this.key.isPK() ? YES : NO) : "");
        if (this.key != null && this.index != null && this.key.isPK() != this.index.isPK()) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(false);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ATTRIBUTES_COLUMNS);
        ph.setLeftValue(this.index != null ? this.getElementsToString(this.index) : "");
        ph.setRightValue(this.key != null ? this.key.getElemntsPresentationAsString() : "");
        if (this.key != null && this.index != null && FWDEngineering.isColumnsChangedForKeyAndIndex(this.key, this.index)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    private String getElementsToString(KeyObject keyObject) {
        StringBuffer sb = new StringBuffer();
        Iterator it = keyObject.getElementsCollection().iterator();
        boolean first = true;
        while (it.hasNext()) {
            ContainedObject co = (ContainedObject)it.next();
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append(" \n").append(co.getName());
        }
        return sb.toString();
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromIndexToKey();
        }
    }

    private void copyPropertiesFromIndexToKey() {
        if (this.key != null && this.index != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(PRIMARY_KEY)) {
                    this.key.setPK(this.index.isPK());
                    continue;
                }
                if (!ph.getName().equals(ATTRIBUTES_COLUMNS)) continue;
                ReverseEngineering.synchronizeColumnsFromIndexToKey(this.index, this.key);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.index != null ? this.index.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.key != null ? this.key.getLongName() : "";
    }

    @Override
    protected boolean shouldApplyNametranslation() {
        return false;
    }
}

