/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import javax.swing.JComponent;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class EngineeringObjectSelection
extends ModelIdObjectSelection {
    private GeneralPropertiesComparator propertiesComparator;
    private EngineeringObjectSelection correspondentNode;
    private JComponent dependentComponent;
    private boolean editable = true;
    private String rname;
    private boolean logicalModelObject = false;
    private boolean relationalModelObject = false;
    protected XtdMapping mapping;
    protected XtdMapping delMapping;
    protected XtdMapping containerMapping;
    private boolean updateDependent = true;

    public EngineeringObjectSelection(ModelIDObject object, XtdMapping mapping, XtdMapping containerMapping) {
        super(object);
        if (object instanceof DesignObject) {
            this.logicalModelObject = ((DesignObject)object).getDesignPart() instanceof LogicalDesign;
            this.relationalModelObject = ((DesignObject)object).getDesignPart() instanceof RelationalDesign;
        }
        this.mapping = mapping;
        this.containerMapping = containerMapping;
        this.selected = this.getObjectSelectionStatus();
    }

    public EngineeringObjectSelection(ModelIDObject object, XtdMapping mapping) {
        this(object, mapping, null);
    }

    public EngineeringObjectSelection(ModelIDObject object) {
        super(object);
        if (object instanceof DesignObject) {
            this.logicalModelObject = ((DesignObject)object).getDesignPart() instanceof LogicalDesign;
            this.relationalModelObject = ((DesignObject)object).getDesignPart() instanceof RelationalDesign;
        }
        this.selected = this.getObject().getShouldEngineer();
    }

    public EngineeringObjectSelection(String name) {
        super(name);
    }

    public GeneralPropertiesComparator getPropertiesComparator() {
        return this.propertiesComparator;
    }

    public void setPropertiesComparator(GeneralPropertiesComparator propertiesComparator) {
        this.propertiesComparator = propertiesComparator;
    }

    public EngineeringObjectSelection getCorrespondentNode() {
        return this.correspondentNode;
    }

    @Override
    public ModelIdObjectSelection getCorrespondentObjectSelection() {
        return this.getCorrespondentNode();
    }

    public void setCorrespondentNode(EngineeringObjectSelection correspondentNode) {
        this.correspondentNode = correspondentNode;
    }

    public void applySelectionToEngineering() {
        this.applySelectionToEngineering(false);
    }

    public void applySelectionToEngineering(boolean setDirty) {
        ModelIDObject obj = this.getObject();
        if (this.getObject() != null) {
            boolean dirty = false;
            if (this.containerMapping != null) {
                String id = this.getObject().getObjectID();
                if (this.isLogicalModelObject()) {
                    if (this.getObject() instanceof Attribute) {
                        if (!this.isSelected()) {
                            if (!this.containerMapping.getAttributes().contains(id)) {
                                this.containerMapping.getAttributes().add(id);
                                dirty = true;
                            }
                        } else {
                            dirty = this.containerMapping.getAttributes().remove(id);
                        }
                    } else if (this.getObject() instanceof KeyObject) {
                        if (!this.isSelected()) {
                            if (!this.containerMapping.getKeys().contains(id)) {
                                this.containerMapping.getKeys().add(id);
                                dirty = true;
                            }
                        } else {
                            dirty = this.containerMapping.getKeys().remove(id);
                        }
                    }
                } else if (this.isRelationalModelObject()) {
                    if (obj instanceof Column) {
                        if (!this.isSelected()) {
                            if (!this.containerMapping.getColumns().contains(id)) {
                                this.containerMapping.getColumns().add(id);
                                dirty = true;
                            }
                        } else {
                            dirty = this.containerMapping.getColumns().remove(id);
                        }
                    } else if (obj instanceof Index) {
                        if (!this.isSelected()) {
                            if (!this.containerMapping.getIndexes().contains(id)) {
                                this.containerMapping.getIndexes().add(id);
                                dirty = true;
                            }
                        } else {
                            dirty = this.containerMapping.getIndexes().remove(id);
                        }
                    }
                }
            } else if (this.mapping != null) {
                if (this.isLogicalModelObject()) {
                    dirty = this.isSelected() != this.mapping.isFwEngineer();
                    this.mapping.setFwEngineer(this.isSelected());
                } else if (this.isRelationalModelObject()) {
                    dirty = this.isSelected() != this.mapping.isRevEngineer();
                    this.mapping.setRevEngineer(this.isSelected());
                }
            }
            if (dirty) {
                this.setMapToDirty();
            }
            this.getObject().setShouldEngineer(this.isSelected(), setDirty);
        }
        int count = this.getNumberOfChildren();
        for (int i = 0; i < count; ++i) {
            EngineeringObjectSelection child = (EngineeringObjectSelection)this.getChild(i);
            child.applySelectionToEngineering(setDirty);
        }
    }

    private boolean getObjectSelectionStatus() {
        if (this.getObject() != null) {
            if (this.containerMapping != null) {
                String id = this.getObject().getObjectID();
                if (this.isLogicalModelObject()) {
                    if (this.getObject() instanceof Attribute) {
                        return !this.containerMapping.getAttributes().contains(id);
                    }
                    if (this.getObject() instanceof CandidateKey) {
                        return !this.containerMapping.getKeys().contains(id);
                    }
                } else if (this.isRelationalModelObject()) {
                    if (this.getObject() instanceof Column) {
                        return !this.containerMapping.getColumns().contains(id);
                    }
                    if (this.getObject() instanceof Index) {
                        return !this.containerMapping.getIndexes().contains(id);
                    }
                }
            } else if (this.mapping != null) {
                if (this.isLogicalModelObject()) {
                    return this.mapping.isFwEngineer();
                }
                if (this.isRelationalModelObject()) {
                    return this.mapping.isRevEngineer();
                }
            }
            return this.getObject().getShouldEngineer();
        }
        return false;
    }

    public void setStatus(int status) {
        if (status == 1) {
            if (this.status != 2 && this.status != 3) {
                this.status = status;
            }
        } else {
            this.status = status;
        }
    }

    @Override
    public boolean isModified() {
        if (this.propertiesComparator != null) {
            if (this.propertiesComparator.isReadOnly()) {
                return false;
            }
            return this.propertiesComparator.isModified();
        }
        return false;
    }

    public boolean hasChildsWithChangeStatus() {
        for (EngineeringObjectSelection selob : this.childs) {
            if (!selob.isModified() && this.status == 0) continue;
            return true;
        }
        for (EngineeringObjectSelection selob : this.childs) {
            if (!selob.hasChildsWithChangeStatus()) continue;
            return true;
        }
        return false;
    }

    public void resetModifiedStatus() {
        for (EngineeringObjectSelection selob : this.childs) {
            selob.resetModifiedStatus();
            if (selob.getStatus() == 0) continue;
            this.setStatus(1);
        }
        if (this.isModified() || this.hasChildsWithChangeStatus()) {
            this.setStatus(1);
        }
    }

    @Override
    public String getName() {
        ModelIDObject object = this.getObject();
        if (object != null) {
            if (this.rname != null) {
                return this.rname;
            }
            if (object instanceof KeyObject && ((KeyObject)object).isPK()) {
                if (this.logicalModelObject) {
                    if (object instanceof CandidateKey && !((CandidateKey)object).getEntity().isCreateSurrogateKey()) {
                        return "(PUID) " + object.getName();
                    }
                } else {
                    return "(PK) " + object.getName();
                }
            }
            return object.getName();
        }
        if (this.rname != null) {
            return this.rname;
        }
        return super.getName();
    }

    @Override
    public boolean setName(String name) {
        this.rname = name;
        super.setName(name);
        return true;
    }

    public JComponent getDependentComponent() {
        return this.dependentComponent;
    }

    public void setDependentComponent(JComponent dependentComponent) {
        this.dependentComponent = dependentComponent;
    }

    @Override
    public void setSelected(boolean selected) {
        boolean old = this.selected;
        super.setSelected(selected);
        if (old != selected && this.updateDependent && this.dependentComponent != null) {
            this.dependentComponent.updateUI();
        }
    }

    public void setSelected(boolean selected, boolean updateDependent) {
        boolean old = this.updateDependent;
        this.updateDependent = updateDependent;
        this.setSelected(selected);
        this.updateDependent = old;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean isFiltered(List filters) {
        for (Integer filter : filters) {
            if (filter.intValue() != this.getStatus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFilteredChilds(List filters) {
        for (EngineeringObjectSelection object : this.getChilds()) {
            if (!object.isFiltered(filters) && !object.hasFilteredChilds(filters)) continue;
            return true;
        }
        return false;
    }

    public boolean isLogicalModelObject() {
        return this.logicalModelObject;
    }

    public boolean isRelationalModelObject() {
        return this.relationalModelObject;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    private void setMapToDirty() {
        DesignObject dob;
        if (this.mapping != null && (dob = this.mapping.getRelationalObject()) != null) {
            ((RelationalDesign)dob.getDesignPart()).getRMExtendedMap().setDirty(true);
        }
    }

    public XtdMapping getDelMapping() {
        return this.delMapping;
    }

    public void setDelMapping(XtdMapping delMapping) {
        this.delMapping = delMapping;
    }
}

