/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class TempDataTypeObject
implements DataTypeObject {
    private DesignObject type;
    private String size;
    private int precision;
    private int scale;
    private boolean isReference;
    private String name = "";
    private Design design;

    public TempDataTypeObject(Design design) {
        this.design = design;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DesignObject getType() {
        return this.type;
    }

    @Override
    public void setType(DesignObject type) {
        this.type = type;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    @Override
    public String getDataType() {
        return this.formatDataType();
    }

    private String formatDataType() {
        if (this.getType() != null) {
            String fSize = "";
            int fPrecision = 0;
            int fScale = 0;
            String dtName = "NONE";
            if (this.getType() instanceof LogicalDatatype) {
                fSize = this.size;
                fPrecision = this.precision;
                fScale = this.scale;
                dtName = ((LogicalDatatype)this.getType()).getName();
            } else if (this.getType() instanceof DistinctType) {
                DistinctType dt = (DistinctType)this.getType();
                if (dt.getLogicalDataType() != null) {
                    fSize = dt.getSize();
                    fPrecision = dt.getPrecision();
                    fScale = dt.getScale();
                    dtName = dt.getLogicalDataType().getName();
                }
            } else if (this.getType() instanceof StructuredType) {
                dtName = this.isReference ? "REF " + this.getType().getName() : this.getType().getName();
            }
            StringBuffer logical = new StringBuffer(dtName);
            boolean needBracket = false;
            boolean needComma = false;
            if (fSize != null && !fSize.equals("") || fPrecision > 0 || fScale > 0) {
                needBracket = true;
            }
            if (needBracket) {
                logical.append('(');
            }
            if (fSize != null && !fSize.equals("")) {
                logical.append(fSize);
                needComma = true;
            }
            if (fPrecision > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fPrecision);
                needComma = true;
            }
            if (fScale > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fScale);
            }
            if (needBracket) {
                logical.append(')');
            }
            return logical.toString();
        }
        return "NONE";
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setSize(String size) {
        this.size = size;
    }

    @Override
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public RDBMSType getSelectedRDBMSType() {
        return this.design.getSelectedRDBMSType();
    }

    @Override
    public void setReference(boolean isReference) {
        this.isReference = isReference;
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    public void copyDataType(DataTypeObject object) {
        object.setType(this.getType());
        object.setSize(this.getSize());
        object.setPrecision(this.getPrecision());
        object.setScale(this.getScale());
        object.setReference(this.isReference());
    }
}

