/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.swingui.ApplicationView;

public class IndexGlobalPartitionComparatorOracle
extends StoragePropertiesComparator {
    public static final String VALUE_LIST = IndexGlobalPartitionComparatorOracle.getPropertyNameOracle("PartitionPropertyDialogOraclev9i.ValueList");
    public static final String POSITION = IndexGlobalPartitionComparatorOracle.getPropertyNameOracle("PartitionPropertyDialogOraclev9i.Position");
    public static final String LOGGING = IndexGlobalPartitionComparatorOracle.getPropertyNameOracle("PartitionPropertyDialogOraclev9i.Logging");
    public static final String STORAGE = IndexGlobalPartitionComparatorOracle.getPropertyNameOracle("PartitionPropertyDialogOraclev9i.Segment");

    public IndexGlobalPartitionComparatorOracle(IndexGlobalPartitionOracle sourcePartition, IndexGlobalPartitionOracle targetPartition) {
        super(sourcePartition, targetPartition);
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initProperty(VALUE_LIST, "valueList");
        this.initProperty(POSITION, "position");
        this.initProperty(TABLESPACE, "tableSpace");
        this.initProperty(LOGGING, "logging");
        this.initStorageProperty();
    }

    private void initStorageProperty() {
        PropertyHolder ph = new PropertyHolder(STORAGE);
        ModelIDObject leftObj = this.getLeftObject();
        ModelIDObject rightObj = this.getRightObject();
        SegmentOracle leftSegment = leftObj != null ? ((IndexGlobalPartitionOracle)leftObj).getSegment() : null;
        SegmentOracle rightSegment = rightObj != null ? ((IndexGlobalPartitionOracle)rightObj).getSegment() : null;
        ph.setLeftValue(leftSegment != null ? leftSegment.getName() : "");
        ph.setRightValue(rightSegment != null ? rightSegment.getName() : "");
        if (this.isExcludedFromComparison(STORAGE)) {
            ph.setExcluded(true);
        } else if (!(leftObj == null || rightObj == null || leftSegment == null && rightSegment == null || leftSegment != null && rightSegment != null && leftSegment.isEqualTo(rightSegment))) {
            if (ApplicationView.getInstance().getSettings().isIncludeStoragePropertiesInCompare()) {
                ph.setModified(true);
                ph.setSelected(true);
                if (this.classDescr != null) {
                    ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("segment");
                    ph.setPropertyDescription(propDescr);
                }
            } else {
                ph.setExcluded(true);
            }
        }
        this.propertiesList.add(ph);
    }
}

