/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.metadata.ClassDescription;

public class ColumnComparatorOracle
extends StoragePropertiesComparator {
    public static final String DEFAULT_ON_NULL = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev12c.DefaultOnNull");
    public static final String COLUMN_EXPRESSION = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev11g.ColumnExpression");
    public static final String INVISIBLE = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev12c.Invisible");
    public static final String AUTO_INCREMENT_DDL = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev12c.AutoIncrementDDL");
    public static final String AUTO_INCREMENT_USER = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.AutoIncrementUser");
    public static final String WITH_ROW_ID = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.WithROWID");
    public static final String SUBSTITUTABLE = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.Substitutable");
    public static final String ELEMENT_TYPE = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.ElementType");
    public static final String NOT_NULL_CONSTRAINT_NAME = Messages.getString("ColumnComparatorOracle.NotNullConstraintName");
    public static final String NOT_NULL_INITIALLY = Messages.getString("ColumnComparatorOracle.NotNullInitially");
    public static final String NOT_NULL_DEFERRABLE = Messages.getString("ColumnComparatorOracle.NotNullDeferrable");
    public static final String NOT_NULL_ENABLE = Messages.getString("ColumnComparatorOracle.NotNullEnable");
    public static final String NOT_NULL_VALIDATE = Messages.getString("ColumnComparatorOracle.NotNullValidate");
    public static final String NOT_NULL_EXCEPTIONS_TABLE = Messages.getString("ColumnComparatorOracle.NotNullExceptionsTable");
    public static final String CHECK_INITIALLY = Messages.getString("ColumnComparatorOracle.CheckInitially");
    public static final String CHECK_DEFERRABLE = Messages.getString("ColumnComparatorOracle.CheckDeferrable");
    public static final String CHECK_ENABLE = Messages.getString("ColumnComparatorOracle.CheckEnable");
    public static final String CHECK_VALIDATE = Messages.getString("ColumnComparatorOracle.CheckValidate");
    public static final String CHECK_EXCEPTIONS_TABLE = Messages.getString("ColumnComparatorOracle.CheckExceptionsTable");
    public static final String ENCRYPT = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev11g.Encrypt");
    public static final String ENCRYPTION_ALGORITHM = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev11g.EncryptionAlgorithm");
    public static final String INTEGRITY_ALGORITHM = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev11g.IntegrityAlgorithm");
    public static final String USE_SALT = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev11g.UseSALT");
    public static final String XML_SCHEMA_URL = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.XMLSchemaURL");
    public static final String XML_SCHEMA_ELEMENT = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.XMLSchemaElem");
    public static final String ALLOW_ANY_SCHEMA = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev11g.AllowAnySchema");
    public static final String ALLOW_NON_SCHEMA = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev11g.AllowNonSchema");
    public static final String STORE_AS = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.StoreAs");
    public static final String LOB_STORAGE_TYPE = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev11g.LobStorageType");
    public static final String LOB_SEGMENT_NAME = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.LobSegmentName");
    public static final String XMLTYPE_TABLESPACE = Messages.getString("ColumnComparatorOracle.XMLTYPETablespace");
    public static final String STORAGE_IN_ROW = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.StorageInRow");
    public static final String XMLTYPE_LOGGING = Messages.getString("ColumnComparatorOracle.XMLTYPELogging");
    public static final String CHUNK = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.Chunk");
    public static final String OLD_VERSIONS = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.OldVersions");
    public static final String PCT_VERSION = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.PCTVersion");
    public static final String FREEPOOLS = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.FreePools");
    public static final String NT_STORAGE_TABLE = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.NTStorageTable");
    public static final String NT_RETURN_AS = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.NTReturnAS");
    public static final String LOB_SEGNAME = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.LOBSegname");
    public static final String ADDITIONAL_NT_SETTINGS = ColumnComparatorOracle.getPropertyNameOracle("ColumnPropertyDialogOraclev9i.AdditionalNestedTableSettings");
    private ColumnProxy targetColumnProxy;
    private StorageDesign storageDesign;

    public ColumnComparatorOracle(ColumnProxy sourceColumnProxy, ColumnProxy targetColumnProxy) {
        super(sourceColumnProxy, targetColumnProxy);
        this.targetColumnProxy = targetColumnProxy;
        if (sourceColumnProxy != null) {
            this.storageDesign = sourceColumnProxy.getStorageDesign();
        } else if (targetColumnProxy != null) {
            this.storageDesign = targetColumnProxy.getStorageDesign();
        }
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initCommentInRDBMSProperty();
        this.initDefaultValueProperty();
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            this.initProperty(DEFAULT_ON_NULL, "defaultOnNull");
            this.initProperty(INVISIBLE, "invisible");
        }
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initColumnExpressionProperty();
        }
        this.initProperty(AUTO_INCREMENT_DDL, "autoIncrementDDL");
        this.initProperty(AUTO_INCREMENT_USER, "autoIncrementUser");
        this.initProperty(WITH_ROW_ID, "withRowId");
        this.initProperty(SUBSTITUTABLE, "substitutable");
        this.initProperty(ELEMENT_TYPE, "elementType");
        this.initNotNullConstraintNameProperty();
        this.initProperty(NOT_NULL_INITIALLY, "nncInitially");
        this.initProperty(NOT_NULL_DEFERRABLE, "nncDeferrable");
        this.initProperty(NOT_NULL_ENABLE, "nncEnable");
        this.initProperty(NOT_NULL_VALIDATE, "nncValidate");
        this.initProperty(NOT_NULL_EXCEPTIONS_TABLE, "nncExceptionsTable");
        this.initProperty(CHECK_INITIALLY, "initially");
        this.initProperty(CHECK_DEFERRABLE, "deferrable");
        this.initProperty(CHECK_ENABLE, "enable");
        this.initProperty(CHECK_VALIDATE, "validate");
        this.initProperty(CHECK_EXCEPTIONS_TABLE, "exceptionsTable");
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(ENCRYPT, "encrypt");
            this.initProperty(ENCRYPTION_ALGORITHM, "encryptionAlgorithm");
            this.initProperty(INTEGRITY_ALGORITHM, "integrityAlgorithm");
            this.initProperty(USE_SALT, "useSalt");
        }
        this.initProperty(XML_SCHEMA_URL, "xmlSchemaUrl");
        this.initProperty(XML_SCHEMA_ELEMENT, "xmlSchemaElement");
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(ALLOW_ANY_SCHEMA, "allowAnySchema");
            this.initProperty(ALLOW_NON_SCHEMA, "allowNonSchema");
        }
        this.initProperty(STORE_AS, "storeAs");
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(LOB_STORAGE_TYPE, "lobStorageType");
        }
        this.initProperty(LOB_SEGMENT_NAME, "lobSegmentName");
        this.initProperty(XMLTYPE_TABLESPACE, "tablespace");
        this.initProperty(STORAGE_IN_ROW, "storageInRow");
        this.initProperty(XMLTYPE_LOGGING, "logging");
        this.initProperty(CACHE, "cache");
        this.initProperty(CHUNK, "chunk");
        this.initProperty(OLD_VERSIONS, "oldVersions");
        this.initProperty(PCT_VERSION, "pctVersion");
        this.initProperty(SC_INITIAL_EXTENT, "scInitialExtent");
        this.initProperty(SC_NEXT_EXTENT, "scNextExtent");
        this.initProperty(SC_MIN_EXTENTS, "scMinExtents");
        this.initProperty(SC_MAX_EXTENTS, "scMaxExtents");
        this.initProperty(SC_PCT_INCREASE, "scPctIncrease");
        this.initProperty(SC_BUFFER_POOL, "scBufferPool");
        this.initProperty(SC_FREE_LISTS, "scFreeLists");
        this.initProperty(SC_FREE_LISTS_GRPS, "scFreelistGroups");
        this.initProperty(FREEPOOLS, "freepools");
        this.initProperty(NT_STORAGE_TABLE, "ntStorageTable");
        this.initProperty(NT_RETURN_AS, "ntReturn");
        this.initProperty(LOB_SEGNAME, "lobSegname");
        this.initProperty(ADDITIONAL_NT_SETTINGS, "additionalNTS");
    }

    private void initDefaultValueProperty() {
        PropertyHolder ph = new PropertyHolder(DEFAULT_VALUE);
        ColumnProxyOracle leftObj = (ColumnProxyOracle)this.getLeftObject();
        ColumnProxyOracle rightObj = (ColumnProxyOracle)this.getRightObject();
        ph.setLeftValue(leftObj != null ? leftObj.getDefaultValue() : "");
        ph.setRightValue(rightObj != null ? rightObj.getDefaultValue() : "");
        if (this.isExcludedFromComparison(DEFAULT_VALUE)) {
            ph.setExcluded(true);
        } else if (!(leftObj == null || rightObj == null || ph.getLeftValue().equals(ph.getRightValue()) || ph.getLeftValue().equals(leftObj.getColumn().getDefaultValue()) && ph.getRightValue().equals(rightObj.getColumn().getDefaultValue()))) {
            ph.setModified(true);
            ph.setSelected(true);
            if (this.classDescr != null) {
                ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("defaultValue");
                ph.setPropertyDescription(propDescr);
            }
        }
        this.propertiesList.add(ph);
    }

    private void initColumnExpressionProperty() {
        PropertyHolder ph = new PropertyHolder(COLUMN_EXPRESSION);
        ColumnProxyOraclev11g leftObj = (ColumnProxyOraclev11g)this.getLeftObject();
        ColumnProxyOraclev11g rightObj = (ColumnProxyOraclev11g)this.getRightObject();
        ph.setLeftValue(leftObj != null ? leftObj.getColumnExpression() : "");
        ph.setRightValue(rightObj != null ? rightObj.getColumnExpression() : "");
        if (this.isExcludedFromComparison(COLUMN_EXPRESSION)) {
            ph.setExcluded(true);
        } else if (leftObj != null && rightObj != null && (leftObj.isExpressionChanged() || rightObj.isExpressionChanged()) && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
            if (this.classDescr != null) {
                ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("columnExpression");
                ph.setPropertyDescription(propDescr);
            }
        }
        this.propertiesList.add(ph);
    }

    private void initNotNullConstraintNameProperty() {
        PropertyHolder ph = new PropertyHolder(NOT_NULL_CONSTRAINT_NAME);
        ColumnProxyOracle leftObj = (ColumnProxyOracle)this.getLeftObject();
        ColumnProxyOracle rightObj = (ColumnProxyOracle)this.getRightObject();
        ph.setLeftValue(leftObj != null ? leftObj.getNncName() : "");
        ph.setRightValue(rightObj != null ? rightObj.getNncName() : "");
        if (this.isExcludedFromComparison(NOT_NULL_CONSTRAINT_NAME)) {
            ph.setExcluded(true);
        } else if (leftObj != null && rightObj != null && (leftObj.isNotNullConstraintNameChanged() || rightObj.isNotNullConstraintNameChanged()) && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
            if (this.classDescr != null) {
                ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("nncname");
                ph.setPropertyDescription(propDescr);
            }
        }
        this.propertiesList.add(ph);
    }

    @Override
    public List<ClassDescription.PropertyDescription> getPropsToMerge() {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.isSelected()) continue;
            if (ph.getName().equals(COLUMN_EXPRESSION)) {
                ((ColumnProxyOraclev11g)this.targetColumnProxy).setExpressionChanged(true);
                continue;
            }
            if (!ph.getName().equals(NOT_NULL_CONSTRAINT_NAME)) continue;
            ((ColumnProxyOracle)this.targetColumnProxy).setNotNullConstraintNameChanged(true);
        }
        return super.getPropsToMerge();
    }
}

