/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableViewProxyOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBTableView
extends AbstractCSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        TableView view = null;
        RelationalObjectProxy proxy = null;
        if (((CompareObjectSelection)object).getObject() instanceof TableView) {
            RDBMSSite site;
            view = (TableView)((CompareObjectSelection)object).getObject();
            Design design = view.getDesign();
            if (design.getStorageDesign(site = view.getSelectedRDBMSSite()) instanceof StorageDesignOraclev9i) {
                this.storageDesign = design.getStorageDesign(site);
                proxy = (TableViewProxyOraclev9i)this.storageDesign.getProxy(view);
            }
        } else if (((CompareObjectSelection)object).getObject() instanceof TableViewProxyOraclev9i) {
            proxy = (TableViewProxyOraclev9i)((CompareObjectSelection)object).getObject();
            view = (TableView)proxy.getObject();
            this.storageDesign = proxy.getStorageDesign();
        }
        if (proxy != null) {
            if (proxy.isCommentChanged()) {
                this.appendComment(oldbuffer, proxy);
            } else {
                this.appendComment(oldbuffer, view);
            }
            String stmt = view.getBasedOnStructuredType() != null ? view.getUserDefinedSQL() : ((TableViewProxy)proxy).getDefinition();
            stmt = stmt.trim();
            if (stmt.endsWith(";")) {
                stmt = stmt.substring(0, stmt.length() - 1).trim();
            }
            if (!"".equalsIgnoreCase(stmt)) {
                int index;
                String createViewPart = "";
                boolean includesColumnList = false;
                if (Token.getFirstToken(stmt).equalsIgnoreCase("CREATE") && (index = stmt.toUpperCase().indexOf("VIEW")) > -1) {
                    int viewNameIndex;
                    int dotIndex;
                    createViewPart = stmt.substring(0, index + 4);
                    String stmtWithoutNL = (stmt = stmt.substring(index + 4).trim()).replaceAll("[\t\n\f\r\u000b]+", " ");
                    String oldViewName = Token.getFirstName(stmtWithoutNL, '\"', '\"');
                    int bracketIndex = oldViewName.indexOf(40);
                    if (bracketIndex > -1) {
                        oldViewName = oldViewName.substring(0, bracketIndex);
                    }
                    if ((dotIndex = oldViewName.indexOf(46)) > -1) {
                        oldViewName = oldViewName.substring(dotIndex + 1);
                    }
                    if ((viewNameIndex = stmt.indexOf(oldViewName, dotIndex)) > -1 && (stmt = stmt.substring(viewNameIndex + oldViewName.length())).startsWith("\"")) {
                        stmt = stmt.substring(1);
                    }
                    if ((stmt = stmt.trim()).toUpperCase().startsWith("AS")) {
                        stmt = stmt.substring(2).trim();
                    } else if (stmt.startsWith("(")) {
                        includesColumnList = true;
                    }
                }
                if ("YES".equalsIgnoreCase(((TableViewProxyOracle)proxy).getForce())) {
                    if (!Token.startsWithString(createViewPart, "CREATE OR REPLACE FORCE")) {
                        createViewPart = "CREATE OR REPLACE FORCE VIEW";
                    }
                } else if (!Token.startsWithString(createViewPart, "CREATE OR REPLACE")) {
                    createViewPart = this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL() ? "CREATE OR REPLACE NOFORCE VIEW" : "CREATE OR REPLACE VIEW";
                }
                ModelIDObject viewObject = this.storageDesign.isOpen() ? proxy : view;
                createViewPart = createViewPart + ' ' + this.storageDesign.getFormatedLongNameDDL(viewObject);
                if (view.getBasedOnStructuredType() != null) {
                    if (stmt.toUpperCase().startsWith("OF")) {
                        createViewPart = createViewPart + NEWLINE + ' ' + stmt;
                        stmt = "";
                    } else {
                        createViewPart = createViewPart + this.appendStructuredType((TableViewProxyOraclev9i)proxy);
                    }
                }
                if (stmt.equals("")) {
                    stmt = createViewPart;
                } else if (includesColumnList) {
                    stmt = createViewPart + ' ' + stmt;
                } else {
                    String columnList = this.getColumnList(view, true);
                    stmt = createViewPart + ' ' + columnList + ' ' + "AS" + NEWLINE + stmt;
                }
                this.appendBeforeCreateScript(oldbuffer, prettyPrint, view);
                CSSBTableView.appendStringWithSpace(buffer, stmt);
                this.appendWith(buffer, (TableViewProxyOracle)proxy);
                this.appendToBuffer(oldbuffer, buffer, createViewPart);
                CSSBTableView.appendNewLine(buffer, prettyPrint, 0);
                CSSBTableView.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, createViewPart);
                CDDLFileMaker.incrementCreateView();
                this.appendAfterCreateScript(oldbuffer, prettyPrint, view);
                if (proxy.getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendViewCommentOn(this.storageDesign, oldbuffer, view, (TableViewProxy)proxy, prettyPrint);
                }
                this.appendPermissions(oldbuffer, (TableViewProxyOracle)proxy, prettyPrint);
            } else {
                CSSBTableView.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid View " + view.getName() + " with empty body");
                CDDLFileMaker.incrementErrors();
            }
            CSSBTableView.appendNewLine(oldbuffer, prettyPrint, 0);
        }
    }

    private String appendStructuredType(TableViewProxyOraclev9i view) {
        StringBuffer forInsert = new StringBuffer();
        CSSBTableView.appendStringWithSpace(forInsert, "\n");
        CSSBTableView.appendStringWithSpace(forInsert, "OF");
        StructuredTypeProxy stp = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getProxy(((TableView)view.getObject()).getBasedOnStructuredType().getObjectID());
        CSSBTableView.appendStringWithSpace(forInsert, this.storageDesign.getFormatedLongNameDDL(stp));
        TableViewProxy superView = view.getSuperView();
        if (superView != null) {
            CSSBTableView.appendStringWithSpace(forInsert, "UNDER");
            CSSBTableView.appendStringWithSpace(forInsert, this.storageDesign.getFormatedLongNameDDL(superView));
        } else {
            String schemaElement = view.getXmlSchemaElement();
            if (!"".equalsIgnoreCase(schemaElement)) {
                String schemaUrl = view.getXmlSchemaUrl();
                if (!"".equalsIgnoreCase(schemaUrl)) {
                    CSSBTableView.appendStringWithSpace(forInsert, "XMLSCHEMA");
                    forInsert.append('\"').append(schemaUrl).append('\"').append(' ');
                }
                CSSBTableView.appendStringWithSpace(forInsert, "ELEMENT");
                forInsert.append('\"').append(schemaElement).append('\"').append(' ');
            }
            CSSBTableView.appendStringWithSpace(forInsert, "WITH");
            CSSBTableView.appendStringWithSpace(forInsert, "OBJECT");
            CSSBTableView.appendStringWithSpace(forInsert, "IDENTIFIER");
            if (view.getOidAttributes() == null || "".equalsIgnoreCase(view.getOidAttributes())) {
                CSSBTableView.appendStringWithSpace(forInsert, "DEFAULT");
            } else {
                CSSBTableView.appendStringWithSpace(forInsert, '(');
                CSSBTableView.appendStringWithSpace(forInsert, view.getOidAttributes());
                CSSBTableView.appendStringWithSpace(forInsert, ')');
            }
        }
        return forInsert.toString();
    }

    private void appendWith(StringBuffer buffer, TableViewProxyOracle viewProxy) {
        if ("YES".equalsIgnoreCase(viewProxy.getReadOnly())) {
            if (buffer.indexOf("WITH READ ONLY") == -1) {
                buffer.append(NEWLINE).append("    ");
                buffer.append("WITH READ ONLY");
            }
        } else if (viewProxy.getCheckOption() && viewProxy.getDefinition() != null && viewProxy.getDefinition().trim().length() != 0) {
            int withCheckOptionIndex = buffer.lastIndexOf("WITH CHECK OPTION");
            if (withCheckOptionIndex == -1) {
                buffer.append(NEWLINE).append("    ");
                CSSBTableView.appendStringWithSpace(buffer, "WITH CHECK OPTION");
            }
            if (!"".equalsIgnoreCase(viewProxy.getCheckOptionName())) {
                int constraintIndex = buffer.lastIndexOf("CONSTRAINT ");
                if (constraintIndex > withCheckOptionIndex && withCheckOptionIndex > -1) {
                    buffer.delete(constraintIndex, buffer.length());
                }
                buffer.append("CONSTRAINT ").append(viewProxy.getCheckOptionName());
            }
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, TableViewProxyOracle viewProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComments = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)this.storageDesign).getPermissionsSet();
        for (PermissionsOraclev9i permissions : permissionsSet) {
            if (permissions.getView() != null && permissions.getView().equals(viewProxy) && !permissions.getPrivileges().equalsIgnoreCase("")) {
                CSSBTableView.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBTableView.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                CSSBTableView.appendStringWithSpace(buffer, "GRANT");
                CSSBTableView.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions);
                this.appendTo(buffer, permissions, this.storageDesign);
                this.appendHierrarchyOption(buffer, permissions);
                advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                this.appendToBuffer(oldbuffer, buffer, advancedComments);
                CSSBTableView.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                CSSBTableView.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComments);
            }
            if (permissions.getView() == null || !permissions.getView().equals(viewProxy) || permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            CSSBTableView.appendNewLine(buffer, prettyPrint, 0);
            CSSBTableView.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, permissions);
            CSSBTableView.appendStringWithSpace(buffer, "GRANT");
            CSSBTableView.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions);
            this.appendTo(buffer, permissions, this.storageDesign);
            this.appendHierrarchyOption(buffer, permissions);
            this.appendGrantOption(buffer, permissions);
            advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            CSSBTableView.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBTableView.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if (permissions.getView() != null) {
            buffer.append(NEWLINE);
            CSSBTableView.appendStringWithSpace(buffer, "ON");
            CSSBTableView.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getView()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if (permissions.getRole() == null) {
            CSSBTableView.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            buffer.append(NEWLINE);
            CSSBTableView.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof TableView;
    }

    private String getPermissionsTO(PermissionsOraclev9i permissions) {
        if (permissions.getUser() != null) {
            return permissions.getUser().getLongName();
        }
        if (permissions.getRole() != null) {
            return permissions.getRole().getLongName();
        }
        return "";
    }

    private String getPermissionsON(PermissionsOraclev9i permissions) {
        if (permissions.getTable() != null) {
            return permissions.getTable().getLongName();
        }
        if (permissions.getView() != null) {
            return permissions.getView().getLongName();
        }
        if (permissions.getSequence() != null) {
            return permissions.getSequence().getLongName();
        }
        if (permissions.getSnapshot() != null) {
            return permissions.getSnapshot().getLongName();
        }
        if (permissions.getProc() != null) {
            return permissions.getProc().getLongName();
        }
        if (permissions.getDirectoryOracle() != null) {
            return permissions.getDirectoryOracle().getLongName();
        }
        if (permissions.getStructuredTypeOracle() != null) {
            return permissions.getStructuredTypeOracle().getLongName();
        }
        if (permissions.getCollectionTypeOracle() != null) {
            return permissions.getCollectionTypeOracle().getLongName();
        }
        if (permissions.getExternalTableOracle() != null) {
            return permissions.getExternalTableOracle().getLongName();
        }
        return "";
    }
}

